/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network;

import io.netty.buffer.ByteBuf;
import java.util.Set;
import mekanism.common.Mekanism;
import mekanism.common.PacketHandler;
import mekanism.common.item.ItemJetpack;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketJetpackData
implements IMessageHandler<JetpackDataMessage, IMessage> {
    public IMessage onMessage(final JetpackDataMessage message, MessageContext context) {
        final EntityPlayer player = PacketHandler.getPlayer(context);
        PacketHandler.handlePacket(new Runnable(){

            @Override
            public void run() {
                ItemStack stack;
                if (message.packetType == JetpackPacket.UPDATE) {
                    if (message.value) {
                        Mekanism.jetpackOn.add(message.username);
                    } else {
                        Mekanism.jetpackOn.remove(message.username);
                    }
                    if (!player.field_70170_p.field_72995_K) {
                        Mekanism.packetHandler.sendToDimension(new JetpackDataMessage(JetpackPacket.UPDATE, message.username, message.value), player.field_70170_p.field_73011_w.getDimension());
                    }
                } else if (message.packetType == JetpackPacket.MODE && !(stack = player.func_184582_a(EntityEquipmentSlot.CHEST)).func_190926_b() && stack.func_77973_b() instanceof ItemJetpack) {
                    if (!message.value) {
                        ((ItemJetpack)stack.func_77973_b()).incrementMode(stack);
                    } else {
                        ((ItemJetpack)stack.func_77973_b()).setMode(stack, ItemJetpack.JetpackMode.DISABLED);
                    }
                }
            }
        }, player);
        return null;
    }

    public static enum JetpackPacket {
        UPDATE,
        FULL,
        MODE;

    }

    public static class JetpackDataMessage
    implements IMessage {
        public JetpackPacket packetType;
        public String username;
        public boolean value;

        public JetpackDataMessage() {
        }

        public JetpackDataMessage(JetpackPacket type, String name, boolean state) {
            this.packetType = type;
            this.value = state;
            if (this.packetType == JetpackPacket.UPDATE) {
                this.username = name;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void toBytes(ByteBuf dataStream) {
            dataStream.writeInt(this.packetType.ordinal());
            if (this.packetType == JetpackPacket.MODE) {
                dataStream.writeBoolean(this.value);
            } else if (this.packetType == JetpackPacket.UPDATE) {
                PacketHandler.writeString(dataStream, this.username);
                dataStream.writeBoolean(this.value);
            } else if (this.packetType == JetpackPacket.FULL) {
                dataStream.writeInt(Mekanism.jetpackOn.size());
                Set<String> set = Mekanism.jetpackOn;
                synchronized (set) {
                    for (String username : Mekanism.jetpackOn) {
                        PacketHandler.writeString(dataStream, username);
                    }
                }
            }
        }

        public void fromBytes(ByteBuf dataStream) {
            this.packetType = JetpackPacket.values()[dataStream.readInt()];
            if (this.packetType == JetpackPacket.MODE) {
                this.value = dataStream.readBoolean();
            } else if (this.packetType == JetpackPacket.UPDATE) {
                this.username = PacketHandler.readString(dataStream);
                this.value = dataStream.readBoolean();
            } else if (this.packetType == JetpackPacket.FULL) {
                Mekanism.jetpackOn.clear();
                int amount = dataStream.readInt();
                for (int i = 0; i < amount; ++i) {
                    Mekanism.jetpackOn.add(PacketHandler.readString(dataStream));
                }
            }
        }
    }
}

