/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network;

import io.netty.buffer.ByteBuf;
import mekanism.common.Mekanism;
import mekanism.common.PacketHandler;
import mekanism.common.item.ItemFlamethrower;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketFlamethrowerData
implements IMessageHandler<FlamethrowerDataMessage, IMessage> {
    public IMessage onMessage(final FlamethrowerDataMessage message, MessageContext context) {
        final EntityPlayer player = PacketHandler.getPlayer(context);
        PacketHandler.handlePacket(new Runnable(){

            @Override
            public void run() {
                ItemStack stack;
                if (message.packetType == FlamethrowerPacket.UPDATE) {
                    if (message.value) {
                        Mekanism.flamethrowerActive.add(message.username);
                    } else {
                        Mekanism.flamethrowerActive.remove(message.username);
                    }
                    if (!player.field_70170_p.field_72995_K) {
                        Mekanism.packetHandler.sendToDimension(new FlamethrowerDataMessage(FlamethrowerPacket.UPDATE, message.currentHand, message.username, message.value), player.field_70170_p.field_73011_w.getDimension());
                    }
                } else if (message.packetType == FlamethrowerPacket.MODE && !(stack = player.func_184586_b(message.currentHand)).func_190926_b() && stack.func_77973_b() instanceof ItemFlamethrower) {
                    ((ItemFlamethrower)stack.func_77973_b()).incrementMode(stack);
                }
            }
        }, player);
        return null;
    }

    public static enum FlamethrowerPacket {
        UPDATE,
        MODE;

    }

    public static class FlamethrowerDataMessage
    implements IMessage {
        public FlamethrowerPacket packetType;
        public EnumHand currentHand;
        public String username;
        public boolean value;

        public FlamethrowerDataMessage() {
        }

        public FlamethrowerDataMessage(FlamethrowerPacket type, EnumHand hand, String name, boolean state) {
            this.packetType = type;
            if (type == FlamethrowerPacket.UPDATE) {
                this.username = name;
                this.value = state;
            } else if (type == FlamethrowerPacket.MODE) {
                this.currentHand = hand;
            }
        }

        public void toBytes(ByteBuf dataStream) {
            dataStream.writeInt(this.packetType.ordinal());
            if (this.packetType == FlamethrowerPacket.UPDATE) {
                PacketHandler.writeString(dataStream, this.username);
                dataStream.writeBoolean(this.value);
            } else {
                dataStream.writeInt(this.currentHand.ordinal());
            }
        }

        public void fromBytes(ByteBuf dataStream) {
            this.packetType = FlamethrowerPacket.values()[dataStream.readInt()];
            if (this.packetType == FlamethrowerPacket.UPDATE) {
                this.username = PacketHandler.readString(dataStream);
                this.value = dataStream.readBoolean();
            } else if (this.packetType == FlamethrowerPacket.MODE) {
                this.currentHand = EnumHand.values()[dataStream.readInt()];
            }
        }
    }
}

