/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item;

import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mekanism.api.EnumColor;
import mekanism.common.base.IItemNetwork;
import mekanism.common.item.ItemMekanism;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.LangUtils;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class ItemWalkieTalkie
extends ItemMekanism
implements IItemNetwork {
    public static ModelResourceLocation OFF_MODEL = new ModelResourceLocation("mekanism:WalkieTalkie", "inventory");
    public static Map<Integer, ModelResourceLocation> CHANNEL_MODELS = new HashMap<Integer, ModelResourceLocation>();

    public ItemWalkieTalkie() {
        this.func_77625_d(1);
    }

    public void func_77624_a(ItemStack itemstack, EntityPlayer entityplayer, List<String> list, boolean flag) {
        super.func_77624_a(itemstack, entityplayer, list, flag);
        list.add((Object)((Object)(this.getOn(itemstack) ? EnumColor.DARK_GREEN : EnumColor.DARK_RED)) + LangUtils.localize("gui." + (this.getOn(itemstack) ? "on" : "off")));
        list.add((Object)((Object)EnumColor.DARK_AQUA) + LangUtils.localize("tooltip.channel") + ": " + (Object)((Object)EnumColor.GREY) + this.getChannel(itemstack));
    }

    public static ModelResourceLocation getModel(int channel) {
        if (CHANNEL_MODELS.get(channel) == null) {
            CHANNEL_MODELS.put(channel, new ModelResourceLocation("mekanism:WalkieTalkie_ch" + channel, "inventory"));
        }
        return CHANNEL_MODELS.get(channel);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack itemStack = player.func_184586_b(hand);
        if (player.func_70093_af()) {
            this.setOn(itemStack, !this.getOn(itemStack));
            return new ActionResult(EnumActionResult.SUCCESS, (Object)itemStack);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)itemStack);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return !ItemStack.func_179545_c((ItemStack)oldStack, (ItemStack)newStack);
    }

    public void setOn(ItemStack itemStack, boolean on) {
        ItemDataUtils.setBoolean(itemStack, "on", on);
    }

    public boolean getOn(ItemStack itemStack) {
        return ItemDataUtils.getBoolean(itemStack, "on");
    }

    public void setChannel(ItemStack itemStack, int channel) {
        ItemDataUtils.setInt(itemStack, "channel", channel);
    }

    public int getChannel(ItemStack itemStack) {
        int channel = ItemDataUtils.getInt(itemStack, "channel");
        if (channel == 0) {
            this.setChannel(itemStack, 1);
            channel = 1;
        }
        return channel;
    }

    @Override
    public void handlePacketData(ItemStack stack, ByteBuf dataStream) throws Exception {
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            int channel = dataStream.readInt();
            this.setChannel(stack, channel);
        }
    }
}

