/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item;

import cofh.api.energy.IEnergyContainerItem;
import ic2.api.item.IElectricItemManager;
import ic2.api.item.ISpecialElectricItem;
import java.util.List;
import mekanism.api.EnumColor;
import mekanism.api.energy.IEnergizedItem;
import mekanism.common.Mekanism;
import mekanism.common.capabilities.ItemCapabilityWrapper;
import mekanism.common.config.MekanismConfig;
import mekanism.common.integration.forgeenergy.ForgeEnergyItemWrapper;
import mekanism.common.integration.ic2.IC2ItemManager;
import mekanism.common.integration.tesla.TeslaItemWrapper;
import mekanism.common.item.ItemMekanism;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.Optional;

@Optional.InterfaceList(value={@Optional.Interface(iface="ic2.api.item.ISpecialElectricItem", modid="ic2")})
public class ItemEnergized
extends ItemMekanism
implements IEnergizedItem,
ISpecialElectricItem,
IEnergyContainerItem {
    public double MAX_ELECTRICITY;

    public ItemEnergized(double maxElectricity) {
        this.MAX_ELECTRICITY = maxElectricity;
        this.func_77625_d(1);
        this.func_77637_a(Mekanism.tabMekanism);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - this.getEnergy(stack) / this.getMaxEnergy(stack);
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return MathHelper.func_181758_c((float)(Math.max(0.0f, (float)(1.0 - this.getDurabilityForDisplay(stack))) / 3.0f), (float)1.0f, (float)1.0f);
    }

    public void func_77624_a(ItemStack itemstack, EntityPlayer entityplayer, List<String> list, boolean flag) {
        list.add((Object)((Object)EnumColor.AQUA) + LangUtils.localize("tooltip.storedEnergy") + ": " + (Object)((Object)EnumColor.GREY) + MekanismUtils.getEnergyDisplay(this.getEnergy(itemstack), this.getMaxEnergy(itemstack)));
    }

    public ItemStack getUnchargedItem() {
        return new ItemStack((Item)this);
    }

    public void func_150895_a(Item item, CreativeTabs tabs, NonNullList<ItemStack> list) {
        ItemStack discharged = new ItemStack((Item)this);
        list.add((Object)discharged);
        ItemStack charged = new ItemStack((Item)this);
        this.setEnergy(charged, ((IEnergizedItem)charged.func_77973_b()).getMaxEnergy(charged));
        list.add((Object)charged);
    }

    @Override
    public double getEnergy(ItemStack itemStack) {
        return ItemDataUtils.getDouble(itemStack, "energyStored");
    }

    @Override
    public void setEnergy(ItemStack itemStack, double amount) {
        ItemDataUtils.setDouble(itemStack, "energyStored", Math.max(Math.min(amount, this.getMaxEnergy(itemStack)), 0.0));
    }

    @Override
    public double getMaxEnergy(ItemStack itemStack) {
        return this.MAX_ELECTRICITY;
    }

    @Override
    public double getMaxTransfer(ItemStack itemStack) {
        return this.getMaxEnergy(itemStack) * 0.005;
    }

    @Override
    public boolean canReceive(ItemStack itemStack) {
        return this.getMaxEnergy(itemStack) - this.getEnergy(itemStack) > 0.0;
    }

    @Override
    public boolean canSend(ItemStack itemStack) {
        return this.getEnergy(itemStack) > 0.0;
    }

    @Override
    public int receiveEnergy(ItemStack theItem, int energy, boolean simulate) {
        if (this.canReceive(theItem)) {
            double energyNeeded = this.getMaxEnergy(theItem) - this.getEnergy(theItem);
            double toReceive = Math.min((double)energy * MekanismConfig.general.FROM_RF, energyNeeded);
            if (!simulate) {
                this.setEnergy(theItem, this.getEnergy(theItem) + toReceive);
            }
            return (int)Math.round(toReceive * MekanismConfig.general.TO_RF);
        }
        return 0;
    }

    @Override
    public int extractEnergy(ItemStack theItem, int energy, boolean simulate) {
        if (this.canSend(theItem)) {
            double energyRemaining = this.getEnergy(theItem);
            double toSend = Math.min((double)energy * MekanismConfig.general.FROM_RF, energyRemaining);
            if (!simulate) {
                this.setEnergy(theItem, this.getEnergy(theItem) - toSend);
            }
            return (int)Math.round(toSend * MekanismConfig.general.TO_RF);
        }
        return 0;
    }

    @Override
    public int getEnergyStored(ItemStack theItem) {
        return (int)Math.round(this.getEnergy(theItem) * MekanismConfig.general.TO_RF);
    }

    @Override
    public int getMaxEnergyStored(ItemStack theItem) {
        return (int)Math.round(this.getMaxEnergy(theItem) * MekanismConfig.general.TO_RF);
    }

    @Optional.Method(modid="ic2")
    public IElectricItemManager getManager(ItemStack itemStack) {
        return IC2ItemManager.getManager(this);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new ItemCapabilityWrapper(stack, new TeslaItemWrapper(), new ForgeEnergyItemWrapper());
    }
}

