/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item;

import java.util.ArrayList;
import java.util.List;
import mekanism.api.EnumColor;
import mekanism.common.item.ItemMekanism;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.LangUtils;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemCraftingFormula
extends ItemMekanism {
    public static ModelResourceLocation MODEL = new ModelResourceLocation("mekanism:CraftingFormula", "inventory");
    public static ModelResourceLocation INVALID_MODEL = new ModelResourceLocation("mekanism:CraftingFormulaInvalid", "inventory");
    public static ModelResourceLocation ENCODED_MODEL = new ModelResourceLocation("mekanism:CraftingFormulaEncoded", "inventory");

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemstack, EntityPlayer entityplayer, List list, boolean flag) {
        NonNullList<ItemStack> inv = this.getInventory(itemstack);
        if (inv != null) {
            this.addIngredientDetails(inv, list);
        }
    }

    private void addIngredientDetails(NonNullList<ItemStack> inv, List list) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (ItemStack stack : inv) {
            if (stack.func_190926_b()) continue;
            boolean found = false;
            for (ItemStack iterStack : stacks) {
                if (!InventoryUtils.canStack(stack, iterStack)) continue;
                iterStack.func_190917_f(stack.func_190916_E());
                found = true;
            }
            if (found) continue;
            stacks.add(stack);
        }
        list.add((Object)((Object)EnumColor.GREY) + LangUtils.localize("tooltip.ingredients") + ":");
        for (ItemStack stack : stacks) {
            list.add((Object)((Object)EnumColor.GREY) + " - " + stack.func_82833_r() + " (" + stack.func_190916_E() + ")");
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_70093_af()) {
            if (!world.field_72995_K) {
                this.setInventory(stack, null);
                this.setInvalid(stack, false);
                ((EntityPlayerMP)player).func_71120_a(player.field_71070_bA);
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }

    public int getItemStackLimit(ItemStack stack) {
        return this.getInventory(stack) != null ? 1 : 64;
    }

    public String func_77653_i(ItemStack stack) {
        if (this.getInventory(stack) == null) {
            return super.func_77653_i(stack);
        }
        return super.func_77653_i(stack) + " " + (this.isInvalid(stack) ? (Object)((Object)EnumColor.DARK_RED) + "(" + LangUtils.localize("tooltip.invalid") : (Object)((Object)EnumColor.DARK_GREEN) + "(" + LangUtils.localize("tooltip.encoded")) + ")";
    }

    public boolean isInvalid(ItemStack stack) {
        return ItemDataUtils.getBoolean(stack, "invalid");
    }

    public void setInvalid(ItemStack stack, boolean invalid) {
        ItemDataUtils.setBoolean(stack, "invalid", invalid);
    }

    public NonNullList<ItemStack> getInventory(ItemStack stack) {
        if (!ItemDataUtils.hasData(stack, "Items")) {
            return null;
        }
        NBTTagList tagList = ItemDataUtils.getList(stack, "Items");
        NonNullList inventory = NonNullList.func_191197_a((int)9, (Object)ItemStack.field_190927_a);
        for (int tagCount = 0; tagCount < tagList.func_74745_c(); ++tagCount) {
            NBTTagCompound tagCompound = tagList.func_150305_b(tagCount);
            byte slotID = tagCompound.func_74771_c("Slot");
            if (slotID < 0 || slotID >= 9) continue;
            inventory.set((int)slotID, (Object)InventoryUtils.loadFromNBT(tagCompound));
        }
        return inventory;
    }

    public void setInventory(ItemStack stack, NonNullList<ItemStack> inv) {
        if (inv == null) {
            ItemDataUtils.removeData(stack, "Items");
            return;
        }
        NBTTagList tagList = new NBTTagList();
        for (int slotCount = 0; slotCount < 9; ++slotCount) {
            if (((ItemStack)inv.get(slotCount)).func_190926_b()) continue;
            NBTTagCompound tagCompound = new NBTTagCompound();
            tagCompound.func_74774_a("Slot", (byte)slotCount);
            ((ItemStack)inv.get(slotCount)).func_77955_b(tagCompound);
            tagList.func_74742_a((NBTBase)tagCompound);
        }
        ItemDataUtils.setList(stack, "Items", tagList);
    }
}

