/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item;

import java.util.List;
import mekanism.api.EnumColor;
import mekanism.api.IConfigCardAccess;
import mekanism.common.base.IRedstoneControl;
import mekanism.common.base.ISideConfiguration;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.item.ItemMekanism;
import mekanism.common.tile.prefab.TileEntityContainerBlock;
import mekanism.common.util.CapabilityUtils;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.LangUtils;
import mekanism.common.util.SecurityUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class ItemConfigurationCard
extends ItemMekanism {
    public ItemConfigurationCard() {
        this.func_77625_d(1);
    }

    public void func_77624_a(ItemStack itemstack, EntityPlayer entityplayer, List list, boolean flag) {
        super.func_77624_a(itemstack, entityplayer, list, flag);
        list.add((Object)((Object)EnumColor.GREY) + LangUtils.localize("gui.data") + ": " + (Object)((Object)EnumColor.INDIGO) + LangUtils.localize(this.getDataType(itemstack)));
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        TileEntity tileEntity;
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K && CapabilityUtils.hasCapability((ICapabilityProvider)(tileEntity = world.func_175625_s(pos)), Capabilities.CONFIG_CARD_CAPABILITY, side)) {
            if (SecurityUtils.canAccess(player, tileEntity)) {
                if (player.func_70093_af()) {
                    NBTTagCompound data = this.getBaseData(tileEntity);
                    if (CapabilityUtils.hasCapability((ICapabilityProvider)tileEntity, Capabilities.SPECIAL_CONFIG_DATA_CAPABILITY, side)) {
                        IConfigCardAccess.ISpecialConfigData special = CapabilityUtils.getCapability((ICapabilityProvider)tileEntity, Capabilities.SPECIAL_CONFIG_DATA_CAPABILITY, side);
                        data = special.getConfigurationData(data);
                    }
                    if (data != null) {
                        data.func_74778_a("dataType", this.getNameFromTile(tileEntity, side));
                        this.setData(stack, data);
                        player.func_145747_a((ITextComponent)new TextComponentString((Object)((Object)EnumColor.DARK_BLUE) + "[Mekanism] " + (Object)((Object)EnumColor.GREY) + LangUtils.localize("tooltip.configurationCard.got").replaceAll("%s", (Object)((Object)EnumColor.INDIGO) + LangUtils.localize(data.func_74779_i("dataType")) + (Object)((Object)EnumColor.GREY))));
                    }
                    return EnumActionResult.SUCCESS;
                }
                if (this.getData(stack) != null) {
                    if (this.getNameFromTile(tileEntity, side).equals(this.getDataType(stack))) {
                        this.setBaseData(this.getData(stack), tileEntity);
                        if (CapabilityUtils.hasCapability((ICapabilityProvider)tileEntity, Capabilities.SPECIAL_CONFIG_DATA_CAPABILITY, side)) {
                            IConfigCardAccess.ISpecialConfigData special = CapabilityUtils.getCapability((ICapabilityProvider)tileEntity, Capabilities.SPECIAL_CONFIG_DATA_CAPABILITY, side);
                            special.setConfigurationData(this.getData(stack));
                        }
                        player.func_145747_a((ITextComponent)new TextComponentString((Object)((Object)EnumColor.DARK_BLUE) + "[Mekanism] " + (Object)((Object)EnumColor.DARK_GREEN) + LangUtils.localize("tooltip.configurationCard.set").replaceAll("%s", (Object)((Object)EnumColor.INDIGO) + LangUtils.localize(this.getDataType(stack)) + (Object)((Object)EnumColor.DARK_GREEN))));
                        this.setData(stack, null);
                    } else {
                        player.func_145747_a((ITextComponent)new TextComponentString((Object)((Object)EnumColor.DARK_BLUE) + "[Mekanism] " + (Object)((Object)EnumColor.RED) + LangUtils.localize("tooltip.configurationCard.unequal") + "."));
                    }
                    return EnumActionResult.SUCCESS;
                }
            } else {
                SecurityUtils.displayNoAccess(player);
            }
        }
        return EnumActionResult.PASS;
    }

    private NBTTagCompound getBaseData(TileEntity tile) {
        NBTTagCompound nbtTags = new NBTTagCompound();
        if (tile instanceof IRedstoneControl) {
            nbtTags.func_74768_a("controlType", ((IRedstoneControl)tile).getControlType().ordinal());
        }
        if (tile instanceof ISideConfiguration) {
            ((ISideConfiguration)tile).getConfig().write(nbtTags);
            ((ISideConfiguration)tile).getEjector().write(nbtTags);
        }
        return nbtTags;
    }

    private void setBaseData(NBTTagCompound nbtTags, TileEntity tile) {
        if (tile instanceof IRedstoneControl) {
            ((IRedstoneControl)tile).setControlType(IRedstoneControl.RedstoneControl.values()[nbtTags.func_74762_e("controlType")]);
        }
        if (tile instanceof ISideConfiguration) {
            ((ISideConfiguration)tile).getConfig().read(nbtTags);
            ((ISideConfiguration)tile).getEjector().read(nbtTags);
        }
    }

    private String getNameFromTile(TileEntity tile, EnumFacing side) {
        String ret = Integer.toString(tile.hashCode());
        if (tile instanceof TileEntityContainerBlock) {
            ret = tile.func_145838_q().func_149739_a() + "." + ((TileEntityContainerBlock)tile).fullName + ".name";
        }
        if (CapabilityUtils.hasCapability((ICapabilityProvider)tile, Capabilities.SPECIAL_CONFIG_DATA_CAPABILITY, side)) {
            IConfigCardAccess.ISpecialConfigData special = CapabilityUtils.getCapability((ICapabilityProvider)tile, Capabilities.SPECIAL_CONFIG_DATA_CAPABILITY, side);
            ret = special.getDataType();
        }
        return ret;
    }

    public void setData(ItemStack itemstack, NBTTagCompound data) {
        if (data != null) {
            ItemDataUtils.setCompound(itemstack, "data", data);
        } else {
            ItemDataUtils.removeData(itemstack, "data");
        }
    }

    public NBTTagCompound getData(ItemStack itemstack) {
        NBTTagCompound data = ItemDataUtils.getCompound(itemstack, "data");
        if (data.func_82582_d()) {
            return null;
        }
        return ItemDataUtils.getCompound(itemstack, "data");
    }

    public String getDataType(ItemStack itemstack) {
        NBTTagCompound data = this.getData(itemstack);
        if (data != null) {
            return data.func_74779_i("dataType");
        }
        return "gui.none";
    }
}

