/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.multipart;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import mcmultipart.api.container.IMultipartContainer;
import mcmultipart.api.multipart.IMultipartTile;
import mcmultipart.api.slot.EnumFaceSlot;
import mcmultipart.api.slot.IPartSlot;
import mcmultipart.api.world.IMultipartBlockAccess;
import mekanism.common.base.ITileNetwork;
import mekanism.common.integration.multipart.MultipartMekanism;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class MultipartTileNetworkJoiner
implements ITileNetwork {
    private final HashMap<Byte, ITileNetwork> tileSideMap = new HashMap();

    public MultipartTileNetworkJoiner(List<ITileNetwork> tileList) {
        IMultipartContainer container = null;
        TileEntity first = (TileEntity)tileList.get(0);
        World world = first.func_145831_w();
        if (world instanceof IMultipartBlockAccess) {
            container = ((IMultipartBlockAccess)world).getPartInfo().getContainer();
        } else {
            TileEntity worldTile = first.func_145831_w().func_175625_s(first.func_174877_v());
            if (worldTile instanceof IMultipartContainer) {
                container = (IMultipartContainer)worldTile;
            }
        }
        if (container != null) {
            for (IPartSlot slot : container.getParts().keySet()) {
                int tileIndex = tileList.indexOf(((IMultipartTile)container.getPartTile(slot).get()).getTileEntity());
                if (tileIndex < 0) continue;
                byte slotValue = slot instanceof EnumFaceSlot ? (byte)((EnumFaceSlot)slot).ordinal() : (byte)6;
                this.tileSideMap.put(slotValue, tileList.get(tileIndex));
            }
        }
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) throws Exception {
        byte side;
        ITileNetwork networkTile;
        while (dataStream.readableBytes() > 0 && (networkTile = this.tileSideMap.get(side = dataStream.readByte())) != null) {
            networkTile.handlePacketData(dataStream);
        }
    }

    @Override
    public ArrayList<Object> getNetworkedData(ArrayList<Object> data) {
        ArrayList<Object> childData = new ArrayList<Object>();
        for (byte slotValue : this.tileSideMap.keySet()) {
            this.tileSideMap.get(slotValue).getNetworkedData(childData);
            data.addAll(childData);
            childData.clear();
        }
        return data;
    }

    public static void addMultipartHeader(TileEntity entity, ArrayList<Object> data, EnumFacing facing) {
        int tileNetworkParts = 0;
        IMultipartContainer container = MultipartMekanism.getContainer((IBlockAccess)entity.func_145831_w(), entity.func_174877_v());
        if (container != null) {
            IPartSlot slot;
            TileEntity part;
            Iterator iterator = container.getParts().keySet().iterator();
            while (iterator.hasNext() && (!((part = (TileEntity)container.getPartTile(slot = (IPartSlot)iterator.next()).map(multiPartTile -> multiPartTile.getTileEntity()).orElse(null)) instanceof ITileNetwork) || ++tileNetworkParts <= 1)) {
            }
        }
        if (tileNetworkParts > 1) {
            data.add(0, (byte)(facing == null ? 6 : facing.ordinal()));
        }
    }
}

