/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.multipart;

import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcmultipart.api.addon.IMCMPAddon;
import mcmultipart.api.addon.MCMPAddon;
import mcmultipart.api.container.IMultipartContainer;
import mcmultipart.api.container.IPartInfo;
import mcmultipart.api.multipart.IMultipart;
import mcmultipart.api.multipart.IMultipartRegistry;
import mcmultipart.api.multipart.IMultipartTile;
import mcmultipart.api.multipart.MultipartCapabilityHelper;
import mcmultipart.api.multipart.MultipartOcclusionHelper;
import mcmultipart.api.ref.MCMPCapabilities;
import mcmultipart.api.slot.EnumCenterSlot;
import mcmultipart.api.slot.IPartSlot;
import mcmultipart.api.world.IMultipartBlockAccess;
import mekanism.common.MekanismBlocks;
import mekanism.common.block.BlockTransmitter;
import mekanism.common.block.states.BlockStateMachine;
import mekanism.common.block.states.BlockStateTransmitter;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.integration.multipart.MultipartGlowPanel;
import mekanism.common.integration.multipart.MultipartTile;
import mekanism.common.integration.multipart.MultipartTileNetworkJoiner;
import mekanism.common.integration.multipart.MultipartTransmitter;
import mekanism.common.tile.TileEntityGlowPanel;
import mekanism.common.tile.transmitter.TileEntityTransmitter;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@MCMPAddon
public class MultipartMekanism
implements IMCMPAddon {
    @SubscribeEvent
    public void onAttachTile(AttachCapabilitiesEvent<TileEntity> event) {
        TileEntity tile = (TileEntity)event.getObject();
        if (tile instanceof TileEntityTransmitter) {
            this.register(event, "transmitter");
        } else if (tile instanceof TileEntityGlowPanel) {
            this.register(event, "glow_panel");
        }
    }

    public void registerParts(IMultipartRegistry registry) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        registry.registerPartWrapper(MekanismBlocks.Transmitter, (IMultipart)new MultipartTransmitter());
        registry.registerStackWrapper(Item.func_150898_a((Block)MekanismBlocks.Transmitter), s -> true, MekanismBlocks.Transmitter);
        registry.registerPartWrapper(MekanismBlocks.GlowPanel, (IMultipart)new MultipartGlowPanel());
        registry.registerStackWrapper(Item.func_150898_a((Block)MekanismBlocks.GlowPanel), s -> true, MekanismBlocks.GlowPanel);
        MultipartCapabilityHelper.registerCapabilityJoiner(Capabilities.TILE_NETWORK_CAPABILITY, MultipartTileNetworkJoiner::new);
    }

    private void register(final AttachCapabilitiesEvent<TileEntity> e, final String id) {
        e.addCapability(new ResourceLocation("mekanism:" + id), new ICapabilityProvider(){
            private MultipartTile tile;

            public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
                return capability == MCMPCapabilities.MULTIPART_TILE;
            }

            @Nullable
            public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
                if (capability == MCMPCapabilities.MULTIPART_TILE) {
                    if (this.tile == null) {
                        this.tile = new MultipartTile((TileEntity)e.getObject(), id);
                    }
                    return (T)MCMPCapabilities.MULTIPART_TILE.cast((Object)this.tile);
                }
                return null;
            }
        });
    }

    public void init() {
        this.registerMicroMaterials();
    }

    public void registerMicroMaterials() {
        for (int i = 0; i < 16; ++i) {
            FMLInterModComms.sendMessage((String)"ForgeMicroblock", (String)"microMaterial", (ItemStack)new ItemStack(MekanismBlocks.BasicBlock, 1, i));
            if (!BlockStateMachine.MachineType.get((BlockStateMachine.MachineBlock)BlockStateMachine.MachineBlock.MACHINE_BLOCK_1, (int)i).hasModel) {
                FMLInterModComms.sendMessage((String)"ForgeMicroblock", (String)"microMaterial", (ItemStack)new ItemStack(MekanismBlocks.MachineBlock, 1, i));
            }
            if (BlockStateMachine.MachineType.get((BlockStateMachine.MachineBlock)BlockStateMachine.MachineBlock.MACHINE_BLOCK_2, (int)i).hasModel) continue;
            FMLInterModComms.sendMessage((String)"ForgeMicroblock", (String)"microMaterial", (ItemStack)new ItemStack(MekanismBlocks.MachineBlock2, 1, i));
        }
        FMLInterModComms.sendMessage((String)"ForgeMicroblock", (String)"microMaterial", (ItemStack)new ItemStack(MekanismBlocks.BasicBlock2, 1, 0));
        FMLInterModComms.sendMessage((String)"ForgeMicroblock", (String)"microMaterial", (ItemStack)new ItemStack(MekanismBlocks.CardboardBox));
    }

    public static boolean hasConnectionWith(TileEntity tile, EnumFacing side) {
        IPartInfo partInfo;
        IMultipartTile multipartTile;
        if (tile != null && tile.hasCapability(MCMPCapabilities.MULTIPART_TILE, null) && (multipartTile = (IMultipartTile)tile.getCapability(MCMPCapabilities.MULTIPART_TILE, null)) instanceof MultipartTile && ((MultipartTile)multipartTile).getID().equals("transmitter") && (partInfo = ((MultipartTile)multipartTile).getInfo()) != null) {
            for (IPartInfo info : partInfo.getContainer().getParts().values()) {
                IMultipart multipart = info.getPart();
                Collection<AxisAlignedBB> origBounds = MultipartMekanism.getTransmitterSideBounds(multipartTile, side);
                if (!MultipartOcclusionHelper.testBoxIntersection(origBounds, (Collection)multipart.getOcclusionBoxes(info))) continue;
                return false;
            }
        }
        return true;
    }

    public static Collection<AxisAlignedBB> getTransmitterSideBounds(IMultipartTile tile, EnumFacing side) {
        if (tile.getTileEntity() instanceof TileEntityTransmitter) {
            TileEntityTransmitter transmitter = (TileEntityTransmitter)tile.getTileEntity();
            boolean large = transmitter.getTransmitterType().getSize() == BlockStateTransmitter.TransmitterType.Size.LARGE;
            AxisAlignedBB ret = large ? BlockTransmitter.largeSides[side.ordinal()] : BlockTransmitter.smallSides[side.ordinal()];
            return Collections.singletonList(ret);
        }
        return Collections.emptyList();
    }

    static IMultipartContainer getContainer(IBlockAccess world, BlockPos pos) {
        IMultipartContainer container = null;
        if (world instanceof IMultipartBlockAccess) {
            container = ((IMultipartBlockAccess)world).getPartInfo().getContainer();
        } else {
            TileEntity possibleContainer = world.func_175625_s(pos);
            if (possibleContainer instanceof IMultipartContainer) {
                container = (IMultipartContainer)possibleContainer;
            }
        }
        return container;
    }

    public static boolean hasCenterSlot(IBlockAccess world, BlockPos pos) {
        boolean hasCenterSlot = false;
        IMultipartContainer container = MultipartMekanism.getContainer(world, pos);
        if (container != null) {
            hasCenterSlot = container.getPart((IPartSlot)EnumCenterSlot.CENTER).isPresent();
        }
        return hasCenterSlot;
    }

    public static TileEntity unwrapTileEntity(IBlockAccess world) {
        TileEntity tile = null;
        if (world instanceof IMultipartBlockAccess) {
            tile = ((IMultipartBlockAccess)world).getPartInfo().getTile().getTileEntity();
        }
        return tile;
    }
}

