/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.transporter;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import mekanism.common.content.transporter.Finder;
import mekanism.common.content.transporter.InvStack;
import mekanism.common.content.transporter.StackSearcher;
import mekanism.common.content.transporter.TransporterFilter;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class TItemStackFilter
extends TransporterFilter {
    public boolean sizeMode;
    public int min;
    public int max;
    public ItemStack itemType = ItemStack.field_190927_a;

    @Override
    public boolean canFilter(ItemStack itemStack, boolean strict) {
        if (itemStack.func_190926_b()) {
            return false;
        }
        if (strict && this.sizeMode && (this.max == 0 || itemStack.func_190916_E() < this.min)) {
            return false;
        }
        return this.itemType.func_77981_g() ? this.itemType.func_77969_a(itemStack) : this.itemType.func_77973_b() == itemStack.func_77973_b();
    }

    @Override
    public InvStack getStackFromInventory(StackSearcher searcher) {
        if (this.sizeMode) {
            return searcher.takeDefinedItem(this.itemType, this.min, this.max);
        }
        return super.getStackFromInventory(searcher);
    }

    @Override
    public Finder getFinder() {
        return new Finder.ItemStackFinder(this.itemType);
    }

    @Override
    public void write(NBTTagCompound nbtTags) {
        super.write(nbtTags);
        nbtTags.func_74768_a("type", 0);
        nbtTags.func_74757_a("sizeMode", this.sizeMode);
        nbtTags.func_74768_a("min", this.min);
        nbtTags.func_74768_a("max", this.max);
        this.itemType.func_77955_b(nbtTags);
    }

    @Override
    protected void read(NBTTagCompound nbtTags) {
        super.read(nbtTags);
        this.sizeMode = nbtTags.func_74767_n("sizeMode");
        this.min = nbtTags.func_74762_e("min");
        this.max = nbtTags.func_74762_e("max");
        this.itemType = InventoryUtils.loadFromNBT(nbtTags);
    }

    @Override
    public void write(ArrayList<Object> data) {
        data.add(0);
        super.write(data);
        data.add(this.sizeMode);
        data.add(this.min);
        data.add(this.max);
        data.add(MekanismUtils.getID(this.itemType));
        data.add(this.itemType.func_190916_E());
        data.add(this.itemType.func_77952_i());
    }

    @Override
    protected void read(ByteBuf dataStream) {
        super.read(dataStream);
        this.sizeMode = dataStream.readBoolean();
        this.min = dataStream.readInt();
        this.max = dataStream.readInt();
        this.itemType = new ItemStack(Item.func_150899_d((int)dataStream.readInt()), dataStream.readInt(), dataStream.readInt());
    }

    @Override
    public int hashCode() {
        int code = 1;
        code = 31 * code + super.hashCode();
        code = 31 * code + MekanismUtils.getID(this.itemType);
        code = 31 * code + this.itemType.func_190916_E();
        code = 31 * code + this.itemType.func_77952_i();
        code = 31 * code + (this.sizeMode ? 1 : 0);
        code = 31 * code + this.min;
        code = 31 * code + this.max;
        return code;
    }

    @Override
    public boolean equals(Object filter) {
        return super.equals(filter) && filter instanceof TItemStackFilter && ((TItemStackFilter)filter).itemType.func_77969_a(this.itemType) && ((TItemStackFilter)filter).sizeMode == this.sizeMode && ((TItemStackFilter)filter).min == this.min && ((TItemStackFilter)filter).max == this.max;
    }

    public TItemStackFilter clone() {
        TItemStackFilter filter = new TItemStackFilter();
        filter.allowDefault = this.allowDefault;
        filter.color = this.color;
        filter.itemType = this.itemType.func_77946_l();
        filter.sizeMode = this.sizeMode;
        filter.min = this.min;
        filter.max = this.max;
        return filter;
    }
}

