/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.miner;

import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import mekanism.api.Chunk3D;
import mekanism.api.Coord4D;
import mekanism.api.util.BlockInfo;
import mekanism.common.content.miner.MinerFilter;
import mekanism.common.tile.TileEntityBoundingBlock;
import mekanism.common.tile.TileEntityDigitalMiner;
import mekanism.common.util.MekanismUtils;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.IFluidBlock;

public class ThreadMinerSearch
extends Thread {
    public TileEntityDigitalMiner tileEntity;
    public State state = State.IDLE;
    public Map<Chunk3D, BitSet> oresToMine = new HashMap<Chunk3D, BitSet>();
    public Map<Integer, MinerFilter> replaceMap = new HashMap<Integer, MinerFilter>();
    public Map<BlockInfo, MinerFilter> acceptedItems = new HashMap<BlockInfo, MinerFilter>();
    public int found = 0;

    public ThreadMinerSearch(TileEntityDigitalMiner tile) {
        this.tileEntity = tile;
    }

    @Override
    public void run() {
        this.state = State.SEARCHING;
        if (!this.tileEntity.inverse && this.tileEntity.filters.isEmpty()) {
            this.state = State.FINISHED;
            return;
        }
        Coord4D coord = this.tileEntity.getStartingCoord();
        int diameter = this.tileEntity.getDiameter();
        int size = this.tileEntity.getTotalSize();
        BlockInfo info = new BlockInfo(null, 0);
        for (int i = 0; i < size; ++i) {
            int x = coord.xCoord + i % diameter;
            int z = coord.zCoord + i / diameter % diameter;
            int y = coord.yCoord + i / diameter / diameter;
            if (this.tileEntity.func_145837_r()) {
                return;
            }
            try {
                TileEntity tile;
                if (this.tileEntity.func_174877_v().func_177958_n() == x && this.tileEntity.func_174877_v().func_177956_o() == y && this.tileEntity.func_174877_v().func_177952_p() == z || this.tileEntity.func_145831_w().func_72863_F().func_186026_b(x >> 4, z >> 4) == null || (tile = this.tileEntity.func_145831_w().func_175625_s(new BlockPos(x, y, z))) instanceof TileEntityBoundingBlock) continue;
                IBlockState state = this.tileEntity.func_145831_w().func_180495_p(new BlockPos(x, y, z));
                info.block = state.func_177230_c();
                info.meta = state.func_177230_c().func_176201_c(state);
                if (info.block instanceof BlockLiquid || info.block instanceof IFluidBlock || info.block == null || this.tileEntity.func_145831_w().func_175623_d(new BlockPos(x, y, z))) continue;
                BlockPos blockPos = new BlockPos(x, y, z);
                if (!(state.func_185887_b(this.tileEntity.func_145831_w(), blockPos) >= 0.0f)) continue;
                MinerFilter filterFound = null;
                boolean canFilter = false;
                if (this.acceptedItems.containsKey(info)) {
                    filterFound = this.acceptedItems.get(info);
                } else {
                    ItemStack stack = new ItemStack(info.block, 1, info.meta);
                    if (this.tileEntity.isReplaceStack(stack)) continue;
                    for (MinerFilter filter : this.tileEntity.filters) {
                        if (!filter.canFilter(stack)) continue;
                        filterFound = filter;
                        break;
                    }
                    this.acceptedItems.put(info, filterFound);
                }
                boolean bl = this.tileEntity.inverse ? filterFound == null : (canFilter = filterFound != null);
                if (!canFilter) continue;
                this.set(i, new Coord4D(x, y, z, this.tileEntity.func_145831_w().field_73011_w.getDimension()));
                this.replaceMap.put(i, filterFound);
                ++this.found;
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.state = State.FINISHED;
        this.tileEntity.oresToMine = this.oresToMine;
        this.tileEntity.replaceMap = this.replaceMap;
        MekanismUtils.saveChunk(this.tileEntity);
    }

    public void set(int i, Coord4D location) {
        Chunk3D chunk = new Chunk3D(location);
        if (this.oresToMine.get(chunk) == null) {
            this.oresToMine.put(chunk, new BitSet());
        }
        this.oresToMine.get(chunk).set(i);
    }

    public void reset() {
        this.state = State.IDLE;
    }

    public static enum State {
        IDLE("Not ready"),
        SEARCHING("Searching"),
        PAUSED("Paused"),
        FINISHED("Ready");

        public String desc;

        private State(String s) {
            this.desc = s;
        }
    }
}

