/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.obj;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.vecmath.Matrix4f;
import javax.vecmath.Vector3f;
import mekanism.api.EnumColor;
import mekanism.client.render.obj.OBJBakedModelBase;
import mekanism.common.block.property.PropertyColor;
import mekanism.common.tile.TileEntityGlowPanel;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.IPerspectiveAwareModel;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.obj.OBJModel;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import org.apache.commons.lang3.tuple.Pair;

public class GlowPanelModel
extends OBJBakedModelBase {
    private static Map<Integer, List<BakedQuad>> glowPanelCache = new HashMap<Integer, List<BakedQuad>>();
    private static Map<Integer, GlowPanelModel> glowPanelItemCache = new HashMap<Integer, GlowPanelModel>();
    private IBlockState tempState;
    private ItemStack tempStack;
    private GlowPanelOverride override = new GlowPanelOverride();
    public static Map<ItemCameraTransforms.TransformType, TRSRTransformation> transforms = ImmutableMap.builder().put((Object)ItemCameraTransforms.TransformType.GUI, (Object)GlowPanelModel.get(0.0f, 0.0f, 0.0f, 30.0f, 225.0f, 0.0f, 0.625f)).put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, (Object)GlowPanelModel.get(0.0f, 2.5f, 0.0f, 75.0f, 45.0f, 0.0f, 0.375f)).put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, (Object)GlowPanelModel.get(0.0f, 2.5f, 0.0f, 75.0f, 45.0f, 0.0f, 0.375f)).put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, (Object)GlowPanelModel.get(0.0f, 0.0f, 0.0f, 0.0f, 45.0f, 0.0f, 0.4f)).put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, (Object)GlowPanelModel.get(0.0f, 0.0f, 0.0f, 0.0f, 225.0f, 0.0f, 0.4f)).put((Object)ItemCameraTransforms.TransformType.GROUND, (Object)GlowPanelModel.get(0.0f, 2.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.25f)).put((Object)ItemCameraTransforms.TransformType.HEAD, (Object)GlowPanelModel.get(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f)).put((Object)ItemCameraTransforms.TransformType.FIXED, (Object)GlowPanelModel.get(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f)).put((Object)ItemCameraTransforms.TransformType.NONE, (Object)GlowPanelModel.get(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f)).build();

    public GlowPanelModel(IBakedModel base, OBJModel model, IModelState state, VertexFormat format, ImmutableMap<String, TextureAtlasSprite> textures, HashMap<ItemCameraTransforms.TransformType, Matrix4f> transform) {
        super(base, model, state, format, textures, transform);
    }

    public static void forceRebake() {
        glowPanelCache.clear();
        glowPanelItemCache.clear();
    }

    public EnumColor getColor() {
        if (this.tempStack != null && !this.tempStack.func_190926_b()) {
            return EnumColor.DYES[this.tempStack.func_77952_i()];
        }
        if (this.tempState != null) {
            return ((PropertyColor)((IExtendedBlockState)this.tempState).getValue((IUnlistedProperty)PropertyColor.INSTANCE)).color;
        }
        return EnumColor.WHITE;
    }

    public ItemOverrideList func_188617_f() {
        return this.override;
    }

    @Override
    public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
        if (side != null) {
            return ImmutableList.of();
        }
        if (state != null && this.tempState == null) {
            int hash = TileEntityGlowPanel.hash((IExtendedBlockState)state);
            EnumColor color = ((PropertyColor)((IExtendedBlockState)state).getValue((IUnlistedProperty)PropertyColor.INSTANCE)).color;
            if (!glowPanelCache.containsKey(hash)) {
                GlowPanelModel model = new GlowPanelModel(this.baseModel, this.getModel(), this.getState(), this.vertexFormat, (ImmutableMap<String, TextureAtlasSprite>)this.textureMap, this.transformationMap);
                model.tempState = state;
                glowPanelCache.put(hash, model.func_188616_a(state, side, rand));
            }
            return glowPanelCache.get(hash);
        }
        return super.func_188616_a(state, side, rand);
    }

    @Override
    public float[] getOverrideColor(OBJModel.Face f, String groupName) {
        if (groupName.equals("light")) {
            EnumColor c = this.getColor();
            return new float[]{c.getColor(0), c.getColor(1), c.getColor(2), 1.0f};
        }
        return null;
    }

    public Pair<? extends IPerspectiveAwareModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType transformType) {
        if (transformType == ItemCameraTransforms.TransformType.GUI) {
            GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            ForgeHooksClient.multiplyCurrentGlMatrix((Matrix4f)transforms.get(transformType).getMatrix());
            GlStateManager.func_179109_b((float)0.65f, (float)0.45f, (float)0.0f);
            GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179152_a((float)1.6f, (float)1.6f, (float)1.6f);
            return Pair.of((Object)((Object)this), null);
        }
        if (transformType == ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND || transformType == ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND) {
            GlStateManager.func_179109_b((float)0.0f, (float)0.2f, (float)0.0f);
        } else if (transformType == ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND || transformType == ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND) {
            ForgeHooksClient.multiplyCurrentGlMatrix((Matrix4f)transforms.get(transformType).getMatrix());
            GlStateManager.func_179109_b((float)0.0f, (float)0.3f, (float)0.2f);
            return Pair.of((Object)((Object)this), null);
        }
        return Pair.of((Object)((Object)this), (Object)transforms.get(transformType).getMatrix());
    }

    private static TRSRTransformation get(float tx, float ty, float tz, float ax, float ay, float az, float s) {
        return new TRSRTransformation(new Vector3f(tx / 16.0f, ty / 16.0f, tz / 16.0f), TRSRTransformation.quatFromXYZDegrees((Vector3f)new Vector3f(ax, ay, az)), new Vector3f(s, s, s), null);
    }

    private class GlowPanelOverride
    extends ItemOverrideList {
        public GlowPanelOverride() {
            super((List)Lists.newArrayList());
        }

        public IBakedModel handleItemState(IBakedModel originalModel, ItemStack stack, World world, EntityLivingBase entity) {
            if (glowPanelItemCache.containsKey(stack.func_77952_i())) {
                return (IBakedModel)glowPanelItemCache.get(stack.func_77952_i());
            }
            ImmutableMap.Builder builder = ImmutableMap.builder();
            builder.put((Object)ModelLoader.White.LOCATION.toString(), (Object)ModelLoader.White.INSTANCE);
            TextureAtlasSprite missing = Minecraft.func_71410_x().func_147117_R().func_110572_b(new ResourceLocation("missingno").toString());
            for (String s : GlowPanelModel.this.getModel().getMatLib().getMaterialNames()) {
                TextureAtlasSprite sprite = null;
                if (sprite == null) {
                    sprite = Minecraft.func_71410_x().func_147117_R().func_110572_b(GlowPanelModel.this.getModel().getMatLib().getMaterial(s).getTexture().getTextureLocation().toString());
                }
                if (sprite == null) {
                    sprite = missing;
                }
                builder.put((Object)s, (Object)sprite);
            }
            builder.put((Object)"missingno", (Object)missing);
            GlowPanelModel bakedModel = new GlowPanelModel(GlowPanelModel.this.baseModel, GlowPanelModel.this.getModel(), GlowPanelModel.this.getState(), GlowPanelModel.this.vertexFormat, (ImmutableMap<String, TextureAtlasSprite>)builder.build(), GlowPanelModel.this.transformationMap);
            bakedModel.tempStack = stack;
            glowPanelItemCache.put(stack.func_77952_i(), bakedModel);
            return bakedModel;
        }
    }
}

