/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.jei;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasRegistry;
import mekanism.api.gas.GasStack;
import mekanism.client.gui.GuiChemicalCrystallizer;
import mekanism.client.gui.GuiChemicalDissolutionChamber;
import mekanism.client.gui.GuiChemicalInfuser;
import mekanism.client.gui.GuiChemicalInjectionChamber;
import mekanism.client.gui.GuiChemicalOxidizer;
import mekanism.client.gui.GuiChemicalWasher;
import mekanism.client.gui.GuiCombiner;
import mekanism.client.gui.GuiCrusher;
import mekanism.client.gui.GuiElectrolyticSeparator;
import mekanism.client.gui.GuiEnrichmentChamber;
import mekanism.client.gui.GuiMetallurgicInfuser;
import mekanism.client.gui.GuiOsmiumCompressor;
import mekanism.client.gui.GuiPRC;
import mekanism.client.gui.GuiPrecisionSawmill;
import mekanism.client.gui.GuiPurificationChamber;
import mekanism.client.gui.GuiRotaryCondensentrator;
import mekanism.client.gui.GuiSolarNeutronActivator;
import mekanism.client.gui.GuiThermalEvaporationController;
import mekanism.client.gui.element.GuiProgress;
import mekanism.client.jei.GasStackHelper;
import mekanism.client.jei.GuiElementHandler;
import mekanism.client.jei.crafting.ShapedMekanismRecipeHandler;
import mekanism.client.jei.crafting.ShapelessMekanismRecipeHandler;
import mekanism.client.jei.gas.GasStackRenderer;
import mekanism.client.jei.machine.AdvancedMachineRecipeCategory;
import mekanism.client.jei.machine.AdvancedMachineRecipeWrapper;
import mekanism.client.jei.machine.BaseRecipeHandler;
import mekanism.client.jei.machine.ChanceMachineRecipeCategory;
import mekanism.client.jei.machine.ChanceMachineRecipeWrapper;
import mekanism.client.jei.machine.MachineRecipeCategory;
import mekanism.client.jei.machine.MachineRecipeWrapper;
import mekanism.client.jei.machine.advanced.ChemicalInjectionChamberRecipeWrapper;
import mekanism.client.jei.machine.advanced.CombinerRecipeWrapper;
import mekanism.client.jei.machine.advanced.OsmiumCompressorRecipeWrapper;
import mekanism.client.jei.machine.advanced.PurificationChamberRecipeWrapper;
import mekanism.client.jei.machine.basic.CrusherRecipeWrapper;
import mekanism.client.jei.machine.basic.EnrichmentRecipeWrapper;
import mekanism.client.jei.machine.chance.PrecisionSawmillRecipeWrapper;
import mekanism.client.jei.machine.chemical.ChemicalCrystallizerRecipeCategory;
import mekanism.client.jei.machine.chemical.ChemicalCrystallizerRecipeWrapper;
import mekanism.client.jei.machine.chemical.ChemicalDissolutionChamberRecipeCategory;
import mekanism.client.jei.machine.chemical.ChemicalDissolutionChamberRecipeWrapper;
import mekanism.client.jei.machine.chemical.ChemicalInfuserRecipeCategory;
import mekanism.client.jei.machine.chemical.ChemicalInfuserRecipeWrapper;
import mekanism.client.jei.machine.chemical.ChemicalOxidizerRecipeCategory;
import mekanism.client.jei.machine.chemical.ChemicalOxidizerRecipeWrapper;
import mekanism.client.jei.machine.chemical.ChemicalWasherRecipeCategory;
import mekanism.client.jei.machine.chemical.ChemicalWasherRecipeWrapper;
import mekanism.client.jei.machine.other.ElectrolyticSeparatorRecipeCategory;
import mekanism.client.jei.machine.other.ElectrolyticSeparatorRecipeWrapper;
import mekanism.client.jei.machine.other.MetallurgicInfuserRecipeCategory;
import mekanism.client.jei.machine.other.MetallurgicInfuserRecipeWrapper;
import mekanism.client.jei.machine.other.PRCRecipeCategory;
import mekanism.client.jei.machine.other.PRCRecipeWrapper;
import mekanism.client.jei.machine.other.RotaryCondensentratorRecipeCategory;
import mekanism.client.jei.machine.other.RotaryCondensentratorRecipeWrapper;
import mekanism.client.jei.machine.other.SolarNeutronRecipeCategory;
import mekanism.client.jei.machine.other.SolarNeutronRecipeWrapper;
import mekanism.client.jei.machine.other.ThermalEvaporationRecipeCategory;
import mekanism.client.jei.machine.other.ThermalEvaporationRecipeWrapper;
import mekanism.common.MekanismBlocks;
import mekanism.common.MekanismItems;
import mekanism.common.base.IFactory;
import mekanism.common.base.ITierItem;
import mekanism.common.block.states.BlockStateBasic;
import mekanism.common.block.states.BlockStateMachine;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.recipe.machines.AdvancedMachineRecipe;
import mekanism.common.recipe.machines.BasicMachineRecipe;
import mekanism.common.recipe.machines.ChanceMachineRecipe;
import mekanism.common.recipe.machines.ChemicalInfuserRecipe;
import mekanism.common.recipe.machines.CrystallizerRecipe;
import mekanism.common.recipe.machines.DissolutionRecipe;
import mekanism.common.recipe.machines.MachineRecipe;
import mekanism.common.recipe.machines.MetallurgicInfuserRecipe;
import mekanism.common.recipe.machines.OxidationRecipe;
import mekanism.common.recipe.machines.PressurizedRecipe;
import mekanism.common.recipe.machines.SeparatorRecipe;
import mekanism.common.recipe.machines.SolarNeutronRecipe;
import mekanism.common.recipe.machines.ThermalEvaporationRecipe;
import mekanism.common.recipe.machines.WasherRecipe;
import mezz.jei.api.BlankModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.ISubtypeRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.gui.IAdvancedGuiHandler;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IModIngredientRegistration;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeHandler;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

@JEIPlugin
public class MekanismJEI
extends BlankModPlugin {
    public static GasStackRenderer GAS_RENDERER;
    public static ISubtypeRegistry.ISubtypeInterpreter NBT_INTERPRETER;

    public void registerItemSubtypes(ISubtypeRegistry registry) {
        registry.registerSubtypeInterpreter(Item.func_150898_a((Block)MekanismBlocks.EnergyCube), NBT_INTERPRETER);
        registry.registerSubtypeInterpreter(Item.func_150898_a((Block)MekanismBlocks.MachineBlock), NBT_INTERPRETER);
        registry.registerSubtypeInterpreter(Item.func_150898_a((Block)MekanismBlocks.MachineBlock2), NBT_INTERPRETER);
        registry.registerSubtypeInterpreter(Item.func_150898_a((Block)MekanismBlocks.MachineBlock3), NBT_INTERPRETER);
        registry.registerSubtypeInterpreter(Item.func_150898_a((Block)MekanismBlocks.BasicBlock), NBT_INTERPRETER);
        registry.registerSubtypeInterpreter(Item.func_150898_a((Block)MekanismBlocks.BasicBlock2), NBT_INTERPRETER);
        registry.registerSubtypeInterpreter(Item.func_150898_a((Block)MekanismBlocks.GasTank), NBT_INTERPRETER);
        registry.registerSubtypeInterpreter(Item.func_150898_a((Block)MekanismBlocks.CardboardBox), NBT_INTERPRETER);
        registry.registerSubtypeInterpreter(Item.func_150898_a((Block)MekanismBlocks.Transmitter), NBT_INTERPRETER);
    }

    public void registerIngredients(IModIngredientRegistration registry) {
        List list = GasRegistry.getRegisteredGasses().stream().filter(g -> g.isVisible()).map(g -> new GasStack((Gas)g, 1000)).collect(Collectors.toList());
        GAS_RENDERER = new GasStackRenderer();
        registry.register(GasStack.class, list, (IIngredientHelper)new GasStackHelper(), (IIngredientRenderer)GAS_RENDERER);
    }

    public void register(IModRegistry registry) {
        registry.addAdvancedGuiHandlers(new IAdvancedGuiHandler[]{new GuiElementHandler()});
        registry.addRecipeHandlers(new IRecipeHandler[]{new ShapedMekanismRecipeHandler(registry.getJeiHelpers())});
        registry.addRecipeHandlers(new IRecipeHandler[]{new ShapelessMekanismRecipeHandler(registry.getJeiHelpers())});
        registry.getJeiHelpers().getIngredientBlacklist().addIngredientToBlacklist((Object)new ItemStack(MekanismItems.ItemProxy));
        registry.getJeiHelpers().getIngredientBlacklist().addIngredientToBlacklist((Object)new ItemStack(MekanismBlocks.BoundingBlock));
        try {
            this.registerBasicMachine(registry, RecipeHandler.Recipe.ENRICHMENT_CHAMBER, "tile.MachineBlock.EnrichmentChamber.name", GuiProgress.ProgressBar.BLUE, EnrichmentRecipeWrapper.class);
            this.registerBasicMachine(registry, RecipeHandler.Recipe.CRUSHER, "tile.MachineBlock.Crusher.name", GuiProgress.ProgressBar.CRUSH, CrusherRecipeWrapper.class);
            this.registerAdvancedMachine(registry, RecipeHandler.Recipe.COMBINER, "tile.MachineBlock.Combiner.name", GuiProgress.ProgressBar.STONE, CombinerRecipeWrapper.class);
            this.registerAdvancedMachine(registry, RecipeHandler.Recipe.PURIFICATION_CHAMBER, "tile.MachineBlock.PurificationChamber.name", GuiProgress.ProgressBar.RED, PurificationChamberRecipeWrapper.class);
            this.registerAdvancedMachine(registry, RecipeHandler.Recipe.OSMIUM_COMPRESSOR, "tile.MachineBlock.OsmiumCompressor.name", GuiProgress.ProgressBar.RED, OsmiumCompressorRecipeWrapper.class);
            this.registerAdvancedMachine(registry, RecipeHandler.Recipe.CHEMICAL_INJECTION_CHAMBER, "nei.chemicalInjectionChamber", GuiProgress.ProgressBar.YELLOW, ChemicalInjectionChamberRecipeWrapper.class);
            this.registerChanceMachine(registry, RecipeHandler.Recipe.PRECISION_SAWMILL, "tile.MachineBlock2.PrecisionSawmill.name", GuiProgress.ProgressBar.PURPLE, PrecisionSawmillRecipeWrapper.class);
            MetallurgicInfuserRecipeCategory metallurgicInfuserCategory = new MetallurgicInfuserRecipeCategory(registry.getJeiHelpers().getGuiHelper());
            registry.addRecipeCategories(new IRecipeCategory[]{metallurgicInfuserCategory});
            registry.addRecipeHandlers(new IRecipeHandler[]{new BaseRecipeHandler<MetallurgicInfuserRecipeCategory, MetallurgicInfuserRecipeWrapper>(metallurgicInfuserCategory, MetallurgicInfuserRecipeWrapper.class)});
            this.addRecipes(registry, RecipeHandler.Recipe.METALLURGIC_INFUSER, metallurgicInfuserCategory, MetallurgicInfuserRecipe.class, MetallurgicInfuserRecipeCategory.class, MetallurgicInfuserRecipeWrapper.class);
            ChemicalCrystallizerRecipeCategory chemicalCrystallizerCategory = new ChemicalCrystallizerRecipeCategory(registry.getJeiHelpers().getGuiHelper());
            registry.addRecipeCategories(new IRecipeCategory[]{chemicalCrystallizerCategory});
            registry.addRecipeHandlers(new IRecipeHandler[]{new BaseRecipeHandler<ChemicalCrystallizerRecipeCategory, ChemicalCrystallizerRecipeWrapper>(chemicalCrystallizerCategory, ChemicalCrystallizerRecipeWrapper.class)});
            this.addRecipes(registry, RecipeHandler.Recipe.CHEMICAL_CRYSTALLIZER, chemicalCrystallizerCategory, CrystallizerRecipe.class, ChemicalCrystallizerRecipeCategory.class, ChemicalCrystallizerRecipeWrapper.class);
            ChemicalDissolutionChamberRecipeCategory chemicalDissolutionChamberCategory = new ChemicalDissolutionChamberRecipeCategory(registry.getJeiHelpers().getGuiHelper());
            registry.addRecipeCategories(new IRecipeCategory[]{chemicalDissolutionChamberCategory});
            registry.addRecipeHandlers(new IRecipeHandler[]{new BaseRecipeHandler<ChemicalDissolutionChamberRecipeCategory, ChemicalDissolutionChamberRecipeWrapper>(chemicalDissolutionChamberCategory, ChemicalDissolutionChamberRecipeWrapper.class)});
            this.addRecipes(registry, RecipeHandler.Recipe.CHEMICAL_DISSOLUTION_CHAMBER, chemicalDissolutionChamberCategory, DissolutionRecipe.class, ChemicalDissolutionChamberRecipeCategory.class, ChemicalDissolutionChamberRecipeWrapper.class);
            ChemicalInfuserRecipeCategory chemicalInfuserCategory = new ChemicalInfuserRecipeCategory(registry.getJeiHelpers().getGuiHelper());
            registry.addRecipeCategories(new IRecipeCategory[]{chemicalInfuserCategory});
            registry.addRecipeHandlers(new IRecipeHandler[]{new BaseRecipeHandler<ChemicalInfuserRecipeCategory, ChemicalInfuserRecipeWrapper>(chemicalInfuserCategory, ChemicalInfuserRecipeWrapper.class)});
            this.addRecipes(registry, RecipeHandler.Recipe.CHEMICAL_INFUSER, chemicalInfuserCategory, ChemicalInfuserRecipe.class, ChemicalInfuserRecipeCategory.class, ChemicalInfuserRecipeWrapper.class);
            ChemicalOxidizerRecipeCategory chemicalOxidizerCategory = new ChemicalOxidizerRecipeCategory(registry.getJeiHelpers().getGuiHelper());
            registry.addRecipeCategories(new IRecipeCategory[]{chemicalOxidizerCategory});
            registry.addRecipeHandlers(new IRecipeHandler[]{new BaseRecipeHandler<ChemicalOxidizerRecipeCategory, ChemicalOxidizerRecipeWrapper>(chemicalOxidizerCategory, ChemicalOxidizerRecipeWrapper.class)});
            this.addRecipes(registry, RecipeHandler.Recipe.CHEMICAL_OXIDIZER, chemicalOxidizerCategory, OxidationRecipe.class, ChemicalOxidizerRecipeCategory.class, ChemicalOxidizerRecipeWrapper.class);
            ChemicalWasherRecipeCategory chemicalWasherCategory = new ChemicalWasherRecipeCategory(registry.getJeiHelpers().getGuiHelper());
            registry.addRecipeCategories(new IRecipeCategory[]{chemicalWasherCategory});
            registry.addRecipeHandlers(new IRecipeHandler[]{new BaseRecipeHandler<ChemicalWasherRecipeCategory, ChemicalWasherRecipeWrapper>(chemicalWasherCategory, ChemicalWasherRecipeWrapper.class)});
            this.addRecipes(registry, RecipeHandler.Recipe.CHEMICAL_WASHER, chemicalWasherCategory, WasherRecipe.class, ChemicalWasherRecipeCategory.class, ChemicalWasherRecipeWrapper.class);
            SolarNeutronRecipeCategory solarNeutronCategory = new SolarNeutronRecipeCategory(registry.getJeiHelpers().getGuiHelper());
            registry.addRecipeCategories(new IRecipeCategory[]{solarNeutronCategory});
            registry.addRecipeHandlers(new IRecipeHandler[]{new BaseRecipeHandler<SolarNeutronRecipeCategory, SolarNeutronRecipeWrapper>(solarNeutronCategory, SolarNeutronRecipeWrapper.class)});
            this.addRecipes(registry, RecipeHandler.Recipe.SOLAR_NEUTRON_ACTIVATOR, solarNeutronCategory, SolarNeutronRecipe.class, SolarNeutronRecipeCategory.class, SolarNeutronRecipeWrapper.class);
            ElectrolyticSeparatorRecipeCategory electrolyticSeparatorCategory = new ElectrolyticSeparatorRecipeCategory(registry.getJeiHelpers().getGuiHelper());
            registry.addRecipeCategories(new IRecipeCategory[]{electrolyticSeparatorCategory});
            registry.addRecipeHandlers(new IRecipeHandler[]{new BaseRecipeHandler<ElectrolyticSeparatorRecipeCategory, ElectrolyticSeparatorRecipeWrapper>(electrolyticSeparatorCategory, ElectrolyticSeparatorRecipeWrapper.class)});
            this.addRecipes(registry, RecipeHandler.Recipe.ELECTROLYTIC_SEPARATOR, electrolyticSeparatorCategory, SeparatorRecipe.class, ElectrolyticSeparatorRecipeCategory.class, ElectrolyticSeparatorRecipeWrapper.class);
            ThermalEvaporationRecipeCategory thermalEvaporationCategory = new ThermalEvaporationRecipeCategory(registry.getJeiHelpers().getGuiHelper());
            registry.addRecipeCategories(new IRecipeCategory[]{thermalEvaporationCategory});
            registry.addRecipeHandlers(new IRecipeHandler[]{new BaseRecipeHandler<ThermalEvaporationRecipeCategory, ThermalEvaporationRecipeWrapper>(thermalEvaporationCategory, ThermalEvaporationRecipeWrapper.class)});
            this.addRecipes(registry, RecipeHandler.Recipe.THERMAL_EVAPORATION_PLANT, thermalEvaporationCategory, ThermalEvaporationRecipe.class, ThermalEvaporationRecipeCategory.class, ThermalEvaporationRecipeWrapper.class);
            PRCRecipeCategory prcCategory = new PRCRecipeCategory(registry.getJeiHelpers().getGuiHelper());
            registry.addRecipeCategories(new IRecipeCategory[]{prcCategory});
            registry.addRecipeHandlers(new IRecipeHandler[]{new BaseRecipeHandler<PRCRecipeCategory, PRCRecipeWrapper>(prcCategory, PRCRecipeWrapper.class)});
            this.addRecipes(registry, RecipeHandler.Recipe.PRESSURIZED_REACTION_CHAMBER, prcCategory, PressurizedRecipe.class, PRCRecipeCategory.class, PRCRecipeWrapper.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ArrayList<RotaryCondensentratorRecipeWrapper> condensentratorRecipes = new ArrayList<RotaryCondensentratorRecipeWrapper>();
        RotaryCondensentratorRecipeCategory rotaryCondensentratorCategory = new RotaryCondensentratorRecipeCategory(registry.getJeiHelpers().getGuiHelper());
        registry.addRecipeCategories(new IRecipeCategory[]{rotaryCondensentratorCategory});
        registry.addRecipeHandlers(new IRecipeHandler[]{new BaseRecipeHandler<RotaryCondensentratorRecipeCategory, RotaryCondensentratorRecipeWrapper>(rotaryCondensentratorCategory, RotaryCondensentratorRecipeWrapper.class)});
        for (Gas gas : GasRegistry.getRegisteredGasses()) {
            if (!gas.hasFluid()) continue;
            condensentratorRecipes.add(new RotaryCondensentratorRecipeWrapper(gas.getFluid(), gas, true, rotaryCondensentratorCategory));
            condensentratorRecipes.add(new RotaryCondensentratorRecipeWrapper(gas.getFluid(), gas, false, rotaryCondensentratorCategory));
        }
        registry.addRecipes(condensentratorRecipes);
        registry.addRecipeClickArea(GuiEnrichmentChamber.class, 79, 40, 24, 7, new String[]{"mekanism.enrichment_chamber"});
        registry.addRecipeClickArea(GuiCrusher.class, 79, 40, 24, 7, new String[]{"mekanism.crusher"});
        registry.addRecipeClickArea(GuiCombiner.class, 79, 40, 24, 7, new String[]{"mekanism.combiner"});
        registry.addRecipeClickArea(GuiPurificationChamber.class, 79, 40, 24, 7, new String[]{"mekanism.purification_chamber"});
        registry.addRecipeClickArea(GuiOsmiumCompressor.class, 79, 40, 24, 7, new String[]{"mekanism.osmium_compressor"});
        registry.addRecipeClickArea(GuiChemicalInjectionChamber.class, 79, 40, 24, 7, new String[]{"mekanism.chemical_injection_chamber"});
        registry.addRecipeClickArea(GuiPrecisionSawmill.class, 79, 40, 24, 7, new String[]{"mekanism.precision_sawmill"});
        registry.addRecipeClickArea(GuiMetallurgicInfuser.class, 72, 47, 32, 8, new String[]{"mekanism.metallurgic_infuser"});
        registry.addRecipeClickArea(GuiChemicalCrystallizer.class, 53, 62, 48, 8, new String[]{"mekanism.chemical_crystallizer"});
        registry.addRecipeClickArea(GuiChemicalDissolutionChamber.class, 64, 40, 48, 8, new String[]{"mekanism.chemical_dissolution_chamber"});
        registry.addRecipeClickArea(GuiChemicalInfuser.class, 47, 39, 28, 8, new String[]{"mekanism.chemical_infuser"});
        registry.addRecipeClickArea(GuiChemicalInfuser.class, 101, 39, 28, 8, new String[]{"mekanism.chemical_infuser"});
        registry.addRecipeClickArea(GuiChemicalOxidizer.class, 64, 40, 48, 8, new String[]{"mekanism.chemical_oxidizer"});
        registry.addRecipeClickArea(GuiChemicalWasher.class, 61, 39, 55, 8, new String[]{"mekanism.chemical_washer"});
        registry.addRecipeClickArea(GuiSolarNeutronActivator.class, 64, 39, 48, 8, new String[]{"mekanism.solar_neutron_activator"});
        registry.addRecipeClickArea(GuiElectrolyticSeparator.class, 80, 30, 16, 6, new String[]{"mekanism.electrolytic_separator"});
        registry.addRecipeClickArea(GuiThermalEvaporationController.class, 49, 20, 78, 38, new String[]{"mekanism.thermal_evaporation_plant"});
        registry.addRecipeClickArea(GuiPRC.class, 75, 37, 36, 10, new String[]{"mekanism.pressurized_reaction_chamber"});
        registry.addRecipeClickArea(GuiRotaryCondensentrator.class, 64, 39, 48, 8, new String[]{"mekanism.rotary_condensentrator"});
        this.registerRecipeItem(registry, BlockStateMachine.MachineType.ENRICHMENT_CHAMBER);
        this.registerRecipeItem(registry, BlockStateMachine.MachineType.CRUSHER);
        this.registerRecipeItem(registry, BlockStateMachine.MachineType.COMBINER);
        this.registerRecipeItem(registry, BlockStateMachine.MachineType.PURIFICATION_CHAMBER);
        this.registerRecipeItem(registry, BlockStateMachine.MachineType.OSMIUM_COMPRESSOR);
        this.registerRecipeItem(registry, BlockStateMachine.MachineType.CHEMICAL_INJECTION_CHAMBER);
        this.registerRecipeItem(registry, BlockStateMachine.MachineType.PRECISION_SAWMILL);
        this.registerRecipeItem(registry, BlockStateMachine.MachineType.METALLURGIC_INFUSER);
        this.registerRecipeItem(registry, BlockStateMachine.MachineType.CHEMICAL_CRYSTALLIZER);
        this.registerRecipeItem(registry, BlockStateMachine.MachineType.CHEMICAL_DISSOLUTION_CHAMBER);
        this.registerRecipeItem(registry, BlockStateMachine.MachineType.CHEMICAL_INFUSER);
        this.registerRecipeItem(registry, BlockStateMachine.MachineType.CHEMICAL_OXIDIZER);
        this.registerRecipeItem(registry, BlockStateMachine.MachineType.CHEMICAL_WASHER);
        this.registerRecipeItem(registry, BlockStateMachine.MachineType.SOLAR_NEUTRON_ACTIVATOR);
        this.registerRecipeItem(registry, BlockStateMachine.MachineType.ELECTROLYTIC_SEPARATOR);
        this.registerRecipeItem(registry, BlockStateMachine.MachineType.PRESSURIZED_REACTION_CHAMBER);
        this.registerRecipeItem(registry, BlockStateMachine.MachineType.ROTARY_CONDENSENTRATOR);
        registry.addRecipeCategoryCraftingItem(BlockStateBasic.BasicBlockType.THERMAL_EVAPORATION_CONTROLLER.getStack(1), new String[]{"mekanism.thermal_evaporation_plant"});
    }

    private void registerRecipeItem(IModRegistry registry, BlockStateMachine.MachineType type) {
        registry.addRecipeCategoryCraftingItem(type.getStack(), new String[]{"mekanism." + type.func_176610_l()});
    }

    private void registerBasicMachine(IModRegistry registry, RecipeHandler.Recipe recipe, String unlocalized, GuiProgress.ProgressBar bar, Class<? extends MachineRecipeWrapper> wrapper) throws Exception {
        MachineRecipeCategory category = new MachineRecipeCategory(registry.getJeiHelpers().getGuiHelper(), recipe.name().toLowerCase(), unlocalized, bar);
        registry.addRecipeCategories(new IRecipeCategory[]{category});
        registry.addRecipeHandlers(new IRecipeHandler[]{new BaseRecipeHandler<MachineRecipeCategory, MachineRecipeWrapper>(category, wrapper)});
        this.addRecipes(registry, recipe, category, BasicMachineRecipe.class, MachineRecipeCategory.class, wrapper);
    }

    private void registerAdvancedMachine(IModRegistry registry, RecipeHandler.Recipe recipe, String unlocalized, GuiProgress.ProgressBar bar, Class<? extends AdvancedMachineRecipeWrapper> wrapper) throws Exception {
        AdvancedMachineRecipeCategory category = new AdvancedMachineRecipeCategory(registry.getJeiHelpers().getGuiHelper(), recipe.name().toLowerCase(), unlocalized, bar);
        registry.addRecipeCategories(new IRecipeCategory[]{category});
        registry.addRecipeHandlers(new IRecipeHandler[]{new BaseRecipeHandler<AdvancedMachineRecipeCategory, AdvancedMachineRecipeWrapper>(category, wrapper)});
        this.addRecipes(registry, recipe, category, AdvancedMachineRecipe.class, AdvancedMachineRecipeCategory.class, wrapper);
    }

    private void registerChanceMachine(IModRegistry registry, RecipeHandler.Recipe recipe, String unlocalized, GuiProgress.ProgressBar bar, Class<? extends ChanceMachineRecipeWrapper> wrapper) throws Exception {
        ChanceMachineRecipeCategory category = new ChanceMachineRecipeCategory(registry.getJeiHelpers().getGuiHelper(), recipe.name().toLowerCase(), unlocalized, bar);
        registry.addRecipeCategories(new IRecipeCategory[]{category});
        registry.addRecipeHandlers(new IRecipeHandler[]{new BaseRecipeHandler<ChanceMachineRecipeCategory, ChanceMachineRecipeWrapper>(category, wrapper)});
        this.addRecipes(registry, recipe, category, ChanceMachineRecipe.class, ChanceMachineRecipeCategory.class, wrapper);
    }

    private void addRecipes(IModRegistry registry, RecipeHandler.Recipe type, IRecipeCategory cat, Class recipe, Class category, Class<? extends IRecipeWrapper> wrapper) throws Exception {
        ArrayList<IRecipeWrapper> recipes = new ArrayList<IRecipeWrapper>();
        for (Object obj : type.get().values()) {
            if (!(obj instanceof MachineRecipe)) continue;
            recipes.add(wrapper.getConstructor(recipe, category).newInstance(obj, cat));
        }
        registry.addRecipes(recipes);
    }

    static {
        NBT_INTERPRETER = new ISubtypeRegistry.ISubtypeInterpreter(){

            public String getSubtypeInfo(ItemStack itemStack) {
                String ret = Integer.toString(itemStack.func_77960_j());
                if (itemStack.func_77973_b() instanceof ITierItem) {
                    ret = ret + ":" + ((ITierItem)itemStack.func_77973_b()).getBaseTier(itemStack).getSimpleName();
                }
                if (itemStack.func_77973_b() instanceof IFactory) {
                    ret = ret + ":" + IFactory.RecipeType.values()[((IFactory)itemStack.func_77973_b()).getRecipeType(itemStack)].func_176610_l();
                }
                return ret.isEmpty() ? null : ret.toLowerCase();
            }
        };
    }
}

