/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.jei;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mekanism.api.gas.GasStack;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.GuiGauge;
import mekanism.client.gui.element.GuiProgress;
import mekanism.client.jei.gas.GasStackRenderer;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IGuiIngredientGroup;
import mezz.jei.api.gui.ITickTimer;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.recipe.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public abstract class BaseRecipeCategory
implements IRecipeCategory,
IGuiWrapper {
    public static final GuiDummy gui = new GuiDummy();
    public IGuiHelper guiHelper;
    public String recipeName;
    public String unlocalizedName;
    public String guiTexture;
    public ResourceLocation guiLocation;
    public GuiProgress.ProgressBar progressBar;
    public ITickTimer timer;
    public int xOffset = 28;
    public int yOffset = 16;
    public IDrawable fluidOverlayLarge;
    public IDrawable fluidOverlaySmall;
    public Set<GuiElement> guiElements = new HashSet<GuiElement>();

    public BaseRecipeCategory(IGuiHelper helper, String gui, String name, String unlocalized, GuiProgress.ProgressBar progress) {
        this.guiHelper = helper;
        this.guiTexture = gui;
        this.guiLocation = new ResourceLocation(this.guiTexture);
        this.progressBar = progress;
        this.recipeName = name;
        this.unlocalizedName = unlocalized;
        this.timer = helper.createTickTimer(20, 20, false);
        this.fluidOverlayLarge = this.guiHelper.createDrawable(MekanismUtils.getResource(MekanismUtils.ResourceType.GUI_ELEMENT, GuiGauge.Type.STANDARD.textureLocation), 19, 1, 16, 59);
        this.fluidOverlaySmall = this.guiHelper.createDrawable(MekanismUtils.getResource(MekanismUtils.ResourceType.GUI_ELEMENT, GuiGauge.Type.STANDARD.textureLocation), 19, 1, 16, 29);
        this.addGuiElements();
    }

    public String getUid() {
        return "mekanism." + this.recipeName;
    }

    public String getTitle() {
        return LangUtils.localize(this.unlocalizedName);
    }

    public void drawExtras(Minecraft minecraft) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.changeTexture(this.guiLocation);
        for (GuiElement e : this.guiElements) {
            e.renderBackground(0, 0, -this.xOffset, -this.yOffset);
        }
    }

    @Override
    public void drawTexturedRect(int x, int y, int u, int v, int w, int h) {
        gui.func_73729_b(x, y, u, v, w, h);
    }

    @Override
    public void drawTexturedRectFromIcon(int x, int y, TextureAtlasSprite icon, int w, int h) {
        gui.func_175175_a(x, y, icon, w, h);
    }

    @Override
    public void displayTooltip(String s, int xAxis, int yAxis) {
    }

    @Override
    public void displayTooltips(List<String> list, int xAxis, int yAxis) {
    }

    @Override
    public FontRenderer getFont() {
        return null;
    }

    public void displayGauge(int length, int xPos, int yPos, int overlayX, int overlayY, int scale, FluidStack fluid, GasStack gas) {
        int renderRemaining;
        if (fluid == null && gas == null) {
            return;
        }
        int start = 0;
        do {
            renderRemaining = 0;
            if (scale > 16) {
                renderRemaining = 16;
                scale -= 16;
            } else {
                renderRemaining = scale;
                scale = 0;
            }
            this.changeTexture(MekanismRenderer.getBlocksTexture());
            if (fluid != null) {
                gui.func_175175_a(xPos, yPos + length - renderRemaining - start, MekanismRenderer.getFluidTexture(fluid.getFluid(), MekanismRenderer.FluidType.STILL), 16, 16 - (16 - renderRemaining));
            } else if (gas != null) {
                gui.func_175175_a(xPos, yPos + length - renderRemaining - start, gas.getGas().getSprite(), 16, 16 - (16 - renderRemaining));
            }
            start += 16;
        } while (renderRemaining != 0 && scale != 0);
        this.changeTexture(this.guiLocation);
        gui.func_73729_b(xPos, yPos, overlayX, overlayY, 16, length + 1);
    }

    public void displayGauge(int xPos, int yPos, int sizeX, int sizeY, GasStack gas) {
        if (gas == null) {
            return;
        }
        this.changeTexture(MekanismRenderer.getBlocksTexture());
        gui.func_175175_a(xPos, yPos, gas.getGas().getSprite(), sizeX, sizeY);
    }

    public String stripTexture() {
        return this.guiTexture.replace("mekanism:gui/", "");
    }

    public void changeTexture(ResourceLocation texture) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(texture);
    }

    public void addGuiElements() {
    }

    public IDrawable getIcon() {
        return null;
    }

    public List getTooltipStrings(int mouseX, int mouseY) {
        return Collections.emptyList();
    }

    protected void initGas(IGuiIngredientGroup<GasStack> group, int slot, boolean input, int x, int y, int width, int height, GasStack stack, boolean overlay) {
        if (stack == null) {
            return;
        }
        IDrawable fluidOverlay = height > 50 ? this.fluidOverlayLarge : this.fluidOverlaySmall;
        GasStackRenderer renderer = new GasStackRenderer(stack.amount, false, width, height, (IDrawable)(overlay ? fluidOverlay : null));
        group.init(slot, input, (IIngredientRenderer)renderer, x, y, width, height, 0, 0);
        group.set(slot, (Object)stack);
        group.addTooltipCallback((index, isInput, ingredient, tooltip) -> {
            String cfr_ignored_0 = (String)tooltip.remove(1);
        });
    }

    public static class GuiDummy
    extends Gui {
    }
}

