/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element;

import mekanism.api.EnumColor;
import mekanism.api.transmitters.TransmissionType;
import mekanism.client.gui.GuiMekanism;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.SideData;
import mekanism.common.base.ISideConfiguration;
import mekanism.common.item.ItemConfigurator;
import mekanism.common.tile.prefab.TileEntityContainerBlock;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public abstract class GuiGauge<T>
extends GuiElement {
    protected int xLocation;
    protected int yLocation;
    protected int texX;
    protected int texY;
    protected int width;
    protected int height;
    public EnumColor color;
    protected int number;
    protected boolean dummy;
    protected T dummyType;

    public GuiGauge(Type type, IGuiWrapper gui, ResourceLocation def, int x, int y) {
        super(MekanismUtils.getResource(MekanismUtils.ResourceType.GUI_ELEMENT, type.textureLocation), gui, def);
        this.xLocation = x;
        this.yLocation = y;
        this.width = type.width;
        this.height = type.height;
        this.texX = type.texX;
        this.texY = type.texY;
        this.color = type.color;
        this.number = type.number;
    }

    public abstract int getScaledLevel();

    public abstract TextureAtlasSprite getIcon();

    public abstract String getTooltipText();

    public int getRenderColor() {
        return -1;
    }

    @Override
    public void renderBackground(int xAxis, int yAxis, int guiWidth, int guiHeight) {
        GuiGauge.mc.field_71446_o.func_110577_a(this.RESOURCE);
        this.guiObj.drawTexturedRect(guiWidth + this.xLocation, guiHeight + this.yLocation, this.texX, this.texY, this.width, this.height);
        if (!this.dummy) {
            this.renderScale(xAxis, yAxis, guiWidth, guiHeight);
        }
        GuiGauge.mc.field_71446_o.func_110577_a(this.defaultLocation);
    }

    public void renderScale(int xAxis, int yAxis, int guiWidth, int guiHeight) {
        if (this.getScaledLevel() == 0 || this.getIcon() == null) {
            this.guiObj.drawTexturedRect(guiWidth + this.xLocation, guiHeight + this.yLocation, this.width, 0, this.width, this.height);
            return;
        }
        int scale = this.getScaledLevel();
        int start = 0;
        while (scale > 0) {
            int renderRemaining = 0;
            if (scale > 16) {
                renderRemaining = 16;
                scale -= 16;
            } else {
                renderRemaining = scale;
                scale = 0;
            }
            GuiGauge.mc.field_71446_o.func_110577_a(MekanismRenderer.getBlocksTexture());
            if (this.getRenderColor() != -1) {
                MekanismRenderer.color(this.getRenderColor());
            }
            for (int i = 0; i < this.number; ++i) {
                this.guiObj.drawTexturedRectFromIcon(guiWidth + this.xLocation + 16 * i + 1, guiHeight + this.yLocation + this.height - renderRemaining - start - 1, this.getIcon(), 16, renderRemaining);
            }
            MekanismRenderer.resetColor();
            start += 16;
            if (renderRemaining != 0 && scale != 0) continue;
            break;
        }
        GuiGauge.mc.field_71446_o.func_110577_a(this.RESOURCE);
        this.guiObj.drawTexturedRect(guiWidth + this.xLocation, guiHeight + this.yLocation, this.width, 0, this.width, this.height);
    }

    @Override
    public void renderForeground(int xAxis, int yAxis) {
        if (xAxis >= this.xLocation + 1 && xAxis <= this.xLocation + this.width - 1 && yAxis >= this.yLocation + 1 && yAxis <= this.yLocation + this.height - 1) {
            ItemStack stack = GuiGauge.mc.field_71439_g.field_71071_by.func_70445_o();
            if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemConfigurator && this.color != null) {
                TileEntityContainerBlock tile;
                if (this.guiObj instanceof GuiMekanism && ((GuiMekanism)this.guiObj).getTileEntity() != null && (tile = ((GuiMekanism)this.guiObj).getTileEntity()) instanceof ISideConfiguration && this.getTransmission() != null) {
                    SideData data = null;
                    for (SideData iterData : ((ISideConfiguration)((Object)tile)).getConfig().getOutputs(this.getTransmission())) {
                        if (iterData.color != this.color) continue;
                        data = iterData;
                        break;
                    }
                    this.guiObj.displayTooltip((Object)((Object)this.color) + data.localize() + " (" + this.color.getColoredName() + ")", xAxis, yAxis);
                }
            } else {
                this.guiObj.displayTooltip(this.getTooltipText(), xAxis, yAxis);
            }
        }
    }

    @Override
    public void preMouseClicked(int xAxis, int yAxis, int button) {
    }

    @Override
    public void mouseClicked(int xAxis, int yAxis, int button) {
    }

    public abstract TransmissionType getTransmission();

    public void setDummyType(T type) {
        this.dummyType = type;
    }

    @Override
    public GuiElement.Rectangle4i getBounds(int guiWidth, int guiHeight) {
        return new GuiElement.Rectangle4i(guiWidth + this.xLocation, guiHeight + this.yLocation, this.width, this.height);
    }

    public static enum Type {
        STANDARD(null, 18, 60, 0, 0, 1, "GuiGaugeStandard.png"),
        STANDARD_YELLOW(EnumColor.YELLOW, 18, 60, 0, 60, 1, "GuiGaugeStandard.png"),
        STANDARD_RED(EnumColor.DARK_RED, 18, 60, 0, 120, 1, "GuiGaugeStandard.png"),
        STANDARD_ORANGE(EnumColor.ORANGE, 18, 60, 0, 180, 1, "GuiGaugeStandard.png"),
        STANDARD_BLUE(EnumColor.DARK_BLUE, 18, 60, 0, 240, 1, "GuiGaugeStandard.png"),
        WIDE(null, 66, 50, 0, 0, 4, "GuiGaugeWide.png"),
        WIDE_YELLOW(EnumColor.YELLOW, 66, 50, 0, 50, 4, "GuiGaugeWide.png"),
        WIDE_RED(EnumColor.DARK_RED, 66, 50, 0, 100, 4, "GuiGaugeWide.png"),
        WIDE_ORANGE(EnumColor.ORANGE, 66, 50, 0, 150, 4, "GuiGaugeWide.png"),
        WIDE_BLUE(EnumColor.DARK_BLUE, 66, 50, 0, 200, 4, "GuiGaugeWide.png"),
        SMALL(null, 18, 30, 0, 0, 1, "GuiGaugeSmall.png"),
        SMALL_YELLOW(EnumColor.YELLOW, 18, 30, 0, 30, 1, "GuiGaugeSmall.png"),
        SMALL_RED(EnumColor.DARK_RED, 18, 30, 0, 60, 1, "GuiGaugeSmall.png"),
        SMALL_ORANGE(EnumColor.ORANGE, 18, 30, 0, 90, 1, "GuiGaugeSmall.png"),
        SMALL_BLUE(EnumColor.DARK_BLUE, 18, 30, 0, 120, 1, "GuiGaugeSmall.png");

        public EnumColor color;
        public int width;
        public int height;
        public int texX;
        public int texY;
        public int number;
        public String textureLocation;

        private Type(EnumColor c, int w, int h, int tx, int ty, int n2, String t) {
            this.color = c;
            this.width = w;
            this.height = h;
            this.texX = tx;
            this.texY = ty;
            this.number = n2;
            this.textureLocation = t;
        }
    }
}

