/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mekanism.api.transmitters.TransmissionType;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.common.SideData;
import mekanism.common.base.ISideConfiguration;
import mekanism.common.item.ItemConfigurator;
import mekanism.common.tile.prefab.TileEntityContainerBlock;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import org.lwjgl.input.Mouse;

public abstract class GuiMekanism
extends GuiContainer
implements IGuiWrapper {
    public Set<GuiElement> guiElements = new HashSet<GuiElement>();
    private TileEntityContainerBlock tileEntity;

    public GuiMekanism(Container container) {
        super(container);
    }

    public GuiMekanism(TileEntityContainerBlock tile, Container container) {
        super(container);
        this.tileEntity = tile;
    }

    public float getNeededScale(String text, int maxX) {
        int length = this.field_146289_q.func_78256_a(text);
        if (length <= maxX) {
            return 1.0f;
        }
        return (float)maxX / (float)length;
    }

    public void renderScaledText(String text, int x, int y, int color, int maxX) {
        int length = this.field_146289_q.func_78256_a(text);
        if (length <= maxX) {
            this.field_146289_q.func_78276_b(text, x, y, color);
        } else {
            float scale = (float)maxX / (float)length;
            float reverse = 1.0f / scale;
            float yAdd = 4.0f - scale * 8.0f / 2.0f;
            GlStateManager.func_179094_E();
            GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
            this.field_146289_q.func_78276_b(text, (int)((float)x * reverse), (int)((float)y * reverse + yAdd), color);
            GlStateManager.func_179121_F();
        }
    }

    public static boolean isTextboxKey(char c, int i) {
        return i == 14 || i == 211 || i == 203 || i == 205 || i == 207 || i == 199 || i == 14 || GuiMekanism.func_175278_g((int)i) || GuiMekanism.func_175280_f((int)i) || GuiMekanism.func_175279_e((int)i) || GuiMekanism.func_175277_d((int)i);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        int xAxis = mouseX - (this.field_146294_l - this.field_146999_f) / 2;
        int yAxis = mouseY - (this.field_146295_m - this.field_147000_g) / 2;
        for (GuiElement element : this.guiElements) {
            element.renderForeground(xAxis, yAxis);
        }
        if (this.tileEntity instanceof ISideConfiguration) {
            SideData data;
            ItemStack stack;
            Slot hovering = null;
            for (int i = 0; i < this.field_147002_h.field_75151_b.size(); ++i) {
                Slot slot = (Slot)this.field_147002_h.field_75151_b.get(i);
                if (!this.func_146981_a(slot, mouseX, mouseY)) continue;
                hovering = slot;
                break;
            }
            if (!(stack = this.field_146297_k.field_71439_g.field_71071_by.func_70445_o()).func_190926_b() && stack.func_77973_b() instanceof ItemConfigurator && hovering != null && (data = this.getFromSlot(hovering)) != null) {
                this.func_146279_a((Object)((Object)data.color) + data.localize() + " (" + data.color.getColoredName() + ")", xAxis, yAxis);
            }
        }
    }

    public TileEntityContainerBlock getTileEntity() {
        return this.tileEntity;
    }

    private SideData getFromSlot(Slot slot) {
        if (slot.field_75222_d < this.tileEntity.func_70302_i_()) {
            ISideConfiguration config = (ISideConfiguration)((Object)this.tileEntity);
            for (SideData data : config.getConfig().getOutputs(TransmissionType.ITEM)) {
                for (int id : data.availableSlots) {
                    if (id != slot.getSlotIndex()) continue;
                    return data;
                }
            }
        }
        return null;
    }

    protected boolean func_146981_a(Slot slot, int mouseX, int mouseY) {
        return this.func_146978_c(slot.field_75223_e, slot.field_75221_f, 16, 16, mouseX, mouseY);
    }

    protected void func_146976_a(float partialTick, int mouseX, int mouseY) {
        int guiWidth = (this.field_146294_l - this.field_146999_f) / 2;
        int guiHeight = (this.field_146295_m - this.field_147000_g) / 2;
        int xAxis = mouseX - guiWidth;
        int yAxis = mouseY - guiHeight;
        for (GuiElement element : this.guiElements) {
            element.renderBackground(xAxis, yAxis, guiWidth, guiHeight);
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int button) throws IOException {
        int xAxis = mouseX - (this.field_146294_l - this.field_146999_f) / 2;
        int yAxis = mouseY - (this.field_146295_m - this.field_147000_g) / 2;
        for (GuiElement element : this.guiElements) {
            element.preMouseClicked(xAxis, yAxis, button);
        }
        super.func_73864_a(mouseX, mouseY, button);
        for (GuiElement element : this.guiElements) {
            element.mouseClicked(xAxis, yAxis, button);
        }
    }

    @Override
    public void drawTexturedRect(int x, int y, int u, int v, int w, int h) {
        this.func_73729_b(x, y, u, v, w, h);
    }

    @Override
    public void drawTexturedRectFromIcon(int x, int y, TextureAtlasSprite icon, int w, int h) {
        this.func_175175_a(x, y, icon, w, h);
    }

    @Override
    public void displayTooltip(String s, int x, int y) {
        this.func_146279_a(s, x, y);
    }

    @Override
    public void displayTooltips(List<String> list, int xAxis, int yAxis) {
        this.func_146283_a(list, xAxis, yAxis);
    }

    @Override
    public FontRenderer getFont() {
        return this.field_146289_q;
    }

    protected void func_146273_a(int mouseX, int mouseY, int button, long ticks) {
        super.func_146273_a(mouseX, mouseY, button, ticks);
        int xAxis = mouseX - (this.field_146294_l - this.field_146999_f) / 2;
        int yAxis = mouseY - (this.field_146295_m - this.field_147000_g) / 2;
        for (GuiElement element : this.guiElements) {
            element.mouseClickMove(xAxis, yAxis, button, ticks);
        }
    }

    protected void func_146286_b(int mouseX, int mouseY, int type) {
        super.func_146286_b(mouseX, mouseY, type);
        int xAxis = mouseX - (this.field_146294_l - this.field_146999_f) / 2;
        int yAxis = mouseY - (this.field_146295_m - this.field_147000_g) / 2;
        for (GuiElement element : this.guiElements) {
            element.mouseReleased(xAxis, yAxis, type);
        }
    }

    public void handleMouse(Slot slot, int slotIndex, int button, ClickType modifier) {
        this.func_184098_a(slot, slotIndex, button, modifier);
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int xAxis = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c - this.getXPos();
        int yAxis = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1 - this.getYPos();
        int delta = Mouse.getEventDWheel();
        if (delta != 0) {
            this.mouseWheel(xAxis, yAxis, delta);
        }
    }

    public void mouseWheel(int xAxis, int yAxis, int delta) {
        for (GuiElement element : this.guiElements) {
            element.mouseWheel(xAxis, yAxis, delta);
        }
    }

    public int getXPos() {
        return (this.field_146294_l - this.field_146999_f) / 2;
    }

    public int getYPos() {
        return (this.field_146295_m - this.field_147000_g) / 2;
    }

    protected FontRenderer getFontRenderer() {
        return this.field_146289_q;
    }
}

