/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import java.io.IOException;
import java.util.ArrayList;
import mekanism.api.Coord4D;
import mekanism.client.gui.GuiMekanism;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiAmplifierTab;
import mekanism.client.gui.element.GuiGauge;
import mekanism.client.gui.element.GuiNumberGauge;
import mekanism.client.gui.element.GuiRedstoneControl;
import mekanism.client.gui.element.GuiSecurityTab;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.Mekanism;
import mekanism.common.inventory.container.ContainerLaserAmplifier;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.tile.TileEntityLaserAmplifier;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiLaserAmplifier
extends GuiMekanism {
    public TileEntityLaserAmplifier tileEntity;
    public GuiTextField minField;
    public GuiTextField maxField;
    public GuiTextField timerField;

    public GuiLaserAmplifier(InventoryPlayer inventory, TileEntityLaserAmplifier tentity) {
        super(tentity, new ContainerLaserAmplifier(inventory, tentity));
        this.tileEntity = tentity;
        this.guiElements.add(new GuiNumberGauge(new GuiNumberGauge.INumberInfoHandler(){

            @Override
            public TextureAtlasSprite getIcon() {
                return MekanismRenderer.energyIcon;
            }

            @Override
            public double getLevel() {
                return GuiLaserAmplifier.this.tileEntity.collectedEnergy;
            }

            @Override
            public double getMaxLevel() {
                TileEntityLaserAmplifier cfr_ignored_0 = GuiLaserAmplifier.this.tileEntity;
                return 5.0E9;
            }

            @Override
            public String getText(double level) {
                return LangUtils.localize("gui.storing") + ": " + MekanismUtils.getEnergyDisplay(level, GuiLaserAmplifier.this.tileEntity.getMaxEnergy());
            }
        }, GuiGauge.Type.STANDARD, this, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiBlank.png"), 6, 10));
        this.guiElements.add(new GuiSecurityTab((IGuiWrapper)this, this.tileEntity, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiBlank.png")));
        this.guiElements.add(new GuiRedstoneControl(this, this.tileEntity, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiBlank.png")));
        this.guiElements.add(new GuiAmplifierTab(this, this.tileEntity, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiBlank.png")));
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        int xAxis = mouseX - (this.field_146294_l - this.field_146999_f) / 2;
        int yAxis = mouseY - (this.field_146295_m - this.field_147000_g) / 2;
        this.field_146289_q.func_78276_b(this.tileEntity.func_70005_c_(), 55, 6, 0x404040);
        this.field_146289_q.func_78276_b(LangUtils.localize("container.inventory"), 8, this.field_147000_g - 96 + 2, 0x404040);
        this.field_146289_q.func_78276_b(this.tileEntity.time > 0 ? LangUtils.localize("gui.delay") + ": " + this.tileEntity.time + "t" : LangUtils.localize("gui.noDelay"), 26, 30, 0x404040);
        this.field_146289_q.func_78276_b(LangUtils.localize("gui.min") + ": " + MekanismUtils.getEnergyDisplay(this.tileEntity.minThreshold), 26, 45, 0x404040);
        this.field_146289_q.func_78276_b(LangUtils.localize("gui.max") + ": " + MekanismUtils.getEnergyDisplay(this.tileEntity.maxThreshold), 26, 60, 0x404040);
        super.func_146979_b(mouseX, mouseY);
    }

    @Override
    protected void func_146976_a(float partialTick, int mouseX, int mouseY) {
        this.field_146297_k.field_71446_o.func_110577_a(MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiBlank.png"));
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int guiWidth = (this.field_146294_l - this.field_146999_f) / 2;
        int guiHeight = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(guiWidth, guiHeight, 0, 0, this.field_146999_f, this.field_147000_g);
        super.func_146976_a(partialTick, mouseX, mouseY);
        this.minField.func_146194_f();
        this.maxField.func_146194_f();
        this.timerField.func_146194_f();
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.minField.func_146178_a();
        this.maxField.func_146178_a();
        this.timerField.func_146178_a();
    }

    @Override
    public void func_73864_a(int mouseX, int mouseY, int button) throws IOException {
        super.func_73864_a(mouseX, mouseY, button);
        this.minField.func_146192_a(mouseX, mouseY, button);
        this.maxField.func_146192_a(mouseX, mouseY, button);
        this.timerField.func_146192_a(mouseX, mouseY, button);
    }

    public void func_73869_a(char c, int i) throws IOException {
        if (!this.minField.func_146206_l() && !this.maxField.func_146206_l() && !this.timerField.func_146206_l() || i == 1) {
            super.func_73869_a(c, i);
        }
        if (i == 28) {
            if (this.minField.func_146206_l()) {
                this.setMinThreshold();
            }
            if (this.maxField.func_146206_l()) {
                this.setMaxThreshold();
            }
            if (this.timerField.func_146206_l()) {
                this.setTime();
            }
        }
        if (Character.isDigit(c) || c == '.' || c == 'E' || GuiLaserAmplifier.isTextboxKey(c, i)) {
            this.minField.func_146201_a(c, i);
            this.maxField.func_146201_a(c, i);
            this.timerField.func_146201_a(c, i);
        }
    }

    private void setMinThreshold() {
        if (!this.minField.func_146179_b().isEmpty()) {
            double toUse;
            try {
                toUse = Math.max(0.0, Double.parseDouble(this.minField.func_146179_b()));
            }
            catch (Exception e) {
                this.minField.func_146180_a("");
                return;
            }
            ArrayList<Object> data = new ArrayList<Object>();
            data.add(0);
            data.add(toUse);
            Mekanism.packetHandler.sendToServer(new PacketTileEntity.TileEntityMessage(Coord4D.get(this.tileEntity), data));
            this.minField.func_146180_a("");
        }
    }

    private void setMaxThreshold() {
        if (!this.maxField.func_146179_b().isEmpty()) {
            double toUse;
            try {
                toUse = Math.max(0.0, Double.parseDouble(this.maxField.func_146179_b()));
            }
            catch (Exception e) {
                this.maxField.func_146180_a("");
                return;
            }
            ArrayList<Object> data = new ArrayList<Object>();
            data.add(1);
            data.add(toUse);
            Mekanism.packetHandler.sendToServer(new PacketTileEntity.TileEntityMessage(Coord4D.get(this.tileEntity), data));
            this.maxField.func_146180_a("");
        }
    }

    private void setTime() {
        if (!this.timerField.func_146179_b().isEmpty()) {
            int toUse = Math.max(0, Integer.parseInt(this.timerField.func_146179_b()));
            ArrayList<Object> data = new ArrayList<Object>();
            data.add(2);
            data.add(toUse);
            Mekanism.packetHandler.sendToServer(new PacketTileEntity.TileEntityMessage(Coord4D.get(this.tileEntity), data));
            this.timerField.func_146180_a("");
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        int guiWidth = (this.field_146294_l - this.field_146999_f) / 2;
        int guiHeight = (this.field_146295_m - this.field_147000_g) / 2;
        String prevTime = this.timerField != null ? this.timerField.func_146179_b() : "";
        this.timerField = new GuiTextField(0, this.field_146289_q, guiWidth + 96, guiHeight + 28, 36, 11);
        this.timerField.func_146203_f(4);
        this.timerField.func_146180_a(prevTime);
        String prevMin = this.minField != null ? this.minField.func_146179_b() : "";
        this.minField = new GuiTextField(1, this.field_146289_q, guiWidth + 96, guiHeight + 43, 72, 11);
        this.minField.func_146203_f(10);
        this.minField.func_146180_a(prevMin);
        String prevMax = this.maxField != null ? this.maxField.func_146179_b() : "";
        this.maxField = new GuiTextField(2, this.field_146289_q, guiWidth + 96, guiHeight + 58, 72, 11);
        this.maxField.func_146203_f(10);
        this.maxField.func_146180_a(prevMax);
    }
}

