/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import java.util.List;
import mekanism.client.gui.GuiMekanism;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.GuiEnergyInfo;
import mekanism.client.gui.element.GuiFluidGauge;
import mekanism.client.gui.element.GuiGauge;
import mekanism.client.gui.element.GuiPowerBar;
import mekanism.client.gui.element.GuiRedstoneControl;
import mekanism.client.gui.element.GuiSecurityTab;
import mekanism.client.gui.element.GuiSlot;
import mekanism.client.gui.element.GuiUpgradeTab;
import mekanism.common.inventory.container.ContainerFluidicPlenisher;
import mekanism.common.tile.TileEntityFluidicPlenisher;
import mekanism.common.util.LangUtils;
import mekanism.common.util.ListUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiFluidicPlenisher
extends GuiMekanism {
    public TileEntityFluidicPlenisher tileEntity;
    public ResourceLocation guiLocation = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiElectricPump.png");

    public GuiFluidicPlenisher(InventoryPlayer inventory, TileEntityFluidicPlenisher tentity) {
        super(tentity, new ContainerFluidicPlenisher(inventory, tentity));
        this.tileEntity = tentity;
        this.guiElements.add(new GuiSlot(GuiSlot.SlotType.NORMAL, this, this.guiLocation, 27, 19));
        this.guiElements.add(new GuiSlot(GuiSlot.SlotType.NORMAL, this, this.guiLocation, 27, 50));
        this.guiElements.add(new GuiSlot(GuiSlot.SlotType.POWER, this, this.guiLocation, 142, 34).with(GuiSlot.SlotOverlay.POWER));
        this.guiElements.add(new GuiPowerBar((IGuiWrapper)this, this.tileEntity, this.guiLocation, 164, 15));
        this.guiElements.add(new GuiFluidGauge(new GuiFluidGauge.IFluidInfoHandler(){

            @Override
            public FluidTank getTank() {
                return GuiFluidicPlenisher.this.tileEntity.fluidTank;
            }
        }, GuiGauge.Type.STANDARD, this, this.guiLocation, 6, 13));
        this.guiElements.add(new GuiEnergyInfo(new GuiElement.IInfoHandler(){

            @Override
            public List<String> getInfo() {
                String multiplier = MekanismUtils.getEnergyDisplay(GuiFluidicPlenisher.this.tileEntity.energyPerTick);
                return ListUtils.asList(LangUtils.localize("gui.using") + ": " + multiplier + "/t", LangUtils.localize("gui.needed") + ": " + MekanismUtils.getEnergyDisplay(GuiFluidicPlenisher.this.tileEntity.getMaxEnergy() - GuiFluidicPlenisher.this.tileEntity.getEnergy()));
            }
        }, (IGuiWrapper)this, this.guiLocation));
        this.guiElements.add(new GuiSecurityTab((IGuiWrapper)this, this.tileEntity, this.guiLocation));
        this.guiElements.add(new GuiRedstoneControl(this, this.tileEntity, this.guiLocation));
        this.guiElements.add(new GuiUpgradeTab(this, this.tileEntity, this.guiLocation));
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(this.tileEntity.func_70005_c_(), this.field_146999_f / 2 - this.field_146289_q.func_78256_a(this.tileEntity.func_70005_c_()) / 2, 6, 0x404040);
        this.field_146289_q.func_78276_b(LangUtils.localize("container.inventory"), 8, this.field_147000_g - 94 + 2, 0x404040);
        this.field_146289_q.func_78276_b(MekanismUtils.getEnergyDisplay(this.tileEntity.getEnergy(), this.tileEntity.getMaxEnergy()), 51, 26, 52480);
        this.field_146289_q.func_78276_b(LangUtils.localize("gui.finished") + ": " + LangUtils.transYesNo(this.tileEntity.finishedCalc), 51, 35, 52480);
        this.field_146289_q.func_78276_b(this.tileEntity.fluidTank.getFluid() != null ? LangUtils.localizeFluidStack(this.tileEntity.fluidTank.getFluid()) + ": " + this.tileEntity.fluidTank.getFluid().amount : LangUtils.localize("gui.noFluid"), 51, 44, 52480);
        super.func_146979_b(mouseX, mouseY);
    }

    @Override
    protected void func_146976_a(float partialTick, int mouseX, int mouseY) {
        this.field_146297_k.field_71446_o.func_110577_a(this.guiLocation);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int guiWidth = (this.field_146294_l - this.field_146999_f) / 2;
        int guiHeight = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(guiWidth, guiHeight, 0, 0, this.field_146999_f, this.field_147000_g);
        super.func_146976_a(partialTick, mouseX, mouseY);
    }
}

