/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import mekanism.api.Coord4D;
import mekanism.api.EnumColor;
import mekanism.api.Pos3D;
import mekanism.client.ClientConnectionHandler;
import mekanism.client.ClientPlayerTracker;
import mekanism.client.ClientTickHandler;
import mekanism.client.HolidayManager;
import mekanism.client.MekanismClient;
import mekanism.client.MekanismKeyHandler;
import mekanism.client.SparkleAnimation;
import mekanism.client.entity.ParticleLaser;
import mekanism.client.gui.GuiAmbientAccumulator;
import mekanism.client.gui.GuiBoilerStats;
import mekanism.client.gui.GuiChemicalCrystallizer;
import mekanism.client.gui.GuiChemicalDissolutionChamber;
import mekanism.client.gui.GuiChemicalInfuser;
import mekanism.client.gui.GuiChemicalInjectionChamber;
import mekanism.client.gui.GuiChemicalOxidizer;
import mekanism.client.gui.GuiChemicalWasher;
import mekanism.client.gui.GuiCombiner;
import mekanism.client.gui.GuiCredits;
import mekanism.client.gui.GuiCrusher;
import mekanism.client.gui.GuiDictionary;
import mekanism.client.gui.GuiDigitalMiner;
import mekanism.client.gui.GuiDynamicTank;
import mekanism.client.gui.GuiElectricPump;
import mekanism.client.gui.GuiElectrolyticSeparator;
import mekanism.client.gui.GuiEnergizedSmelter;
import mekanism.client.gui.GuiEnergyCube;
import mekanism.client.gui.GuiEnrichmentChamber;
import mekanism.client.gui.GuiFactory;
import mekanism.client.gui.GuiFluidTank;
import mekanism.client.gui.GuiFluidicPlenisher;
import mekanism.client.gui.GuiFormulaicAssemblicator;
import mekanism.client.gui.GuiFuelwoodHeater;
import mekanism.client.gui.GuiGasTank;
import mekanism.client.gui.GuiInductionMatrix;
import mekanism.client.gui.GuiLaserAmplifier;
import mekanism.client.gui.GuiLaserTractorBeam;
import mekanism.client.gui.GuiMatrixStats;
import mekanism.client.gui.GuiMetallurgicInfuser;
import mekanism.client.gui.GuiOredictionificator;
import mekanism.client.gui.GuiOsmiumCompressor;
import mekanism.client.gui.GuiPRC;
import mekanism.client.gui.GuiPersonalChest;
import mekanism.client.gui.GuiPrecisionSawmill;
import mekanism.client.gui.GuiPurificationChamber;
import mekanism.client.gui.GuiQuantumEntangloporter;
import mekanism.client.gui.GuiResistiveHeater;
import mekanism.client.gui.GuiRobitCrafting;
import mekanism.client.gui.GuiRobitInventory;
import mekanism.client.gui.GuiRobitMain;
import mekanism.client.gui.GuiRobitRepair;
import mekanism.client.gui.GuiRobitSmelting;
import mekanism.client.gui.GuiRotaryCondensentrator;
import mekanism.client.gui.GuiSecurityDesk;
import mekanism.client.gui.GuiSeismicReader;
import mekanism.client.gui.GuiSeismicVibrator;
import mekanism.client.gui.GuiSideConfiguration;
import mekanism.client.gui.GuiSolarNeutronActivator;
import mekanism.client.gui.GuiTeleporter;
import mekanism.client.gui.GuiThermalEvaporationController;
import mekanism.client.gui.GuiThermoelectricBoiler;
import mekanism.client.gui.GuiTransporterConfig;
import mekanism.client.gui.GuiUpgradeManagement;
import mekanism.client.render.MekanismRenderer;
import mekanism.client.render.RenderTickHandler;
import mekanism.client.render.entity.RenderBalloon;
import mekanism.client.render.entity.RenderFlame;
import mekanism.client.render.entity.RenderObsidianTNTPrimed;
import mekanism.client.render.entity.RenderRobit;
import mekanism.client.render.item.CustomItemModelFactory;
import mekanism.client.render.obj.MekanismOBJLoader;
import mekanism.client.render.tileentity.RenderBin;
import mekanism.client.render.tileentity.RenderChargepad;
import mekanism.client.render.tileentity.RenderChemicalCrystallizer;
import mekanism.client.render.tileentity.RenderChemicalDissolutionChamber;
import mekanism.client.render.tileentity.RenderConfigurableMachine;
import mekanism.client.render.tileentity.RenderDigitalMiner;
import mekanism.client.render.tileentity.RenderDynamicTank;
import mekanism.client.render.tileentity.RenderEnergyCube;
import mekanism.client.render.tileentity.RenderFluidTank;
import mekanism.client.render.tileentity.RenderGasTank;
import mekanism.client.render.tileentity.RenderLogisticalSorter;
import mekanism.client.render.tileentity.RenderPersonalChest;
import mekanism.client.render.tileentity.RenderQuantumEntangloporter;
import mekanism.client.render.tileentity.RenderResistiveHeater;
import mekanism.client.render.tileentity.RenderSecurityDesk;
import mekanism.client.render.tileentity.RenderSeismicVibrator;
import mekanism.client.render.tileentity.RenderSolarNeutronActivator;
import mekanism.client.render.tileentity.RenderTeleporter;
import mekanism.client.render.tileentity.RenderThermalEvaporationController;
import mekanism.client.render.tileentity.RenderThermoelectricBoiler;
import mekanism.client.render.transmitter.RenderLogisticalTransporter;
import mekanism.client.render.transmitter.RenderMechanicalPipe;
import mekanism.client.render.transmitter.RenderPressurizedTube;
import mekanism.client.render.transmitter.RenderThermodynamicConductor;
import mekanism.client.render.transmitter.RenderUniversalCable;
import mekanism.common.CommonProxy;
import mekanism.common.Mekanism;
import mekanism.common.MekanismBlocks;
import mekanism.common.MekanismItems;
import mekanism.common.Tier;
import mekanism.common.base.IFactory;
import mekanism.common.base.ISideConfiguration;
import mekanism.common.base.IUpgradeTile;
import mekanism.common.block.BlockMachine;
import mekanism.common.block.BlockPlasticFence;
import mekanism.common.block.states.BlockStateBasic;
import mekanism.common.block.states.BlockStateCardboardBox;
import mekanism.common.block.states.BlockStateMachine;
import mekanism.common.block.states.BlockStateOre;
import mekanism.common.block.states.BlockStatePlastic;
import mekanism.common.block.states.BlockStateTransmitter;
import mekanism.common.config.MekanismConfig;
import mekanism.common.entity.EntityBabySkeleton;
import mekanism.common.entity.EntityBalloon;
import mekanism.common.entity.EntityFlame;
import mekanism.common.entity.EntityObsidianTNT;
import mekanism.common.entity.EntityRobit;
import mekanism.common.inventory.InventoryPersonalChest;
import mekanism.common.item.ItemBlockBasic;
import mekanism.common.item.ItemBlockGasTank;
import mekanism.common.item.ItemBlockMachine;
import mekanism.common.item.ItemBlockTransmitter;
import mekanism.common.item.ItemCraftingFormula;
import mekanism.common.item.ItemPortableTeleporter;
import mekanism.common.item.ItemSeismicReader;
import mekanism.common.item.ItemWalkieTalkie;
import mekanism.common.multiblock.MultiblockManager;
import mekanism.common.network.PacketPortableTeleporter;
import mekanism.common.tile.TileEntityAdvancedFactory;
import mekanism.common.tile.TileEntityAmbientAccumulator;
import mekanism.common.tile.TileEntityBin;
import mekanism.common.tile.TileEntityBoilerCasing;
import mekanism.common.tile.TileEntityBoilerValve;
import mekanism.common.tile.TileEntityChargepad;
import mekanism.common.tile.TileEntityChemicalCrystallizer;
import mekanism.common.tile.TileEntityChemicalDissolutionChamber;
import mekanism.common.tile.TileEntityChemicalInfuser;
import mekanism.common.tile.TileEntityChemicalInjectionChamber;
import mekanism.common.tile.TileEntityChemicalOxidizer;
import mekanism.common.tile.TileEntityChemicalWasher;
import mekanism.common.tile.TileEntityCombiner;
import mekanism.common.tile.TileEntityCrusher;
import mekanism.common.tile.TileEntityDigitalMiner;
import mekanism.common.tile.TileEntityDynamicTank;
import mekanism.common.tile.TileEntityDynamicValve;
import mekanism.common.tile.TileEntityElectricPump;
import mekanism.common.tile.TileEntityElectrolyticSeparator;
import mekanism.common.tile.TileEntityEliteFactory;
import mekanism.common.tile.TileEntityEnergizedSmelter;
import mekanism.common.tile.TileEntityEnergyCube;
import mekanism.common.tile.TileEntityEnrichmentChamber;
import mekanism.common.tile.TileEntityFactory;
import mekanism.common.tile.TileEntityFluidTank;
import mekanism.common.tile.TileEntityFluidicPlenisher;
import mekanism.common.tile.TileEntityFormulaicAssemblicator;
import mekanism.common.tile.TileEntityFuelwoodHeater;
import mekanism.common.tile.TileEntityGasTank;
import mekanism.common.tile.TileEntityInductionCasing;
import mekanism.common.tile.TileEntityLaserAmplifier;
import mekanism.common.tile.TileEntityLaserTractorBeam;
import mekanism.common.tile.TileEntityLogisticalSorter;
import mekanism.common.tile.TileEntityMetallurgicInfuser;
import mekanism.common.tile.TileEntityMultiblock;
import mekanism.common.tile.TileEntityOredictionificator;
import mekanism.common.tile.TileEntityOsmiumCompressor;
import mekanism.common.tile.TileEntityPRC;
import mekanism.common.tile.TileEntityPersonalChest;
import mekanism.common.tile.TileEntityPrecisionSawmill;
import mekanism.common.tile.TileEntityPurificationChamber;
import mekanism.common.tile.TileEntityQuantumEntangloporter;
import mekanism.common.tile.TileEntityResistiveHeater;
import mekanism.common.tile.TileEntityRotaryCondensentrator;
import mekanism.common.tile.TileEntitySecurityDesk;
import mekanism.common.tile.TileEntitySeismicVibrator;
import mekanism.common.tile.TileEntitySolarNeutronActivator;
import mekanism.common.tile.TileEntityTeleporter;
import mekanism.common.tile.TileEntityThermalEvaporationController;
import mekanism.common.tile.prefab.TileEntityAdvancedElectricMachine;
import mekanism.common.tile.prefab.TileEntityElectricMachine;
import mekanism.common.tile.transmitter.TileEntityDiversionTransporter;
import mekanism.common.tile.transmitter.TileEntityLogisticalTransporter;
import mekanism.common.tile.transmitter.TileEntityMechanicalPipe;
import mekanism.common.tile.transmitter.TileEntityPressurizedTube;
import mekanism.common.tile.transmitter.TileEntityRestrictiveTransporter;
import mekanism.common.tile.transmitter.TileEntityThermodynamicConductor;
import mekanism.common.tile.transmitter.TileEntityUniversalCable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.RenderSkeleton;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.AbstractSkeleton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.obj.OBJLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ClientProxy
extends CommonProxy {
    public static Map<String, ModelResourceLocation> machineResources = new HashMap<String, ModelResourceLocation>();
    public static Map<String, ModelResourceLocation> basicResources = new HashMap<String, ModelResourceLocation>();
    public static Map<String, ModelResourceLocation> transmitterResources = new HashMap<String, ModelResourceLocation>();
    public static final String[] CUSTOM_RENDERS = new String[]{"fluid_tank", "bin_basic", "bin_advanced", "bin_elite", "bin_ultimate", "Jetpack", "FreeRunners", "AtomicDisassembler", "ScubaTank", "GasMask", "ArmoredJetpack", "Flamethrower", "personal_chest", "solar_neutron_activator", "chemical_dissolution_chamber", "chemical_crystallizer", "seismic_vibrator", "security_desk", "quantum_entangloporter", "resistive_heater", "EnergyCube", "digital_miner", "bin_creative"};
    private static final IStateMapper machineMapper = new BlockStateMachine.MachineBlockStateMapper();
    private static final IStateMapper basicMapper = new BlockStateBasic.BasicBlockStateMapper();
    private static final IStateMapper plasticMapper = new BlockStatePlastic.PlasticBlockStateMapper();
    private static final IStateMapper fenceMapper = new BlockPlasticFence.PlasticFenceStateMapper();
    private static final IStateMapper boxMapper = new BlockStateCardboardBox.CardboardBoxStateMapper();
    private static final IStateMapper transmitterMapper = new BlockStateTransmitter.TransmitterStateMapper();

    @Override
    public void loadConfiguration() {
        super.loadConfiguration();
        MekanismConfig.client.enablePlayerSounds = Mekanism.configuration.get("client", "EnablePlayerSounds", true).getBoolean();
        MekanismConfig.client.enableMachineSounds = Mekanism.configuration.get("client", "EnableMachineSounds", true).getBoolean();
        MekanismConfig.client.holidays = Mekanism.configuration.get("client", "Holidays", true).getBoolean();
        MekanismConfig.client.baseSoundVolume = (float)Mekanism.configuration.get("client", "SoundVolume", 1.0).getDouble();
        MekanismConfig.client.machineEffects = Mekanism.configuration.get("client", "MachineEffects", true).getBoolean();
        MekanismConfig.client.replaceSoundsWhenResuming = Mekanism.configuration.get("client", "ReplaceSoundsWhenResuming", true, "If true, will reduce lagging between player sounds. Setting to false will reduce GC load").getBoolean();
        MekanismConfig.client.enableAmbientLighting = Mekanism.configuration.get("client", "EnableAmbientLighting", true).getBoolean();
        MekanismConfig.client.ambientLightingLevel = Mekanism.configuration.get("client", "AmbientLightingLevel", 15).getInt();
        MekanismConfig.client.opaqueTransmitters = Mekanism.configuration.get("client", "OpaqueTransmitterRender", false).getBoolean();
        MekanismConfig.client.allowConfiguratorModeScroll = Mekanism.configuration.get("client", "ConfiguratorModeScroll", true).getBoolean();
        if (Mekanism.configuration.hasChanged()) {
            Mekanism.configuration.save();
        }
    }

    @Override
    public void openPersonalChest(EntityPlayer entityplayer, int id, int windowId, boolean isBlock, BlockPos pos, EnumHand hand) {
        TileEntityPersonalChest tileEntity = (TileEntityPersonalChest)entityplayer.field_70170_p.func_175625_s(pos);
        if (id == 0) {
            if (isBlock) {
                FMLClientHandler.instance().displayGuiScreen(entityplayer, (GuiScreen)new GuiPersonalChest(entityplayer.field_71071_by, tileEntity));
                entityplayer.field_71070_bA.field_75152_c = windowId;
            } else {
                ItemStack stack = entityplayer.func_184586_b(hand);
                if (BlockStateMachine.MachineType.get(stack) == BlockStateMachine.MachineType.PERSONAL_CHEST) {
                    InventoryPersonalChest inventory = new InventoryPersonalChest(entityplayer, hand);
                    FMLClientHandler.instance().displayGuiScreen(entityplayer, (GuiScreen)new GuiPersonalChest(entityplayer.field_71071_by, inventory));
                    entityplayer.field_71070_bA.field_75152_c = windowId;
                }
            }
        }
    }

    @Override
    public void registerSpecialTileEntities() {
        ClientRegistry.registerTileEntity(TileEntityEnrichmentChamber.class, (String)"EnrichmentChamber", new RenderConfigurableMachine());
        ClientRegistry.registerTileEntity(TileEntityOsmiumCompressor.class, (String)"OsmiumCompressor", new RenderConfigurableMachine());
        ClientRegistry.registerTileEntity(TileEntityCombiner.class, (String)"Combiner", new RenderConfigurableMachine());
        ClientRegistry.registerTileEntity(TileEntityCrusher.class, (String)"Crusher", new RenderConfigurableMachine());
        ClientRegistry.registerTileEntity(TileEntityFactory.class, (String)"SmeltingFactory", new RenderConfigurableMachine());
        ClientRegistry.registerTileEntity(TileEntityAdvancedFactory.class, (String)"AdvancedSmeltingFactory", new RenderConfigurableMachine());
        ClientRegistry.registerTileEntity(TileEntityEliteFactory.class, (String)"UltimateSmeltingFactory", new RenderConfigurableMachine());
        ClientRegistry.registerTileEntity(TileEntityPurificationChamber.class, (String)"PurificationChamber", new RenderConfigurableMachine());
        ClientRegistry.registerTileEntity(TileEntityEnergizedSmelter.class, (String)"EnergizedSmelter", new RenderConfigurableMachine());
        ClientRegistry.registerTileEntity(TileEntityMetallurgicInfuser.class, (String)"MetallurgicInfuser", new RenderConfigurableMachine());
        ClientRegistry.registerTileEntity(TileEntityGasTank.class, (String)"GasTank", (TileEntitySpecialRenderer)new RenderGasTank());
        ClientRegistry.registerTileEntity(TileEntityEnergyCube.class, (String)"EnergyCube", (TileEntitySpecialRenderer)new RenderEnergyCube());
        ClientRegistry.registerTileEntity(TileEntityPersonalChest.class, (String)"PersonalChest", (TileEntitySpecialRenderer)new RenderPersonalChest());
        ClientRegistry.registerTileEntity(TileEntityDynamicTank.class, (String)"DynamicTank", (TileEntitySpecialRenderer)new RenderDynamicTank());
        ClientRegistry.registerTileEntity(TileEntityDynamicValve.class, (String)"DynamicValve", (TileEntitySpecialRenderer)new RenderDynamicTank());
        ClientRegistry.registerTileEntity(TileEntityChargepad.class, (String)"Chargepad", (TileEntitySpecialRenderer)new RenderChargepad());
        ClientRegistry.registerTileEntity(TileEntityLogisticalSorter.class, (String)"LogisticalSorter", (TileEntitySpecialRenderer)new RenderLogisticalSorter());
        ClientRegistry.registerTileEntity(TileEntityBin.class, (String)"Bin", (TileEntitySpecialRenderer)new RenderBin());
        ClientRegistry.registerTileEntity(TileEntityDigitalMiner.class, (String)"DigitalMiner", (TileEntitySpecialRenderer)new RenderDigitalMiner());
        ClientRegistry.registerTileEntity(TileEntityTeleporter.class, (String)"MekanismTeleporter", (TileEntitySpecialRenderer)new RenderTeleporter());
        ClientRegistry.registerTileEntity(TileEntityChemicalInjectionChamber.class, (String)"ChemicalInjectionChamber", new RenderConfigurableMachine());
        ClientRegistry.registerTileEntity(TileEntityThermalEvaporationController.class, (String)"ThermalEvaporationController", (TileEntitySpecialRenderer)new RenderThermalEvaporationController());
        ClientRegistry.registerTileEntity(TileEntityPrecisionSawmill.class, (String)"PrecisionSawmill", new RenderConfigurableMachine());
        ClientRegistry.registerTileEntity(TileEntityChemicalCrystallizer.class, (String)"ChemicalCrystallizer", (TileEntitySpecialRenderer)new RenderChemicalCrystallizer());
        ClientRegistry.registerTileEntity(TileEntitySeismicVibrator.class, (String)"SeismicVibrator", (TileEntitySpecialRenderer)new RenderSeismicVibrator());
        ClientRegistry.registerTileEntity(TileEntityPRC.class, (String)"PressurizedReactionChamber", new RenderConfigurableMachine());
        ClientRegistry.registerTileEntity(TileEntityFluidTank.class, (String)"FluidTank", (TileEntitySpecialRenderer)new RenderFluidTank());
        ClientRegistry.registerTileEntity(TileEntitySolarNeutronActivator.class, (String)"SolarNeutronActivator", (TileEntitySpecialRenderer)new RenderSolarNeutronActivator());
        ClientRegistry.registerTileEntity(TileEntityFormulaicAssemblicator.class, (String)"FormulaicAssemblicator", new RenderConfigurableMachine());
        ClientRegistry.registerTileEntity(TileEntityResistiveHeater.class, (String)"ResistiveHeater", (TileEntitySpecialRenderer)new RenderResistiveHeater());
        ClientRegistry.registerTileEntity(TileEntityBoilerCasing.class, (String)"BoilerCasing", (TileEntitySpecialRenderer)new RenderThermoelectricBoiler());
        ClientRegistry.registerTileEntity(TileEntityBoilerValve.class, (String)"BoilerValve", (TileEntitySpecialRenderer)new RenderThermoelectricBoiler());
        ClientRegistry.registerTileEntity(TileEntitySecurityDesk.class, (String)"SecurityDesk", (TileEntitySpecialRenderer)new RenderSecurityDesk());
        ClientRegistry.registerTileEntity(TileEntityQuantumEntangloporter.class, (String)"QuantumEntangloporter", (TileEntitySpecialRenderer)new RenderQuantumEntangloporter());
        ClientRegistry.registerTileEntity(TileEntityChemicalDissolutionChamber.class, (String)"ChemicalDissolutionChamber", (TileEntitySpecialRenderer)new RenderChemicalDissolutionChamber());
        ClientRegistry.registerTileEntity(TileEntityMechanicalPipe.class, (String)"MechanicalPipe", (TileEntitySpecialRenderer)new RenderMechanicalPipe());
        ClientRegistry.registerTileEntity(TileEntityUniversalCable.class, (String)"UniversalCable", (TileEntitySpecialRenderer)new RenderUniversalCable());
        ClientRegistry.registerTileEntity(TileEntityThermodynamicConductor.class, (String)"ThermodynamicConductor", (TileEntitySpecialRenderer)new RenderThermodynamicConductor());
        ClientRegistry.registerTileEntity(TileEntityLogisticalTransporter.class, (String)"LogisticalTransporter", (TileEntitySpecialRenderer)new RenderLogisticalTransporter());
        ClientRegistry.registerTileEntity(TileEntityDiversionTransporter.class, (String)"DiversionTransporter", (TileEntitySpecialRenderer)new RenderLogisticalTransporter());
        ClientRegistry.registerTileEntity(TileEntityRestrictiveTransporter.class, (String)"RestrictiveTransporter", (TileEntitySpecialRenderer)new RenderLogisticalTransporter());
        ClientRegistry.registerTileEntity(TileEntityPressurizedTube.class, (String)"PressurizedTube", (TileEntitySpecialRenderer)new RenderPressurizedTube());
    }

    @Override
    public void registerItemRenders() {
        this.registerItemRender(MekanismItems.ElectricBow);
        this.registerItemRender(MekanismItems.Dust);
        this.registerItemRender(MekanismItems.Ingot);
        this.registerItemRender(MekanismItems.EnergyTablet);
        this.registerItemRender(MekanismItems.SpeedUpgrade);
        this.registerItemRender(MekanismItems.EnergyUpgrade);
        this.registerItemRender(MekanismItems.FilterUpgrade);
        this.registerItemRender(MekanismItems.MufflingUpgrade);
        this.registerItemRender(MekanismItems.GasUpgrade);
        this.registerItemRender(MekanismItems.AnchorUpgrade);
        this.registerItemRender(MekanismItems.Robit);
        this.registerItemRender(MekanismItems.AtomicDisassembler);
        this.registerItemRender(MekanismItems.EnrichedAlloy);
        this.registerItemRender(MekanismItems.ReinforcedAlloy);
        this.registerItemRender(MekanismItems.AtomicAlloy);
        this.registerItemRender(MekanismItems.ItemProxy);
        this.registerItemRender(MekanismItems.ControlCircuit);
        this.registerItemRender(MekanismItems.EnrichedIron);
        this.registerItemRender(MekanismItems.CompressedCarbon);
        this.registerItemRender(MekanismItems.CompressedRedstone);
        this.registerItemRender(MekanismItems.CompressedDiamond);
        this.registerItemRender(MekanismItems.CompressedObsidian);
        this.registerItemRender(MekanismItems.PortableTeleporter);
        this.registerItemRender(MekanismItems.TeleportationCore);
        this.registerItemRender(MekanismItems.Clump);
        this.registerItemRender(MekanismItems.DirtyDust);
        this.registerItemRender(MekanismItems.Configurator);
        this.registerItemRender(MekanismItems.NetworkReader);
        this.registerItemRender((Item)MekanismItems.Jetpack);
        this.registerItemRender(MekanismItems.Dictionary);
        this.registerItemRender((Item)MekanismItems.GasMask);
        this.registerItemRender((Item)MekanismItems.ScubaTank);
        this.registerItemRender(MekanismItems.Balloon);
        this.registerItemRender(MekanismItems.Shard);
        this.registerItemRender(MekanismItems.ElectrolyticCore);
        this.registerItemRender(MekanismItems.Sawdust);
        this.registerItemRender(MekanismItems.Salt);
        this.registerItemRender(MekanismItems.Crystal);
        this.registerItemRender((Item)MekanismItems.FreeRunners);
        this.registerItemRender((Item)MekanismItems.ArmoredJetpack);
        this.registerItemRender(MekanismItems.ConfigurationCard);
        this.registerItemRender(MekanismItems.SeismicReader);
        this.registerItemRender(MekanismItems.Substrate);
        this.registerItemRender(MekanismItems.Polyethene);
        this.registerItemRender(MekanismItems.BioFuel);
        this.registerItemRender(MekanismItems.Flamethrower);
        this.registerItemRender(MekanismItems.GaugeDropper);
        this.registerItemRender(MekanismItems.TierInstaller);
        this.registerItemRender(MekanismItems.OtherDust);
        ModelBakery.registerItemVariants((Item)MekanismItems.WalkieTalkie, (ResourceLocation[])new ResourceLocation[]{ItemWalkieTalkie.OFF_MODEL});
        for (int i = 1; i <= 9; ++i) {
            ModelBakery.registerItemVariants((Item)MekanismItems.WalkieTalkie, (ResourceLocation[])new ResourceLocation[]{ItemWalkieTalkie.getModel(i)});
        }
        ModelBakery.registerItemVariants((Item)MekanismItems.CraftingFormula, (ResourceLocation[])new ResourceLocation[]{ItemCraftingFormula.MODEL, ItemCraftingFormula.INVALID_MODEL, ItemCraftingFormula.ENCODED_MODEL});
    }

    @Override
    public void registerBlockRenders() {
        Tier.BaseTier tierPointer;
        ModelResourceLocation model;
        String properties;
        ArrayList<String> entries;
        String resource;
        ArrayList<ModelResourceLocation> modelsToAdd;
        ModelLoader.setCustomStateMapper((Block)MekanismBlocks.MachineBlock, (IStateMapper)machineMapper);
        ModelLoader.setCustomStateMapper((Block)MekanismBlocks.MachineBlock2, (IStateMapper)machineMapper);
        ModelLoader.setCustomStateMapper((Block)MekanismBlocks.MachineBlock3, (IStateMapper)machineMapper);
        ModelLoader.setCustomStateMapper((Block)MekanismBlocks.BasicBlock, (IStateMapper)basicMapper);
        ModelLoader.setCustomStateMapper((Block)MekanismBlocks.BasicBlock2, (IStateMapper)basicMapper);
        ModelLoader.setCustomStateMapper((Block)MekanismBlocks.PlasticBlock, (IStateMapper)plasticMapper);
        ModelLoader.setCustomStateMapper((Block)MekanismBlocks.SlickPlasticBlock, (IStateMapper)plasticMapper);
        ModelLoader.setCustomStateMapper((Block)MekanismBlocks.GlowPlasticBlock, (IStateMapper)plasticMapper);
        ModelLoader.setCustomStateMapper((Block)MekanismBlocks.ReinforcedPlasticBlock, (IStateMapper)plasticMapper);
        ModelLoader.setCustomStateMapper((Block)MekanismBlocks.RoadPlasticBlock, (IStateMapper)plasticMapper);
        ModelLoader.setCustomStateMapper((Block)MekanismBlocks.PlasticFence, (IStateMapper)fenceMapper);
        ModelLoader.setCustomStateMapper((Block)MekanismBlocks.CardboardBox, (IStateMapper)boxMapper);
        ModelLoader.setCustomStateMapper((Block)MekanismBlocks.Transmitter, (IStateMapper)transmitterMapper);
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)MekanismBlocks.ObsidianTNT), (int)0, (ModelResourceLocation)new ModelResourceLocation("mekanism:ObsidianTNT", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)MekanismBlocks.SaltBlock), (int)0, (ModelResourceLocation)new ModelResourceLocation("mekanism:SaltBlock", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)MekanismBlocks.CardboardBox), (int)0, (ModelResourceLocation)new ModelResourceLocation("mekanism:CardboardBox", "storage=false"));
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)MekanismBlocks.CardboardBox), (int)1, (ModelResourceLocation)new ModelResourceLocation("mekanism:CardboardBox", "storage=true"));
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)MekanismBlocks.EnergyCube), (int)0, (ModelResourceLocation)new ModelResourceLocation("mekanism:EnergyCube", "inventory"));
        for (int i = 0; i < EnumColor.DYES.length; ++i) {
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)MekanismBlocks.GlowPanel), (int)i, (ModelResourceLocation)new ModelResourceLocation("mekanism:glowpanel", "inventory"));
        }
        for (BlockStateMachine.MachineType machineType : BlockStateMachine.MachineType.values()) {
            if (!machineType.isValidMachine()) continue;
            modelsToAdd = new ArrayList<ModelResourceLocation>();
            resource = "mekanism:" + machineType.func_176610_l();
            IFactory.RecipeType recipePointer = null;
            if (machineType == BlockStateMachine.MachineType.BASIC_FACTORY || machineType == BlockStateMachine.MachineType.ADVANCED_FACTORY || machineType == BlockStateMachine.MachineType.ELITE_FACTORY) {
                recipePointer = IFactory.RecipeType.values()[0];
                resource = "mekanism:" + machineType.func_176610_l() + "_" + recipePointer.func_176610_l();
            }
            while (machineResources.get(resource) == null) {
                entries = new ArrayList<String>();
                if (machineType.hasActiveTexture()) {
                    entries.add("active=false");
                }
                if (machineType.hasRotations()) {
                    entries.add("facing=north");
                }
                properties = new String();
                for (int i = 0; i < entries.size(); ++i) {
                    properties = properties + (String)entries.get(i);
                    if (i >= entries.size() - 1) continue;
                    properties = properties + ",";
                }
                if (Arrays.asList(CUSTOM_RENDERS).contains(machineType.func_176610_l())) {
                    properties = "inventory";
                }
                model = new ModelResourceLocation(resource, properties);
                machineResources.put(resource, model);
                modelsToAdd.add(model);
                if (machineType != BlockStateMachine.MachineType.BASIC_FACTORY && machineType != BlockStateMachine.MachineType.ADVANCED_FACTORY && machineType != BlockStateMachine.MachineType.ELITE_FACTORY || recipePointer.ordinal() >= IFactory.RecipeType.values().length - 1) break;
                recipePointer = IFactory.RecipeType.values()[recipePointer.ordinal() + 1];
                resource = "mekanism:" + machineType.func_176610_l() + "_" + recipePointer.func_176610_l();
            }
            ModelLoader.registerItemVariants((Item)Item.func_150898_a((Block)machineType.typeBlock.getBlock()), (ResourceLocation[])((ResourceLocation[])modelsToAdd.toArray(new ModelResourceLocation[0])));
        }
        for (Enum enum_ : BlockStateBasic.BasicBlockType.values()) {
            modelsToAdd = new ArrayList();
            resource = "mekanism:" + ((BlockStateBasic.BasicBlockType)enum_).func_176610_l();
            tierPointer = null;
            if (((BlockStateBasic.BasicBlockType)enum_).tiers) {
                tierPointer = Tier.BaseTier.values()[0];
                resource = "mekanism:" + ((BlockStateBasic.BasicBlockType)enum_).func_176610_l() + "_" + tierPointer.func_176610_l();
            }
            while (basicResources.get(resource) == null) {
                entries = new ArrayList();
                if (((BlockStateBasic.BasicBlockType)enum_).hasActiveTexture()) {
                    entries.add("active=false");
                }
                if (((BlockStateBasic.BasicBlockType)enum_).hasRotations() || enum_ == BlockStateBasic.BasicBlockType.THERMAL_EVAPORATION_CONTROLLER) {
                    entries.add("facing=north");
                }
                properties = new String();
                for (int i = 0; i < entries.size(); ++i) {
                    properties = properties + (String)entries.get(i);
                    if (i >= entries.size() - 1) continue;
                    properties = properties + ",";
                }
                if (enum_ == BlockStateBasic.BasicBlockType.BIN || Arrays.asList(CUSTOM_RENDERS).contains(((BlockStateBasic.BasicBlockType)enum_).func_176610_l())) {
                    properties = "inventory";
                }
                model = new ModelResourceLocation(resource, properties);
                basicResources.put(resource, model);
                modelsToAdd.add(model);
                if (!((BlockStateBasic.BasicBlockType)enum_).tiers || tierPointer.ordinal() >= Tier.BaseTier.values().length - 1) break;
                tierPointer = Tier.BaseTier.values()[tierPointer.ordinal() + 1];
                if (enum_ != BlockStateBasic.BasicBlockType.BIN && !tierPointer.isObtainable()) break;
                resource = "mekanism:" + ((BlockStateBasic.BasicBlockType)enum_).func_176610_l() + "_" + tierPointer.func_176610_l();
            }
            ModelLoader.registerItemVariants((Item)Item.func_150898_a((Block)((BlockStateBasic.BasicBlockType)enum_).blockType.getBlock()), (ResourceLocation[])((ResourceLocation[])modelsToAdd.toArray(new ModelResourceLocation[0])));
        }
        for (Enum enum_ : BlockStateTransmitter.TransmitterType.values()) {
            modelsToAdd = new ArrayList();
            resource = "mekanism:" + ((BlockStateTransmitter.TransmitterType)enum_).func_176610_l();
            tierPointer = null;
            if (((BlockStateTransmitter.TransmitterType)enum_).hasTiers()) {
                tierPointer = Tier.BaseTier.values()[0];
                resource = "mekanism:" + ((BlockStateTransmitter.TransmitterType)enum_).func_176610_l() + "_" + tierPointer.func_176610_l();
            }
            while (transmitterResources.get(resource) == null) {
                String properties2 = "inventory";
                ModelResourceLocation model2 = new ModelResourceLocation(resource, properties2);
                transmitterResources.put(resource, model2);
                modelsToAdd.add(model2);
                if (!((BlockStateTransmitter.TransmitterType)enum_).hasTiers() || tierPointer.ordinal() >= Tier.BaseTier.values().length - 1 || !(tierPointer = Tier.BaseTier.values()[tierPointer.ordinal() + 1]).isObtainable()) break;
                resource = "mekanism:" + ((BlockStateTransmitter.TransmitterType)enum_).func_176610_l() + "_" + tierPointer.func_176610_l();
            }
            ModelLoader.registerItemVariants((Item)Item.func_150898_a((Block)MekanismBlocks.Transmitter), (ResourceLocation[])((ResourceLocation[])modelsToAdd.toArray(new ModelResourceLocation[0])));
        }
        for (Enum enum_ : EnumColor.DYES) {
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)MekanismBlocks.PlasticBlock), (int)((EnumColor)enum_).getMetaValue(), (ModelResourceLocation)new ModelResourceLocation("mekanism:plastic_block", "type=plastic"));
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)MekanismBlocks.SlickPlasticBlock), (int)((EnumColor)enum_).getMetaValue(), (ModelResourceLocation)new ModelResourceLocation("mekanism:plastic_block", "type=slick"));
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)MekanismBlocks.GlowPlasticBlock), (int)((EnumColor)enum_).getMetaValue(), (ModelResourceLocation)new ModelResourceLocation("mekanism:plastic_block", "type=glow"));
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)MekanismBlocks.ReinforcedPlasticBlock), (int)((EnumColor)enum_).getMetaValue(), (ModelResourceLocation)new ModelResourceLocation("mekanism:plastic_block", "type=reinforced"));
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)MekanismBlocks.RoadPlasticBlock), (int)((EnumColor)enum_).getMetaValue(), (ModelResourceLocation)new ModelResourceLocation("mekanism:plastic_block", "type=road"));
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)MekanismBlocks.PlasticFence), (int)((EnumColor)enum_).getMetaValue(), (ModelResourceLocation)new ModelResourceLocation("mekanism:PlasticFence", "inventory"));
        }
        for (Enum enum_ : BlockStateOre.EnumOreType.values()) {
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)MekanismBlocks.OreBlock), (int)enum_.ordinal(), (ModelResourceLocation)new ModelResourceLocation("mekanism:OreBlock", "type=" + ((BlockStateOre.EnumOreType)enum_).func_176610_l()));
        }
        ModelLoader.setCustomMeshDefinition((Item)Item.func_150898_a((Block)MekanismBlocks.GasTank), (ItemMeshDefinition)new ItemMeshDefinition(){

            public ModelResourceLocation func_178113_a(ItemStack stack) {
                Tier.GasTankTier tier = Tier.GasTankTier.values()[((ItemBlockGasTank)stack.func_77973_b()).getBaseTier(stack).ordinal()];
                ResourceLocation baseLocation = new ResourceLocation("mekanism", "GasTank");
                return new ModelResourceLocation(baseLocation, "facing=north,tier=" + tier);
            }
        });
        ItemMeshDefinition machineMesher = new ItemMeshDefinition(){

            public ModelResourceLocation func_178113_a(ItemStack stack) {
                BlockStateMachine.MachineType type = BlockStateMachine.MachineType.get(stack);
                if (type != null) {
                    String resource = "mekanism:" + type.func_176610_l();
                    if (type == BlockStateMachine.MachineType.BASIC_FACTORY || type == BlockStateMachine.MachineType.ADVANCED_FACTORY || type == BlockStateMachine.MachineType.ELITE_FACTORY) {
                        IFactory.RecipeType recipe = IFactory.RecipeType.values()[((ItemBlockMachine)stack.func_77973_b()).getRecipeType(stack)];
                        resource = "mekanism:" + type.func_176610_l() + "_" + recipe.func_176610_l();
                    }
                    return machineResources.get(resource);
                }
                return null;
            }
        };
        ModelLoader.setCustomMeshDefinition((Item)Item.func_150898_a((Block)MekanismBlocks.MachineBlock), (ItemMeshDefinition)machineMesher);
        ModelLoader.setCustomMeshDefinition((Item)Item.func_150898_a((Block)MekanismBlocks.MachineBlock2), (ItemMeshDefinition)machineMesher);
        ModelLoader.setCustomMeshDefinition((Item)Item.func_150898_a((Block)MekanismBlocks.MachineBlock3), (ItemMeshDefinition)machineMesher);
        ItemMeshDefinition basicMesher = new ItemMeshDefinition(){

            public ModelResourceLocation func_178113_a(ItemStack stack) {
                BlockStateBasic.BasicBlockType type = BlockStateBasic.BasicBlockType.get(stack);
                if (type != null) {
                    String resource = "mekanism:" + type.func_176610_l();
                    if (type.tiers) {
                        Tier.BaseTier tier = ((ItemBlockBasic)stack.func_77973_b()).getBaseTier(stack);
                        resource = "mekanism:" + type.func_176610_l() + "_" + tier.func_176610_l();
                    }
                    return basicResources.get(resource);
                }
                return null;
            }
        };
        ModelLoader.setCustomMeshDefinition((Item)Item.func_150898_a((Block)MekanismBlocks.BasicBlock), (ItemMeshDefinition)basicMesher);
        ModelLoader.setCustomMeshDefinition((Item)Item.func_150898_a((Block)MekanismBlocks.BasicBlock2), (ItemMeshDefinition)basicMesher);
        ItemMeshDefinition transmitterMesher = new ItemMeshDefinition(){

            public ModelResourceLocation func_178113_a(ItemStack stack) {
                BlockStateTransmitter.TransmitterType type = BlockStateTransmitter.TransmitterType.get(stack.func_77952_i());
                if (type != null) {
                    String resource = "mekanism:" + type.func_176610_l();
                    if (type.hasTiers()) {
                        Tier.BaseTier tier = ((ItemBlockTransmitter)stack.func_77973_b()).getBaseTier(stack);
                        resource = "mekanism:" + type.func_176610_l() + "_" + tier.func_176610_l();
                    }
                    return transmitterResources.get(resource);
                }
                return null;
            }
        };
        ModelLoader.setCustomMeshDefinition((Item)Item.func_150898_a((Block)MekanismBlocks.Transmitter), (ItemMeshDefinition)transmitterMesher);
        OBJLoader.INSTANCE.addDomain("mekanism");
    }

    public void registerItemRender(Item item) {
        MekanismRenderer.registerItemRender("mekanism", item);
    }

    public GuiScreen getClientGui(int ID, EntityPlayer player, World world, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        switch (ID) {
            case 0: {
                return new GuiDictionary(player.field_71071_by);
            }
            case 1: {
                return new GuiCredits();
            }
            case 2: {
                return new GuiDigitalMiner(player.field_71071_by, (TileEntityDigitalMiner)tileEntity);
            }
            case 3: {
                return new GuiEnrichmentChamber(player.field_71071_by, (TileEntityElectricMachine)tileEntity);
            }
            case 4: {
                return new GuiOsmiumCompressor(player.field_71071_by, (TileEntityAdvancedElectricMachine)tileEntity);
            }
            case 5: {
                return new GuiCombiner(player.field_71071_by, (TileEntityAdvancedElectricMachine)tileEntity);
            }
            case 6: {
                return new GuiCrusher(player.field_71071_by, (TileEntityElectricMachine)tileEntity);
            }
            case 7: {
                return new GuiRotaryCondensentrator(player.field_71071_by, (TileEntityRotaryCondensentrator)tileEntity);
            }
            case 8: {
                return new GuiEnergyCube(player.field_71071_by, (TileEntityEnergyCube)tileEntity);
            }
            case 9: {
                return new GuiSideConfiguration(player, (ISideConfiguration)tileEntity);
            }
            case 10: {
                return new GuiGasTank(player.field_71071_by, (TileEntityGasTank)tileEntity);
            }
            case 11: {
                return new GuiFactory(player.field_71071_by, (TileEntityFactory)tileEntity);
            }
            case 12: {
                return new GuiMetallurgicInfuser(player.field_71071_by, (TileEntityMetallurgicInfuser)tileEntity);
            }
            case 13: {
                return new GuiTeleporter(player.field_71071_by, (TileEntityTeleporter)tileEntity);
            }
            case 14: {
                ItemStack itemStack = player.func_184586_b(EnumHand.values()[pos.func_177958_n()]);
                if (!itemStack.func_190926_b() && itemStack.func_77973_b() instanceof ItemPortableTeleporter) {
                    return new GuiTeleporter(player, EnumHand.values()[pos.func_177958_n()], itemStack);
                }
                return null;
            }
            case 15: {
                return new GuiPurificationChamber(player.field_71071_by, (TileEntityAdvancedElectricMachine)tileEntity);
            }
            case 16: {
                return new GuiEnergizedSmelter(player.field_71071_by, (TileEntityElectricMachine)tileEntity);
            }
            case 17: {
                return new GuiElectricPump(player.field_71071_by, (TileEntityElectricPump)tileEntity);
            }
            case 18: {
                return new GuiDynamicTank(player.field_71071_by, (TileEntityDynamicTank)tileEntity);
            }
            case 21: {
                EntityRobit robit = (EntityRobit)world.func_73045_a(pos.func_177958_n());
                if (robit != null) {
                    return new GuiRobitMain(player.field_71071_by, robit);
                }
                return null;
            }
            case 22: {
                EntityRobit robit = (EntityRobit)world.func_73045_a(pos.func_177958_n());
                if (robit != null) {
                    return new GuiRobitCrafting(player.field_71071_by, robit);
                }
                return null;
            }
            case 23: {
                EntityRobit robit = (EntityRobit)world.func_73045_a(pos.func_177958_n());
                if (robit != null) {
                    return new GuiRobitInventory(player.field_71071_by, robit);
                }
                return null;
            }
            case 24: {
                EntityRobit robit = (EntityRobit)world.func_73045_a(pos.func_177958_n());
                if (robit != null) {
                    return new GuiRobitSmelting(player.field_71071_by, robit);
                }
                return null;
            }
            case 25: {
                EntityRobit robit = (EntityRobit)world.func_73045_a(pos.func_177958_n());
                if (robit != null) {
                    return new GuiRobitRepair(player.field_71071_by, robit);
                }
                return null;
            }
            case 29: {
                return new GuiChemicalOxidizer(player.field_71071_by, (TileEntityChemicalOxidizer)tileEntity);
            }
            case 30: {
                return new GuiChemicalInfuser(player.field_71071_by, (TileEntityChemicalInfuser)tileEntity);
            }
            case 31: {
                return new GuiChemicalInjectionChamber(player.field_71071_by, (TileEntityAdvancedElectricMachine)tileEntity);
            }
            case 32: {
                return new GuiElectrolyticSeparator(player.field_71071_by, (TileEntityElectrolyticSeparator)tileEntity);
            }
            case 33: {
                return new GuiThermalEvaporationController(player.field_71071_by, (TileEntityThermalEvaporationController)tileEntity);
            }
            case 34: {
                return new GuiPrecisionSawmill(player.field_71071_by, (TileEntityPrecisionSawmill)tileEntity);
            }
            case 35: {
                return new GuiChemicalDissolutionChamber(player.field_71071_by, (TileEntityChemicalDissolutionChamber)tileEntity);
            }
            case 36: {
                return new GuiChemicalWasher(player.field_71071_by, (TileEntityChemicalWasher)tileEntity);
            }
            case 37: {
                return new GuiChemicalCrystallizer(player.field_71071_by, (TileEntityChemicalCrystallizer)tileEntity);
            }
            case 38: {
                ItemStack itemStack1 = player.func_184586_b(EnumHand.values()[pos.func_177958_n()]);
                if (!itemStack1.func_190926_b() && itemStack1.func_77973_b() instanceof ItemSeismicReader) {
                    return new GuiSeismicReader(world, new Coord4D((Entity)player), itemStack1.func_77946_l());
                }
                return null;
            }
            case 39: {
                return new GuiSeismicVibrator(player.field_71071_by, (TileEntitySeismicVibrator)tileEntity);
            }
            case 40: {
                return new GuiPRC(player.field_71071_by, (TileEntityPRC)tileEntity);
            }
            case 41: {
                return new GuiFluidTank(player.field_71071_by, (TileEntityFluidTank)tileEntity);
            }
            case 42: {
                return new GuiFluidicPlenisher(player.field_71071_by, (TileEntityFluidicPlenisher)tileEntity);
            }
            case 43: {
                return new GuiUpgradeManagement(player.field_71071_by, (IUpgradeTile)tileEntity);
            }
            case 44: {
                return new GuiLaserAmplifier(player.field_71071_by, (TileEntityLaserAmplifier)tileEntity);
            }
            case 45: {
                return new GuiLaserTractorBeam(player.field_71071_by, (TileEntityLaserTractorBeam)tileEntity);
            }
            case 46: {
                return new GuiQuantumEntangloporter(player.field_71071_by, (TileEntityQuantumEntangloporter)tileEntity);
            }
            case 47: {
                return new GuiSolarNeutronActivator(player.field_71071_by, (TileEntitySolarNeutronActivator)tileEntity);
            }
            case 48: {
                return new GuiAmbientAccumulator(player, (TileEntityAmbientAccumulator)tileEntity);
            }
            case 49: {
                return new GuiInductionMatrix(player.field_71071_by, (TileEntityInductionCasing)tileEntity);
            }
            case 50: {
                return new GuiMatrixStats(player.field_71071_by, (TileEntityInductionCasing)tileEntity);
            }
            case 51: {
                return new GuiTransporterConfig(player, (ISideConfiguration)tileEntity);
            }
            case 52: {
                return new GuiOredictionificator(player.field_71071_by, (TileEntityOredictionificator)tileEntity);
            }
            case 53: {
                return new GuiResistiveHeater(player.field_71071_by, (TileEntityResistiveHeater)tileEntity);
            }
            case 54: {
                return new GuiThermoelectricBoiler(player.field_71071_by, (TileEntityBoilerCasing)tileEntity);
            }
            case 55: {
                return new GuiBoilerStats(player.field_71071_by, (TileEntityBoilerCasing)tileEntity);
            }
            case 56: {
                return new GuiFormulaicAssemblicator(player.field_71071_by, (TileEntityFormulaicAssemblicator)tileEntity);
            }
            case 57: {
                return new GuiSecurityDesk(player.field_71071_by, (TileEntitySecurityDesk)tileEntity);
            }
            case 58: {
                return new GuiFuelwoodHeater(player.field_71071_by, (TileEntityFuelwoodHeater)tileEntity);
            }
        }
        return null;
    }

    @Override
    public void handleTeleporterUpdate(PacketPortableTeleporter.PortableTeleporterMessage message) {
        GuiScreen screen = Minecraft.func_71410_x().field_71462_r;
        if (screen instanceof GuiTeleporter && !((GuiTeleporter)screen).itemStack.func_190926_b()) {
            GuiTeleporter teleporter = (GuiTeleporter)screen;
            teleporter.clientStatus = message.status;
            teleporter.clientFreq = message.frequency;
            teleporter.clientPublicCache = message.publicCache;
            teleporter.clientPrivateCache = message.privateCache;
            teleporter.updateButtons();
        }
    }

    @Override
    public void addHitEffects(Coord4D coord, RayTraceResult mop) {
        if (Minecraft.func_71410_x().field_71441_e != null) {
            Minecraft.func_71410_x().field_71452_i.addBlockHitEffects(coord.getPos(), mop);
        }
    }

    @Override
    public void doGenericSparkle(TileEntity tileEntity, SparkleAnimation.INodeChecker checker) {
        new SparkleAnimation(tileEntity, checker).run();
    }

    @Override
    public void doMultiblockSparkle(final TileEntityMultiblock<?> tileEntity) {
        new SparkleAnimation(tileEntity, new SparkleAnimation.INodeChecker(){

            @Override
            public boolean isNode(TileEntity tile) {
                return MultiblockManager.areEqual(tile, tileEntity);
            }
        }).run();
    }

    @Override
    public void init() {
        super.init();
        Minecraft.func_71410_x().func_184125_al().func_186722_a(new IBlockColor(){

            public int func_186720_a(IBlockState state, IBlockAccess worldIn, BlockPos pos, int tintIndex) {
                BlockMachine machine = (BlockMachine)state.func_177230_c();
                if (state.func_177229_b(machine.getMachineBlock().getProperty()) == BlockStateMachine.MachineType.FLUID_TANK) {
                    EnumColor color = ((Tier.BaseTier)((Object)state.func_177229_b(BlockStateMachine.tierProperty))).getColor();
                    return (int)(color.getColor(0) * 255.0f) << 16 | (int)(color.getColor(1) * 255.0f) << 8 | (int)(color.getColor(2) * 255.0f);
                }
                return -1;
            }
        }, new Block[]{MekanismBlocks.MachineBlock, MekanismBlocks.MachineBlock2, MekanismBlocks.MachineBlock3});
        Minecraft.func_71410_x().func_184125_al().func_186722_a(new IBlockColor(){

            public int func_186720_a(IBlockState state, IBlockAccess worldIn, BlockPos pos, int tintIndex) {
                EnumDyeColor color = (EnumDyeColor)state.func_177229_b(BlockStatePlastic.colorProperty);
                EnumColor dye = EnumColor.DYES[color.func_176767_b()];
                return (int)(dye.getColor(0) * 255.0f) << 16 | (int)(dye.getColor(1) * 255.0f) << 8 | (int)(dye.getColor(2) * 255.0f);
            }
        }, new Block[]{MekanismBlocks.PlasticBlock, MekanismBlocks.GlowPlasticBlock, MekanismBlocks.RoadPlasticBlock, MekanismBlocks.ReinforcedPlasticBlock, MekanismBlocks.SlickPlasticBlock, MekanismBlocks.PlasticFence});
        Minecraft.func_71410_x().getItemColors().func_186731_a(new IItemColor(){

            public int func_186726_a(ItemStack stack, int tintIndex) {
                if (BlockStateMachine.MachineType.get(stack) == BlockStateMachine.MachineType.FLUID_TANK) {
                    EnumColor color = ((ItemBlockMachine)stack.func_77973_b()).getBaseTier(stack).getColor();
                    return (int)(color.getColor(0) * 255.0f) << 16 | (int)(color.getColor(1) * 255.0f) << 8 | (int)(color.getColor(2) * 255.0f);
                }
                return -1;
            }
        }, new Block[]{MekanismBlocks.MachineBlock, MekanismBlocks.MachineBlock2, MekanismBlocks.MachineBlock3});
        Minecraft.func_71410_x().getItemColors().func_186731_a(new IItemColor(){

            public int func_186726_a(ItemStack stack, int tintIndex) {
                EnumDyeColor dyeColor = EnumDyeColor.func_176766_a((int)(stack.func_77952_i() & 0xF));
                EnumColor dye = EnumColor.DYES[dyeColor.func_176767_b()];
                return (int)(dye.getColor(0) * 255.0f) << 16 | (int)(dye.getColor(1) * 255.0f) << 8 | (int)(dye.getColor(2) * 255.0f);
            }
        }, new Block[]{MekanismBlocks.PlasticBlock, MekanismBlocks.GlowPlasticBlock, MekanismBlocks.RoadPlasticBlock, MekanismBlocks.ReinforcedPlasticBlock, MekanismBlocks.SlickPlasticBlock, MekanismBlocks.PlasticFence});
        Minecraft.func_71410_x().getItemColors().func_186730_a(new IItemColor(){

            public int func_186726_a(ItemStack stack, int tintIndex) {
                EnumColor dye = EnumColor.DYES[stack.func_77952_i()];
                return (int)(dye.getColor(0) * 255.0f) << 16 | (int)(dye.getColor(1) * 255.0f) << 8 | (int)(dye.getColor(2) * 255.0f);
            }
        }, new Item[]{MekanismItems.Balloon});
        MinecraftForge.EVENT_BUS.register((Object)new ClientConnectionHandler());
        MinecraftForge.EVENT_BUS.register((Object)new ClientPlayerTracker());
        MinecraftForge.EVENT_BUS.register((Object)new ClientTickHandler());
        MinecraftForge.EVENT_BUS.register((Object)new RenderTickHandler());
        new MekanismKeyHandler();
        HolidayManager.init();
    }

    @SubscribeEvent
    public void onModelBake(ModelBakeEvent event) throws IOException {
        for (String s : CUSTOM_RENDERS) {
            ModelResourceLocation model = new ModelResourceLocation("mekanism:" + s, "inventory");
            Object obj = event.getModelRegistry().func_82594_a((Object)model);
            if (!(obj instanceof IBakedModel)) continue;
            event.getModelRegistry().func_82595_a((Object)model, (Object)new CustomItemModelFactory((IBakedModel)obj));
        }
    }

    @Override
    public void preInit() {
        MekanismRenderer.init();
        ModelLoaderRegistry.registerLoader((ICustomModelLoader)MekanismOBJLoader.INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)MekanismOBJLoader.INSTANCE);
        RenderingRegistry.registerEntityRenderingHandler(EntityObsidianTNT.class, (IRenderFactory)new IRenderFactory<EntityObsidianTNT>(){

            public Render<EntityObsidianTNT> createRenderFor(RenderManager manager) {
                return new RenderObsidianTNTPrimed(manager);
            }
        });
        RenderingRegistry.registerEntityRenderingHandler(EntityRobit.class, (IRenderFactory)new IRenderFactory<EntityRobit>(){

            public Render<EntityRobit> createRenderFor(RenderManager manager) {
                return new RenderRobit(manager);
            }
        });
        RenderingRegistry.registerEntityRenderingHandler(EntityBalloon.class, (IRenderFactory)new IRenderFactory<EntityBalloon>(){

            public Render<EntityBalloon> createRenderFor(RenderManager manager) {
                return new RenderBalloon(manager);
            }
        });
        RenderingRegistry.registerEntityRenderingHandler(EntityBabySkeleton.class, (IRenderFactory)new IRenderFactory<EntityBabySkeleton>(){

            public Render<AbstractSkeleton> createRenderFor(RenderManager manager) {
                return new RenderSkeleton(manager);
            }
        });
        RenderingRegistry.registerEntityRenderingHandler(EntityFlame.class, (IRenderFactory)new IRenderFactory<EntityFlame>(){

            public Render<? super EntityFlame> createRenderFor(RenderManager manager) {
                return new RenderFlame(manager);
            }
        });
        ModelLoader.setCustomMeshDefinition((Item)MekanismItems.WalkieTalkie, (ItemMeshDefinition)new ItemMeshDefinition(){

            public ModelResourceLocation func_178113_a(ItemStack stack) {
                ItemWalkieTalkie item;
                if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemWalkieTalkie && (item = (ItemWalkieTalkie)stack.func_77973_b()).getOn(stack)) {
                    return ItemWalkieTalkie.CHANNEL_MODELS.get(item.getChannel(stack));
                }
                return ItemWalkieTalkie.OFF_MODEL;
            }
        });
        ModelLoader.setCustomMeshDefinition((Item)MekanismItems.CraftingFormula, (ItemMeshDefinition)new ItemMeshDefinition(){

            public ModelResourceLocation func_178113_a(ItemStack stack) {
                if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemCraftingFormula) {
                    ItemCraftingFormula item = (ItemCraftingFormula)stack.func_77973_b();
                    if (item.getInventory(stack) == null) {
                        return ItemCraftingFormula.MODEL;
                    }
                    return item.isInvalid(stack) ? ItemCraftingFormula.INVALID_MODEL : ItemCraftingFormula.ENCODED_MODEL;
                }
                return ItemCraftingFormula.MODEL;
            }
        });
    }

    @Override
    public double getReach(EntityPlayer player) {
        return Minecraft.func_71410_x().field_71442_b.func_78757_d();
    }

    @Override
    public boolean isPaused() {
        GuiScreen screen;
        return FMLClientHandler.instance().getClient().func_71356_B() && !FMLClientHandler.instance().getClient().func_71401_C().func_71344_c() && (screen = FMLClientHandler.instance().getClient().field_71462_r) != null && screen.func_73868_f();
    }

    @Override
    public File getMinecraftDir() {
        return Minecraft.func_71410_x().field_71412_D;
    }

    @Override
    public void onConfigSync(boolean fromPacket) {
        super.onConfigSync(fromPacket);
        if (fromPacket && MekanismConfig.general.voiceServerEnabled && MekanismClient.voiceClient != null) {
            MekanismClient.voiceClient.start();
        }
    }

    @Override
    public EntityPlayer getPlayer(MessageContext context) {
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            return context.getServerHandler().field_147369_b;
        }
        return Minecraft.func_71410_x().field_71439_g;
    }

    @Override
    public void handlePacket(Runnable runnable, EntityPlayer player) {
        if (player == null || player.field_70170_p.field_72995_K) {
            Minecraft.func_71410_x().func_152344_a(runnable);
        } else if (player != null && !player.field_70170_p.field_72995_K) {
            ((WorldServer)player.field_70170_p).func_152344_a(runnable);
        }
    }

    @Override
    public void renderLaser(World world, Pos3D from, Pos3D to, EnumFacing direction, double energy) {
        Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new ParticleLaser(world, from, to, direction, energy));
    }

    public FontRenderer getFontRenderer() {
        return Minecraft.func_71410_x().field_71466_p;
    }
}

