/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import mekanism.api.Chunk3D;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.common.network.NetworkRegistry;

public class Coord4D {
    public int xCoord;
    public int yCoord;
    public int zCoord;
    public int dimensionId;

    public Coord4D(Entity entity) {
        this.xCoord = (int)entity.field_70165_t;
        this.yCoord = (int)entity.field_70163_u;
        this.zCoord = (int)entity.field_70161_v;
        this.dimensionId = entity.field_70170_p.field_73011_w.getDimension();
    }

    public Coord4D(double x, double y, double z, int dimension) {
        this.xCoord = MathHelper.func_76128_c((double)x);
        this.yCoord = MathHelper.func_76128_c((double)y);
        this.zCoord = MathHelper.func_76128_c((double)z);
        this.dimensionId = dimension;
    }

    public Coord4D(BlockPos pos, World world) {
        this(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), world.field_73011_w.getDimension());
    }

    public Coord4D(RayTraceResult mop, World world) {
        this(mop.func_178782_a(), world);
    }

    public IBlockState getBlockState(IBlockAccess world) {
        return world.func_180495_p(this.getPos());
    }

    public int getBlockMeta(IBlockAccess world) {
        IBlockState state = this.getBlockState(world);
        return state == null ? 0 : state.func_177230_c().func_176201_c(state);
    }

    public BlockPos getPos() {
        return new BlockPos(this.xCoord, this.yCoord, this.zCoord);
    }

    public TileEntity getTileEntity(IBlockAccess world) {
        if (world instanceof World && !this.exists((World)world)) {
            return null;
        }
        return world.func_175625_s(this.getPos());
    }

    public Block getBlock(IBlockAccess world) {
        if (world instanceof World && !this.exists((World)world)) {
            return null;
        }
        return this.getBlockState(world).func_177230_c();
    }

    public NBTTagCompound write(NBTTagCompound nbtTags) {
        nbtTags.func_74768_a("x", this.xCoord);
        nbtTags.func_74768_a("y", this.yCoord);
        nbtTags.func_74768_a("z", this.zCoord);
        nbtTags.func_74768_a("dimensionId", this.dimensionId);
        return nbtTags;
    }

    public void write(ArrayList data) {
        data.add(this.xCoord);
        data.add(this.yCoord);
        data.add(this.zCoord);
        data.add(this.dimensionId);
    }

    public void write(ByteBuf dataStream) {
        dataStream.writeInt(this.xCoord);
        dataStream.writeInt(this.yCoord);
        dataStream.writeInt(this.zCoord);
        dataStream.writeInt(this.dimensionId);
    }

    public Coord4D translate(int x, int y, int z) {
        return new Coord4D(this.xCoord + x, this.yCoord + y, this.zCoord + z, this.dimensionId);
    }

    public Coord4D translate(Coord4D coord) {
        return this.translate(coord.xCoord, coord.yCoord, coord.zCoord);
    }

    public Coord4D offset(EnumFacing side) {
        return this.offset(side, 1);
    }

    public Coord4D offset(EnumFacing side, int amount) {
        if (side == null || amount == 0) {
            return this;
        }
        return new Coord4D(this.xCoord + side.func_82601_c() * amount, this.yCoord + side.func_96559_d() * amount, this.zCoord + side.func_82599_e() * amount, this.dimensionId);
    }

    public ItemStack getStack(IBlockAccess world) {
        IBlockState state = this.getBlockState(world);
        if (state == null || state == Blocks.field_150350_a) {
            return ItemStack.field_190927_a;
        }
        return new ItemStack(state.func_177230_c(), 1, state.func_177230_c().func_176201_c(state));
    }

    public static Coord4D get(TileEntity tileEntity) {
        return new Coord4D(tileEntity.func_174877_v(), tileEntity.func_145831_w());
    }

    public static Coord4D read(NBTTagCompound tag) {
        return new Coord4D(tag.func_74762_e("x"), tag.func_74762_e("y"), tag.func_74762_e("z"), tag.func_74762_e("id"));
    }

    public static Coord4D read(ByteBuf dataStream) {
        return new Coord4D(dataStream.readInt(), dataStream.readInt(), dataStream.readInt(), dataStream.readInt());
    }

    public Coord4D difference(Coord4D other) {
        return new Coord4D(this.xCoord - other.xCoord, this.yCoord - other.yCoord, this.zCoord - other.zCoord, this.dimensionId);
    }

    public EnumFacing sideDifference(Coord4D other) {
        Coord4D diff = this.difference(other);
        for (EnumFacing side : EnumFacing.field_82609_l) {
            if (side.func_82601_c() != diff.xCoord || side.func_96559_d() != diff.yCoord || side.func_82599_e() != diff.zCoord) continue;
            return side;
        }
        return null;
    }

    public int distanceTo(Coord4D obj) {
        int subX = this.xCoord - obj.xCoord;
        int subY = this.yCoord - obj.yCoord;
        int subZ = this.zCoord - obj.zCoord;
        return (int)MathHelper.func_76129_c((float)(subX * subX + subY * subY + subZ * subZ));
    }

    public boolean sideVisible(EnumFacing side, IBlockAccess world) {
        return world.func_175623_d(this.step(side).getPos());
    }

    public NetworkRegistry.TargetPoint getTargetPoint(double range) {
        return new NetworkRegistry.TargetPoint(this.dimensionId, (double)this.xCoord, (double)this.yCoord, (double)this.zCoord, range);
    }

    public Coord4D step(EnumFacing side) {
        return this.translate(side.func_82601_c(), side.func_96559_d(), side.func_82599_e());
    }

    public boolean exists(World world) {
        return world.func_72863_F() == null || world.func_72863_F().func_186026_b(this.xCoord >> 4, this.zCoord >> 4) != null;
    }

    public Chunk getChunk(World world) {
        return world.func_175726_f(this.getPos());
    }

    public Chunk3D getChunk3D() {
        return new Chunk3D(this);
    }

    public boolean isAirBlock(IBlockAccess world) {
        return world.func_175623_d(this.getPos());
    }

    public boolean isReplaceable(World world) {
        return this.getBlock((IBlockAccess)world).func_176200_f((IBlockAccess)world, this.getPos());
    }

    public AxisAlignedBB getBoundingBox() {
        return new AxisAlignedBB((double)this.xCoord, (double)this.yCoord, (double)this.zCoord, (double)(this.xCoord + 1), (double)(this.yCoord + 1), (double)(this.zCoord + 1));
    }

    public Coord4D clone() {
        return new Coord4D(this.xCoord, this.yCoord, this.zCoord, this.dimensionId);
    }

    public String toString() {
        return "[Coord4D: " + this.xCoord + ", " + this.yCoord + ", " + this.zCoord + ", dim=" + this.dimensionId + "]";
    }

    public boolean equals(Object obj) {
        return obj instanceof Coord4D && ((Coord4D)obj).xCoord == this.xCoord && ((Coord4D)obj).yCoord == this.yCoord && ((Coord4D)obj).zCoord == this.zCoord && ((Coord4D)obj).dimensionId == this.dimensionId;
    }

    public int hashCode() {
        int code = 1;
        code = 31 * code + this.xCoord;
        code = 31 * code + this.yCoord;
        code = 31 * code + this.zCoord;
        code = 31 * code + this.dimensionId;
        return code;
    }
}

