/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.block;

import buildcraft.api.tools.IToolWrench;
import java.util.Random;
import mekanism.api.energy.IEnergizedItem;
import mekanism.common.Mekanism;
import mekanism.common.base.IActiveState;
import mekanism.common.base.IBoundingBlock;
import mekanism.common.base.ISustainedData;
import mekanism.common.base.ISustainedInventory;
import mekanism.common.base.ISustainedTank;
import mekanism.common.block.states.BlockStateFacing;
import mekanism.common.config.MekanismConfig;
import mekanism.common.multiblock.IMultiblock;
import mekanism.common.security.ISecurityItem;
import mekanism.common.security.ISecurityTile;
import mekanism.common.tile.TileEntityMultiblock;
import mekanism.common.tile.prefab.TileEntityBasicBlock;
import mekanism.common.tile.prefab.TileEntityContainerBlock;
import mekanism.common.tile.prefab.TileEntityElectricBlock;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.SecurityUtils;
import mekanism.generators.common.GeneratorsBlocks;
import mekanism.generators.common.GeneratorsItems;
import mekanism.generators.common.MekanismGenerators;
import mekanism.generators.common.block.states.BlockStateGenerator;
import mekanism.generators.common.tile.TileEntitySolarGenerator;
import mekanism.generators.common.tile.turbine.TileEntityTurbineRotor;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class BlockGenerator
extends BlockContainer {
    public Random machineRand = new Random();
    private static final AxisAlignedBB SOLAR_BOUNDS = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, (double)0.7f, 1.0);
    private static final AxisAlignedBB ROTOR_BOUNDS = new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 1.0, 0.625);

    public BlockGenerator() {
        super(Material.field_151573_f);
        this.func_149711_c(3.5f);
        this.func_149752_b(8.0f);
        this.func_149647_a((CreativeTabs)Mekanism.tabMekanism);
    }

    public static BlockGenerator getGeneratorBlock(final BlockStateGenerator.GeneratorBlock block) {
        return new BlockGenerator(){

            @Override
            public BlockStateGenerator.GeneratorBlock getGeneratorBlock() {
                return block;
            }
        };
    }

    public abstract BlockStateGenerator.GeneratorBlock getGeneratorBlock();

    public BlockStateContainer func_180661_e() {
        return new BlockStateGenerator(this, this.getTypeProperty());
    }

    public IBlockState func_176203_a(int meta) {
        BlockStateGenerator.GeneratorType type = BlockStateGenerator.GeneratorType.get(this.getGeneratorBlock(), meta & 0xF);
        return this.func_176223_P().func_177226_a(this.getTypeProperty(), (Comparable)((Object)type));
    }

    public int func_176201_c(IBlockState state) {
        BlockStateGenerator.GeneratorType type = (BlockStateGenerator.GeneratorType)((Object)state.func_177229_b(this.getTypeProperty()));
        return type.meta;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        TileEntity tile = MekanismUtils.getTileEntitySafe((IBlockAccess)worldIn, (BlockPos)pos);
        if (tile instanceof TileEntityBasicBlock && ((TileEntityBasicBlock)tile).facing != null) {
            state = state.func_177226_a((IProperty)BlockStateFacing.facingProperty, (Comparable)((TileEntityBasicBlock)tile).facing);
        }
        if (tile instanceof IActiveState) {
            state = state.func_177226_a((IProperty)BlockStateGenerator.activeProperty, (Comparable)Boolean.valueOf(((IActiveState)tile).getActive()));
        }
        return state;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block neighborBlock, BlockPos neighborPos) {
        if (!world.field_72995_K) {
            TileEntity tileEntity = world.func_175625_s(pos);
            if (tileEntity instanceof IMultiblock) {
                ((IMultiblock)tileEntity).doUpdate();
            }
            if (tileEntity instanceof TileEntityBasicBlock) {
                ((TileEntityBasicBlock)tileEntity).onNeighborChange(neighborBlock);
            }
        }
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase entityliving, ItemStack itemstack) {
        TileEntityBasicBlock tileEntity = (TileEntityBasicBlock)world.func_175625_s(pos);
        int side = MathHelper.func_76128_c((double)((double)(entityliving.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        int height = Math.round(entityliving.field_70125_A);
        int change = 3;
        if (tileEntity.canSetFacing(0) && tileEntity.canSetFacing(1)) {
            if (height >= 65) {
                change = 1;
            } else if (height <= -65) {
                change = 0;
            }
        }
        if (change != 0 && change != 1) {
            switch (side) {
                case 0: {
                    change = 2;
                    break;
                }
                case 1: {
                    change = 5;
                    break;
                }
                case 2: {
                    change = 3;
                    break;
                }
                case 3: {
                    change = 4;
                }
            }
        }
        tileEntity.setFacing((short)change);
        boolean bl = tileEntity.redstone = world.func_175687_A(pos) > 0;
        if (tileEntity instanceof IBoundingBlock) {
            ((IBoundingBlock)tileEntity).onPlace();
        }
        if (!world.field_72995_K && tileEntity instanceof IMultiblock) {
            ((IMultiblock)tileEntity).doUpdate();
        }
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tileEntity;
        if (MekanismConfig.client.enableAmbientLighting && (tileEntity = MekanismUtils.getTileEntitySafe((IBlockAccess)world, (BlockPos)pos)) instanceof IActiveState && !(tileEntity instanceof TileEntitySolarGenerator) && ((IActiveState)tileEntity).getActive() && ((IActiveState)tileEntity).lightUpdate()) {
            return MekanismConfig.client.ambientLightingLevel;
        }
        return 0;
    }

    public int func_180651_a(IBlockState state) {
        return state.func_177230_c().func_176201_c(state);
    }

    public float func_180647_a(IBlockState state, EntityPlayer player, World world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        return SecurityUtils.canAccess((EntityPlayer)player, (TileEntity)tile) ? super.func_180647_a(state, player, world, pos) : 0.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item i, CreativeTabs creativetabs, NonNullList<ItemStack> list) {
        for (BlockStateGenerator.GeneratorType type : BlockStateGenerator.GeneratorType.values()) {
            if (!type.isEnabled()) continue;
            list.add((Object)new ItemStack(i, 1, type.meta));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random random) {
        BlockStateGenerator.GeneratorType type = BlockStateGenerator.GeneratorType.get(state.func_177230_c(), state.func_177230_c().func_176201_c(state));
        TileEntityBasicBlock tileEntity = (TileEntityBasicBlock)world.func_175625_s(pos);
        if (MekanismUtils.isActive((IBlockAccess)world, (BlockPos)pos)) {
            float xRandom = (float)pos.func_177958_n() + 0.5f;
            float yRandom = (float)pos.func_177956_o() + 0.0f + random.nextFloat() * 6.0f / 16.0f;
            float zRandom = (float)pos.func_177952_p() + 0.5f;
            float iRandom = 0.52f;
            float jRandom = random.nextFloat() * 0.6f - 0.3f;
            if (tileEntity.facing == EnumFacing.WEST) {
                switch (type) {
                    case HEAT_GENERATOR: {
                        world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)(xRandom + iRandom), (double)yRandom, (double)(zRandom - jRandom), 0.0, 0.0, 0.0, new int[0]);
                        world.func_175688_a(EnumParticleTypes.FLAME, (double)(xRandom + iRandom), (double)yRandom, (double)(zRandom - jRandom), 0.0, 0.0, 0.0, new int[0]);
                        break;
                    }
                    case BIO_GENERATOR: {
                        world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)pos.func_177958_n() + 0.25, (double)pos.func_177956_o() + 0.2, (double)pos.func_177952_p() + 0.5, 0.0, 0.0, 0.0, new int[0]);
                        break;
                    }
                }
            } else if (tileEntity.facing == EnumFacing.EAST) {
                switch (type) {
                    case HEAT_GENERATOR: {
                        world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)(xRandom + iRandom), (double)yRandom + 0.5, (double)(zRandom - jRandom), 0.0, 0.0, 0.0, new int[0]);
                        world.func_175688_a(EnumParticleTypes.FLAME, (double)(xRandom + iRandom), (double)yRandom + 0.5, (double)(zRandom - jRandom), 0.0, 0.0, 0.0, new int[0]);
                        break;
                    }
                    case BIO_GENERATOR: {
                        world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)pos.func_177958_n() + 0.75, (double)pos.func_177956_o() + 0.2, (double)pos.func_177952_p() + 0.5, 0.0, 0.0, 0.0, new int[0]);
                        break;
                    }
                }
            } else if (tileEntity.facing == EnumFacing.NORTH) {
                switch (type) {
                    case HEAT_GENERATOR: {
                        world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)(xRandom - jRandom), (double)yRandom + 0.5, (double)(zRandom - iRandom), 0.0, 0.0, 0.0, new int[0]);
                        world.func_175688_a(EnumParticleTypes.FLAME, (double)(xRandom - jRandom), (double)yRandom + 0.5, (double)(zRandom - iRandom), 0.0, 0.0, 0.0, new int[0]);
                        break;
                    }
                    case BIO_GENERATOR: {
                        world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.2, (double)pos.func_177952_p() + 0.25, 0.0, 0.0, 0.0, new int[0]);
                        break;
                    }
                }
            } else if (tileEntity.facing == EnumFacing.SOUTH) {
                switch (type) {
                    case HEAT_GENERATOR: {
                        world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)(xRandom - jRandom), (double)yRandom + 0.5, (double)(zRandom + iRandom), 0.0, 0.0, 0.0, new int[0]);
                        world.func_175688_a(EnumParticleTypes.FLAME, (double)(xRandom - jRandom), (double)yRandom + 0.5, (double)(zRandom + iRandom), 0.0, 0.0, 0.0, new int[0]);
                        break;
                    }
                    case BIO_GENERATOR: {
                        world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.2, (double)pos.func_177952_p() + 0.75, 0.0, 0.0, 0.0, new int[0]);
                        break;
                    }
                }
            }
        }
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        int amount;
        TileEntityBasicBlock tileEntity = (TileEntityBasicBlock)world.func_175625_s(pos);
        if (!world.field_72995_K && tileEntity instanceof TileEntityTurbineRotor && (amount = ((TileEntityTurbineRotor)tileEntity).getHousedBlades()) > 0) {
            float motion = 0.7f;
            double motionX = (double)(world.field_73012_v.nextFloat() * motion) + (double)(1.0f - motion) * 0.5;
            double motionY = (double)(world.field_73012_v.nextFloat() * motion) + (double)(1.0f - motion) * 0.5;
            double motionZ = (double)(world.field_73012_v.nextFloat() * motion) + (double)(1.0f - motion) * 0.5;
            EntityItem entityItem = new EntityItem(world, (double)pos.func_177958_n() + motionX, (double)pos.func_177956_o() + motionY, (double)pos.func_177952_p() + motionZ, new ItemStack(GeneratorsItems.TurbineBlade, amount));
            world.func_72838_d((Entity)entityItem);
        }
        if (tileEntity instanceof IBoundingBlock) {
            ((IBoundingBlock)tileEntity).onBreak();
        }
        super.func_180663_b(world, pos, state);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer entityplayer, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        TileEntityBasicBlock tileEntity = (TileEntityBasicBlock)world.func_175625_s(pos);
        int metadata = state.func_177230_c().func_176201_c(state);
        ItemStack stack = entityplayer.func_184586_b(hand);
        if (!stack.func_190926_b()) {
            Item tool = stack.func_77973_b();
            if (MekanismUtils.hasUsableWrench((EntityPlayer)entityplayer, (BlockPos)pos)) {
                if (SecurityUtils.canAccess((EntityPlayer)entityplayer, (TileEntity)tileEntity)) {
                    if (entityplayer.func_70093_af()) {
                        this.dismantleBlock(state, world, pos, false);
                        return true;
                    }
                    if (MekanismUtils.isBCWrench((Item)tool)) {
                        ((IToolWrench)tool).wrenchUsed(entityplayer, hand, stack, new RayTraceResult(new Vec3d((double)hitX, (double)hitY, (double)hitZ), side, pos));
                    }
                    int change = tileEntity.facing.func_176746_e().ordinal();
                    tileEntity.setFacing((short)change);
                    world.func_175685_c(pos, (Block)this, true);
                } else {
                    SecurityUtils.displayNoAccess((EntityPlayer)entityplayer);
                }
                return true;
            }
        }
        if (metadata == BlockStateGenerator.GeneratorType.TURBINE_CASING.meta || metadata == BlockStateGenerator.GeneratorType.TURBINE_VALVE.meta || metadata == BlockStateGenerator.GeneratorType.TURBINE_VENT.meta) {
            return ((IMultiblock)tileEntity).onActivate(entityplayer, hand, stack);
        }
        if (metadata == BlockStateGenerator.GeneratorType.TURBINE_ROTOR.meta) {
            TileEntityTurbineRotor rod = (TileEntityTurbineRotor)tileEntity;
            if (!entityplayer.func_70093_af()) {
                if (!stack.func_190926_b() && stack.func_77973_b() == GeneratorsItems.TurbineBlade) {
                    if (!world.field_72995_K && rod.editBlade(true) && !entityplayer.field_71075_bZ.field_75098_d) {
                        stack.func_190918_g(1);
                        if (stack.func_190916_E() == 0) {
                            entityplayer.func_184611_a(hand, ItemStack.field_190927_a);
                        }
                    }
                    return true;
                }
            } else {
                if (!world.field_72995_K) {
                    if (stack.func_190926_b()) {
                        if (rod.editBlade(false) && !entityplayer.field_71075_bZ.field_75098_d) {
                            entityplayer.func_184611_a(hand, new ItemStack(GeneratorsItems.TurbineBlade));
                            entityplayer.field_71071_by.func_70296_d();
                        }
                    } else if (stack.func_77973_b() == GeneratorsItems.TurbineBlade && stack.func_190916_E() < stack.func_77976_d() && rod.editBlade(false) && !entityplayer.field_71075_bZ.field_75098_d) {
                        stack.func_190917_f(1);
                        entityplayer.field_71071_by.func_70296_d();
                    }
                }
                return true;
            }
            return false;
        }
        int guiId = BlockStateGenerator.GeneratorType.get((BlockStateGenerator.GeneratorBlock)this.getGeneratorBlock(), (int)metadata).guiId;
        if (guiId != -1 && tileEntity != null && !entityplayer.func_70093_af()) {
            if (SecurityUtils.canAccess((EntityPlayer)entityplayer, (TileEntity)tileEntity)) {
                entityplayer.openGui((Object)MekanismGenerators.instance, guiId, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            } else {
                SecurityUtils.displayNoAccess((EntityPlayer)entityplayer);
            }
            return true;
        }
        return false;
    }

    public int func_149745_a(Random random) {
        return 0;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        int metadata = state.func_177230_c().func_176201_c(state);
        if (BlockStateGenerator.GeneratorType.get(this.getGeneratorBlock(), metadata) == null) {
            return null;
        }
        return BlockStateGenerator.GeneratorType.get(this.getGeneratorBlock(), metadata).create();
    }

    public Item func_180660_a(IBlockState state, Random random, int fortune) {
        return null;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return null;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        BlockStateGenerator.GeneratorType type = BlockStateGenerator.GeneratorType.get(state);
        switch (type) {
            case SOLAR_GENERATOR: {
                return SOLAR_BOUNDS;
            }
            case TURBINE_ROTOR: {
                return ROTOR_BOUNDS;
            }
        }
        return super.func_185496_a(state, world, pos);
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (!player.field_71075_bZ.field_75098_d && !world.field_72995_K && willHarvest) {
            float motion = 0.7f;
            double motionX = (double)(world.field_73012_v.nextFloat() * motion) + (double)(1.0f - motion) * 0.5;
            double motionY = (double)(world.field_73012_v.nextFloat() * motion) + (double)(1.0f - motion) * 0.5;
            double motionZ = (double)(world.field_73012_v.nextFloat() * motion) + (double)(1.0f - motion) * 0.5;
            EntityItem entityItem = new EntityItem(world, (double)pos.func_177958_n() + motionX, (double)pos.func_177956_o() + motionY, (double)pos.func_177952_p() + motionZ, this.getPickBlock(state, null, world, pos, player));
            world.func_72838_d((Entity)entityItem);
        }
        return world.func_175698_g(pos);
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        ISecurityItem securityItem;
        TileEntityBasicBlock tileEntity = (TileEntityBasicBlock)world.func_175625_s(pos);
        ItemStack itemStack = new ItemStack(GeneratorsBlocks.Generator, 1, state.func_177230_c().func_176201_c(state));
        if (itemStack.func_77978_p() == null && !(tileEntity instanceof TileEntityMultiblock)) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        if (tileEntity == null) {
            return ItemStack.field_190927_a;
        }
        if (tileEntity instanceof ISecurityTile && (securityItem = (ISecurityItem)itemStack.func_77973_b()).hasSecurity(itemStack)) {
            securityItem.setOwnerUUID(itemStack, ((ISecurityTile)tileEntity).getSecurity().getOwnerUUID());
            securityItem.setSecurity(itemStack, ((ISecurityTile)tileEntity).getSecurity().getMode());
        }
        if (tileEntity instanceof TileEntityElectricBlock) {
            IEnergizedItem electricItem = (IEnergizedItem)itemStack.func_77973_b();
            electricItem.setEnergy(itemStack, ((TileEntityElectricBlock)tileEntity).electricityStored);
        }
        if (tileEntity instanceof TileEntityContainerBlock && ((TileEntityContainerBlock)tileEntity).handleInventory()) {
            ISustainedInventory inventory = (ISustainedInventory)itemStack.func_77973_b();
            inventory.setInventory(((TileEntityContainerBlock)tileEntity).getInventory(new Object[0]), new Object[]{itemStack});
        }
        if (tileEntity instanceof ISustainedData) {
            ((ISustainedData)tileEntity).writeSustainedData(itemStack);
        }
        if (((ISustainedTank)itemStack.func_77973_b()).hasTank(new Object[]{itemStack}) && tileEntity instanceof ISustainedTank && ((ISustainedTank)tileEntity).getFluidStack(new Object[0]) != null) {
            ((ISustainedTank)itemStack.func_77973_b()).setFluidStack(((ISustainedTank)tileEntity).getFluidStack(new Object[0]), new Object[]{itemStack});
        }
        return itemStack;
    }

    public ItemStack dismantleBlock(IBlockState state, World world, BlockPos pos, boolean returnBlock) {
        ItemStack itemStack = this.getPickBlock(state, null, world, pos, null);
        world.func_175698_g(pos);
        if (!returnBlock) {
            float motion = 0.7f;
            double motionX = (double)(world.field_73012_v.nextFloat() * motion) + (double)(1.0f - motion) * 0.5;
            double motionY = (double)(world.field_73012_v.nextFloat() * motion) + (double)(1.0f - motion) * 0.5;
            double motionZ = (double)(world.field_73012_v.nextFloat() * motion) + (double)(1.0f - motion) * 0.5;
            EntityItem entityItem = new EntityItem(world, (double)pos.func_177958_n() + motionX, (double)pos.func_177956_o() + motionY, (double)pos.func_177952_p() + motionZ, itemStack);
            world.func_72838_d((Entity)entityItem);
        }
        return itemStack;
    }

    public boolean isSideSolid(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        BlockStateGenerator.GeneratorType type = BlockStateGenerator.GeneratorType.get(this.getGeneratorBlock(), state.func_177230_c().func_176201_c(state));
        return type != BlockStateGenerator.GeneratorType.SOLAR_GENERATOR && type != BlockStateGenerator.GeneratorType.ADVANCED_SOLAR_GENERATOR && type != BlockStateGenerator.GeneratorType.WIND_GENERATOR && type != BlockStateGenerator.GeneratorType.TURBINE_ROTOR;
    }

    public EnumFacing[] getValidRotations(World world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        EnumFacing[] valid = new EnumFacing[6];
        if (tile instanceof TileEntityBasicBlock) {
            TileEntityBasicBlock basicTile = (TileEntityBasicBlock)tile;
            for (EnumFacing dir : EnumFacing.field_82609_l) {
                if (!basicTile.canSetFacing(dir.ordinal())) continue;
                valid[dir.ordinal()] = dir;
            }
        }
        return valid;
    }

    public boolean rotateBlock(World world, BlockPos pos, EnumFacing axis) {
        TileEntityBasicBlock basicTile;
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityBasicBlock && (basicTile = (TileEntityBasicBlock)tile).canSetFacing(axis.ordinal())) {
            basicTile.setFacing((short)axis.ordinal());
            return true;
        }
        return false;
    }

    public PropertyEnum<BlockStateGenerator.GeneratorType> getTypeProperty() {
        return this.getGeneratorBlock().getProperty();
    }
}

