/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.client.render.item;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.vecmath.Matrix4f;
import javax.vecmath.Vector3f;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.util.MekanismUtils;
import mekanism.generators.client.model.ModelAdvancedSolarGenerator;
import mekanism.generators.client.model.ModelBioGenerator;
import mekanism.generators.client.model.ModelGasGenerator;
import mekanism.generators.client.model.ModelHeatGenerator;
import mekanism.generators.client.model.ModelSolarGenerator;
import mekanism.generators.client.model.ModelWindGenerator;
import mekanism.generators.common.block.states.BlockStateGenerator;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.client.model.IPerspectiveAwareModel;
import net.minecraftforge.common.model.TRSRTransformation;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.opengl.GL11;

public class BakedGeneratorItemModel
implements IBakedModel,
IPerspectiveAwareModel {
    private IBakedModel baseModel;
    private ItemStack stack;
    private ItemCameraTransforms.TransformType prevTransform;
    private Minecraft mc = Minecraft.func_71410_x();
    public static ModelAdvancedSolarGenerator advancedSolarGenerator = new ModelAdvancedSolarGenerator();
    public static ModelSolarGenerator solarGenerator = new ModelSolarGenerator();
    public static ModelBioGenerator bioGenerator = new ModelBioGenerator();
    public static ModelHeatGenerator heatGenerator = new ModelHeatGenerator();
    public static ModelGasGenerator gasGenerator = new ModelGasGenerator();
    public static ModelWindGenerator windGenerator = new ModelWindGenerator();
    public static Map<ItemCameraTransforms.TransformType, TRSRTransformation> transforms = ImmutableMap.builder().put((Object)ItemCameraTransforms.TransformType.GUI, (Object)BakedGeneratorItemModel.get(0.0f, 0.0f, 0.0f, 30.0f, 225.0f, 0.0f, 0.625f)).put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, (Object)BakedGeneratorItemModel.get(0.0f, 2.5f, 0.0f, 75.0f, 45.0f, 0.0f, 0.375f)).put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, (Object)BakedGeneratorItemModel.get(0.0f, 2.5f, 0.0f, 75.0f, 45.0f, 0.0f, 0.375f)).put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, (Object)BakedGeneratorItemModel.get(0.0f, 0.0f, 0.0f, 0.0f, 45.0f, 0.0f, 0.4f)).put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, (Object)BakedGeneratorItemModel.get(0.0f, 0.0f, 0.0f, 0.0f, 225.0f, 0.0f, 0.4f)).put((Object)ItemCameraTransforms.TransformType.GROUND, (Object)BakedGeneratorItemModel.get(0.0f, 2.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.25f)).put((Object)ItemCameraTransforms.TransformType.HEAD, (Object)BakedGeneratorItemModel.get(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f)).put((Object)ItemCameraTransforms.TransformType.FIXED, (Object)BakedGeneratorItemModel.get(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f)).put((Object)ItemCameraTransforms.TransformType.NONE, (Object)BakedGeneratorItemModel.get(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f)).build();

    public BakedGeneratorItemModel(IBakedModel model, ItemStack s) {
        this.baseModel = model;
        this.stack = s;
    }

    private void doRender(ItemCameraTransforms.TransformType type) {
        BlockStateGenerator.GeneratorType generatorType = BlockStateGenerator.GeneratorType.get(this.stack);
        if (generatorType != null) {
            if (generatorType == BlockStateGenerator.GeneratorType.BIO_GENERATOR) {
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glTranslated((double)0.0, (double)-1.0, (double)0.0);
                this.mc.field_71446_o.func_110577_a(MekanismUtils.getResource((MekanismUtils.ResourceType)MekanismUtils.ResourceType.RENDER, (String)"BioGenerator.png"));
                bioGenerator.render(0.0625f);
            } else if (generatorType == BlockStateGenerator.GeneratorType.ADVANCED_SOLAR_GENERATOR) {
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179109_b((float)0.0f, (float)0.2f, (float)0.0f);
                this.mc.field_71446_o.func_110577_a(MekanismUtils.getResource((MekanismUtils.ResourceType)MekanismUtils.ResourceType.RENDER, (String)"AdvancedSolarGenerator.png"));
                advancedSolarGenerator.render(0.022f);
            } else if (generatorType == BlockStateGenerator.GeneratorType.SOLAR_GENERATOR) {
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)-1.0f, (float)0.0f);
                GL11.glTranslated((double)0.0, (double)-1.0, (double)0.0);
                this.mc.field_71446_o.func_110577_a(MekanismUtils.getResource((MekanismUtils.ResourceType)MekanismUtils.ResourceType.RENDER, (String)"SolarGenerator.png"));
                solarGenerator.render(0.0625f);
            } else if (generatorType == BlockStateGenerator.GeneratorType.HEAT_GENERATOR) {
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glTranslated((double)0.0, (double)-1.0, (double)0.0);
                this.mc.field_71446_o.func_110577_a(MekanismUtils.getResource((MekanismUtils.ResourceType)MekanismUtils.ResourceType.RENDER, (String)"HeatGenerator.png"));
                heatGenerator.render(0.0625f, false, this.mc.field_71446_o);
            } else if (generatorType == BlockStateGenerator.GeneratorType.GAS_GENERATOR) {
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179114_b((float)90.0f, (float)-1.0f, (float)0.0f, (float)0.0f);
                GL11.glTranslated((double)0.0, (double)-1.0, (double)0.0);
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                this.mc.field_71446_o.func_110577_a(MekanismUtils.getResource((MekanismUtils.ResourceType)MekanismUtils.ResourceType.RENDER, (String)"GasGenerator.png"));
                gasGenerator.render(0.0625f);
            } else if (generatorType == BlockStateGenerator.GeneratorType.WIND_GENERATOR) {
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179109_b((float)0.0f, (float)0.4f, (float)0.0f);
                this.mc.field_71446_o.func_110577_a(MekanismUtils.getResource((MekanismUtils.ResourceType)MekanismUtils.ResourceType.RENDER, (String)"WindGenerator.png"));
                windGenerator.render(0.016f, 0.0);
            }
            return;
        }
    }

    public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
        if (side != null) {
            return ImmutableList.of();
        }
        Tessellator tessellator = Tessellator.func_178181_a();
        Object prevFormat = null;
        MekanismRenderer.pauseRenderer((Tessellator)tessellator);
        LinkedList<BakedQuad> generalQuads = new LinkedList<BakedQuad>();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.5f, (float)0.5f, (float)0.5f);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        this.doRender(this.prevTransform);
        GlStateManager.func_179145_e();
        GlStateManager.func_179085_a((int)0);
        GlStateManager.func_179085_a((int)1);
        GlStateManager.func_179142_g();
        GlStateManager.func_179104_a((int)1032, (int)5634);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
        GlStateManager.func_179121_F();
        MekanismRenderer.resumeRenderer((Tessellator)tessellator);
        if (Block.func_149634_a((Item)this.stack.func_77973_b()) != null) {
            generalQuads.addAll(this.baseModel.func_188616_a(state, side, rand));
        }
        return generalQuads;
    }

    public boolean func_177555_b() {
        return this.baseModel.func_177555_b();
    }

    public boolean func_177556_c() {
        return this.baseModel.func_177556_c();
    }

    public boolean func_188618_c() {
        return this.baseModel.func_188618_c();
    }

    public TextureAtlasSprite func_177554_e() {
        return this.baseModel.func_177554_e();
    }

    public ItemCameraTransforms func_177552_f() {
        return this.baseModel.func_177552_f();
    }

    public Pair<? extends IPerspectiveAwareModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
        this.prevTransform = cameraTransformType;
        return Pair.of((Object)this, (Object)transforms.get(cameraTransformType).getMatrix());
    }

    private static TRSRTransformation get(float tx, float ty, float tz, float ax, float ay, float az, float s) {
        return new TRSRTransformation(new Vector3f(tx / 16.0f, ty / 16.0f, tz / 16.0f), TRSRTransformation.quatFromXYZDegrees((Vector3f)new Vector3f(ax, ay, az)), new Vector3f(s, s, s), null);
    }

    public ItemOverrideList func_188617_f() {
        return ItemOverrideList.field_188022_a;
    }
}

