/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.webprefs;

import com.mojang.authlib.GameProfile;
import com.mojang.realmsclient.dto.RealmsServer;
import com.mumfrey.liteloader.JoinGameListener;
import com.mumfrey.liteloader.Tickable;
import com.mumfrey.liteloader.core.LiteLoader;
import com.mumfrey.webprefs.AbstractWebPreferences;
import com.mumfrey.webprefs.DummyOfflineWebPreferences;
import com.mumfrey.webprefs.OfflineWebPreferences;
import com.mumfrey.webprefs.WebPreferences;
import com.mumfrey.webprefs.exceptions.InvalidServiceException;
import com.mumfrey.webprefs.exceptions.InvalidUUIDException;
import com.mumfrey.webprefs.framework.WebPreferencesProvider;
import com.mumfrey.webprefs.interfaces.IWebPreferences;
import com.mumfrey.webprefs.interfaces.IWebPreferencesProvider;
import java.io.File;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class WebPreferencesManager {
    private static final String DEFAULT_HOSTNAME = "kv.liteloader.com";
    private static final Pattern uuidPattern = Pattern.compile("^[a-f0-9]{32}$");
    static final Map<String, WebPreferencesManager> managers = new LinkedHashMap<String, WebPreferencesManager>();
    private static WebPreferencesUpdateDeamon updateDeamon;
    private final bez session;
    private final WebPreferencesProvider provider;
    private final List<AbstractWebPreferences> allPreferences = new LinkedList<AbstractWebPreferences>();
    private final Map<String, IWebPreferences> preferencesPublic = new HashMap<String, IWebPreferences>();
    private final Map<String, IWebPreferences> preferencesPrivate = new HashMap<String, IWebPreferences>();

    private WebPreferencesManager(Proxy proxy, bez session, String hostName) {
        this.session = session;
        this.provider = new WebPreferencesProvider(proxy, session, hostName, 50);
    }

    void onTick() {
        this.provider.onTick();
        for (AbstractWebPreferences prefs : this.allPreferences) {
            try {
                prefs.onTick();
            }
            catch (Exception exception) {}
        }
    }

    void onJoinGame() {
        for (AbstractWebPreferences prefs : this.allPreferences) {
            try {
                prefs.poll();
            }
            catch (Exception exception) {}
        }
    }

    public IWebPreferences getLocalPreferences(boolean privatePrefs) {
        try {
            return this.getPreferences(this.session.b(), privatePrefs);
        }
        catch (InvalidUUIDException ex) {
            UUID offlineUUID = aay.d((String)this.session.c());
            return this.getOfflinePreferences(offlineUUID, privatePrefs, false, false);
        }
    }

    public IWebPreferences getPreferences(aay player) {
        try {
            return this.getPreferences(player, false);
        }
        catch (InvalidUUIDException ex) {
            String playerName = player.h_();
            UUID offlineUUID = aay.d((String)playerName);
            return this.getOfflinePreferences(offlineUUID, false, false, !playerName.equals(this.session.c()));
        }
    }

    public IWebPreferences getPreferences(aay player, boolean privatePrefs) {
        GameProfile gameProfile = player.cS();
        return gameProfile != null ? this.getPreferences(gameProfile, privatePrefs) : null;
    }

    public IWebPreferences getPreferences(GameProfile gameProfile) {
        return gameProfile != null ? this.getPreferences(gameProfile, false) : null;
    }

    public IWebPreferences getPreferences(GameProfile gameProfile, boolean privatePrefs) {
        return gameProfile != null ? this.getPreferences(gameProfile.getId(), privatePrefs) : null;
    }

    public IWebPreferences getPreferences(UUID uuid) {
        return uuid != null ? this.getPreferences(uuid, false) : null;
    }

    public IWebPreferences getPreferences(UUID uuid, boolean privatePrefs) {
        return uuid != null ? this.getPreferences(uuid.toString(), privatePrefs) : null;
    }

    public IWebPreferences getPreferences(String uuid, boolean privatePrefs) {
        Map<String, IWebPreferences> preferences = privatePrefs ? this.preferencesPrivate : this.preferencesPublic;
        IWebPreferences prefs = preferences.get(uuid = this.sanitiseUUID(uuid));
        if (prefs == null) {
            WebPreferences newPrefs = new WebPreferences((IWebPreferencesProvider)this.provider, uuid, privatePrefs, !uuid.equals(this.session.b()));
            this.allPreferences.add(newPrefs);
            preferences.put(uuid, newPrefs);
            prefs = newPrefs;
        }
        return prefs;
    }

    private IWebPreferences getOfflinePreferences(UUID uuid, boolean privatePrefs, boolean readOnly, boolean dummy) {
        Map<String, IWebPreferences> preferences = privatePrefs ? this.preferencesPrivate : this.preferencesPublic;
        IWebPreferences prefs = preferences.get(uuid);
        if (prefs == null) {
            DummyOfflineWebPreferences newPrefs = dummy ? new DummyOfflineWebPreferences(uuid, privatePrefs, readOnly) : new OfflineWebPreferences(uuid, privatePrefs, readOnly);
            this.allPreferences.add(newPrefs);
            preferences.put(uuid.toString(), newPrefs);
            prefs = newPrefs;
        }
        return prefs;
    }

    private String sanitiseUUID(String uuid) {
        if (uuid == null) {
            throw new InvalidUUIDException("The UUID was null");
        }
        Matcher uuidPatternMatcher = uuidPattern.matcher(uuid = uuid.toLowerCase().replace("-", "").trim());
        if (!uuidPatternMatcher.matches()) {
            throw new InvalidUUIDException("The specified string [" + uuid + "] is not a valid UUID");
        }
        return uuid;
    }

    public static WebPreferencesManager getDefault() {
        return WebPreferencesManager.get(DEFAULT_HOSTNAME);
    }

    public static WebPreferencesManager get(String hostName) throws InvalidServiceException {
        WebPreferencesManager manager;
        try {
            new URI(String.format("http://%s/", hostName));
        }
        catch (URISyntaxException ex) {
            throw new InvalidServiceException("The specified service host was not valid: " + hostName, ex);
        }
        if (updateDeamon == null) {
            updateDeamon = new WebPreferencesUpdateDeamon();
            LiteLoader.getInterfaceManager().registerListener(updateDeamon);
        }
        if ((manager = managers.get(hostName)) == null) {
            bes minecraft = bes.z();
            Proxy proxy = minecraft.M();
            bez session = minecraft.K();
            manager = new WebPreferencesManager(proxy, session, hostName);
            managers.put(hostName, manager);
        }
        return manager;
    }

    static class WebPreferencesUpdateDeamon
    implements Tickable,
    JoinGameListener {
        WebPreferencesUpdateDeamon() {
        }

        @Override
        public String getName() {
            return "Web Preferences Update Daemon";
        }

        @Override
        public String getVersion() {
            return "N/A";
        }

        @Override
        public void init(File configPath) {
        }

        @Override
        public void upgradeSettings(String version, File configPath, File oldConfigPath) {
        }

        @Override
        public void onTick(bes minecraft, float partialTicks, boolean inGame, boolean clock) {
            if (clock) {
                for (WebPreferencesManager manager : managers.values()) {
                    manager.onTick();
                }
            }
        }

        @Override
        public void onJoinGame(ew netHandler, gz joinGamePacket, bnt serverData, RealmsServer realmsServer) {
            for (WebPreferencesManager manager : managers.values()) {
                manager.onJoinGame();
            }
        }
    }
}

