/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.util;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.List;

public abstract class EntityUtilities {
    static final Predicate<sn> TRACEABLE = Predicates.and((Predicate)sr.e, (Predicate)new Predicate<sn>(){

        public boolean apply(sn entity) {
            return entity != null && entity.aq();
        }
    });

    public static bdu rayTraceFromEntity(sn source, double traceDistance, float partialTicks, boolean includeEntities) {
        bdu blockRay = EntityUtilities.rayTraceFromEntity(source, traceDistance, partialTicks);
        if (!includeEntities) {
            return blockRay;
        }
        bdw traceStart = EntityUtilities.getPositionEyes(source, partialTicks);
        double blockDistance = blockRay != null ? blockRay.c.f(traceStart) : traceDistance;
        EntityTrace entityRay = EntityUtilities.rayTraceEntities(source, traceDistance, partialTicks, blockDistance, traceStart);
        if (entityRay.entity != null && (entityRay.distance < blockDistance || blockRay == null)) {
            return entityRay.asRayTraceResult();
        }
        return blockRay;
    }

    private static EntityTrace rayTraceEntities(sn source, double traceDistance, float partialTicks, double blockDistance, bdw traceStart) {
        EntityTrace trace = new EntityTrace(blockDistance);
        bdw lookDir = source.f(partialTicks).a(traceDistance);
        bdw traceEnd = traceStart.e(lookDir);
        for (sn entity : EntityUtilities.getTraceEntities(source, traceDistance, lookDir, TRACEABLE)) {
            double distanceToEntity;
            bdt entityBB = entity.bo().g((double)entity.aA());
            bdu entityRay = entityBB.b(traceStart, traceEnd);
            if (entityBB.b(traceStart)) {
                if (!(trace.distance >= 0.0)) continue;
                trace.entity = entity;
                trace.location = entityRay == null ? traceStart : entityRay.c;
                trace.distance = 0.0;
                continue;
            }
            if (entityRay == null || !((distanceToEntity = traceStart.f(entityRay.c)) < trace.distance) && trace.distance != 0.0) continue;
            if (entity.bz() == source.bz()) {
                if (trace.distance != 0.0) continue;
                trace.entity = entity;
                trace.location = entityRay.c;
                continue;
            }
            trace.entity = entity;
            trace.location = entityRay.c;
            trace.distance = distanceToEntity;
        }
        return trace;
    }

    private static List<sn> getTraceEntities(sn source, double traceDistance, bdw dir, Predicate<sn> filter) {
        bdt boundingBox = source.bo();
        bdt traceBox = boundingBox.b(dir.b, dir.c, dir.d);
        List entities = source.l.a(source, traceBox.c(1.0, 1.0, 1.0), filter);
        return entities;
    }

    public static bdu rayTraceFromEntity(sn source, double traceDistance, float partialTicks) {
        bdw traceStart = EntityUtilities.getPositionEyes(source, partialTicks);
        bdw lookDir = source.f(partialTicks).a(traceDistance);
        bdw traceEnd = traceStart.e(lookDir);
        return source.l.a(traceStart, traceEnd, false, false, true);
    }

    public static bdw getPositionEyes(sn entity, float partialTicks) {
        if (partialTicks == 1.0f) {
            return new bdw(entity.p, entity.q + (double)entity.bq(), entity.r);
        }
        double interpX = entity.m + (entity.p - entity.m) * (double)partialTicks;
        double interpY = entity.n + (entity.q - entity.n) * (double)partialTicks + (double)entity.bq();
        double interpZ = entity.o + (entity.r - entity.o) * (double)partialTicks;
        return new bdw(interpX, interpY, interpZ);
    }

    static final class EntityTrace {
        sn entity;
        bdw location;
        double distance;

        EntityTrace(double entityDistance) {
            this.distance = entityDistance;
        }

        bdu asRayTraceResult() {
            return new bdu(this.entity, this.location);
        }
    }
}

