/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.transformers.event.json;

import com.mumfrey.liteloader.transformers.ObfProvider;
import com.mumfrey.liteloader.transformers.event.Event;
import com.mumfrey.liteloader.transformers.event.EventInjectionTransformer;
import com.mumfrey.liteloader.transformers.event.InjectionPoint;
import com.mumfrey.liteloader.transformers.event.MethodInfo;
import com.mumfrey.liteloader.transformers.event.json.InvalidEventJsonException;
import com.mumfrey.liteloader.transformers.event.json.JsonEvents;
import com.mumfrey.liteloader.transformers.event.json.ModEvents;
import com.mumfrey.liteloader.util.log.LiteLoaderLogger;

public class ModEventInjectionTransformer
extends EventInjectionTransformer {
    @Override
    protected void addEvents() {
        for (ModEvents.ModEventDefinition eventsDefinition : ModEvents.getEvents().values()) {
            this.addEvents(eventsDefinition);
        }
    }

    private void addEvents(ModEvents.ModEventDefinition def) {
        JsonEvents events = null;
        try {
            LiteLoaderLogger.info("Parsing events for mod with id %s", def.getIdentifier());
            events = JsonEvents.parse(def.getJson());
        }
        catch (InvalidEventJsonException ex) {
            LiteLoaderLogger.debug("----------------------------------------------------------------------------------------------------", new Object[0]);
            LiteLoaderLogger.debug(ex.getMessage(), new Object[0]);
            LiteLoaderLogger.debug("----------------------------------------------------------------------------------------------------", new Object[0]);
            LiteLoaderLogger.debug(def.getJson(), new Object[0]);
            LiteLoaderLogger.debug("----------------------------------------------------------------------------------------------------", new Object[0]);
            LiteLoaderLogger.severe(ex, "Invalid JSON event declarations for mod with id %s", def.getIdentifier());
        }
        catch (Throwable ex) {
            LiteLoaderLogger.severe(ex, "Error whilst parsing event declarations for mod with id %s", def.getIdentifier());
        }
        try {
            if (events != null) {
                if (events.hasAccessors()) {
                    LiteLoaderLogger.info("%s contains Accessor definitions, injecting into classpath...", def.getIdentifier());
                    def.injectIntoClassPath();
                }
                LiteLoaderLogger.info(LiteLoaderLogger.Verbosity.REDUCED, "Registering events for mod with id %s", def.getIdentifier());
                events.register(this);
                def.onEventsInjected();
            }
        }
        catch (Throwable ex) {
            LiteLoaderLogger.severe(ex, "Error whilst parsing event declarations for mod with id %s", def.getIdentifier());
        }
    }

    protected Event registerEvent(Event event, MethodInfo targetMethod, InjectionPoint injectionPoint) {
        return super.addEvent(event, targetMethod, injectionPoint);
    }

    protected void registerAccessor(String interfaceName, ObfProvider obfProvider) {
        super.addAccessor(interfaceName, obfProvider);
    }
}

