/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.transformers.event.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.SerializedName;
import com.mumfrey.liteloader.core.runtime.Obf;
import com.mumfrey.liteloader.transformers.ObfProvider;
import com.mumfrey.liteloader.transformers.event.json.InvalidEventJsonException;
import com.mumfrey.liteloader.transformers.event.json.JsonDescriptor;
import com.mumfrey.liteloader.transformers.event.json.JsonEvent;
import com.mumfrey.liteloader.transformers.event.json.JsonMethods;
import com.mumfrey.liteloader.transformers.event.json.JsonObfuscationTable;
import com.mumfrey.liteloader.transformers.event.json.ModEventInjectionTransformer;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JsonEvents
implements Serializable,
ObfProvider {
    private static final long serialVersionUID = 1L;
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private static final Pattern tokenPattern = Pattern.compile("^\\$\\{([a-zA-Z0-9_\\-\\.\\$]+)\\}$");
    @SerializedName(value="obfuscation")
    private JsonObfuscationTable obfuscation;
    @SerializedName(value="descriptors")
    private List<JsonDescriptor> descriptors;
    @SerializedName(value="events")
    private List<JsonEvent> events;
    @SerializedName(value="accessors")
    private List<String> accessors;
    private transient JsonMethods methods;
    private transient List<String> accessorInterfaces = new ArrayList<String>();

    private void parse() {
        if (this.obfuscation == null) {
            this.obfuscation = new JsonObfuscationTable();
        }
        try {
            this.obfuscation.parse();
            this.methods = new JsonMethods(this.obfuscation, this.descriptors);
            if (this.events != null) {
                for (JsonEvent event : this.events) {
                    event.parse(this.methods);
                }
            }
            if (this.accessors != null) {
                for (String accessor : this.accessors) {
                    if (accessor == null) continue;
                    Obf accessorName = this.obfuscation.parseClass(accessor);
                    this.accessorInterfaces.add(accessorName.name);
                }
            }
        }
        catch (InvalidEventJsonException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new InvalidEventJsonException("An error occurred whilst parsing the event definition: " + ex.getClass().getSimpleName() + ": " + ex.getMessage(), ex);
        }
    }

    public boolean hasAccessors() {
        return this.accessorInterfaces.size() > 0;
    }

    static String parseToken(String token) {
        Matcher tokenPatternMatcher = tokenPattern.matcher(token = token.replace(" ", "").trim());
        if (tokenPatternMatcher.matches()) {
            return tokenPatternMatcher.group(1);
        }
        return null;
    }

    public void register(ModEventInjectionTransformer transformer) {
        for (JsonEvent event : this.events) {
            event.register(transformer);
        }
        for (String interfaceName : this.accessorInterfaces) {
            transformer.registerAccessor(interfaceName, this);
        }
    }

    @Override
    public Obf getByName(String name) {
        return this.obfuscation.getByName(name);
    }

    public static JsonEvents parse(String json) throws InvalidEventJsonException {
        try {
            JsonEvents newJsonEvents = (JsonEvents)gson.fromJson(json, JsonEvents.class);
            newJsonEvents.parse();
            return newJsonEvents;
        }
        catch (InvalidEventJsonException ex) {
            throw ex;
        }
        catch (Throwable th) {
            throw new InvalidEventJsonException("An error occurred whilst parsing the event definition: " + th.getClass().getSimpleName() + ": " + th.getMessage(), th);
        }
    }
}

