/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.modconfig;

import com.mumfrey.liteloader.client.gui.GuiLiteLoaderPanel;
import com.mumfrey.liteloader.client.mixin.IGuiButton;
import com.mumfrey.liteloader.modconfig.ConfigPanel;
import com.mumfrey.liteloader.modconfig.ConfigPanelHost;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public abstract class AbstractConfigPanel
implements ConfigPanel {
    protected final bes mc;
    private final List<ConfigOption> options = new ArrayList<ConfigOption>();
    private final List<GuiConfigTextField> textFields = new ArrayList<GuiConfigTextField>();
    private int contentHeight = 0;
    private ConfigOption selected;

    public AbstractConfigPanel() {
        this.mc = bes.z();
    }

    @Override
    public int getContentHeight() {
        return this.contentHeight;
    }

    @Override
    public final void onPanelShown(ConfigPanelHost host) {
        this.clearOptions();
        this.addOptions(host);
    }

    protected abstract void addOptions(ConfigPanelHost var1);

    protected void clearOptions() {
        this.options.clear();
        this.contentHeight = 0;
    }

    protected void addLabel(int id, int x, int y, int width, int height, int colour, String ... lines) {
        if (lines == null || lines.length < 1) {
            return;
        }
        bfs label = new bfs(this.mc.k, id, x, y, width, height, colour);
        for (String line : lines) {
            label.a(line);
        }
        this.contentHeight = Math.max(y + height, this.contentHeight);
        this.options.add(new ConfigOptionLabel(label));
    }

    protected <T extends bfm> T addControl(T control, ConfigOptionListener<T> listener) {
        if (control != null) {
            this.contentHeight = Math.max(control.i + ((IGuiButton)control).getButtonHeight(), this.contentHeight);
            this.options.add(new ConfigOptionButton<T>(control, listener));
        }
        return control;
    }

    protected ConfigTextField addTextField(int id, int x, int y, int width, int height) {
        GuiConfigTextField textField = new GuiConfigTextField(id, this.mc.k, x + 2, y, width, height);
        this.textFields.add(textField);
        ConfigOptionTextField configOption = new ConfigOptionTextField(this.textFields, textField);
        this.options.add(configOption);
        return configOption;
    }

    @Override
    public void onPanelResize(ConfigPanelHost host) {
    }

    @Override
    public void onTick(ConfigPanelHost host) {
        for (ConfigOption configOption : this.options) {
            configOption.onTick();
        }
    }

    @Override
    public void drawPanel(ConfigPanelHost host, int mouseX, int mouseY, float partialTicks) {
        for (ConfigOption configOption : this.options) {
            configOption.draw(this.mc, mouseX, mouseY, partialTicks);
        }
    }

    @Override
    public void mousePressed(ConfigPanelHost host, int mouseX, int mouseY, int mouseButton) {
        this.selected = null;
        if (mouseButton != 0) {
            return;
        }
        for (ConfigOption configOption : this.options) {
            if (!configOption.mousePressed(this.mc, mouseX, mouseY)) continue;
            this.selected = configOption;
        }
    }

    @Override
    public void mouseReleased(ConfigPanelHost host, int mouseX, int mouseY, int mouseButton) {
        if (this.selected != null && mouseButton == 0) {
            this.selected.mouseReleased(this.mc, mouseX, mouseY);
        }
        this.selected = null;
    }

    @Override
    public void mouseMoved(ConfigPanelHost host, int mouseX, int mouseY) {
    }

    @Override
    public void keyPressed(ConfigPanelHost host, char keyChar, int keyCode) {
        if (keyCode == 1) {
            host.close();
            return;
        }
        for (ConfigOption configOption : this.options) {
            if (configOption.keyPressed(this.mc, keyChar, keyCode)) break;
        }
    }

    protected final void drawHoveringText(String text, int x, int y) {
        if (this.mc.m != null) {
            GuiLiteLoaderPanel.drawTooltip(this.mc.k, text, x, y, Integer.MAX_VALUE, Integer.MAX_VALUE, -43691, -1342177280);
            beq.a();
        }
    }

    class GuiConfigTextField
    extends bfq {
        private final bfg fontRenderer;
        private final int width;
        private final int height;
        private Pattern regex;
        private boolean valid;
        private boolean drawing;

        GuiConfigTextField(int id, bfg fontRenderer, int x, int y, int width, int height) {
            super(id, fontRenderer, x, y, width, height);
            this.fontRenderer = fontRenderer;
            this.width = width;
            this.height = height;
            this.setRegex(null, false);
        }

        void setRegex(Pattern regex, boolean restrict) {
            if (restrict && regex != null) {
                this.a(text -> regex.matcher((CharSequence)text).matches());
                this.regex = null;
            } else {
                this.a(text -> {
                    this.validate((String)text);
                    return true;
                });
                this.regex = regex;
                this.validate(this.b());
            }
        }

        private boolean validate(String text) {
            this.valid = this.regex == null || this.regex.matcher(text).matches();
            return true;
        }

        boolean isValid() {
            return this.valid;
        }

        public boolean j() {
            boolean bg = super.j();
            if (bg && this.drawing && !this.isValid()) {
                GuiConfigTextField.a((int)(this.a - 1), (int)(this.f - 1), (int)(this.a + this.width + 1), (int)(this.f + this.height + 1), (int)-43691);
                GuiConfigTextField.a((int)this.a, (int)this.f, (int)(this.a + this.width), (int)(this.f + this.height), (int)-16777216);
                return false;
            }
            return bg;
        }

        public void drawTextBox(int mouseX, int mouseY) {
            this.drawing = true;
            super.g();
            if (!this.isValid()) {
                GuiConfigTextField.a((int)(this.a + this.width - 10), (int)this.f, (int)(this.a + this.width), (int)(this.f + this.height), (int)0x66000000);
                this.fontRenderer.a("\u00a7l!", this.a + this.width - 6, this.f + this.height / 2 - 4, -43691);
                if (mouseX >= this.a && mouseX < this.a + this.width && mouseY >= this.f && mouseY < this.f + this.height) {
                    AbstractConfigPanel.this.drawHoveringText(cah.a((String)"gui.invalidvalue", (Object[])new Object[0]), mouseX, mouseY);
                }
            }
            this.drawing = false;
        }
    }

    class ConfigOptionTextField
    extends ConfigOption
    implements ConfigTextField {
        private final List<GuiConfigTextField> tabOrder;
        private final int tabIndex;
        private final GuiConfigTextField textField;

        ConfigOptionTextField(List<GuiConfigTextField> tabOrder, GuiConfigTextField textField) {
            this.tabOrder = tabOrder;
            this.tabIndex = tabOrder.indexOf((Object)textField);
            this.textField = textField;
            if (this.tabIndex == 0) {
                textField.b(true);
            }
        }

        @Override
        void onTick() {
            this.textField.a();
        }

        @Override
        void draw(bes minecraft, int mouseX, int mouseY, float partialTicks) {
            this.textField.drawTextBox(mouseX, mouseY);
        }

        @Override
        boolean mousePressed(bes minecraft, int mouseX, int mouseY) {
            this.textField.a(mouseX, mouseY, 0);
            if (this.textField.m()) {
                for (bfq bfq2 : this.tabOrder) {
                    if (bfq2 == this.textField) continue;
                    bfq2.b(false);
                }
            }
            return false;
        }

        @Override
        boolean keyPressed(bes minecraft, char keyChar, int keyCode) {
            if (!this.textField.m()) {
                return false;
            }
            if (keyCode == 15) {
                this.textField.b(false);
                int tabOrderSize = this.tabOrder.size();
                this.tabOrder.get((this.tabIndex + (bho.r() ? -1 : 1) + tabOrderSize) % tabOrderSize).b(true);
                return true;
            }
            return this.textField.a(keyChar, keyCode);
        }

        @Override
        public bfq getNativeTextField() {
            return this.textField;
        }

        @Override
        public String getText() {
            return this.textField.b();
        }

        @Override
        public ConfigTextField setText(String text) {
            this.textField.a(text);
            return this;
        }

        @Override
        public ConfigTextField setMaxLength(int maxLength) {
            this.textField.f(maxLength);
            return this;
        }

        @Override
        public ConfigTextField setRegex(String regex, boolean force) {
            this.textField.setRegex(Pattern.compile(regex), force);
            return this;
        }

        @Override
        public boolean isValid() {
            return this.textField.isValid();
        }
    }

    static class ConfigOptionButton<T extends bfm>
    extends ConfigOption {
        private final T control;
        private final ConfigOptionListener<T> listener;

        ConfigOptionButton(T control, ConfigOptionListener<T> listener) {
            this.control = control;
            this.listener = listener;
        }

        @Override
        void draw(bes minecraft, int mouseX, int mouseY, float partialTicks) {
            this.control.a(minecraft, mouseX, mouseY);
        }

        @Override
        boolean mousePressed(bes minecraft, int mouseX, int mouseY) {
            if (this.control.c(minecraft, mouseX, mouseY)) {
                this.control.a(minecraft.U());
                if (this.listener != null) {
                    this.listener.actionPerformed(this.control);
                }
                return true;
            }
            return false;
        }

        @Override
        void mouseReleased(bes minecraft, int mouseX, int mouseY) {
            this.control.a(mouseX, mouseY);
        }
    }

    static class ConfigOptionLabel
    extends ConfigOption {
        private final bfs label;

        ConfigOptionLabel(bfs label) {
            this.label = label;
        }

        @Override
        void draw(bes minecraft, int mouseX, int mouseY, float partialTicks) {
            this.label.a(minecraft, mouseX, mouseY);
        }
    }

    static abstract class ConfigOption {
        ConfigOption() {
        }

        void onTick() {
        }

        abstract void draw(bes var1, int var2, int var3, float var4);

        void mouseReleased(bes minecraft, int mouseX, int mouseY) {
        }

        boolean mousePressed(bes minecraft, int mouseX, int mouseY) {
            return false;
        }

        boolean keyPressed(bes minecraft, char keyChar, int keyCode) {
            return false;
        }
    }

    public static interface ConfigTextField {
        public bfq getNativeTextField();

        public String getText();

        public ConfigTextField setText(String var1);

        public ConfigTextField setRegex(String var1, boolean var2);

        public boolean isValid();

        public ConfigTextField setMaxLength(int var1);
    }

    public static interface ConfigOptionListener<T extends bfm> {
        public void actionPerformed(T var1);
    }
}

