/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.interfaces;

import com.google.common.io.Files;
import com.google.common.primitives.Ints;
import com.mumfrey.liteloader.core.api.LoadableModFile;
import com.mumfrey.liteloader.interfaces.TweakContainer;
import com.mumfrey.liteloader.launch.ClassPathUtilities;
import com.mumfrey.liteloader.launch.InjectionStrategy;
import com.mumfrey.liteloader.launch.LiteLoaderTweaker;
import com.mumfrey.liteloader.launch.LoaderEnvironment;
import com.mumfrey.liteloader.util.log.LiteLoaderLogger;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraft.launchwrapper.LaunchClassLoader;

public class LoadableFile
extends File
implements TweakContainer<File> {
    public static final String MFATT_MODTYPE = "ModType";
    public static final String MFATT_TWEAK_CLASS = "TweakClass";
    public static final String MFATT_CLASS_PATH = "Class-Path";
    public static final String MFATT_TWEAK_ORDER = "TweakOrder";
    public static final String MFATT_IMPLEMENTATION_TITLE = "Implementation-Title";
    public static final String MFATT_TWEAK_NAME = "TweakName";
    public static final String MFATT_IMPLEMENTATION_VERSION = "Implementation-Version";
    public static final String MFATT_TWEAK_VERSION = "TweakVersion";
    public static final String MFATT_IMPLEMENTATION_VENDOR = "Implementation-Vendor";
    public static final String MFATT_TWEAK_AUTHOR = "TweakAuthor";
    public static final String MFATT_MIXIN_CONFIGS = "MixinConfigs";
    public static final String MFATT_INJECTION_STRATEGY = "TweakInjectionStrategy";
    private static final Pattern versionPattern = Pattern.compile("([0-9]+\\.)+[0-9]+([_A-Z0-9]+)?");
    private static final long serialVersionUID = 1L;
    protected boolean injected;
    protected boolean forceInjection;
    protected InjectionStrategy injectionStrategy = null;
    protected Set<String> modSystems = new HashSet<String>();
    protected String tweakClassName;
    protected int tweakPriority = 1000;
    protected String[] classPathEntries = null;
    protected String displayName;
    protected String version = "Unknown";
    protected String author = "Unknown";
    protected boolean hasEventTransformers;
    protected Set<String> mixinConfigs = new HashSet<String>();

    public LoadableFile(File parent) {
        super(parent.getAbsolutePath());
        this.displayName = this.getName();
        this.guessVersionFromName();
        this.readJarMetaData();
    }

    protected LoadableFile(LoadableFile file) {
        super(file.getAbsolutePath());
        this.displayName = this.getName();
        this.forceInjection = file.forceInjection;
        this.assignJarMetaData(file);
    }

    protected LoadableFile(String pathname) {
        super(pathname);
        this.displayName = this.getName();
        this.readJarMetaData();
    }

    private void guessVersionFromName() {
        Matcher versionPatternMatcher = versionPattern.matcher(this.getName());
        while (versionPatternMatcher.find()) {
            this.version = versionPatternMatcher.group();
        }
    }

    protected void assignJarMetaData(LoadableFile file) {
        this.modSystems = file.modSystems;
        this.tweakClassName = file.tweakClassName;
        this.classPathEntries = file.classPathEntries;
        this.tweakPriority = file.tweakPriority;
        this.displayName = file.displayName;
        this.version = file.version;
        this.author = file.author;
        this.injectionStrategy = file.injectionStrategy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readJarMetaData() {
        JarFile jar = null;
        if (this.isDirectory()) {
            return;
        }
        try {
            jar = new JarFile(this);
            if (jar.getManifest() != null) {
                Integer tweakOrder;
                LiteLoaderLogger.info("Inspecting jar metadata in '%s'", this.getName());
                Attributes mfAttributes = jar.getManifest().getMainAttributes();
                String mfAttmodSystemList = mfAttributes.getValue(MFATT_MODTYPE);
                String mfAttTweakClass = mfAttributes.getValue(MFATT_TWEAK_CLASS);
                String mfAttClassPath = mfAttributes.getValue(MFATT_CLASS_PATH);
                String mfAttTweakOrder = mfAttributes.getValue(MFATT_TWEAK_ORDER);
                String mfAttDisplayName = mfAttributes.getValue(MFATT_IMPLEMENTATION_TITLE);
                String mfAttTweakName = mfAttributes.getValue(MFATT_TWEAK_NAME);
                String mfAttVersion = mfAttributes.getValue(MFATT_IMPLEMENTATION_VERSION);
                String mfAttTweakVersion = mfAttributes.getValue(MFATT_TWEAK_VERSION);
                String mfAttAuthor = mfAttributes.getValue(MFATT_IMPLEMENTATION_VENDOR);
                String mfAttTweakAuthor = mfAttributes.getValue(MFATT_TWEAK_AUTHOR);
                String mfAttMixinConfigs = mfAttributes.getValue(MFATT_MIXIN_CONFIGS);
                String mfAttInjectionStrategy = mfAttributes.getValue(MFATT_INJECTION_STRATEGY);
                if (mfAttmodSystemList != null) {
                    for (String modSystem : mfAttmodSystemList.split(",")) {
                        if ((modSystem = modSystem.trim()).length() <= 0) continue;
                        this.modSystems.add(modSystem);
                    }
                }
                this.tweakClassName = mfAttTweakClass;
                if (this.tweakClassName != null && mfAttClassPath != null) {
                    this.classPathEntries = mfAttClassPath.split(" ");
                }
                if (mfAttTweakOrder != null && (tweakOrder = Ints.tryParse((String)mfAttTweakOrder)) != null) {
                    this.tweakPriority = tweakOrder;
                }
                if (mfAttDisplayName != null) {
                    this.displayName = mfAttDisplayName;
                }
                if (mfAttTweakName != null) {
                    this.displayName = mfAttTweakName;
                }
                if (mfAttVersion != null) {
                    this.version = mfAttVersion;
                }
                if (mfAttTweakVersion != null) {
                    this.version = mfAttTweakVersion;
                }
                if (mfAttAuthor != null) {
                    this.author = mfAttAuthor;
                }
                if (mfAttTweakAuthor != null) {
                    this.author = mfAttTweakAuthor;
                }
                if (mfAttMixinConfigs != null) {
                    for (String config : mfAttMixinConfigs.split(",")) {
                        this.mixinConfigs.add(config);
                    }
                }
                this.injectionStrategy = InjectionStrategy.parseStrategy(mfAttInjectionStrategy, InjectionStrategy.TOP);
            }
        }
        catch (Exception ex) {
            LiteLoaderLogger.warning("Could not parse jar metadata in '%s'", this);
        }
        finally {
            try {
                if (jar != null) {
                    jar.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public Set<String> getModSystems() {
        return Collections.unmodifiableSet(this.modSystems);
    }

    @Override
    public File getTarget() {
        return this;
    }

    @Override
    public File toFile() {
        return this;
    }

    @Override
    public String getLocation() {
        return this.getAbsolutePath();
    }

    @Override
    public URL getURL() throws MalformedURLException {
        return this.toURI().toURL();
    }

    @Override
    public String getIdentifier() {
        return this.getName().toLowerCase();
    }

    @Override
    public boolean hasTweakClass() {
        return this.tweakClassName != null;
    }

    @Override
    public String getTweakClassName() {
        return this.tweakClassName;
    }

    @Override
    public int getTweakPriority() {
        return this.tweakPriority;
    }

    @Override
    public String[] getClassPathEntries() {
        return this.classPathEntries;
    }

    @Override
    public boolean hasClassTransformers() {
        return false;
    }

    @Override
    public List<String> getClassTransformerClassNames() {
        return Collections.emptyList();
    }

    @Override
    public boolean hasMixins() {
        return this.mixinConfigs.size() > 0;
    }

    @Override
    public Set<String> getMixinConfigs() {
        return this.mixinConfigs;
    }

    @Override
    public boolean hasEventTransformers() {
        return this.hasEventTransformers;
    }

    public void onEventsInjected() {
        this.hasEventTransformers = true;
    }

    public boolean isInjectionForced() {
        return this.forceInjection;
    }

    public void setForceInjection(boolean forceInjection) {
        this.forceInjection = forceInjection;
    }

    @Override
    public boolean requiresPreInitInjection() {
        return this.hasTweakClass() || this.hasClassTransformers() || this.hasMixins();
    }

    @Override
    public boolean isInjected() {
        return this.injected;
    }

    @Override
    public boolean injectIntoClassPath(LaunchClassLoader classLoader, boolean injectIntoParent) throws MalformedURLException {
        if (!this.injected) {
            this.injected = true;
            boolean isOnClassPath = ClassPathUtilities.isJarOnClassPath(this, (URLClassLoader)classLoader);
            if (!this.forceInjection && isOnClassPath) {
                LiteLoaderLogger.info("%s already exists on the classpath, skipping injection", this);
                return false;
            }
            ClassPathUtilities.injectIntoClassPath((URLClassLoader)classLoader, this.getURL(), this.getInjectionStrategy());
            if (injectIntoParent) {
                LiteLoaderTweaker.addURLToParentClassLoader(this.getURL());
            }
            return true;
        }
        return false;
    }

    @Override
    public InjectionStrategy getInjectionStrategy() {
        return this.injectionStrategy;
    }

    @Override
    public String getDisplayName() {
        return this.displayName != null ? this.displayName : this.getName();
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public String getAuthor() {
        return this.author;
    }

    @Override
    public String getDescription(String key) {
        return "";
    }

    @Override
    public boolean isExternalJar() {
        return true;
    }

    @Override
    public boolean isToggleable() {
        return false;
    }

    @Override
    public boolean isEnabled(LoaderEnvironment environment) {
        return environment.getEnabledModsList().isEnabled(environment.getProfile(), this.getIdentifier());
    }

    @Override
    public String toString() {
        return this.getLocation();
    }

    public String getFileContents(String name, Charset charset) {
        return LoadableFile.getFileContents(this, name, charset);
    }

    public static String getFileContents(File parent, String name, Charset charset) {
        block7: {
            try {
                if (parent.isDirectory()) {
                    File file = new File(parent, name);
                    if (file.isFile()) {
                        return Files.toString((File)file, (Charset)charset);
                    }
                    break block7;
                }
                String content = null;
                ZipFile zipFile = new ZipFile(parent);
                ZipEntry zipEntry = zipFile.getEntry(name);
                if (zipEntry != null) {
                    try {
                        content = LoadableModFile.zipEntryToString(zipFile, zipEntry);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                zipFile.close();
                return content;
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return null;
    }
}

