/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.core.event;

import com.mumfrey.liteloader.api.Listener;
import com.mumfrey.liteloader.core.event.HandlerList;
import com.mumfrey.liteloader.core.event.IHandlerListDecorator;
import com.mumfrey.liteloader.core.runtime.Obf;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class ProfilingHandlerList<T extends Listener>
extends HandlerList<T> {
    private static final long serialVersionUID = 1L;
    private final ou profiler;

    public ProfilingHandlerList(Class<T> type, ou profiler) {
        super(type);
        this.profiler = profiler;
    }

    public ProfilingHandlerList(Class<T> type, HandlerList.ReturnLogicOp logicOp, ou profiler) {
        super(type, logicOp);
        this.profiler = profiler;
    }

    public ProfilingHandlerList(Class<T> type, HandlerList.ReturnLogicOp logicOp, boolean sorted, ou profiler) {
        super(type, logicOp, sorted);
        this.profiler = profiler;
    }

    @Override
    protected IHandlerListDecorator<T> getDecorator() {
        return new ProfilingHandlerListDecorator(this.profiler);
    }

    public static abstract class BakedList<T>
    extends HandlerList.BakedHandlerList<T> {
        private final ou profiler;

        public BakedList(ou profiler) {
            this.profiler = profiler;
        }

        @Override
        public abstract T get();

        @Override
        public abstract HandlerList.BakedHandlerList<T> populate(List<T> var1);

        protected void startSection(String name) {
            this.profiler.a(name);
        }

        protected void endSection() {
            this.profiler.b();
        }
    }

    static class ProfilingHandlerListDecorator<T extends Listener>
    implements IHandlerListDecorator<T> {
        private final ou profiler;
        private final List<String> names = new ArrayList<String>();

        protected ProfilingHandlerListDecorator(ou profiler) {
            this.profiler = profiler;
        }

        @Override
        public Obf getTemplate() {
            return Obf.BakedProfilingHandlerList;
        }

        @Override
        public void prepare(List<T> sortedList) {
            this.names.clear();
            for (Listener l : sortedList) {
                String name = l.getName();
                this.names.add(name != null ? name : l.getClass().getSimpleName());
            }
        }

        @Override
        public HandlerList.BakedHandlerList<T> createInstance(Class<HandlerList.BakedHandlerList<T>> handlerClass) throws Exception {
            try {
                Constructor<HandlerList.BakedHandlerList<T>> ctor = handlerClass.getDeclaredConstructor(ou.class);
                ctor.setAccessible(true);
                return ctor.newInstance(this.profiler);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }

        @Override
        public void populateClass(String name, ClassNode classNode) {
        }

        @Override
        public void processCtor(ClassNode classNode, MethodNode method) {
            method.instructions.clear();
            method.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            method.instructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
            method.instructions.add((AbstractInsnNode)new MethodInsnNode(183, Obf.BakedProfilingHandlerList.ref, Obf.constructor.name, method.desc, false));
            method.instructions.add((AbstractInsnNode)new InsnNode(177));
        }

        @Override
        public void preInvokeInterfaceMethod(int handlerIndex, ClassNode classNode, MethodNode method, Type[] args) {
            method.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            method.instructions.add((AbstractInsnNode)new LdcInsnNode((Object)this.names.get(handlerIndex)));
            method.instructions.add((AbstractInsnNode)new MethodInsnNode(183, classNode.superName, "startSection", "(Ljava/lang/String;)V", false));
        }

        @Override
        public void postInvokeInterfaceMethod(int handlerIndex, ClassNode classNode, MethodNode method, Type[] args) {
            method.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            method.instructions.add((AbstractInsnNode)new MethodInsnNode(183, classNode.superName, "endSection", "()V", false));
        }

        @Override
        public void populateInterfaceMethod(ClassNode classNode, MethodNode method) {
        }
    }
}

