/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.core;

import com.mumfrey.liteloader.PacketHandler;
import com.mumfrey.liteloader.ServerChatFilter;
import com.mumfrey.liteloader.api.InterfaceProvider;
import com.mumfrey.liteloader.api.Listener;
import com.mumfrey.liteloader.common.transformers.PacketEventInfo;
import com.mumfrey.liteloader.core.InterfaceRegistrationDelegate;
import com.mumfrey.liteloader.core.LiteLoader;
import com.mumfrey.liteloader.core.LiteLoaderEventBroker;
import com.mumfrey.liteloader.core.event.HandlerList;
import com.mumfrey.liteloader.core.runtime.Packets;
import com.mumfrey.liteloader.interfaces.FastIterable;
import com.mumfrey.liteloader.util.log.LiteLoaderLogger;
import java.util.List;

public abstract class PacketEvents
implements InterfaceProvider {
    protected static PacketEvents instance;
    protected final LiteLoader loader;
    private PacketHandlerList[] packetHandlers = new PacketHandlerList[Packets.count()];
    private FastIterable<ServerChatFilter> serverChatFilters = new HandlerList<ServerChatFilter>(ServerChatFilter.class, HandlerList.ReturnLogicOp.AND_BREAK_ON_FALSE);
    private final int loginSuccessPacketId = Packets.SPacketLoginSuccess.getIndex();
    private final int serverChatPacketId = Packets.SPacketChat.getIndex();
    private final int clientChatPacketId = Packets.CPacketChatMessage.getIndex();
    private final int joinGamePacketId = Packets.SPacketJoinGame.getIndex();
    private final int serverPayloadPacketId = Packets.SPacketCustomPayload.getIndex();
    private final int clientPayloadPacketId = Packets.CPacketCustomPayload.getIndex();
    private final int clientSettingsPacketId = Packets.CPacketClientSettings.getIndex();

    public PacketEvents() {
        instance = this;
        this.loader = LiteLoader.getInstance();
    }

    @Override
    public Class<? extends Listener> getListenerBaseType() {
        return Listener.class;
    }

    @Override
    public void registerInterfaces(InterfaceRegistrationDelegate delegate) {
        delegate.registerInterface(PacketHandler.class);
        delegate.registerInterface(ServerChatFilter.class);
    }

    @Override
    public void initProvider() {
    }

    public void registerServerChatFilter(ServerChatFilter serverChatFilter) {
        this.serverChatFilters.add(serverChatFilter);
    }

    public void registerPacketHandler(PacketHandler handler) {
        List<Class<fm<?>>> handledPackets = handler.getHandledPackets();
        if (handledPackets != null) {
            for (Class<fm<?>> packetClass : handledPackets) {
                String packetClassName = packetClass.getName();
                int packetId = Packets.indexOf(packetClassName);
                if (packetId == -1 || packetId >= this.packetHandlers.length) {
                    LiteLoaderLogger.warning("PacketHandler %s attempted to register a handler for unupported packet class %s", handler.getName(), packetClassName);
                    continue;
                }
                if (this.packetHandlers[packetId] == null) {
                    this.packetHandlers[packetId] = new PacketHandlerList();
                }
                this.packetHandlers[packetId].add(handler);
            }
        }
    }

    public static void handlePacket(PacketEventInfo<fm<?>> e, ew netHandler) {
        instance.handlePacket(e, netHandler, e.getPacketId());
    }

    private void handlePacket(PacketEventInfo<fm<?>> e, ew netHandler, int packetId) {
        Packets packetInfo = Packets.packets[e.getPacketId()];
        qy threadListener = this.getPacketContextListener(packetInfo.getContext());
        if (threadListener != null && !threadListener.aF()) {
            this.handleAsyncPacketEvent(e, netHandler, packetId);
            return;
        }
        if (this.handlePacketEvent(e, netHandler, packetId) || this.packetHandlers[packetId] == null || e.isCancelled()) {
            return;
        }
        if (((PacketHandler)this.packetHandlers[packetId].all()).handlePacket(netHandler, (fm)e.getSource())) {
            return;
        }
        e.cancel();
    }

    protected abstract qy getPacketContextListener(Packets.Context var1);

    protected void handleAsyncPacketEvent(PacketEventInfo<fm<?>> e, ew netHandler, int packetId) {
        fm packet = (fm)e.getSource();
        if (packetId == this.loginSuccessPacketId) {
            this.handlePacket(e, netHandler, (jt)packet);
        }
    }

    protected boolean handlePacketEvent(PacketEventInfo<fm<?>> e, ew netHandler, int packetId) {
        fm packet = (fm)e.getSource();
        if (packetId == this.serverChatPacketId) {
            this.handlePacket(e, netHandler, (gf)packet);
            return true;
        }
        if (packetId == this.clientChatPacketId) {
            this.handlePacket(e, netHandler, (ip)packet);
            return true;
        }
        if (packetId == this.joinGamePacketId) {
            this.handlePacket(e, netHandler, (gz)packet);
            return true;
        }
        if (packetId == this.serverPayloadPacketId) {
            this.handlePacket(e, netHandler, (go)packet);
            return true;
        }
        if (packetId == this.clientPayloadPacketId) {
            this.handlePacket(e, netHandler, (iw)packet);
            return true;
        }
        if (packetId == this.clientSettingsPacketId) {
            this.handlePacket(e, netHandler, (ir)packet);
            return true;
        }
        return false;
    }

    protected abstract void handlePacket(PacketEventInfo<fm<?>> var1, ew var2, jt var3);

    protected abstract void handlePacket(PacketEventInfo<fm<?>> var1, ew var2, gf var3);

    protected void handlePacket(PacketEventInfo<fm<?>> e, ew netHandler, ip packet) {
        ly player;
        ly ly2 = player = netHandler instanceof mi ? ((mi)netHandler).b : null;
        if (!this.serverChatFilters.all().onChat(player, packet, packet.a())) {
            e.cancel();
        }
    }

    protected void handlePacket(PacketEventInfo<fm<?>> e, ew netHandler, gz packet) {
        this.loader.onJoinGame(netHandler, packet);
    }

    protected void handlePacket(PacketEventInfo<fm<?>> e, ew netHandler, go packet) {
        LiteLoader.getClientPluginChannels().onPluginChannelMessage(packet);
    }

    protected void handlePacket(PacketEventInfo<fm<?>> e, ew netHandler, iw packet) {
        LiteLoader.getServerPluginChannels().onPluginChannelMessage(netHandler, packet);
    }

    private void handlePacket(PacketEventInfo<fm<?>> e, ew netHandler, ir packet) {
        if (netHandler instanceof mi) {
            LiteLoaderEventBroker.broker.onPlayerSettingsReceived(((mi)netHandler).b, packet);
        }
    }

    class PacketHandlerList
    extends HandlerList<PacketHandler> {
        private static final long serialVersionUID = 1L;

        PacketHandlerList() {
            super(PacketHandler.class, HandlerList.ReturnLogicOp.AND_BREAK_ON_FALSE);
        }
    }
}

