/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.core;

import com.mumfrey.liteloader.core.LiteLoaderUpdateSite;
import java.util.HashSet;
import java.util.Set;

public enum LiteLoaderVersion {
    LEGACY(0, 0L, "-", "Unknown", "-"),
    FUTURE(Integer.MAX_VALUE, Long.MAX_VALUE, "-", "Future", "-"),
    MC_1_5_2_R1(9, 0L, "1.5.2", "1.5.2", "1.5.2"),
    MC_1_6_1_R0(11, 0L, "1.6.1", "1.6.1", "1.6.1", "1.6.r1"),
    MC_1_6_1_R1(11, 0L, "1.6.1", "1.6.1", "1.6.1", "1.6.r1"),
    MC_1_6_2_R0(12, 0L, "1.6.2", "1.6.2", "1.6.2", "1.6.r2"),
    MC_1_6_2_R1(12, 1374025480L, "1.6.2", "1.6.2_01", "1.6.2", "1.6.r2"),
    MC_1_6_2_R2(13, 1374709543L, "1.6.2", "1.6.2_02", "1.6.2", "1.6.r2"),
    MC_1_6_2_R3(14, 1375228794L, "1.6.2", "1.6.2_03", "1.6.2", "1.6.r2"),
    MC_1_6_2_R4(15, 1375662298L, "1.6.2", "1.6.2_04", "1.6.2", "1.6.r2"),
    MC_1_6_3_R0(16, 1375662298L, "1.6.3", "1.6.3", "1.6.3", "1.6.r3"),
    MC_1_6_4_R0(17, 1380279938L, "1.6.4", "1.6.4", "1.6.4", "1.6.r4"),
    MC_1_6_4_R1(18, 1380796916L, "1.6.4", "1.6.4_01", "1.6.4", "1.6.r4"),
    MC_1_6_4_R2(19, 1380796916L, "1.6.4", "1.6.4_02", "1.6.4", "1.6.r4"),
    MC_1_7_2_R0(20, 1386027226L, "1.7.2", "1.7.2", "1.7.2", "1.7.r1"),
    MC_1_7_2_R1(21, 1388455995L, "1.7.2", "1.7.2_01", "1.7.2_01"),
    MC_1_7_2_R2(22, 1391815963L, "1.7.2", "1.7.2_02", "1.7.2_02"),
    MC_1_7_2_R3(23, 1391890695L, "1.7.2", "1.7.2_03", "1.7.2_02", "1.7.2_03"),
    MC_1_7_2_R4(24, 1392487926L, "1.7.2", "1.7.2_04", "1.7.2_02", "1.7.2_03", "1.7.2_04"),
    MC_1_7_2_R5(25, 0L, "1.7.2", "1.7.2_05", "1.7.2_02", "1.7.2_03", "1.7.2_04", "1.7.2_05"),
    MC_1_7_2_R6(26, 0L, "1.7.2", "1.7.2_06", "1.7.2_06"),
    MC_1_7_10_R0(27, 1404330030L, "1.7.10", "1.7.10", "1.7.10"),
    MC_1_7_10_R1(28, 1404673785L, "1.7.10", "1.7.10_01", "1.7.10"),
    MC_1_7_10_R2(29, 1405369406L, "1.7.10", "1.7.10_02", "1.7.10"),
    MC_1_7_10_R3(30, 1407687918L, "1.7.10", "1.7.10_03", "1.7.10", "1.7.10_03"),
    MC_1_7_10_R4(31, 1414368553L, "1.7.10", "1.7.10_04", "1.7.10", "1.7.10_03", "1.7.10_04"),
    MC_1_8_0_R0(32, 1463585254L, "1.8", "1.8.0", "1.8", "1.8.0"),
    MC_1_8_9_R0(34, 0L, "1.8.9", "1.8.9", "1.8.9"),
    MC_1_9_0_R0(35, 0L, "1.9", "1.9.0", "1.9", "1.9.0"),
    MC_1_9_4_R0(36, 1479472002L, "1.9.4", "1.9.4", "1.9.4"),
    MC_1_10_R0(37, 0L, "1.10", "1.10", "1.10", "1.10.0", "1.10.r1"),
    MC_1_10_2_R0(38, 1479473570L, "1.10.2", "1.10.2", "1.10.2", "1.10.r1"),
    MC_1_11_0_R0(39, 0L, "1.11", "1.11", "1.11", "1.11.0", "1.11.r1"),
    MC_1_11_2_R0(40, 0L, "1.11.2", "1.11.2", "1.11.2", "1.11.r2");

    public static final LiteLoaderVersion CURRENT;
    private static final LiteLoaderUpdateSite updateSite;
    private final int revision;
    private final long timestamp;
    private final String minecraftVersion;
    private final String loaderVersion;
    private final Set<String> supportedVersions = new HashSet<String>();

    private LiteLoaderVersion(int revision, long timestamp, String minecraftVersion, String loaderVersion, String ... supportedVersions) {
        this.revision = revision;
        this.timestamp = timestamp;
        this.minecraftVersion = minecraftVersion;
        this.loaderVersion = loaderVersion;
        for (String supportedVersion : supportedVersions) {
            this.supportedVersions.add(supportedVersion);
        }
    }

    public int getLoaderRevision() {
        return this.revision;
    }

    public long getReleaseTimestamp() {
        return this.timestamp;
    }

    public String getMinecraftVersion() {
        return this.minecraftVersion;
    }

    public String getLoaderVersion() {
        return this.loaderVersion;
    }

    public static LiteLoaderVersion getVersionFromRevision(int revision) {
        if (revision > LiteLoaderVersion.CURRENT.revision) {
            return FUTURE;
        }
        for (LiteLoaderVersion version : LiteLoaderVersion.values()) {
            if (version.getLoaderRevision() != revision) continue;
            return version;
        }
        return LEGACY;
    }

    public static int getRevisionFromVersion(String versionString) {
        for (LiteLoaderVersion version : LiteLoaderVersion.values()) {
            if (!version.getLoaderVersion().equals(versionString)) continue;
            return version.getLoaderRevision();
        }
        return LEGACY.getLoaderRevision();
    }

    public boolean isVersionSupported(String version) {
        return this.supportedVersions.contains(version);
    }

    public String toString() {
        return this.loaderVersion;
    }

    public static LiteLoaderUpdateSite getUpdateSite() {
        return updateSite;
    }

    static {
        CURRENT = MC_1_11_2_R0;
        updateSite = new LiteLoaderUpdateSite(CURRENT.getMinecraftVersion(), CURRENT.getReleaseTimestamp());
    }
}

