/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.core;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public final class EnabledModsList {
    private static final transient long serialVersionUID = -6449451105617763769L;
    private static transient Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private TreeMap<String, TreeMap<String, Boolean>> mods;
    private transient Enabled defaultEnabledValue = Enabled.ENABLED;
    private transient boolean allowSave = true;
    private transient File enabledModsFile = null;

    private EnabledModsList() {
    }

    public boolean isEnabled(String profileName, String identifier) {
        return this.getEnabled(profileName, identifier).booleanValue();
    }

    public Enabled getEnabled(String profileName, String identifier) {
        Map<String, Boolean> profile = this.getProfile(profileName);
        if (!profile.containsKey(identifier = identifier.toLowerCase().trim()) && this.defaultEnabledValue != Enabled.FILTERED) {
            profile.put(identifier, this.defaultEnabledValue.booleanValue());
        }
        return Enabled.of(profile.get(identifier));
    }

    public void setEnabled(String profileName, String identifier, boolean enabled) {
        Map<String, Boolean> profile = this.getProfile(profileName);
        profile.put(identifier.toLowerCase().trim(), enabled ? Boolean.TRUE : Boolean.FALSE);
        this.allowSave = true;
    }

    public void processModsList(String profileName, List<String> modNameFilter) {
        Map<String, Boolean> profile = this.getProfile(profileName);
        try {
            if (modNameFilter != null) {
                profile.clear();
                this.defaultEnabledValue = Enabled.FILTERED;
                this.allowSave = false;
                for (String filterEntry : modNameFilter) {
                    profile.put(filterEntry.toLowerCase().trim(), Boolean.TRUE);
                }
            }
        }
        catch (Exception ex) {
            this.defaultEnabledValue = Enabled.ENABLED;
        }
    }

    private Map<String, Boolean> getProfile(String profileName) {
        if (profileName == null) {
            profileName = "default";
        }
        if (this.mods == null) {
            this.mods = new TreeMap();
        }
        if (!this.mods.containsKey(profileName)) {
            this.mods.put(profileName, new TreeMap());
        }
        return this.mods.get(profileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EnabledModsList createFrom(File file) {
        if (file.exists()) {
            FileReader reader = null;
            try {
                reader = new FileReader(file);
                EnabledModsList instance = (EnabledModsList)gson.fromJson((Reader)reader, EnabledModsList.class);
                instance.setEnabledModsFile(file);
                EnabledModsList enabledModsList = instance;
                return enabledModsList;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            finally {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
        EnabledModsList instance = new EnabledModsList();
        instance.setEnabledModsFile(file);
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveTo(File file) {
        if (!this.allowSave) {
            return;
        }
        FileWriter writer = null;
        try {
            writer = new FileWriter(file);
            gson.toJson((Object)this, (Appendable)writer);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public void save() {
        if (this.enabledModsFile != null) {
            this.saveTo(this.enabledModsFile);
        }
    }

    public boolean saveAllowed() {
        return this.allowSave;
    }

    public File getEnabledModsFile() {
        return this.enabledModsFile;
    }

    public void setEnabledModsFile(File enabledModsFile) {
        this.enabledModsFile = enabledModsFile;
    }

    public static enum Enabled {
        ENABLED(true),
        DISABLED(false),
        FILTERED(false);

        private final boolean value;

        private Enabled(boolean value) {
            this.value = value;
        }

        public boolean booleanValue() {
            return this.value;
        }

        public static Enabled of(Boolean value) {
            return value == null ? FILTERED : (value != false ? ENABLED : DISABLED);
        }
    }
}

