/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.client.mixin;

import com.mumfrey.liteloader.PlayerInteractionListener;
import com.mumfrey.liteloader.client.LiteLoaderEventBrokerClient;
import com.mumfrey.liteloader.client.ducks.IFramebuffer;
import com.mumfrey.liteloader.client.gui.startup.LoadingBar;
import com.mumfrey.liteloader.client.overlays.IMinecraft;
import com.mumfrey.liteloader.launch.LiteLoaderTweaker;
import java.util.List;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={bes.class})
public abstract class MixinMinecraft
implements IMinecraft {
    @Shadow
    @Final
    private bey Y;
    @Shadow
    volatile boolean C;
    @Shadow
    @Final
    private List<caa> aB;
    @Shadow
    private String ar;
    @Shadow
    private int as;
    @Shadow
    private boolean af;
    private LiteLoaderEventBrokerClient broker;

    @Shadow
    abstract void a(int var1, int var2);

    @Shadow
    private void aw() {
    }

    @Shadow
    private void ax() {
    }

    @Shadow
    private void aC() {
    }

    @Inject(method={"init()V"}, at={@At(value="NEW", target="net/minecraft/client/renderer/EntityRenderer")})
    private void init(CallbackInfo ci) {
        LiteLoaderTweaker.init();
        LiteLoaderTweaker.postInit();
    }

    @Inject(method={"init()V"}, at={@At(value="NEW", target="net/minecraft/client/renderer/texture/TextureMap")})
    private void initTextures(CallbackInfo ci) {
        LoadingBar.initTextures();
    }

    @Inject(method={"init()V"}, at={@At(value="INVOKE")})
    private void progress(CallbackInfo ci) {
        LoadingBar.incrementProgress();
    }

    @Inject(method={"init()V"}, at={@At(value="RETURN")})
    private void onStartupComplete(CallbackInfo ci) {
        this.broker = LiteLoaderEventBrokerClient.getInstance();
        if (this.broker == null) {
            throw new RuntimeException("LiteLoader failed to start up properly. The game is in an unstable state and must shut down now. Check the developer log for startup errors");
        }
        this.broker.onStartupComplete();
    }

    @Inject(method={"updateFramebufferSize()V"}, at={@At(value="HEAD")})
    private void onResize(CallbackInfo ci) {
        if (this.broker != null) {
            this.broker.onResize((bes)this);
        }
    }

    @Inject(method={"runTick()V"}, at={@At(value="HEAD")})
    private void newTick(CallbackInfo ci) {
    }

    @Inject(method={"runGameLoop()V"}, at={@At(value="INVOKE", shift=At.Shift.AFTER, target="Lnet/minecraft/client/renderer/EntityRenderer;updateCameraAndRender(FJ)V")})
    private void onTick(CallbackInfo ci) {
        boolean clock = this.Y.b > 0;
        float partialTicks = this.Y.c;
        this.broker.onTick(clock, partialTicks);
    }

    @Redirect(method={"runGameLoop()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/shader/Framebuffer;framebufferRender(II)V"))
    private void renderFBO(bqr framebufferMc, int width, int height) {
        boolean fboEnabled = cdb.j();
        if (fboEnabled && this.broker != null) {
            if (framebufferMc instanceof IFramebuffer) {
                ((IFramebuffer)framebufferMc).setDispatchRenderEvent(true);
            }
            this.broker.preRenderFBO(framebufferMc);
            framebufferMc.c(width, height);
            this.broker.postRenderFBO(framebufferMc);
        } else {
            framebufferMc.c(width, height);
        }
    }

    @Inject(method={"runGameLoop()V"}, at={@At(value="INVOKE_STRING", target="Lnet/minecraft/profiler/Profiler;startSection(Ljava/lang/String;)V", args={"ldc=tick"})})
    private void onTimerUpdate(CallbackInfo ci) {
        this.broker.onTimerUpdate();
    }

    @Inject(method={"runGameLoop()V"}, at={@At(value="INVOKE_STRING", target="Lnet/minecraft/profiler/Profiler;endStartSection(Ljava/lang/String;)V", args={"ldc=gameRenderer"})})
    private void onRender(CallbackInfo ci) {
        this.broker.onRender();
    }

    @Redirect(method={"processKeyBinds()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/Minecraft;clickMouse()V"))
    private void onClickMouse(bes self) {
        if (this.broker.onClickMouse(self.h, PlayerInteractionListener.MouseButton.LEFT)) {
            this.aw();
        }
    }

    @Inject(method={"sendClickBlockToController(Z)V"}, at={@At(value="FIELD", target="Lnet/minecraft/client/Minecraft;objectMouseOver:Lnet/minecraft/util/math/RayTraceResult;", ordinal=0)}, cancellable=true)
    private void onMouseHeld(boolean leftClick, CallbackInfo ci) {
        if (!this.broker.onMouseHeld(((bes)this).h, PlayerInteractionListener.MouseButton.LEFT)) {
            ci.cancel();
        }
    }

    @Redirect(method={"processKeyBinds()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/Minecraft;rightClickMouse()V", ordinal=0))
    private void onRightClickMouse(bes self) {
        if (this.broker.onClickMouse(self.h, PlayerInteractionListener.MouseButton.RIGHT)) {
            this.ax();
        }
    }

    @Redirect(method={"processKeyBinds()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/Minecraft;rightClickMouse()V", ordinal=1))
    private void onRightMouseHeld(bes self) {
        if (this.broker.onMouseHeld(self.h, PlayerInteractionListener.MouseButton.RIGHT)) {
            this.ax();
        }
    }

    @Redirect(method={"processKeyBinds()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/Minecraft;middleClickMouse()V"))
    private void onMiddleClickMouse(bes self) {
        if (this.broker.onClickMouse(self.h, PlayerInteractionListener.MouseButton.MIDDLE)) {
            this.aC();
        }
    }

    @Override
    public bey getTimer() {
        return this.Y;
    }

    @Override
    public boolean isRunning() {
        return this.C;
    }

    @Override
    public List<caa> getDefaultResourcePacks() {
        return this.aB;
    }

    @Override
    public String getServerName() {
        return this.ar;
    }

    @Override
    public int getServerPort() {
        return this.as;
    }

    @Override
    public void onResizeWindow(int width, int height) {
        this.a(width, height);
    }
}

