/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.client.gui;

import com.mumfrey.liteloader.client.gui.GuiLiteLoaderPanel;
import com.mumfrey.liteloader.client.gui.GuiPanel;
import com.mumfrey.liteloader.core.LiteLoaderUpdateSite;
import com.mumfrey.liteloader.launch.ClassPathUtilities;
import com.mumfrey.liteloader.launch.LoaderProperties;
import com.mumfrey.liteloader.update.UpdateSite;
import java.net.URI;

class GuiPanelUpdateCheck
extends GuiPanel {
    private static final int WHITE = -1;
    private static final URI DOWNLOAD_URI = URI.create("http://dl.liteloader.com");
    private final GuiLiteLoaderPanel parentScreen;
    private final UpdateSite updateSite;
    private final String panelTitle;
    private bfm btnCheck;
    private bfm btnDownload;
    private int throb;
    private boolean canForceUpdate;
    private boolean updateForced;

    public GuiPanelUpdateCheck(GuiLiteLoaderPanel parentScreen, bes minecraft, UpdateSite updateSite, String updateName, LoaderProperties properties) {
        super(minecraft);
        this.parentScreen = parentScreen;
        this.updateSite = updateSite;
        this.panelTitle = cah.a((String)"gui.updates.title", (Object[])new Object[]{updateName});
        this.canForceUpdate = updateSite instanceof LiteLoaderUpdateSite && ((LiteLoaderUpdateSite)updateSite).canForceUpdate(properties);
    }

    @Override
    void setSize(int width, int height) {
        super.setSize(width, height);
        this.controls.add(new bfm(0, this.width - 99 - 12, this.height - 40 + 9, 100, 20, this.updateForced ? cah.a((String)"gui.exitgame", (Object[])new Object[0]) : cah.a((String)"gui.done", (Object[])new Object[0])));
        this.btnCheck = new bfm(1, 28, 42, 100, 20, cah.a((String)"gui.checknow", (Object[])new Object[0]));
        this.controls.add(this.btnCheck);
        this.btnDownload = new bfm(2, 28, 144, 100, 20, this.canForceUpdate ? cah.a((String)"gui.forceupdate", (Object[])new Object[0]) : cah.a((String)"gui.downloadupdate", (Object[])new Object[0]));
        this.controls.add(this.btnDownload);
    }

    @Override
    void draw(int mouseX, int mouseY, float partialTicks) {
        bfg fontRenderer = this.mc.k;
        fontRenderer.a(this.panelTitle, 12, 12, -1);
        GuiPanelUpdateCheck.a((int)12, (int)22, (int)(this.width - 12), (int)23, (int)-6710887);
        GuiPanelUpdateCheck.a((int)12, (int)(this.height - 40 + 2), (int)(this.width - 12), (int)(this.height - 40 + 3), (int)-6710887);
        this.btnCheck.l = !this.updateForced && !this.updateSite.isCheckInProgress();
        this.btnDownload.m = false;
        if (this.updateSite.isCheckInProgress()) {
            this.drawThrobber(12, 66, this.throb);
            fontRenderer.a(cah.a((String)"gui.updates.status.checking", (Object[])new Object[]{""}), 30, 70, -1);
        } else if (this.updateSite.isCheckComplete()) {
            boolean success = this.updateSite.isCheckSucceess();
            String status = success ? cah.a((String)"gui.updates.status.success", (Object[])new Object[0]) : cah.a((String)"gui.updates.status.failed", (Object[])new Object[0]);
            fontRenderer.a(cah.a((String)"gui.updates.status.checking", (Object[])new Object[]{status}), 30, 70, -1);
            if (success) {
                fontRenderer.a(cah.a((String)"gui.updates.available.title", (Object[])new Object[0]), 30, 96, -1);
                if (this.updateSite.isUpdateAvailable()) {
                    this.btnDownload.m = !this.updateForced;
                    fontRenderer.a(cah.a((String)"gui.updates.available.newversion", (Object[])new Object[0]), 30, 110, -1);
                    fontRenderer.a(cah.a((String)"gui.updates.available.version", (Object[])new Object[]{this.updateSite.getAvailableVersion()}), 30, 120, -1);
                    fontRenderer.a(cah.a((String)"gui.updates.available.date", (Object[])new Object[]{this.updateSite.getAvailableVersionDate()}), 30, 130, -1);
                    if (this.updateForced) {
                        fontRenderer.a(cah.a((String)"gui.updates.forced", (Object[])new Object[0]), 30, 170, -22016);
                    }
                } else {
                    fontRenderer.a(cah.a((String)"gui.updates.available.nonewversion", (Object[])new Object[0]), 30, 110, -1);
                }
            }
        } else {
            fontRenderer.a(cah.a((String)"gui.updates.status.idle", (Object[])new Object[0]), 30, 70, -1);
        }
        super.draw(mouseX, mouseY, partialTicks);
    }

    @Override
    public void close() {
        if (this.updateForced) {
            return;
        }
        super.close();
    }

    @Override
    void actionPerformed(bfm control) {
        if (control.k == 0) {
            if (this.updateForced) {
                ClassPathUtilities.terminateRuntime(0);
                return;
            }
            this.close();
        }
        if (control.k == 1) {
            this.updateSite.beginUpdateCheck();
        }
        if (control.k == 2) {
            if (this.canForceUpdate && ((LiteLoaderUpdateSite)this.updateSite).forceUpdate()) {
                this.updateForced = true;
                this.parentScreen.setToggleable(false);
                bfk sr2 = new bfk(this.mc);
                this.parentScreen.a(this.mc, sr2.a(), sr2.b());
            } else {
                this.openURI(DOWNLOAD_URI);
            }
            this.btnDownload.l = false;
        }
    }

    private void openURI(URI uri) {
        try {
            Class<?> desktop = Class.forName("java.awt.Desktop");
            Object instance = desktop.getMethod("getDesktop", new Class[0]).invoke(null, new Object[0]);
            desktop.getMethod("browse", URI.class).invoke(instance, uri);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    void onTick() {
        ++this.throb;
    }

    @Override
    void onHidden() {
    }

    @Override
    void onShown() {
    }

    @Override
    void keyPressed(char keyChar, int keyCode) {
        if (keyCode == 1) {
            this.close();
        }
    }

    @Override
    void mouseMoved(int mouseX, int mouseY) {
    }

    @Override
    void mouseReleased(int mouseX, int mouseY, int mouseButton) {
    }

    @Override
    void mouseWheelScrolled(int mouseWheelDelta) {
    }
}

