/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.client.gui;

import com.mumfrey.liteloader.api.BrandingProvider;
import com.mumfrey.liteloader.api.LiteAPI;
import com.mumfrey.liteloader.client.api.LiteLoaderBrandingProvider;
import com.mumfrey.liteloader.client.gui.GuiHoverLabel;
import com.mumfrey.liteloader.client.gui.GuiLiteLoaderPanel;
import com.mumfrey.liteloader.client.gui.GuiPanel;
import com.mumfrey.liteloader.client.gui.GuiScrollPanel;
import com.mumfrey.liteloader.client.gui.ScrollPanelContent;
import com.mumfrey.liteloader.client.util.render.IconAbsolute;
import com.mumfrey.liteloader.core.LiteLoader;
import com.mumfrey.liteloader.util.SortableValue;
import com.mumfrey.liteloader.util.render.Icon;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;

class GuiPanelAbout
extends GuiPanel
implements ScrollPanelContent {
    public static final IconAbsolute apiIconCoords = new IconAbsolute(LiteLoaderBrandingProvider.ABOUT_TEXTURE, "api_icon", 32, 32, 192.0f, 144.0f, 256.0f, 208.0f);
    private static final int ROW_HEIGHT = 40;
    private static final URI MCP_URI = URI.create("http://mcp.ocean-labs.de/");
    private GuiLiteLoaderPanel parent;
    private GuiScrollPanel scrollPane;
    private List<BrandingProvider> brandings = new ArrayList<BrandingProvider>();
    private boolean mouseOverLogo;

    public GuiPanelAbout(bes minecraft, GuiLiteLoaderPanel parent) {
        super(minecraft);
        this.parent = parent;
        this.scrollPane = new GuiScrollPanel(minecraft, this, 12, 90, 100, 100);
        this.sortBrandingProviders();
        this.scrollPane.addControl(new GuiHoverLabel(-2, 38, 22 + this.brandings.size() * 40, this.mc.k, "\u00a7n" + MCP_URI.toString(), this.parent.getBrandColour()));
    }

    /*
     * WARNING - void declaration
     */
    private void sortBrandingProviders() {
        void var4_7;
        TreeSet<SortableValue<BrandingProvider>> sortedBrandingProviders = new TreeSet<SortableValue<BrandingProvider>>();
        LiteAPI[] liteAPIArray = LiteLoader.getAPIs();
        int n = liteAPIArray.length;
        boolean bl = false;
        while (var4_7 < n) {
            LiteAPI api = liteAPIArray[var4_7];
            BrandingProvider brandingProvider = LiteLoader.getCustomisationProvider(api, BrandingProvider.class);
            if (brandingProvider != null) {
                sortedBrandingProviders.add(new SortableValue<BrandingProvider>(Integer.MAX_VALUE - brandingProvider.getPriority(), 0, brandingProvider));
            }
            ++var4_7;
        }
        int brandingIndex = 0;
        for (SortableValue sortableValue : sortedBrandingProviders) {
            BrandingProvider brandingProvider = (BrandingProvider)sortableValue.getValue();
            this.brandings.add(brandingProvider);
            URI homepage = brandingProvider.getHomepage();
            if (homepage != null) {
                this.scrollPane.addControl(new GuiHoverLabel(brandingIndex, 38, 22 + brandingIndex * 40, this.mc.k, "\u00a7n" + homepage, this.parent.getBrandColour()));
            }
            ++brandingIndex;
        }
    }

    @Override
    void setSize(int width, int height) {
        super.setSize(width, height);
        this.scrollPane.setSizeAndPosition(12, 86, this.width - 24, this.height - 126);
        this.controls.add(new bfm(-1, this.width - 99 - 12, this.height - 40 + 9, 100, 20, cah.a((String)"gui.done", (Object[])new Object[0])));
        this.controls.add(new bfm(-3, 12, this.height - 40 + 9, 100, 20, cah.a((String)"gui.log.button", (Object[])new Object[0])));
    }

    @Override
    void draw(int mouseX, int mouseY, float partialTicks) {
        this.mouseOverLogo = this.parent.drawInfoPanel(mouseX, mouseY, partialTicks, 0, 38);
        this.scrollPane.draw(mouseX, mouseY, partialTicks);
        super.draw(mouseX, mouseY, partialTicks);
    }

    @Override
    public int getScrollPanelContentHeight(GuiScrollPanel source) {
        return 64 + this.brandings.size() * 40;
    }

    @Override
    public void drawScrollPanelContent(GuiScrollPanel source, int mouseX, int mouseY, float partialTicks, int scrollAmount, int visibleHeight) {
        bfg fontRenderer = this.mc.k;
        int textColour = -5592406;
        int yPos = 0;
        for (BrandingProvider branding : this.brandings) {
            kq twitterAvatarResource = branding.getTwitterAvatarResource();
            Icon twitterAvatarCoords = branding.getTwitterAvatarCoords();
            this.mc.N().a(twitterAvatarResource != null ? twitterAvatarResource : LiteLoaderBrandingProvider.ABOUT_TEXTURE);
            GuiLiteLoaderPanel.glDrawTexturedRect(0, yPos, twitterAvatarCoords != null ? twitterAvatarCoords : apiIconCoords, 1.0f);
            fontRenderer.a(branding.getDisplayName(), 38, yPos, -1);
            fontRenderer.a(branding.getCopyrightText(), 38, yPos + 11, textColour);
            yPos += 40;
        }
        fontRenderer.a("Created using Mod Coder Pack", 38, yPos, -1);
        fontRenderer.a("MCP is (c) Copyright by the MCP Team", 38, yPos + 11, textColour);
        fontRenderer.a("Minecraft is Copyright (c) Mojang AB", 38, yPos += 40, textColour);
        fontRenderer.a("All rights reserved.", 38, yPos + 11, textColour);
    }

    @Override
    public void scrollPanelMousePressed(GuiScrollPanel source, int mouseX, int mouseY, int mouseButton) {
        String twitterUserName;
        int index = mouseY / 40;
        int yOffset = mouseY - 40 * index;
        if (mouseButton == 0 && mouseX < 33 && index >= 0 && index < this.brandings.size() && yOffset < 33 && (twitterUserName = this.brandings.get(index).getTwitterUserName()) != null) {
            URI twitterURI = URI.create("https://www.twitter.com/" + twitterUserName);
            this.openURI(twitterURI);
        }
    }

    @Override
    void actionPerformed(bfm control) {
        if (control.k == -1) {
            this.close();
        }
        if (control.k == -2) {
            this.openURI(MCP_URI);
        }
        if (control.k == -3) {
            this.parent.showLogPanel();
        }
    }

    @Override
    public void scrollPanelActionPerformed(GuiScrollPanel source, bfm control) {
        URI homepage;
        if (control.k >= 0 && control.k < this.brandings.size() && (homepage = this.brandings.get(control.k).getHomepage()) != null) {
            this.openURI(homepage);
        }
    }

    private void openURI(URI uri) {
        try {
            Class<?> desktop = Class.forName("java.awt.Desktop");
            Object instance = desktop.getMethod("getDesktop", new Class[0]).invoke(null, new Object[0]);
            desktop.getMethod("browse", URI.class).invoke(instance, uri);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    void onTick() {
    }

    @Override
    void onHidden() {
    }

    @Override
    void onShown() {
    }

    @Override
    void keyPressed(char keyChar, int keyCode) {
        if (keyCode == 1) {
            this.close();
        }
    }

    @Override
    void mousePressed(int mouseX, int mouseY, int mouseButton) {
        this.scrollPane.mousePressed(mouseX, mouseY, mouseButton);
        if (mouseButton == 0 && this.mouseOverLogo) {
            this.close();
        }
        super.mousePressed(mouseX, mouseY, mouseButton);
    }

    @Override
    void mouseMoved(int mouseX, int mouseY) {
    }

    @Override
    void mouseReleased(int mouseX, int mouseY, int mouseButton) {
        this.scrollPane.mouseReleased(mouseX, mouseY, mouseButton);
    }

    @Override
    void mouseWheelScrolled(int mouseWheelDelta) {
        this.scrollPane.mouseWheelScrolled(mouseWheelDelta);
    }
}

