/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.tile.world;

import com.buuz135.industrial.proxy.BlockRegistry;
import com.buuz135.industrial.proxy.ItemRegistry;
import com.buuz135.industrial.proxy.client.infopiece.LaserBaseInfoPiece;
import com.buuz135.industrial.tile.CustomColoredItemHandler;
import com.buuz135.industrial.tile.block.LaserBaseBlock;
import com.buuz135.industrial.utils.ItemStackWeightedItem;
import com.buuz135.industrial.utils.WorkUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.WeightedRandom;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.ndrei.teslacorelib.gui.BasicTeslaGuiContainer;
import net.ndrei.teslacorelib.gui.IGuiContainerPiece;
import net.ndrei.teslacorelib.tileentities.SidedTileEntity;

public class LaserBaseTile
extends SidedTileEntity {
    private static String NBT_CURRENT = "currentWork";
    private int currentWork = 0;
    private ItemStackHandler outItems;
    private ItemStackHandler lensItems;

    public LaserBaseTile() {
        super(LaserBaseTile.class.getName().hashCode());
    }

    protected void initializeInventories() {
        super.initializeInventories();
        this.lensItems = new ItemStackHandler(6){

            protected void onContentsChanged(int slot) {
                LaserBaseTile.this.func_70296_d();
            }
        };
        this.addInventory((IItemHandler)new CustomColoredItemHandler((IItemHandler)this.lensItems, EnumDyeColor.GREEN, "Lens items", 36, 25, 2, 3){

            public boolean canInsertItem(int slot, ItemStack stack) {
                return stack.func_77973_b().equals((Object)ItemRegistry.laserLensItem);
            }

            public boolean canExtractItem(int slot) {
                return super.canExtractItem(slot);
            }
        });
        this.addInventoryToStorage(this.lensItems, "lensItems");
        this.outItems = new ItemStackHandler(15){

            protected void onContentsChanged(int slot) {
                LaserBaseTile.this.func_70296_d();
            }
        };
        this.addInventory((IItemHandler)new CustomColoredItemHandler((IItemHandler)this.outItems, EnumDyeColor.ORANGE, "Output items", 78, 25, 5, 3){

            public boolean canInsertItem(int slot, ItemStack stack) {
                return false;
            }

            public boolean canExtractItem(int slot) {
                return true;
            }
        });
        this.addInventoryToStorage(this.outItems, "outItems");
    }

    public List<IGuiContainerPiece> getGuiContainerPieces(BasicTeslaGuiContainer container) {
        List pieces = super.getGuiContainerPieces(container);
        pieces.add(new LaserBaseInfoPiece(this, 10, 25));
        return pieces;
    }

    protected void innerUpdate() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (WorkUtils.isDisabled(this.func_145838_q()) && this.currentWork >= this.getMaxWork()) {
            ArrayList items = new ArrayList();
            BlockRegistry.laserBaseBlock.getColoreOres().keySet().forEach(integer -> BlockRegistry.laserBaseBlock.getColoreOres().get(integer).forEach(itemStackWeightedItem -> {
                int increase = 0;
                for (int i = 0; i < this.lensItems.getSlots(); ++i) {
                    if (this.lensItems.getStackInSlot(i).func_190926_b() || this.lensItems.getStackInSlot(i).func_77960_j() != integer.intValue()) continue;
                    increase += BlockRegistry.laserBaseBlock.getLenseChanceIncrease();
                }
                items.add(new ItemStackWeightedItem(itemStackWeightedItem.getStack(), itemStackWeightedItem.field_76292_a + increase));
            }));
            ItemStack stack = ((ItemStackWeightedItem)WeightedRandom.func_76271_a((Random)this.field_145850_b.field_73012_v, items)).getStack().func_77946_l();
            if (ItemHandlerHelper.insertItem((IItemHandler)this.outItems, (ItemStack)stack, (boolean)true).func_190926_b()) {
                ItemHandlerHelper.insertItem((IItemHandler)this.outItems, (ItemStack)stack, (boolean)false);
            }
            this.currentWork = 0;
        }
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.currentWork = 0;
        if (compound.func_74764_b(NBT_CURRENT)) {
            this.currentWork = compound.func_74762_e(NBT_CURRENT);
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74768_a(NBT_CURRENT, this.currentWork);
        return super.func_189515_b(compound);
    }

    public int getCurrentWork() {
        return this.currentWork;
    }

    public int getMaxWork() {
        return ((LaserBaseBlock)this.func_145838_q()).getWorkNeeded();
    }

    public void increaseWork() {
        ++this.currentWork;
    }
}

