/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.tile.mob;

import com.buuz135.industrial.item.MobImprisonmentToolItem;
import com.buuz135.industrial.proxy.FluidsRegistry;
import com.buuz135.industrial.proxy.ItemRegistry;
import com.buuz135.industrial.tile.CustomColoredItemHandler;
import com.buuz135.industrial.tile.WorkingAreaElectricMachine;
import com.buuz135.industrial.utils.BlockUtils;
import com.buuz135.industrial.utils.WorkUtils;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.ndrei.teslacorelib.inventory.BoundingRectangle;

public class MobDuplicatorTile
extends WorkingAreaElectricMachine {
    private IFluidTank experienceTank;
    private ItemStackHandler mobTool;

    public MobDuplicatorTile() {
        super(MobDuplicatorTile.class.getName().hashCode(), 4, 1, false);
    }

    @Override
    protected void initializeInventories() {
        super.initializeInventories();
        this.experienceTank = this.addFluidTank(FluidsRegistry.ESSENCE, 8000, EnumDyeColor.LIME, "Experience tank", new BoundingRectangle(50, 25, 18, 54));
        this.mobTool = new ItemStackHandler(1){

            protected void onContentsChanged(int slot) {
                MobDuplicatorTile.this.func_70296_d();
            }
        };
        this.addInventory((IItemHandler)new CustomColoredItemHandler((IItemHandler)this.mobTool, EnumDyeColor.ORANGE, "Mob imprisonment Tool", 93, 25, 1, 1){

            public boolean canInsertItem(int slot, ItemStack stack) {
                return stack.func_77973_b().equals((Object)ItemRegistry.mobImprisonmentToolItem) && ((MobImprisonmentToolItem)stack.func_77973_b()).containsEntity(stack);
            }

            public boolean canExtractItem(int slot) {
                return true;
            }
        });
        this.addInventoryToStorage(this.mobTool, "mob_replicator_tool");
    }

    @Override
    public AxisAlignedBB getWorkingArea() {
        return new AxisAlignedBB((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (double)(this.field_174879_c.func_177958_n() + 1), (double)(this.field_174879_c.func_177956_o() + 1), (double)(this.field_174879_c.func_177952_p() + 1)).func_72314_b((double)this.getRadius(), (double)this.getHeight(), (double)this.getRadius());
    }

    @Override
    public float work() {
        if (WorkUtils.isDisabled(this.func_145838_q())) {
            return 0.0f;
        }
        if (this.mobTool.getStackInSlot(0).func_190926_b()) {
            return 0.0f;
        }
        if (this.experienceTank.getFluid() == null) {
            return 0.0f;
        }
        AxisAlignedBB alignedBB = this.getWorkingArea();
        List livings = this.func_145831_w().func_72872_a(EntityLiving.class, alignedBB);
        if (livings.size() > 20) {
            return 0.0f;
        }
        ItemStack stack = this.mobTool.getStackInSlot(0);
        EntityLiving entity = (EntityLiving)((MobImprisonmentToolItem)stack.func_77973_b()).getEntityFromStack(stack, this.field_145850_b, false);
        int canSpawn = (int)((float)(this.experienceTank.getFluid() == null ? 0 : this.experienceTank.getFluid().amount) / (entity.func_110143_aJ() * 2.0f));
        if (canSpawn == 0) {
            return 0.0f;
        }
        List<BlockPos> blocks = BlockUtils.getBlockPosInAABB(alignedBB);
        for (int spawnAmount = 1 + this.field_145850_b.field_73012_v.nextInt(Math.min(canSpawn, 4)); spawnAmount > 0; --spawnAmount) {
            if (this.experienceTank.getFluid() == null || !((float)this.experienceTank.getFluid().amount > entity.func_110143_aJ() * 2.0f)) continue;
            BlockPos random = blocks.get(this.field_145850_b.field_73012_v.nextInt(blocks.size()));
            for (int tries = 20; tries > 0 && !this.field_145850_b.func_175623_d(random); --tries) {
                random = blocks.get(this.field_145850_b.field_73012_v.nextInt(blocks.size()));
            }
            entity = (EntityLiving)((MobImprisonmentToolItem)stack.func_77973_b()).getEntityFromStack(stack, this.field_145850_b, false);
            entity.func_184221_a(UUID.randomUUID());
            entity.func_180482_a(this.field_145850_b.func_175649_E(this.field_174879_c), null);
            entity.func_70107_b((double)random.func_177958_n() + 0.5, (double)random.func_177956_o(), (double)random.func_177952_p() + 0.5);
            this.field_145850_b.func_72838_d((Entity)entity);
            this.experienceTank.drain((int)(entity.func_110143_aJ() * 2.0f), true);
        }
        return 1.0f;
    }
}

