/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.tile.misc;

import com.buuz135.industrial.proxy.client.infopiece.BlackHoleInfoPiece;
import com.buuz135.industrial.utils.WorkUtils;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.inventory.Slot;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.ndrei.teslacorelib.containers.BasicTeslaContainer;
import net.ndrei.teslacorelib.containers.FilteredSlot;
import net.ndrei.teslacorelib.gui.BasicTeslaGuiContainer;
import net.ndrei.teslacorelib.gui.IGuiContainerPiece;
import net.ndrei.teslacorelib.gui.TiledRenderedGuiPiece;
import net.ndrei.teslacorelib.inventory.BoundingRectangle;
import net.ndrei.teslacorelib.inventory.ColoredItemHandler;
import net.ndrei.teslacorelib.tileentities.SidedTileEntity;

public class BlackHoleUnitTile
extends SidedTileEntity {
    public static final String NBT_ITEMSTACK = "itemstack";
    public static final String NBT_AMOUNT = "amount";
    public static final String NBT_META = "meta";
    public static final String NBT_ITEM_NBT = "stack_nbt";
    private ItemStackHandler inItems;
    private ItemStackHandler outItems;
    private ItemStack stack;
    private int amount = 0;
    private BlackHoleHandler itemHandler = new BlackHoleHandler(this);

    public BlackHoleUnitTile() {
        super(BlackHoleUnitTile.class.getName().hashCode());
        this.stack = ItemStack.field_190927_a;
    }

    protected void innerUpdate() {
        ItemStack stack;
        if (WorkUtils.isDisabled(this.func_145838_q())) {
            return;
        }
        if (!this.inItems.getStackInSlot(0).func_190926_b()) {
            ItemStack in = this.inItems.getStackInSlot(0);
            if (this.stack.func_190926_b()) {
                this.stack = in;
                this.amount = 0;
            }
            this.amount += in.func_190916_E();
            this.inItems.setStackInSlot(0, ItemStack.field_190927_a);
        }
        if (this.outItems.getStackInSlot(0).func_190926_b()) {
            stack = this.stack.func_77946_l();
            stack.func_190920_e(Math.min(stack.func_77976_d(), this.amount));
            this.amount -= stack.func_190916_E();
            ItemHandlerHelper.insertItem((IItemHandler)this.outItems, (ItemStack)stack, (boolean)false);
        } else if (this.outItems.getStackInSlot(0).func_190916_E() < this.outItems.getStackInSlot(0).func_77976_d()) {
            stack = this.outItems.getStackInSlot(0);
            int increment = Math.min(this.amount, 64 - stack.func_190916_E());
            stack.func_190920_e(stack.func_190916_E() + increment);
            this.amount -= increment;
        }
        if (this.amount == 0 && this.outItems.getStackInSlot(0).func_190926_b()) {
            this.stack = ItemStack.field_190927_a;
        }
    }

    protected void initializeInventories() {
        super.initializeInventories();
        this.inItems = new ItemStackHandler(1);
        this.addInventory((IItemHandler)new ColoredItemHandler((IItemHandler)this.inItems, EnumDyeColor.BLUE, "Input items", new BoundingRectangle(16, 25, 18, 18)){

            public boolean canInsertItem(int slot, ItemStack stack) {
                return BlackHoleUnitTile.this.canInsertItem(stack);
            }

            public boolean canExtractItem(int slot) {
                return true;
            }

            public List<Slot> getSlots(BasicTeslaContainer container) {
                List slots = super.getSlots(container);
                BoundingRectangle box = this.getBoundingBox();
                slots.add(new FilteredSlot(this.getItemHandlerForContainer(), 0, box.getLeft() + 1, box.getTop() + 1));
                return slots;
            }

            public List<IGuiContainerPiece> getGuiContainerPieces(BasicTeslaGuiContainer container) {
                List pieces = super.getGuiContainerPieces(container);
                BoundingRectangle box = this.getBoundingBox();
                pieces.add(new TiledRenderedGuiPiece(box.getLeft(), box.getTop(), 18, 18, 1, 1, BasicTeslaGuiContainer.MACHINE_BACKGROUND, 108, 225, EnumDyeColor.BLUE));
                return pieces;
            }

            public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
                super.setStackInSlot(slot, stack);
            }
        });
        this.addInventoryToStorage(this.inItems, "block_hole_in");
        this.outItems = new ItemStackHandler(1);
        this.addInventory((IItemHandler)new ColoredItemHandler((IItemHandler)this.outItems, EnumDyeColor.ORANGE, "Output items", new BoundingRectangle(16, 61, 18, 18)){

            public boolean canInsertItem(int slot, ItemStack stack) {
                return false;
            }

            public boolean canExtractItem(int slot) {
                return true;
            }

            public List<Slot> getSlots(BasicTeslaContainer container) {
                List slots = super.getSlots(container);
                BoundingRectangle box = this.getBoundingBox();
                slots.add(new FilteredSlot(this.getItemHandlerForContainer(), 0, box.getLeft() + 1, box.getTop() + 1));
                return slots;
            }

            public List<IGuiContainerPiece> getGuiContainerPieces(BasicTeslaGuiContainer container) {
                List pieces = super.getGuiContainerPieces(container);
                BoundingRectangle box = this.getBoundingBox();
                pieces.add(new TiledRenderedGuiPiece(box.getLeft(), box.getTop(), 18, 18, 1, 1, BasicTeslaGuiContainer.MACHINE_BACKGROUND, 108, 225, EnumDyeColor.ORANGE));
                return pieces;
            }

            public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
                super.setStackInSlot(slot, stack);
            }
        });
        this.addInventoryToStorage(this.outItems, "black_hole_out");
    }

    public List<IGuiContainerPiece> getGuiContainerPieces(BasicTeslaGuiContainer container) {
        List list = super.getGuiContainerPieces(container);
        list.add(new BlackHoleInfoPiece(this, 44, 25));
        return list;
    }

    protected void createAddonsInventory() {
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        NBTTagCompound tagCompound = super.func_189515_b(compound);
        tagCompound.func_74778_a(NBT_ITEMSTACK, this.stack.func_77973_b().getRegistryName().toString());
        tagCompound.func_74768_a(NBT_AMOUNT, this.amount);
        tagCompound.func_74768_a(NBT_META, this.stack.func_77960_j());
        tagCompound.func_74782_a(NBT_ITEM_NBT, (NBTBase)(this.stack.func_77942_o() ? this.stack.func_77978_p() : new NBTTagCompound()));
        return tagCompound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (!compound.func_74764_b(NBT_ITEMSTACK)) {
            this.stack = ItemStack.field_190927_a;
        } else {
            Item item = Item.func_111206_d((String)compound.func_74779_i(NBT_ITEMSTACK));
            if (item != null) {
                this.stack = new ItemStack(item, 1, compound.func_74764_b(NBT_META) ? compound.func_74762_e(NBT_META) : 0);
                if (compound.func_74764_b(NBT_ITEM_NBT)) {
                    this.stack.func_77982_d(compound.func_74775_l(NBT_ITEM_NBT));
                }
            }
        }
        this.amount = !compound.func_74764_b(NBT_AMOUNT) ? 0 : compound.func_74762_e(NBT_AMOUNT);
    }

    public boolean canInsertItem(ItemStack stack) {
        return Integer.MAX_VALUE >= stack.func_190916_E() + this.amount && (this.stack.func_190926_b() || stack.func_77973_b() == this.stack.func_77973_b() && stack.func_77960_j() == this.stack.func_77960_j() && (!stack.func_77942_o() || !this.stack.func_77942_o() || stack.func_77978_p().equals((Object)this.stack.func_77978_p())));
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public void setStack(ItemStack stack) {
        this.stack = stack;
    }

    public int getAmount() {
        return this.amount + (this.outItems.getStackInSlot(0).func_190926_b() ? 0 : this.outItems.getStackInSlot(0).func_190916_E());
    }

    public void setAmount(int amount) {
        this.amount = amount;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.itemHandler;
        }
        return (T)super.getCapability(capability, facing);
    }

    private class BlackHoleHandler
    implements IItemHandler {
        private BlackHoleUnitTile tile;

        public BlackHoleHandler(BlackHoleUnitTile tile) {
            this.tile = tile;
        }

        public int getSlots() {
            return (int)Math.ceil((double)this.tile.getAmount() / (double)this.tile.getStack().func_77976_d());
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            double stacks = (double)this.tile.getAmount() / (double)this.tile.getStack().func_77976_d();
            if (BlackHoleUnitTile.this.getAmount() <= this.tile.getStack().func_77976_d() && slot == 0) {
                return BlackHoleUnitTile.this.outItems.getStackInSlot(0);
            }
            ItemStack stack = this.tile.stack.func_77946_l();
            stack.func_190920_e(slot < (int)stacks ? this.tile.getStack().func_77976_d() : (slot == (int)stacks ? (int)((stacks - (double)(this.tile.getAmount() / this.tile.getStack().func_77976_d())) * (double)this.tile.getStack().func_77976_d()) : 0));
            return stack;
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (this.tile.canInsertItem(stack)) {
                return BlackHoleUnitTile.this.inItems.insertItem(0, stack, simulate);
            }
            return stack;
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return BlackHoleUnitTile.this.outItems.extractItem(0, amount, simulate);
        }

        public int getSlotLimit(int slot) {
            return 64;
        }
    }
}

