/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.tile.misc;

import com.buuz135.industrial.proxy.BlockRegistry;
import com.buuz135.industrial.tile.CustomColoredItemHandler;
import com.buuz135.industrial.utils.WorkUtils;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.ndrei.teslacorelib.compatibility.ItemStackUtil;
import net.ndrei.teslacorelib.tileentities.SidedTileEntity;

public class BlackHoleControllerTile
extends SidedTileEntity {
    private ItemStackHandler input;
    private ItemStackHandler storage;
    private ItemStackHandler output;
    private BlackHoleControllerHandler itemHandler = new BlackHoleControllerHandler(this);

    public BlackHoleControllerTile() {
        super(BlackHoleControllerTile.class.getName().hashCode());
    }

    protected void initializeInventories() {
        super.initializeInventories();
        this.input = new ItemStackHandler(9){

            protected void onContentsChanged(int slot) {
                BlackHoleControllerTile.this.func_70296_d();
            }
        };
        this.addInventory((IItemHandler)new CustomColoredItemHandler((IItemHandler)this.input, EnumDyeColor.BLUE, "Input items", 15, 18, 9, 1){

            public boolean canInsertItem(int slot, ItemStack stack) {
                if (stack.func_77973_b().equals(Item.func_150898_a((Block)BlockRegistry.blackHoleUnitBlock))) {
                    return false;
                }
                if (BlackHoleControllerTile.this.storage.getStackInSlot(slot).func_190926_b()) {
                    return false;
                }
                ItemStack contained = BlockRegistry.blackHoleUnitBlock.getItemStack(BlackHoleControllerTile.this.storage.getStackInSlot(slot));
                return stack.func_77969_a(contained);
            }

            public boolean canExtractItem(int slot) {
                return super.canExtractItem(slot);
            }
        });
        this.addInventoryToStorage(this.input, "input");
        this.storage = new ItemStackHandler(9){

            protected void onContentsChanged(int slot) {
                BlackHoleControllerTile.this.func_70296_d();
            }

            public int getSlotLimit(int slot) {
                return 1;
            }
        };
        this.addInventory((IItemHandler)new CustomColoredItemHandler((IItemHandler)this.storage, EnumDyeColor.YELLOW, "Black hole units", 15, 40, 9, 1){

            public boolean canInsertItem(int slot, ItemStack stack) {
                return stack.func_77973_b().equals(Item.func_150898_a((Block)BlockRegistry.blackHoleUnitBlock));
            }

            public boolean canExtractItem(int slot) {
                return super.canExtractItem(slot);
            }
        });
        this.addInventoryToStorage(this.storage, "storage");
        this.output = new ItemStackHandler(9){

            protected void onContentsChanged(int slot) {
                BlackHoleControllerTile.this.func_70296_d();
            }
        };
        this.addInventory((IItemHandler)new CustomColoredItemHandler((IItemHandler)this.output, EnumDyeColor.ORANGE, "Output items", 15, 63, 9, 1){

            public boolean canInsertItem(int slot, ItemStack stack) {
                return false;
            }

            public boolean canExtractItem(int slot) {
                return true;
            }
        });
        this.addInventoryToStorage(this.output, "output");
    }

    protected void createAddonsInventory() {
    }

    public void dropItems() {
        for (ItemStackHandler items : new ItemStackHandler[]{this.input, this.storage, this.output}) {
            for (int i = 0; i < items.getSlots(); ++i) {
                ItemStack stack = items.getStackInSlot(i);
                if (ItemStackUtil.isEmpty((ItemStack)stack)) continue;
                InventoryHelper.func_180173_a((World)this.func_145831_w(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (ItemStack)stack);
            }
        }
    }

    protected void innerUpdate() {
        if (WorkUtils.isDisabled(this.func_145838_q())) {
            return;
        }
        for (int i = 0; i < 9; ++i) {
            ItemStack stack = this.storage.getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            int amount = BlockRegistry.blackHoleUnitBlock.getAmount(stack);
            ItemStack s = BlockRegistry.blackHoleUnitBlock.getItemStack(stack);
            if (s.func_190926_b()) continue;
            ItemStack in = this.input.getStackInSlot(i);
            if (!in.func_190926_b() && in.func_190916_E() + amount < Integer.MAX_VALUE) {
                BlockRegistry.blackHoleUnitBlock.setAmount(stack, amount + in.func_190916_E());
                in.func_190920_e(0);
                continue;
            }
            ItemStack out = this.output.getStackInSlot(i);
            if (out.func_190926_b()) {
                out = s.func_77946_l();
                out.func_190920_e(Math.min(amount, 64));
                BlockRegistry.blackHoleUnitBlock.setAmount(stack, amount - out.func_190916_E());
                this.output.setStackInSlot(i, out);
                continue;
            }
            if (out.func_190916_E() >= out.func_77976_d()) continue;
            int increase = Math.min(amount, out.func_77976_d() - out.func_190916_E());
            out.func_190920_e(out.func_190916_E() + increase);
            BlockRegistry.blackHoleUnitBlock.setAmount(stack, amount - increase);
        }
    }

    public ItemStackHandler getInput() {
        return this.input;
    }

    public ItemStackHandler getStorage() {
        return this.storage;
    }

    public ItemStackHandler getOutput() {
        return this.output;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.itemHandler;
        }
        return (T)super.getCapability(capability, facing);
    }

    private class BlackHoleControllerHandler
    implements IItemHandler {
        private BlackHoleControllerTile tile;

        public BlackHoleControllerHandler(BlackHoleControllerTile tile) {
            this.tile = tile;
        }

        public int getSlots() {
            int slots = 0;
            for (int i = 0; i < 9; ++i) {
                ItemStack stack = this.tile.getStorage().getStackInSlot(i);
                if (stack.func_190926_b()) continue;
                int amount = BlockRegistry.blackHoleUnitBlock.getAmount(stack) + this.tile.getOutput().getStackInSlot(i).func_190916_E();
                ItemStack s = BlockRegistry.blackHoleUnitBlock.getItemStack(stack);
                slots = (int)((double)slots + Math.ceil((double)amount / (double)s.func_77976_d()));
            }
            return slots;
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            int slots = 0;
            for (int i = 0; i < 9; ++i) {
                ItemStack hole = this.tile.getStorage().getStackInSlot(i);
                if (hole.func_190926_b()) continue;
                int amount = BlockRegistry.blackHoleUnitBlock.getAmount(hole) + this.tile.getOutput().getStackInSlot(i).func_190916_E();
                ItemStack s = BlockRegistry.blackHoleUnitBlock.getItemStack(hole);
                double toAdd = (double)amount / (double)s.func_77976_d();
                if (slot >= slots && (double)slot < (double)slots + toAdd) {
                    ItemStack stack = s.func_77946_l();
                    int z = slot - slots;
                    stack.func_190920_e(z < (int)toAdd ? s.func_77976_d() : (z == (int)toAdd ? (int)((toAdd - (double)((int)toAdd)) * (double)s.func_77976_d()) : 0));
                    return stack;
                }
                slots = (int)((double)slots + Math.ceil(toAdd));
            }
            return ItemStack.field_190927_a;
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            for (int i = 0; i < 9; ++i) {
                ItemStack contained = BlockRegistry.blackHoleUnitBlock.getItemStack(BlackHoleControllerTile.this.storage.getStackInSlot(i));
                if (!stack.func_77969_a(contained)) continue;
                return this.tile.getInput().insertItem(i, stack, simulate);
            }
            return stack;
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            int slots = 0;
            for (int i = 0; i < 9; ++i) {
                ItemStack hole = this.tile.getStorage().getStackInSlot(i);
                if (hole.func_190926_b()) continue;
                ItemStack s = BlockRegistry.blackHoleUnitBlock.getItemStack(hole);
                int a = BlockRegistry.blackHoleUnitBlock.getAmount(hole) + this.tile.getOutput().getStackInSlot(i).func_190916_E();
                double toAdd = Math.ceil((double)a / (double)s.func_77976_d());
                if (slots == slot) {
                    slots = i;
                    break;
                }
                slots = (int)((double)slots + toAdd);
            }
            return this.tile.getOutput().extractItem(slots, amount, simulate);
        }

        public int getSlotLimit(int slot) {
            return 64;
        }
    }
}

