/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.tile.generator;

import com.buuz135.industrial.tile.CustomElectricMachine;
import com.buuz135.industrial.utils.WorkUtils;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.UniversalBucket;
import net.minecraftforge.items.ItemStackHandler;
import net.ndrei.teslacorelib.inventory.BoundingRectangle;

public class LavaFabricatorTile
extends CustomElectricMachine {
    private IFluidTank tank;

    public LavaFabricatorTile() {
        super(LavaFabricatorTile.class.getName().hashCode());
    }

    @Override
    protected void initializeInventories() {
        super.initializeInventories();
        this.tank = this.addFluidTank(FluidRegistry.LAVA, 8000, EnumDyeColor.ORANGE, "Lava tank", new BoundingRectangle(50, 25, 18, 54));
    }

    protected float performWork() {
        if (WorkUtils.isDisabled(this.func_145838_q())) {
            return 0.0f;
        }
        if (this.tank.getFluid() == null || this.tank.getFluidAmount() <= 7000) {
            this.tank.fill(new FluidStack(FluidRegistry.LAVA, 1000), true);
            return 1.0f;
        }
        return 0.0f;
    }

    protected boolean acceptsFluidItem(ItemStack stack) {
        return stack.func_77973_b().equals(Items.field_151133_ar);
    }

    protected void processFluidItems(ItemStackHandler fluidItems) {
        ItemStack stack = fluidItems.getStackInSlot(0);
        if (!stack.func_190926_b() && fluidItems.getStackInSlot(1).func_190926_b() && this.tank.getFluidAmount() >= 1000) {
            ItemStack out = UniversalBucket.getFilledBucket((UniversalBucket)ForgeModContainer.getInstance().universalBucket, (Fluid)FluidRegistry.LAVA);
            this.tank.drain(1000, true);
            stack.func_190920_e(stack.func_190916_E() - 1);
            fluidItems.setStackInSlot(1, out);
        }
    }
}

