/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.tile.generator;

import com.buuz135.industrial.proxy.FluidsRegistry;
import com.buuz135.industrial.proxy.client.infopiece.BioreactorEfficiencyInfoPiece;
import com.buuz135.industrial.tile.CustomColoredItemHandler;
import com.buuz135.industrial.tile.CustomElectricMachine;
import com.buuz135.industrial.tile.block.BioReactorBlock;
import com.buuz135.industrial.utils.WorkUtils;
import java.util.List;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.ndrei.teslacorelib.gui.BasicTeslaGuiContainer;
import net.ndrei.teslacorelib.gui.IGuiContainerPiece;
import net.ndrei.teslacorelib.inventory.BoundingRectangle;

public class BioReactorTile
extends CustomElectricMachine {
    private ItemStackHandler input;
    private IFluidTank tank;

    public BioReactorTile() {
        super(BioReactorTile.class.getName().hashCode());
    }

    @Override
    protected void initializeInventories() {
        super.initializeInventories();
        this.tank = this.addFluidTank(FluidsRegistry.BIOFUEL, 8000, EnumDyeColor.PURPLE, "Biofuel tank", new BoundingRectangle(48, 25, 18, 54));
        this.input = new ItemStackHandler(9){

            protected void onContentsChanged(int slot) {
                BioReactorTile.this.func_70296_d();
            }

            public int getSlotLimit(int slot) {
                return 16;
            }
        };
        this.addInventory((IItemHandler)new CustomColoredItemHandler((IItemHandler)this.input, EnumDyeColor.BLUE, "Input items", 90, 25, 3, 3){

            public boolean canInsertItem(int slot, ItemStack stack) {
                return ((BioReactorBlock)BioReactorTile.this.func_145838_q()).getItemsAccepted().stream().anyMatch(stack1 -> stack.func_77973_b().equals(stack1.func_77973_b())) && !BioReactorTile.this.alreadyContains(BioReactorTile.this.input, stack, 16);
            }

            public boolean canExtractItem(int slot) {
                return false;
            }
        });
        this.addInventoryToStorage(this.input, "input");
    }

    public List<IGuiContainerPiece> getGuiContainerPieces(BasicTeslaGuiContainer container) {
        List pieces = super.getGuiContainerPieces(container);
        pieces.add(new BioreactorEfficiencyInfoPiece(this, 149, 25));
        return pieces;
    }

    protected float performWork() {
        if (WorkUtils.isDisabled(this.func_145838_q())) {
            return 0.0f;
        }
        if (this.getEfficiency() < 0.0f) {
            return 0.0f;
        }
        FluidStack stack = new FluidStack((Fluid)FluidsRegistry.BIOFUEL, this.getProducedAmountItem() * this.getItemAmount());
        if (this.tank.getFluid() == null || stack.amount + this.tank.getFluidAmount() <= this.tank.getCapacity()) {
            this.tank.fill(stack, true);
            for (int i = 0; i < this.input.getSlots(); ++i) {
                if (this.input.getStackInSlot(i).func_190926_b()) continue;
                this.input.getStackInSlot(i).func_190920_e(this.input.getStackInSlot(i).func_190916_E() - 1);
            }
            return 1.0f;
        }
        return 0.0f;
    }

    private boolean alreadyContains(ItemStackHandler handler, ItemStack stack, int amountAtleast) {
        for (int i = 0; i < handler.getSlots(); ++i) {
            if (!stack.func_77973_b().equals(handler.getStackInSlot(i).func_77973_b()) || stack.func_77960_j() != handler.getStackInSlot(i).func_77960_j() || handler.getStackInSlot(i).func_190916_E() < amountAtleast) continue;
            return true;
        }
        return false;
    }

    public int getItemAmount() {
        int am = 0;
        for (int i = 0; i < this.input.getSlots(); ++i) {
            if (this.input.getStackInSlot(i).func_190926_b()) continue;
            ++am;
        }
        return am;
    }

    public float getEfficiency() {
        return (float)(this.getItemAmount() - 1) / 8.0f;
    }

    public int getProducedAmountItem() {
        float eff = this.getEfficiency();
        if (eff < 0.0f) {
            return 0;
        }
        int base = ((BioReactorBlock)this.func_145838_q()).getBaseAmount();
        return (int)(this.getEfficiency() * (float)base + (float)base);
    }

    public void protectedUpdate() {
        super.protectedUpdate();
    }
}

