/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.tile.block;

import com.buuz135.industrial.config.CustomConfiguration;
import com.buuz135.industrial.proxy.ItemRegistry;
import com.buuz135.industrial.tile.block.CustomOrientedBlock;
import com.buuz135.industrial.tile.world.LaserBaseTile;
import com.buuz135.industrial.utils.ItemStackWeightedItem;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.ndrei.teslacorelib.TeslaCoreLib;

public class LaserBaseBlock
extends CustomOrientedBlock<LaserBaseTile> {
    private int workNeeded;
    private Multimap<Integer, ItemStackWeightedItem> coloreOres = ArrayListMultimap.create();
    private int lenseChanceIncrease;

    public LaserBaseBlock() {
        super("laser_base", LaserBaseTile.class, Material.field_151576_e, 100000, 100);
    }

    @Override
    public void getMachineConfig() {
        String[] entries;
        super.getMachineConfig();
        this.workNeeded = CustomConfiguration.config.getInt("workNeeded", "machines." + this.getRegistryName().func_110623_a().toString(), 100, 1, Integer.MAX_VALUE, "Amount of work needed to produce an ore");
        this.lenseChanceIncrease = CustomConfiguration.config.getInt("lenseChanceIncrease", "machines." + this.getRegistryName().func_110623_a().toString(), 5, 1, Integer.MAX_VALUE, "How much weight each lense increases to the ore");
        for (String s : entries = CustomConfiguration.config.getStringList("ores", "machines." + this.getRegistryName().func_110623_a().toString(), new String[]{"4 oreGold 0 6", "12 oreIron 0 10", "15 oreCoal 0 12", "11 oreLapis 0 8", "3 oreDiamond 0 4", "14 oreRedstone 0 6", "0 oreQuartz 0 4", "5 oreEmerald 0 2", "13 oreUranium 0 3", "4 oreSulfur 0 8", "10 oreGalena 0 6", "0 oreIridium 0 2", "14 oreRuby 0 7", "11 oreSapphire 0 7", "12 oreBauxite 0 5", "12 orePyrite 0 5", "14 oreCinnabar 0 8", "12 oreSphalerite 0 4", "15 oreTungsten 0 3", "0 oreSheldonite 0 1", "3 orePlatinum 0 2", "13 orePeridot 0 7", "11 oreSoladite 0 4", "14 oreTetrahedrite 0 4", "8 oreTin 0 8", "10 oreLead 0 5", "7 oreSilver 0 5", "1 oreCopper 0 10"}, "List of ores, format 'lensMetada itemID/oredictEntry itemMeta weight'")) {
            String[] temp = s.split(" ");
            int lens = Integer.parseInt(temp[0]);
            int meta = Integer.parseInt(temp[2]);
            int weight = Integer.parseInt(temp[3]);
            if (temp[1].contains(":")) {
                if (Item.func_111206_d((String)temp[1]) == null) continue;
                this.coloreOres.put((Object)lens, (Object)new ItemStackWeightedItem(new ItemStack(Item.func_111206_d((String)temp[1]), 1, meta), weight));
                continue;
            }
            for (ItemStack stack : OreDictionary.getOres((String)temp[1])) {
                this.coloreOres.put((Object)lens, (Object)new ItemStackWeightedItem(stack, weight));
            }
        }
    }

    public int getWorkNeeded() {
        return this.workNeeded;
    }

    public Multimap<Integer, ItemStackWeightedItem> getColoreOres() {
        return this.coloreOres;
    }

    public int getLenseChanceIncrease() {
        return this.lenseChanceIncrease;
    }

    protected IRecipe getRecipe() {
        return new ShapedOreRecipe(new ItemStack((Block)this), new Object[]{"pwp", "gwg", "dmd", Character.valueOf('p'), ItemRegistry.plastic, Character.valueOf('w'), Blocks.field_150426_aN, Character.valueOf('g'), "gearGold", Character.valueOf('d'), "gearDiamond", Character.valueOf('m'), TeslaCoreLib.machineCase});
    }
}

