/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.tile.agriculture;

import com.buuz135.industrial.IndustrialForegoing;
import com.buuz135.industrial.proxy.client.infopiece.CropSowerFilterInfoPiece;
import com.buuz135.industrial.tile.CustomColoredItemHandler;
import com.buuz135.industrial.tile.WorkingAreaElectricMachine;
import com.buuz135.industrial.utils.BlockUtils;
import com.buuz135.industrial.utils.IFFakePlayer;
import com.buuz135.industrial.utils.ItemStackUtils;
import com.buuz135.industrial.utils.WorkUtils;
import java.util.Arrays;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemSeedFood;
import net.minecraft.item.ItemSeeds;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.ndrei.teslacorelib.gui.BasicTeslaGuiContainer;
import net.ndrei.teslacorelib.gui.IGuiContainerPiece;

public class CropSowerTile
extends WorkingAreaElectricMachine {
    private static final String NBT_POINTER = "pointer";
    private static final String NBT_FILTER = "filter";
    private static final String NBT_NAME = "name";
    private static final String NBT_DATA = "data";
    private ItemStackHandler inPlant;
    private ItemStackHandler filter;
    private ItemStack[] filterStorage = new ItemStack[9];
    private int pointer;

    public CropSowerTile() {
        super(CropSowerTile.class.getName().hashCode(), 1, 1, true);
        Arrays.fill(this.filterStorage, ItemStack.field_190927_a);
    }

    @Override
    protected void initializeInventories() {
        super.initializeInventories();
        this.inPlant = new ItemStackHandler(24){

            protected void onContentsChanged(int slot) {
                CropSowerTile.this.func_70296_d();
            }
        };
        this.addInventory((IItemHandler)new CustomColoredItemHandler((IItemHandler)this.inPlant, EnumDyeColor.GREEN, "Seeds input", 54, 25, 6, 3){

            public boolean canInsertItem(int slot, ItemStack stack) {
                return stack.func_77973_b() instanceof ItemSeeds || stack.func_77973_b() instanceof ItemSeedFood || ItemStackUtils.isStackOreDict(stack, "treeSapling");
            }

            public boolean canExtractItem(int slot) {
                return false;
            }
        });
        this.addInventoryToStorage(this.inPlant, "inPlant");
        this.filter = new ItemStackHandler(9);
        this.addInventory((IItemHandler)new CustomColoredItemHandler((IItemHandler)this.filter, EnumDyeColor.WHITE, "Filter", -58, 25, 3, 3){

            public boolean canInsertItem(int slot, ItemStack stack) {
                if (stack.func_77973_b() instanceof ItemSeeds || stack.func_77973_b() instanceof ItemSeedFood || ItemStackUtils.isStackOreDict(stack, "treeSapling")) {
                    ItemStack clone = stack.func_77946_l();
                    clone.func_190920_e(1);
                    ((CropSowerTile)CropSowerTile.this).filterStorage[slot] = clone;
                } else {
                    ((CropSowerTile)CropSowerTile.this).filterStorage[slot] = ItemStack.field_190927_a;
                }
                return false;
            }

            public boolean canExtractItem(int slot) {
                return false;
            }
        });
    }

    @Override
    public AxisAlignedBB getWorkingArea() {
        BlockPos corner1 = new BlockPos(0, 2, 0);
        return new AxisAlignedBB((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (double)(this.field_174879_c.func_177958_n() + 1), (double)(this.field_174879_c.func_177956_o() + 1), (double)(this.field_174879_c.func_177952_p() + 1)).func_186670_a(corner1).func_72314_b((double)this.getRadius(), 0.0, (double)this.getRadius());
    }

    @Override
    public float work() {
        if (WorkUtils.isDisabled(this.func_145838_q())) {
            return 0.0f;
        }
        List<BlockPos> blockPos = BlockUtils.getBlockPosInAABB(this.getWorkingArea());
        ++this.pointer;
        if (this.pointer >= blockPos.size()) {
            this.pointer = 0;
        }
        if (this.pointer < blockPos.size()) {
            BlockPos pos = blockPos.get(this.pointer);
            if (this.field_145850_b.func_175623_d(pos)) {
                IFFakePlayer player = IndustrialForegoing.getFakePlayer(this.field_145850_b);
                ItemStack stack = this.getFirstItem(pos);
                if (!stack.func_190926_b()) {
                    Item seeds = stack.func_77973_b();
                    player.func_184611_a(EnumHand.MAIN_HAND, stack);
                    if (!ItemStackUtils.isStackOreDict(stack, "treeSapling") && (this.field_145850_b.func_180495_p(pos.func_177972_a(EnumFacing.DOWN)).func_177230_c().equals(Blocks.field_150346_d) || this.field_145850_b.func_180495_p(pos.func_177972_a(EnumFacing.DOWN)).func_177230_c().equals(Blocks.field_150349_c))) {
                        this.field_145850_b.func_175656_a(pos.func_177972_a(EnumFacing.DOWN), Blocks.field_150458_ak.func_176223_P());
                    }
                    seeds.func_180614_a((EntityPlayer)player, this.field_145850_b, pos.func_177972_a(EnumFacing.DOWN), EnumHand.MAIN_HAND, EnumFacing.UP, 0.0f, 0.0f, 0.0f);
                    return 1.0f;
                }
            }
        } else {
            this.pointer = 0;
        }
        return 1.0f;
    }

    private ItemStack getFirstItem(BlockPos pos) {
        int slot = this.getFilteredSlot(pos);
        for (int i = 0; i < this.inPlant.getSlots(); ++i) {
            if (!this.inPlant.getStackInSlot(i).func_190926_b() && (this.filterStorage[slot] == null || this.filterStorage[slot].func_190926_b())) {
                return this.inPlant.getStackInSlot(i);
            }
            if (this.inPlant.getStackInSlot(i).func_190926_b() || this.filterStorage[slot] == null || this.filterStorage[slot].func_190926_b() || !this.filterStorage[slot].func_77973_b().equals(this.inPlant.getStackInSlot(i).func_77973_b()) || this.filterStorage[slot].func_77960_j() != this.inPlant.getStackInSlot(i).func_77960_j()) continue;
            return this.inPlant.getStackInSlot(i);
        }
        return ItemStack.field_190927_a;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        NBTTagCompound tagCompound = super.func_189515_b(compound);
        tagCompound.func_74768_a(NBT_POINTER, this.pointer);
        NBTTagCompound filterComp = new NBTTagCompound();
        int i = 0;
        for (ItemStack filter : this.filterStorage) {
            if (filter != null && !filter.func_190926_b()) {
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74778_a(NBT_NAME, filter.func_77973_b().getRegistryName().toString());
                tag.func_74768_a(NBT_DATA, filter.func_77960_j());
                filterComp.func_74782_a(String.valueOf(i), (NBTBase)tag);
            }
            ++i;
        }
        tagCompound.func_74782_a(NBT_FILTER, (NBTBase)filterComp);
        return tagCompound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.pointer = !compound.func_74764_b(NBT_POINTER) ? 0 : compound.func_74762_e(NBT_POINTER);
        this.filterStorage = new ItemStack[9];
        if (compound.func_74764_b(NBT_FILTER)) {
            NBTTagCompound filterComp = compound.func_74775_l(NBT_FILTER);
            for (int i = 0; i < 9; ++i) {
                NBTTagCompound tag;
                Item item;
                this.filterStorage[i] = ItemStack.field_190927_a;
                if (!filterComp.func_74764_b(String.valueOf(i)) || (item = Item.func_111206_d((String)(tag = filterComp.func_74775_l(String.valueOf(i))).func_74779_i(NBT_NAME))) == null) continue;
                this.filterStorage[i] = new ItemStack(item, 1, tag.func_74762_e(NBT_DATA));
            }
        }
    }

    @Override
    public List<IGuiContainerPiece> getGuiContainerPieces(BasicTeslaGuiContainer container) {
        List<IGuiContainerPiece> pieces = super.getGuiContainerPieces(container);
        pieces.add((IGuiContainerPiece)new CropSowerFilterInfoPiece(this, -65, 19));
        return pieces;
    }

    public ItemStack[] getFilterStorage() {
        return this.filterStorage;
    }

    private int getFilteredSlot(BlockPos pos) {
        int radius = this.getRadius();
        int x = Math.round(1.49f * (float)(pos.func_177958_n() - this.field_174879_c.func_177958_n()) / (float)radius);
        int z = Math.round(1.49f * (float)(pos.func_177952_p() - this.field_174879_c.func_177952_p()) / (float)radius);
        return 4 + x + 3 * z;
    }
}

