/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.tile.agriculture;

import com.buuz135.industrial.proxy.FluidsRegistry;
import com.buuz135.industrial.tile.CustomColoredItemHandler;
import com.buuz135.industrial.tile.WorkingAreaElectricMachine;
import com.buuz135.industrial.tile.block.CropRecolectorBlock;
import com.buuz135.industrial.utils.BlockUtils;
import com.buuz135.industrial.utils.ItemStackUtils;
import com.buuz135.industrial.utils.WorkUtils;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Stack;
import net.minecraft.block.BlockCactus;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockNetherWart;
import net.minecraft.block.BlockReed;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.ndrei.teslacorelib.inventory.BoundingRectangle;

public class CropRecolectorTile
extends WorkingAreaElectricMachine {
    private static String NBT_POINTER = "pointer";
    private IFluidTank sludge;
    private ItemStackHandler outItems;
    private int pointer;
    private Queue<BlockPos> woodCache = new PriorityQueue<Object>(Comparator.comparingDouble(value -> ((BlockPos)value).func_177954_c((double)((BlockPos)value).func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)((BlockPos)value).func_177952_p())).reversed());
    private Queue<BlockPos> leavesCache = new PriorityQueue<Object>(Comparator.comparingDouble(value -> ((BlockPos)value).func_177954_c((double)((BlockPos)value).func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)((BlockPos)value).func_177952_p())).reversed());

    public CropRecolectorTile() {
        super(CropRecolectorTile.class.getName().hashCode(), 1, 0, true);
    }

    @Override
    protected void initializeInventories() {
        super.initializeInventories();
        this.sludge = this.addFluidTank(FluidsRegistry.SLUDGE, 8000, EnumDyeColor.BLACK, "Sludge tank", new BoundingRectangle(50, 25, 18, 54));
        this.outItems = new ItemStackHandler(12){

            protected void onContentsChanged(int slot) {
                CropRecolectorTile.this.func_70296_d();
            }
        };
        this.addInventory((IItemHandler)new CustomColoredItemHandler((IItemHandler)this.outItems, EnumDyeColor.ORANGE, "Crops output", 93, 25, 4, 3){

            public boolean canInsertItem(int slot, ItemStack stack) {
                return false;
            }

            public boolean canExtractItem(int slot) {
                return true;
            }
        });
        this.addInventoryToStorage(this.outItems, "outItems");
    }

    @Override
    public AxisAlignedBB getWorkingArea() {
        BlockPos corner1 = new BlockPos(0, 0, 0).func_177967_a(this.getFacing().func_176734_d(), this.getRadius() + 1);
        return new AxisAlignedBB((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (double)(this.field_174879_c.func_177958_n() + 1), (double)(this.field_174879_c.func_177956_o() + 1), (double)(this.field_174879_c.func_177952_p() + 1)).func_186670_a(corner1).func_72314_b((double)this.getRadius(), 0.0, (double)this.getRadius());
    }

    @Override
    public float work() {
        if (WorkUtils.isDisabled(this.func_145838_q())) {
            return 0.0f;
        }
        if (ItemStackUtils.isInventoryFull(this.outItems)) {
            return 0.0f;
        }
        List<BlockPos> blockPos = BlockUtils.getBlockPosInAABB(this.getWorkingArea());
        boolean needPointerIncrease = true;
        boolean treeOperation = false;
        if (this.pointer < blockPos.size()) {
            BlockPos pos = blockPos.get(this.pointer);
            IBlockState state = this.field_145850_b.func_180495_p(blockPos.get(this.pointer));
            if (state.func_177230_c() instanceof BlockCrops && ((BlockCrops)state.func_177230_c()).func_185525_y(state) || state.func_177230_c() instanceof BlockNetherWart && (Integer)state.func_177229_b((IProperty)BlockNetherWart.field_176486_a) >= 3) {
                List drops = state.func_177230_c().getDrops((IBlockAccess)this.field_145850_b, blockPos.get(this.pointer), state, 0);
                if (this.canInsertAll(drops, this.outItems)) {
                    this.insertItemsAndRemove(drops, pos, this.outItems);
                }
            } else if (BlockUtils.isLog(this.field_145850_b, pos)) {
                if (this.woodCache.isEmpty()) {
                    this.checkForTrees(this.field_145850_b, pos);
                }
                needPointerIncrease = false;
                treeOperation = true;
                for (int i = 0; !(i >= ((CropRecolectorBlock)this.func_145838_q()).getTreeOperations() || this.woodCache.isEmpty() && this.leavesCache.isEmpty()); ++i) {
                    if (!this.leavesCache.isEmpty()) {
                        this.chop(this.leavesCache);
                        continue;
                    }
                    this.chop(this.woodCache);
                }
                if (this.woodCache.isEmpty()) {
                    needPointerIncrease = true;
                }
            } else if (state.func_177230_c() instanceof BlockCactus || state.func_177230_c() instanceof BlockReed) {
                List drops;
                if (state.func_177230_c().equals(this.field_145850_b.func_180495_p(pos.func_177967_a(EnumFacing.UP, 2)).func_177230_c()) && this.canInsertAll(drops = state.func_177230_c().getDrops((IBlockAccess)this.field_145850_b, blockPos.get(this.pointer), state, 0), this.outItems)) {
                    this.insertItemsAndRemove(drops, pos.func_177967_a(EnumFacing.UP, 2), this.outItems);
                }
                if (state.func_177230_c().equals(this.field_145850_b.func_180495_p(pos.func_177967_a(EnumFacing.UP, 1)).func_177230_c()) && this.canInsertAll(drops = state.func_177230_c().getDrops((IBlockAccess)this.field_145850_b, blockPos.get(this.pointer), state, 0), this.outItems)) {
                    this.insertItemsAndRemove(drops, pos.func_177967_a(EnumFacing.UP, 1), this.outItems);
                }
            }
        } else {
            this.pointer = 0;
        }
        if (needPointerIncrease) {
            ++this.pointer;
        }
        if (this.pointer >= blockPos.size()) {
            this.pointer = 0;
        }
        if (treeOperation) {
            return -1.0f;
        }
        return 1.0f;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        NBTTagCompound tagCompound = super.func_189515_b(compound);
        tagCompound.func_74768_a(NBT_POINTER, this.pointer);
        return tagCompound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.pointer = !compound.func_74764_b(NBT_POINTER) ? 0 : compound.func_74762_e(NBT_POINTER);
    }

    public void checkForTrees(World world, BlockPos current) {
        Stack<BlockPos> tree = new Stack<BlockPos>();
        tree.push(current);
        while (!tree.isEmpty()) {
            BlockPos checking = (BlockPos)tree.pop();
            if (!BlockUtils.isLog(world, checking) && !BlockUtils.isLeaves(world, checking)) continue;
            Iterable area = BlockPos.func_177980_a((BlockPos)checking.func_177972_a(EnumFacing.DOWN).func_177972_a(EnumFacing.SOUTH).func_177972_a(EnumFacing.WEST), (BlockPos)checking.func_177972_a(EnumFacing.UP).func_177972_a(EnumFacing.NORTH).func_177972_a(EnumFacing.EAST));
            for (BlockPos blockPos : area) {
                if (BlockUtils.isLog(world, blockPos) && !this.woodCache.contains(blockPos) && blockPos.func_177954_c((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p()) <= 1000.0) {
                    tree.push(blockPos);
                    this.woodCache.add(blockPos);
                    continue;
                }
                if (!BlockUtils.isLeaves(world, blockPos) || this.leavesCache.contains(blockPos) || !(blockPos.func_177954_c((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p()) <= 1000.0)) continue;
                tree.push(blockPos);
                this.leavesCache.add(blockPos);
            }
        }
    }

    private boolean canInsertAll(List<ItemStack> drops, ItemStackHandler outItems) {
        boolean canInsert = true;
        for (ItemStack stack : drops) {
            if (ItemHandlerHelper.insertItem((IItemHandler)outItems, (ItemStack)stack, (boolean)true).func_190926_b()) continue;
            canInsert = false;
            break;
        }
        return canInsert;
    }

    private void insertItemsAndRemove(List<ItemStack> drops, BlockPos blockPos, ItemStackHandler outItems) {
        for (ItemStack stack : drops) {
            ItemHandlerHelper.insertItem((IItemHandler)outItems, (ItemStack)stack, (boolean)false);
        }
        this.sludge.fill(new FluidStack((Fluid)FluidsRegistry.SLUDGE, ((CropRecolectorBlock)this.func_145838_q()).getSludgeOperation()), true);
        this.field_145850_b.func_175698_g(blockPos);
    }

    private void chop(Queue<BlockPos> cache) {
        BlockPos p = cache.peek();
        if (BlockUtils.isLeaves(this.field_145850_b, p) || BlockUtils.isLog(this.field_145850_b, p)) {
            ItemStack drop;
            IBlockState s = this.field_145850_b.func_180495_p(p);
            List drops = s.func_177230_c().getDrops((IBlockAccess)this.field_145850_b, p, s, 0);
            Iterator iterator = drops.iterator();
            while (iterator.hasNext() && ItemHandlerHelper.insertItem((IItemHandler)this.outItems, (ItemStack)(drop = (ItemStack)iterator.next()), (boolean)true).func_190926_b()) {
                ItemHandlerHelper.insertItem((IItemHandler)this.outItems, (ItemStack)drop, (boolean)false);
            }
            this.field_145850_b.func_175698_g(p);
            this.sludge.fill(new FluidStack((Fluid)FluidsRegistry.SLUDGE, ((CropRecolectorBlock)this.func_145838_q()).getSludgeOperation()), true);
        }
        cache.poll();
    }
}

