/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets.venus.tile;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Set;
import micdoodle8.mods.galacticraft.api.tile.IDisableableMachine;
import micdoodle8.mods.galacticraft.api.transmission.NetworkType;
import micdoodle8.mods.galacticraft.api.transmission.tile.IConnector;
import micdoodle8.mods.galacticraft.api.transmission.tile.INetworkProvider;
import micdoodle8.mods.galacticraft.api.transmission.tile.ITransmitter;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.api.world.ISolarLevel;
import micdoodle8.mods.galacticraft.core.dimension.WorldProviderSpaceStation;
import micdoodle8.mods.galacticraft.core.energy.item.ItemElectricBase;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseUniversalElectricalSource;
import micdoodle8.mods.galacticraft.core.inventory.IInventoryDefaults;
import micdoodle8.mods.galacticraft.planets.venus.blocks.BlockSolarArrayController;
import micdoodle8.mods.galacticraft.planets.venus.dimension.WorldProviderVenus;
import micdoodle8.mods.galacticraft.planets.venus.tile.SolarModuleNetwork;
import micdoodle8.mods.miccore.Annotations;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.fml.relauncher.Side;

public class TileEntitySolarArrayController
extends TileBaseUniversalElectricalSource
implements IDisableableMachine,
IInventoryDefaults,
ISidedInventory,
IConnector {
    private int solarStrength = 0;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public boolean disabled = false;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int disableCooldown = 0;
    public static final int MAX_GENERATE_WATTS = 1000;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int generateWatts = 0;
    private Set<ITransmitter> solarArray = Sets.newHashSet();
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int connectedInfo = 0;
    private boolean initialised = false;

    public TileEntitySolarArrayController() {
        super("container.solar_array_controller.name");
        this.storage.setMaxExtract(1000.0f);
        this.storage.setMaxReceive(1000.0f);
        this.storage.setCapacity(50000.0f);
        this.initialised = true;
        this.inventory = NonNullList.func_191197_a((int)1, (Object)ItemStack.field_190927_a);
    }

    public void func_73660_a() {
        boolean isDaytime;
        if (!this.initialised) {
            this.storage.setCapacity(50000.0f);
            this.initialised = true;
        }
        if (!this.field_145850_b.field_72995_K) {
            this.receiveEnergyGC(null, this.generateWatts, false);
            EnumSet<EnumFacing> outputDirections = EnumSet.noneOf(EnumFacing.class);
            outputDirections.addAll(Arrays.asList(EnumFacing.field_176754_o));
            outputDirections.removeAll(this.getElectricalOutputDirections());
            BlockVec3 thisVec = new BlockVec3((TileEntity)this);
            this.solarArray.clear();
            for (EnumFacing direction : outputDirections) {
                TileEntity tileAdj = thisVec.getTileEntityOnSide(this.field_145850_b, direction);
                if (tileAdj == null || !(tileAdj instanceof INetworkProvider)) continue;
                if (tileAdj instanceof ITransmitter) {
                    if (!((ITransmitter)tileAdj).canConnect(direction.func_176734_d(), NetworkType.SOLAR_MODULE) || !(((INetworkProvider)tileAdj).getNetwork() instanceof SolarModuleNetwork)) continue;
                    this.solarArray.addAll(((SolarModuleNetwork)((INetworkProvider)tileAdj).getNetwork()).getTransmitters());
                    continue;
                }
                if (!(((INetworkProvider)tileAdj).getNetwork() instanceof SolarModuleNetwork)) continue;
                this.solarArray.addAll(((SolarModuleNetwork)((INetworkProvider)tileAdj).getNetwork()).getTransmitters());
            }
        }
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K) {
            this.recharge((ItemStack)this.getInventory().get(0));
            if (this.disableCooldown > 0) {
                --this.disableCooldown;
            }
            if (!this.getDisabled(0) && this.ticks % 20 == 0) {
                this.solarStrength = 0;
                int arraySizeWithinRange = 0;
                if (this.field_145850_b.func_72935_r() && (this.field_145850_b.field_73011_w instanceof IGalacticraftWorldProvider || !this.field_145850_b.func_72896_J() && !this.field_145850_b.func_72911_I())) {
                    for (ITransmitter transmitter : this.solarArray) {
                        TileEntity tile = (TileEntity)transmitter;
                        BlockPos diff = tile.func_174877_v().func_177973_b((Vec3i)this.func_174877_v());
                        if (Math.abs(diff.func_177958_n()) > 16 || diff.func_177956_o() != 0 || Math.abs(diff.func_177952_p()) > 16) continue;
                        ++arraySizeWithinRange;
                        if (!this.field_145850_b.func_175710_j(tile.func_174877_v())) continue;
                        boolean valid = true;
                        for (int y = this.func_174877_v().func_177956_o() + 1; y < 256; ++y) {
                            IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v().func_177982_a(0, y, 0));
                            if (!state.func_177230_c().func_149662_c(state)) continue;
                            valid = false;
                            break;
                        }
                        if (!valid) continue;
                        ++this.solarStrength;
                    }
                }
                this.connectedInfo = this.solarStrength << 16 | arraySizeWithinRange;
            }
        }
        float angle = this.field_145850_b.func_72826_c(1.0f) - 0.7845194f < 0.0f ? 0.21548063f : -0.7845194f;
        float celestialAngle = (this.field_145850_b.func_72826_c(1.0f) + angle) * 360.0f;
        if (!(this.field_145850_b.field_73011_w instanceof WorldProviderSpaceStation)) {
            celestialAngle += 12.5f;
        }
        if (this.field_145850_b.field_73011_w instanceof WorldProviderVenus) {
            celestialAngle = 180.0f - celestialAngle;
        }
        boolean bl = isDaytime = this.field_145850_b.func_72935_r() && ((celestialAngle %= 360.0f) < 180.5f || celestialAngle > 359.5f) || this.field_145850_b.field_73011_w instanceof WorldProviderSpaceStation;
        if (!this.field_145850_b.field_72995_K) {
            int generated = this.getGenerate();
            this.generateWatts = generated > 0 ? Math.min(Math.max(generated, 0), 1000) : 0;
        }
        this.produce();
    }

    public int getGenerate() {
        if (this.getDisabled(0)) {
            return 0;
        }
        return (int)Math.floor((float)this.solarStrength * 6.3f * this.getSolarBoost());
    }

    public float getSolarBoost() {
        float result = (float)(this.field_145850_b.field_73011_w instanceof ISolarLevel ? ((ISolarLevel)this.field_145850_b.field_73011_w).getSolarEnergyMultiplier() : 1.0);
        if (this.field_145850_b.field_73011_w instanceof WorldProviderSpaceStation) {
            result *= 1.1f;
        }
        if (this.field_145850_b.field_73011_w instanceof WorldProviderVenus && this.field_174879_c.func_177956_o() > 90) {
            result += (float)(this.field_174879_c.func_177956_o() - 90) / 1000.0f;
        }
        return result;
    }

    public double getPacketRange() {
        return 20.0;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.storage.setCapacity(nbt.func_74760_g("maxEnergy"));
        this.setDisabled(0, nbt.func_74767_n("disabled"));
        this.disableCooldown = nbt.func_74762_e("disabledCooldown");
        this.initialised = false;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74776_a("maxEnergy", this.getMaxEnergyStoredGC());
        nbt.func_74768_a("disabledCooldown", this.disableCooldown);
        nbt.func_74757_a("disabled", this.getDisabled(0));
        return nbt;
    }

    public EnumSet<EnumFacing> getElectricalInputDirections() {
        return EnumSet.noneOf(EnumFacing.class);
    }

    public EnumFacing getFront() {
        IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        if (state.func_177230_c() instanceof BlockSolarArrayController) {
            return (EnumFacing)state.func_177229_b((IProperty)BlockSolarArrayController.FACING);
        }
        return EnumFacing.NORTH;
    }

    public EnumSet<EnumFacing> getElectricalOutputDirections() {
        return EnumSet.of(this.getFront());
    }

    public EnumFacing getElectricOutputDirection() {
        return this.getFront();
    }

    public boolean func_145818_k_() {
        return true;
    }

    public void setDisabled(int index, boolean disabled) {
        if (this.disableCooldown == 0) {
            this.disabled = disabled;
            this.disableCooldown = 20;
        }
    }

    public boolean getDisabled(int index) {
        return this.disabled;
    }

    public int getScaledElecticalLevel(int i) {
        return (int)Math.floor(this.getEnergyStoredGC() * (float)i / this.getMaxEnergyStoredGC());
    }

    public int func_70297_j_() {
        return 1;
    }

    public int[] func_180463_a(EnumFacing side) {
        return new int[]{0};
    }

    public boolean func_180461_b(int slotID, ItemStack itemstack, EnumFacing side) {
        return slotID == 0;
    }

    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        return slotID == 0 && ItemElectricBase.isElectricItem((Item)itemstack.func_77973_b());
    }

    public boolean canConnect(EnumFacing direction, NetworkType type) {
        return type == NetworkType.POWER && direction == this.getElectricOutputDirection() || type == NetworkType.SOLAR_MODULE && direction != this.getElectricOutputDirection() && direction.func_176740_k() != EnumFacing.Axis.Y;
    }

    public int getPossibleArraySize() {
        return this.connectedInfo & 0xFFFF;
    }

    public int getActualArraySize() {
        return this.connectedInfo >> 16 & 0xFFFF;
    }
}

