/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.energy.tile;

import ic2.api.energy.tile.IEnergyAcceptor;
import ic2.api.energy.tile.IEnergyEmitter;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.energy.tile.IEnergyTile;
import micdoodle8.mods.galacticraft.api.transmission.tile.IConductor;
import micdoodle8.mods.galacticraft.api.transmission.tile.IElectrical;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.core.energy.EnergyConfigHandler;
import micdoodle8.mods.galacticraft.core.energy.EnergyUtil;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseConductor;
import micdoodle8.mods.galacticraft.core.util.CompatibilityManager;
import micdoodle8.mods.miccore.Annotations;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public abstract class TileBaseUniversalConductor
extends TileBaseConductor {
    protected boolean isAddedToEnergyNet;
    private float IC2surplusJoules = 0.0f;

    @Override
    public void onNetworkChanged() {
    }

    @Override
    public TileEntity[] getAdjacentConnections() {
        return EnergyUtil.getAdjacentPowerConnections(this);
    }

    @Annotations.RuntimeInterface(clazz="net.minecraft.util.ITickable", modID="ic2", deobfName="func_73660_a")
    public void update() {
        if (!this.isAddedToEnergyNet) {
            if (!this.field_145850_b.field_72995_K) {
                this.initIC();
            }
            this.isAddedToEnergyNet = true;
        }
    }

    @Override
    public void func_145843_s() {
        this.IC2surplusJoules = 0.0f;
        this.unloadTileIC2();
        super.func_145843_s();
    }

    @Override
    public void onChunkUnload() {
        this.unloadTileIC2();
        super.onChunkUnload();
    }

    protected void initIC() {
        if (EnergyConfigHandler.isIndustrialCraft2Loaded() && !this.field_145850_b.field_72995_K) {
            try {
                Object o = CompatibilityManager.classIC2tileEventLoad.getConstructor(IEnergyTile.class).newInstance(this);
                if (o != null && o instanceof Event) {
                    MinecraftForge.EVENT_BUS.post((Event)o);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void unloadTileIC2() {
        if (this.isAddedToEnergyNet && this.field_145850_b != null) {
            if (!this.field_145850_b.field_72995_K && EnergyConfigHandler.isIndustrialCraft2Loaded()) {
                try {
                    Object o = CompatibilityManager.classIC2tileEventUnload.getConstructor(IEnergyTile.class).newInstance(this);
                    if (o != null && o instanceof Event) {
                        MinecraftForge.EVENT_BUS.post((Event)o);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.isAddedToEnergyNet = false;
        }
    }

    @Annotations.RuntimeInterface(clazz="ic2.api.energy.tile.IEnergySink", modID="ic2")
    public double getDemandedEnergy() {
        if (this.getNetwork() == null) {
            return 0.0;
        }
        if (this.IC2surplusJoules < 0.001f) {
            this.IC2surplusJoules = 0.0f;
            return this.getNetwork().getRequest(this) / EnergyConfigHandler.IC2_RATIO;
        }
        this.IC2surplusJoules = this.getNetwork().produce(this.IC2surplusJoules, true, 1, this);
        if (this.IC2surplusJoules < 0.001f) {
            this.IC2surplusJoules = 0.0f;
            return this.getNetwork().getRequest(this) / EnergyConfigHandler.IC2_RATIO;
        }
        return 0.0;
    }

    @Annotations.RuntimeInterface(clazz="ic2.api.energy.tile.IEnergySink", modID="ic2")
    public double injectEnergy(EnumFacing directionFrom, double amount, double voltage) {
        int tier;
        TileEntity tile = new BlockVec3(this).getTileEntityOnSide(this.field_145850_b, directionFrom);
        int n = tier = (int)voltage > 120 ? 2 : 1;
        if (tile instanceof IEnergySource && ((IEnergySource)tile).getOfferedEnergy() >= 128.0) {
            tier = 2;
        }
        float convertedEnergy = (float)amount * EnergyConfigHandler.IC2_RATIO;
        float surplus = this.getNetwork().produce(convertedEnergy, true, tier, this, tile);
        this.IC2surplusJoules = surplus >= 0.001f ? surplus : 0.0f;
        return 0.0;
    }

    @Annotations.RuntimeInterface(clazz="ic2.api.energy.tile.IEnergySink", modID="ic2")
    public int getSinkTier() {
        return 3;
    }

    @Annotations.RuntimeInterface(clazz="ic2.api.energy.tile.IEnergyAcceptor", modID="ic2")
    public boolean acceptsEnergyFrom(IEnergyEmitter emitter, EnumFacing side) {
        if (emitter instanceof IElectrical || emitter instanceof IConductor) {
            return false;
        }
        try {
            if (EnergyUtil.clazzIC2Cable != null && EnergyUtil.clazzIC2Cable.isInstance(emitter)) {
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    @Annotations.RuntimeInterface(clazz="ic2.api.energy.tile.IEnergyEmitter", modID="ic2")
    public boolean emitsEnergyTo(IEnergyAcceptor receiver, EnumFacing side) {
        if (receiver instanceof IElectrical || receiver instanceof IConductor) {
            return false;
        }
        try {
            if (EnergyUtil.clazzIC2Cable != null && EnergyUtil.clazzIC2Cable.isInstance(receiver)) {
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    @Annotations.RuntimeInterface(clazz="cofh.api.energy.IEnergyReceiver", modID="")
    public int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        if (this.getNetwork() == null) {
            return 0;
        }
        float receiveGC = (float)maxReceive * EnergyConfigHandler.RF_RATIO;
        float sentGC = receiveGC - this.getNetwork().produce(receiveGC, !simulate, 1, new TileEntity[0]);
        return MathHelper.func_76141_d((float)(sentGC / EnergyConfigHandler.RF_RATIO));
    }

    @Annotations.RuntimeInterface(clazz="cofh.api.energy.IEnergyProvider", modID="")
    public int extractEnergy(EnumFacing from, int maxExtract, boolean simulate) {
        return 0;
    }

    @Annotations.RuntimeInterface(clazz="cofh.api.energy.IEnergyHandler", modID="")
    public boolean canConnectEnergy(EnumFacing from) {
        TileEntity tile = new BlockVec3(this).getTileEntityOnSide(this.field_145850_b, from);
        try {
            if (EnergyUtil.clazzEnderIOCable != null && EnergyUtil.clazzEnderIOCable.isInstance(tile)) {
                return false;
            }
            if (EnergyUtil.clazzMekCable != null && EnergyUtil.clazzMekCable.isInstance(tile)) {
                return false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    @Annotations.RuntimeInterface(clazz="cofh.api.energy.IEnergyHandler", modID="")
    public int getEnergyStored(EnumFacing from) {
        return 0;
    }

    @Annotations.RuntimeInterface(clazz="cofh.api.energy.IEnergyHandler", modID="")
    public int getMaxEnergyStored(EnumFacing from) {
        if (this.getNetwork() == null) {
            return 0;
        }
        return MathHelper.func_76141_d((float)(this.getNetwork().getRequest(this) / EnergyConfigHandler.RF_RATIO));
    }

    @Annotations.RuntimeInterface(clazz="mekanism.api.energy.IStrictEnergyAcceptor", modID="mekanism")
    public double transferEnergyToAcceptor(EnumFacing side, double amount) {
        if (EnergyConfigHandler.disableMekanismInput) {
            return 0.0;
        }
        if (!this.canReceiveEnergy(side)) {
            return 0.0;
        }
        return amount - (double)(this.getNetwork().produce((float)amount * EnergyConfigHandler.MEKANISM_RATIO, true, 1, this) / EnergyConfigHandler.MEKANISM_RATIO);
    }

    @Annotations.RuntimeInterface(clazz="mekanism.api.energy.IStrictEnergyAcceptor", modID="mekanism")
    public double acceptEnergy(EnumFacing side, double amount, boolean simulate) {
        if (EnergyConfigHandler.disableMekanismInput) {
            return 0.0;
        }
        if (!this.canReceiveEnergy(side)) {
            return 0.0;
        }
        return amount - (double)(this.getNetwork().produce((float)amount * EnergyConfigHandler.MEKANISM_RATIO, !simulate, 1, this) / EnergyConfigHandler.MEKANISM_RATIO);
    }

    @Annotations.RuntimeInterface(clazz="mekanism.api.energy.IStrictEnergyAcceptor", modID="mekanism")
    public boolean canReceiveEnergy(EnumFacing side) {
        if (this.getNetwork() == null) {
            return false;
        }
        TileEntity te = new BlockVec3(this).getTileEntityOnSide(this.field_145850_b, side);
        try {
            if (EnergyUtil.clazzMekCable != null && EnergyUtil.clazzMekCable.isInstance(te)) {
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    @Annotations.RuntimeInterface(clazz="mekanism.api.energy.IStrictEnergyAcceptor", modID="mekanism")
    public double getEnergy() {
        return 0.0;
    }

    @Annotations.RuntimeInterface(clazz="mekanism.api.energy.IStrictEnergyAcceptor", modID="mekanism")
    public void setEnergy(double energy) {
    }

    @Annotations.RuntimeInterface(clazz="mekanism.api.energy.IStrictEnergyAcceptor", modID="mekanism")
    public double getMaxEnergy() {
        if (this.getNetwork() == null) {
            return 0.0;
        }
        return this.getNetwork().getRequest(this) / EnergyConfigHandler.MEKANISM_RATIO;
    }
}

