/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.dimension;

import java.util.HashSet;
import java.util.Set;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.api.world.IExitHeight;
import micdoodle8.mods.galacticraft.api.world.IOrbitDimension;
import micdoodle8.mods.galacticraft.api.world.ISolarLevel;
import micdoodle8.mods.galacticraft.api.world.IZeroGDimension;
import micdoodle8.mods.galacticraft.core.Constants;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.client.CloudRenderer;
import micdoodle8.mods.galacticraft.core.client.SkyProviderOrbit;
import micdoodle8.mods.galacticraft.core.dimension.GCDimensions;
import micdoodle8.mods.galacticraft.core.dimension.WorldProviderSpaceStation;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.world.gen.dungeon.RoomTreasure;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DimensionType;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class WorldProviderOverworldOrbit
extends WorldProviderSpaceStation
implements IOrbitDimension,
IZeroGDimension,
ISolarLevel,
IExitHeight {
    Set<Entity> freefallingEntities = new HashSet<Entity>();

    public DimensionType func_186058_p() {
        return GCDimensions.ORBIT;
    }

    @Override
    public Vector3 getFogColor() {
        return new Vector3(0.0, 0.0, 0.0);
    }

    @Override
    public Vector3 getSkyColor() {
        return new Vector3(0.0, 0.0, 0.0);
    }

    @Override
    public boolean hasSunset() {
        return false;
    }

    @Override
    public long getDayLength() {
        return 24000L;
    }

    public boolean isDaytime() {
        float a = this.field_76579_a.func_72826_c(0.0f);
        return a < 0.42f || a > 0.58f;
    }

    @SideOnly(value=Side.CLIENT)
    public float getStarBrightness(float par1) {
        float var2 = this.field_76579_a.func_72826_c(par1);
        float var3 = 1.0f - (MathHelper.func_76134_b((float)(var2 * ((float)Math.PI * 2))) * 2.0f + 0.25f);
        if (var3 < 0.0f) {
            var3 = 0.0f;
        }
        if (var3 > 1.0f) {
            var3 = 1.0f;
        }
        return var3 * var3 * 0.5f + 0.3f;
    }

    @Override
    public boolean func_76561_g() {
        return false;
    }

    public double getHorizon() {
        return 44.0;
    }

    public int func_76557_i() {
        return 64;
    }

    public boolean func_76566_a(int var1, int var2) {
        return true;
    }

    @Override
    public CelestialBody getCelestialBody() {
        return GalacticraftCore.satelliteSpaceStation;
    }

    @Override
    public float getGravity() {
        return 0.075f;
    }

    @Override
    public double getMeteorFrequency() {
        return 0.0;
    }

    @Override
    public double getFuelUsageMultiplier() {
        return 0.5;
    }

    @Override
    public String getPlanetToOrbit() {
        return "Overworld";
    }

    @Override
    public int getYCoordToTeleportToPlanet() {
        return 30;
    }

    @Override
    public String getSaveFolder() {
        return "DIM_SPACESTATION" + this.getDimension();
    }

    @Override
    public double getSolarEnergyMultiplier() {
        return ConfigManagerCore.spaceStationEnergyScalar;
    }

    @Override
    public double getYCoordinateToTeleport() {
        return 750.0;
    }

    @Override
    public boolean canSpaceshipTierPass(int tier) {
        return tier > 0;
    }

    @Override
    public float getFallDamageModifier() {
        return 0.4f;
    }

    @Override
    public boolean inFreefall(Entity entity) {
        return this.freefallingEntities.contains(entity);
    }

    @Override
    public void setInFreefall(Entity entity) {
        this.freefallingEntities.add(entity);
    }

    @Override
    public void updateWeather() {
        this.freefallingEntities.clear();
        super.updateWeather();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void setSpinDeltaPerTick(float angle) {
        SkyProviderOrbit skyProvider = (SkyProviderOrbit)this.getSkyRenderer();
        if (skyProvider != null) {
            skyProvider.spinDeltaPerTick = angle;
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public float getSkyRotation() {
        SkyProviderOrbit skyProvider = (SkyProviderOrbit)this.getSkyRenderer();
        return skyProvider.spinAngle;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void createSkyProvider() {
        this.setSkyRenderer(new SkyProviderOrbit(new ResourceLocation(Constants.ASSET_PREFIX, "textures/gui/celestialbodies/earth.png"), true, true));
        this.setSpinDeltaPerTick(this.getSpinManager().getSpinRate());
        if (this.getCloudRenderer() == null) {
            this.setCloudRenderer(new CloudRenderer());
        }
    }

    @Override
    public int getDungeonSpacing() {
        return 0;
    }

    @Override
    public ResourceLocation getDungeonChestType() {
        return RoomTreasure.MOONCHEST;
    }
}

