/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.dimension;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.BlockSpinThruster;
import micdoodle8.mods.galacticraft.core.dimension.OrbitSpinSaveData;
import micdoodle8.mods.galacticraft.core.dimension.WorldProviderSpaceStation;
import micdoodle8.mods.galacticraft.core.entities.ITumblable;
import micdoodle8.mods.galacticraft.core.entities.player.FreefallHandler;
import micdoodle8.mods.galacticraft.core.network.PacketSimple;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.core.util.GCLog;
import micdoodle8.mods.galacticraft.core.util.RedstoneUtil;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDynamicLiquid;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SpinManager {
    private static final float GFORCE = 0.024525002f;
    public boolean doSpinning = true;
    public float angularVelocityRadians = 0.0f;
    public float skyAngularVelocity = this.angularVelocityRadians * 57.295776f;
    public float angularVelocityTarget = 0.0f;
    public float angularVelocityAccel = 0.0f;
    public double spinCentreX;
    public double spinCentreZ;
    private float momentOfInertia;
    private float massCentreX;
    private float massCentreZ;
    public int ssBoundsMaxX;
    public int ssBoundsMinX;
    public int ssBoundsMaxY;
    public int ssBoundsMinY;
    public int ssBoundsMaxZ;
    public int ssBoundsMinZ;
    private OrbitSpinSaveData savefile;
    private LinkedList<BlockPos> thrustersPlus = Lists.newLinkedList();
    private LinkedList<BlockPos> thrustersMinus = Lists.newLinkedList();
    private BlockPos oneSSBlock;
    private HashSet<BlockVec3> checked = new HashSet();
    private float artificialG;
    public boolean thrustersFiring = false;
    private boolean dataNotLoaded = true;
    private List<Entity> loadedEntities = Lists.newLinkedList();
    private WorldProviderSpaceStation worldProvider;
    private boolean clientSide = true;

    public SpinManager(WorldProviderSpaceStation provider) {
        this.worldProvider = provider;
    }

    public void registerServerSide() {
        if (!this.worldProvider.field_76579_a.field_72995_K) {
            this.clientSide = false;
        }
    }

    public float getSpinRate() {
        return this.skyAngularVelocity;
    }

    public void setSpinRate(float angle) {
        this.angularVelocityRadians = angle;
        this.skyAngularVelocity = angle * 180.0f / (float)Math.PI;
        if (GCCoreUtil.getEffectiveSide() == Side.CLIENT) {
            this.updateSkyProviderSpinRate();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void updateSkyProviderSpinRate() {
        this.worldProvider.setSpinDeltaPerTick(this.skyAngularVelocity);
    }

    public void setSpinRate(float angle, boolean firing) {
        this.angularVelocityRadians = angle;
        this.skyAngularVelocity = angle * 180.0f / (float)Math.PI;
        this.worldProvider.setSpinDeltaPerTick(this.skyAngularVelocity);
        this.thrustersFiring = firing;
    }

    public void setSpinCentre(double x, double z) {
        this.spinCentreX = x;
        this.spinCentreZ = z;
        if (this.clientSide && ConfigManagerCore.enableDebug) {
            GCLog.info("Clientside update to spin centre: " + x + "," + z);
        }
    }

    public void setSpinBox(int mx, int xx, int my, int yy, int mz, int zz) {
        this.ssBoundsMinX = mx;
        this.ssBoundsMaxX = xx;
        this.ssBoundsMinY = my;
        this.ssBoundsMaxY = yy;
        this.ssBoundsMinZ = mz;
        this.ssBoundsMaxZ = zz;
    }

    public void removeThruster(BlockPos thruster, boolean positive) {
        if (positive) {
            this.thrustersPlus.remove(thruster);
        } else {
            this.thrustersMinus.remove(thruster);
        }
    }

    public boolean refresh(BlockPos baseBlock, boolean placingThruster) {
        int thisssBoundsMaxZ;
        int thisssBoundsMaxY;
        int thisssBoundsMaxX;
        if (this.oneSSBlock == null || this.worldProvider.field_76579_a.func_180495_p(this.oneSSBlock).func_177230_c().isAir(this.worldProvider.field_76579_a.func_180495_p(this.oneSSBlock), (IBlockAccess)this.worldProvider.field_76579_a, this.oneSSBlock)) {
            this.oneSSBlock = baseBlock != null ? baseBlock : new BlockPos(0, 64, 0);
        }
        LinkedList<BlockVec3> currentLayer = new LinkedList<BlockVec3>();
        LinkedList<BlockVec3> nextLayer = new LinkedList<BlockVec3>();
        LinkedList<BlockPos> foundThrusters = new LinkedList<BlockPos>();
        this.checked.clear();
        currentLayer.add(new BlockVec3(this.oneSSBlock));
        this.checked.add(new BlockVec3(this.oneSSBlock));
        IBlockState bsStart = this.worldProvider.field_76579_a.func_180495_p(this.oneSSBlock);
        Block bStart = bsStart.func_177230_c();
        if (bStart instanceof BlockSpinThruster) {
            foundThrusters.add(this.oneSSBlock);
        }
        int thisssBoundsMinX = thisssBoundsMaxX = this.oneSSBlock.func_177958_n();
        int thisssBoundsMinY = thisssBoundsMaxY = this.oneSSBlock.func_177956_o();
        int thisssBoundsMinZ = thisssBoundsMaxZ = this.oneSSBlock.func_177952_p();
        float thismass = 0.1f;
        float thismassCentreX = 0.1f * (float)thisssBoundsMaxX;
        float thismassCentreY = 0.1f * (float)thisssBoundsMaxY;
        float thismassCentreZ = 0.1f * (float)thisssBoundsMaxZ;
        float thismoment = 0.0f;
        while (currentLayer.size() > 0) {
            for (BlockVec3 vec : currentLayer) {
                int bits = vec.sideDoneBits;
                if (vec.x < thisssBoundsMinX) {
                    thisssBoundsMinX = vec.x;
                }
                if (vec.y < thisssBoundsMinY) {
                    thisssBoundsMinY = vec.y;
                }
                if (vec.z < thisssBoundsMinZ) {
                    thisssBoundsMinZ = vec.z;
                }
                if (vec.x > thisssBoundsMaxX) {
                    thisssBoundsMaxX = vec.x;
                }
                if (vec.y > thisssBoundsMaxY) {
                    thisssBoundsMaxY = vec.y;
                }
                if (vec.z > thisssBoundsMaxZ) {
                    thisssBoundsMaxZ = vec.z;
                }
                for (int side = 0; side < 6; ++side) {
                    Block b;
                    BlockVec3 sideVec;
                    if ((bits & 1 << side) == 1 || (sideVec = vec.newVecSide(side)) == null || this.checked.contains(sideVec)) continue;
                    this.checked.add(sideVec);
                    IBlockState state = sideVec.getBlockState(this.worldProvider.field_76579_a);
                    if (state == null || (b = state.func_177230_c()) == null || b.isAir(state, (IBlockAccess)this.worldProvider.field_76579_a, sideVec.toBlockPos()) || b instanceof BlockDynamicLiquid) continue;
                    nextLayer.add(sideVec);
                    if (bStart.isAir(bsStart, (IBlockAccess)this.worldProvider.field_76579_a, this.oneSSBlock)) {
                        this.oneSSBlock = sideVec.toBlockPos();
                        bStart = b;
                    }
                    float m = 1.0f;
                    if (!(b instanceof BlockLiquid)) {
                        m = b.func_176195_g(state, this.worldProvider.field_76579_a, sideVec.toBlockPos());
                        if (m < 0.1f) {
                            m = 0.1f;
                        } else if (m > 30.0f) {
                            m = 30.0f;
                        }
                        if (b.func_149688_o(state) == Material.field_151575_d) {
                            m /= 4.0f;
                        }
                    }
                    thismassCentreX += m * (float)sideVec.x;
                    thismassCentreY += m * (float)sideVec.y;
                    thismassCentreZ += m * (float)sideVec.z;
                    thismass += m;
                    thismoment += m * (float)(sideVec.x * sideVec.x + sideVec.z * sideVec.z);
                    if (!(b instanceof BlockSpinThruster) || RedstoneUtil.isBlockReceivingRedstone(this.worldProvider.field_76579_a, sideVec.toBlockPos())) continue;
                    foundThrusters.add(sideVec.toBlockPos());
                }
            }
            currentLayer = nextLayer;
            nextLayer = new LinkedList();
        }
        if (placingThruster && !this.checked.contains(new BlockVec3(baseBlock))) {
            if (foundThrusters.size() > 0) {
                if (ConfigManagerCore.enableDebug) {
                    GCLog.info("Thruster placed on wrong part of space station: base at " + this.oneSSBlock + " - baseBlock was " + baseBlock + " - found " + foundThrusters.size());
                }
                return false;
            }
            if (!this.oneSSBlock.equals((Object)baseBlock)) {
                this.oneSSBlock = baseBlock;
                IBlockState state = this.worldProvider.field_76579_a.func_180495_p(this.oneSSBlock);
                if (state.func_177230_c().func_149688_o(state) != Material.field_151579_a) {
                    return this.refresh(baseBlock, true);
                }
            }
            return false;
        }
        this.thrustersPlus.clear();
        this.thrustersMinus.clear();
        for (BlockPos thruster : foundThrusters) {
            IBlockState state = this.worldProvider.field_76579_a.func_180495_p(thruster);
            int facing = state.func_177230_c().func_176201_c(state) & 8;
            if (facing == 0) {
                this.thrustersPlus.add(thruster);
                continue;
            }
            this.thrustersMinus.add(thruster);
        }
        float mass = thismass;
        this.massCentreX = thismassCentreX / thismass + 0.5f;
        float massCentreY = thismassCentreY / thismass + 0.5f;
        this.massCentreZ = thismassCentreZ / thismass + 0.5f;
        this.setSpinCentre(this.massCentreX, this.massCentreZ);
        this.ssBoundsMaxX = thisssBoundsMaxX + 1;
        this.ssBoundsMinX = thisssBoundsMinX;
        this.ssBoundsMaxY = thisssBoundsMaxY + 1;
        this.ssBoundsMinY = thisssBoundsMinY;
        this.ssBoundsMaxZ = thisssBoundsMaxZ + 1;
        this.ssBoundsMinZ = thisssBoundsMinZ;
        thismoment -= this.massCentreX * this.massCentreX * mass;
        this.momentOfInertia = thismoment -= this.massCentreZ * this.massCentreZ * mass;
        GCLog.debug("MoI = " + this.momentOfInertia + " CoMx = " + this.massCentreX + " CoMz = " + this.massCentreZ);
        ArrayList<Object> objList = new ArrayList<Object>();
        objList.add(this.spinCentreX);
        objList.add(this.spinCentreZ);
        GalacticraftCore.packetPipeline.sendToDimension(new PacketSimple(PacketSimple.EnumSimplePacket.C_UPDATE_STATION_DATA, GCCoreUtil.getDimensionID(this.worldProvider), objList), GCCoreUtil.getDimensionID(this.worldProvider));
        objList = new ArrayList();
        objList.add(this.ssBoundsMinX);
        objList.add(this.ssBoundsMaxX);
        objList.add(this.ssBoundsMinY);
        objList.add(this.ssBoundsMaxY);
        objList.add(this.ssBoundsMinZ);
        objList.add(this.ssBoundsMaxZ);
        GalacticraftCore.packetPipeline.sendToDimension(new PacketSimple(PacketSimple.EnumSimplePacket.C_UPDATE_STATION_BOX, GCCoreUtil.getDimensionID(this.worldProvider), objList), GCCoreUtil.getDimensionID(this.worldProvider));
        this.updateSpinSpeed();
        return true;
    }

    public void updateSpinSpeed() {
        if (this.momentOfInertia > 0.0f) {
            float zz;
            float xx;
            float netTorque = 0.0f;
            int countThrusters = 0;
            int countThrustersReverse = 0;
            for (BlockPos thruster : this.thrustersPlus) {
                xx = (float)thruster.func_177958_n() - this.massCentreX;
                zz = (float)thruster.func_177952_p() - this.massCentreZ;
                netTorque += MathHelper.func_76129_c((float)(xx * xx + zz * zz));
                ++countThrusters;
            }
            for (BlockPos thruster : this.thrustersMinus) {
                xx = (float)thruster.func_177958_n() - this.massCentreX;
                zz = (float)thruster.func_177952_p() - this.massCentreZ;
                netTorque -= MathHelper.func_76129_c((float)(xx * xx + zz * zz));
                ++countThrustersReverse;
            }
            if (countThrusters == countThrustersReverse) {
                this.angularVelocityAccel = 4.0E-6f;
                this.angularVelocityTarget = 0.0f;
            } else {
                if ((countThrusters += countThrustersReverse) > 4) {
                    countThrusters = 4;
                }
                float maxRx = Math.max((float)this.ssBoundsMaxX - this.massCentreX, this.massCentreX - (float)this.ssBoundsMinX);
                float maxRz = Math.max((float)this.ssBoundsMaxZ - this.massCentreZ, this.massCentreZ - (float)this.ssBoundsMinZ);
                float maxR = Math.max(maxRx, maxRz);
                this.angularVelocityTarget = MathHelper.func_76129_c((float)(0.024525002f / maxR)) / 2.0f;
                float spinCap = 0.00125f * (float)countThrusters;
                this.angularVelocityAccel = netTorque / this.momentOfInertia / 20.0f;
                if (this.angularVelocityAccel < 0.0f) {
                    this.angularVelocityAccel = -this.angularVelocityAccel;
                    this.angularVelocityTarget = -this.angularVelocityTarget;
                    if (this.angularVelocityTarget < -spinCap) {
                        this.angularVelocityTarget = -spinCap;
                    }
                } else if (this.angularVelocityTarget > spinCap) {
                    this.angularVelocityTarget = spinCap;
                }
                if (ConfigManagerCore.enableDebug) {
                    GCLog.info("MaxR = " + maxR + " Angular vel = " + this.angularVelocityTarget + " Angular accel = " + this.angularVelocityAccel);
                }
            }
        }
        if (!this.clientSide) {
            this.save();
        }
    }

    public void updateSpin() {
        if (!this.clientSide) {
            if (this.dataNotLoaded) {
                this.savefile = OrbitSpinSaveData.initWorldData(this.worldProvider.field_76579_a);
                this.readFromNBT(this.savefile.datacompound);
                if (ConfigManagerCore.enableDebug) {
                    GCLog.info("Loading data from save: " + this.savefile.datacompound.func_74760_g("omegaSky"));
                }
                this.dataNotLoaded = false;
            }
            if (this.doSpinning) {
                float newAngle;
                boolean updateNeeded = true;
                if (this.angularVelocityTarget < this.angularVelocityRadians) {
                    newAngle = this.angularVelocityRadians - this.angularVelocityAccel;
                    if (newAngle < this.angularVelocityTarget) {
                        newAngle = this.angularVelocityTarget;
                    }
                    this.setSpinRate(newAngle);
                    this.thrustersFiring = true;
                } else if (this.angularVelocityTarget > this.angularVelocityRadians) {
                    newAngle = this.angularVelocityRadians + this.angularVelocityAccel;
                    if (newAngle > this.angularVelocityTarget) {
                        newAngle = this.angularVelocityTarget;
                    }
                    this.setSpinRate(newAngle);
                    this.thrustersFiring = true;
                } else if (this.thrustersFiring) {
                    this.thrustersFiring = false;
                } else {
                    updateNeeded = false;
                }
                if (updateNeeded) {
                    this.writeToNBT(this.savefile.datacompound);
                    this.savefile.func_76185_a();
                    ArrayList<Object> objList = new ArrayList<Object>();
                    objList.add(Float.valueOf(this.angularVelocityRadians));
                    objList.add(this.thrustersFiring);
                    GalacticraftCore.packetPipeline.sendToDimension(new PacketSimple(PacketSimple.EnumSimplePacket.C_UPDATE_STATION_SPIN, GCCoreUtil.getDimensionID(this.worldProvider), objList), GCCoreUtil.getDimensionID(this.worldProvider));
                }
            }
            this.loadedEntities.clear();
            this.loadedEntities.addAll(this.worldProvider.field_76579_a.field_72996_f);
            for (Entity e : this.loadedEntities) {
                boolean outsideStation;
                if (!(e instanceof EntityItem) && (!(e instanceof EntityLivingBase) || e instanceof EntityPlayer) && !(e instanceof EntityTNTPrimed) && !(e instanceof EntityFallingBlock) || e.field_70122_E) continue;
                AxisAlignedBB entityBoundingBox = e.func_174813_aQ();
                boolean bl = outsideStation = entityBoundingBox.field_72336_d < (double)this.ssBoundsMinX || entityBoundingBox.field_72340_a > (double)this.ssBoundsMaxX || entityBoundingBox.field_72337_e < (double)this.ssBoundsMinY || entityBoundingBox.field_72338_b > (double)this.ssBoundsMaxY || entityBoundingBox.field_72334_f < (double)this.ssBoundsMinZ || entityBoundingBox.field_72339_c > (double)this.ssBoundsMaxZ;
                if (outsideStation || FreefallHandler.testEntityFreefall(this.worldProvider.field_76579_a, entityBoundingBox)) {
                    if (this.doSpinning) {
                        this.moveRotatedEntity(e, this.spinCentreX, this.spinCentreZ, this.angularVelocityRadians);
                    }
                    FreefallHandler.tickFreefallEntity(e);
                    if (!(e instanceof ITumblable)) continue;
                    ((ITumblable)e).setTumbling(3.0f);
                    continue;
                }
                if (!(e instanceof ITumblable)) continue;
                ((ITumblable)e).setTumbling(0.0f);
            }
        }
    }

    private void moveRotatedEntity(Entity e, double rotationCentreX, double rotationCentreZ, float deltaTheta) {
        if (deltaTheta != 0.0f) {
            double xx = e.field_70165_t - rotationCentreX;
            double zz = e.field_70161_v - rotationCentreZ;
            double arc = Math.sqrt(xx * xx + zz * zz);
            float angle = xx == 0.0 ? (zz > 0.0 ? 1.5707964f : -1.5707964f) : (float)Math.atan(zz / xx);
            if (xx < 0.0) {
                angle += (float)Math.PI;
            }
            double offsetX = -(arc *= (double)deltaTheta) * (double)MathHelper.func_76126_a((float)(angle += deltaTheta / 3.0f));
            double offsetZ = arc * (double)MathHelper.func_76134_b((float)angle);
            e.field_70165_t += offsetX;
            e.field_70161_v += offsetZ;
            e.field_70142_S += offsetX;
            e.field_70136_U += offsetZ;
            if (!e.field_70170_p.func_175667_e(new BlockPos(MathHelper.func_76128_c((double)e.field_70165_t), 64, MathHelper.func_76128_c((double)e.field_70161_v)))) {
                e.func_70106_y();
                return;
            }
            e.func_174826_a(e.func_174813_aQ().func_72317_d(offsetX, 0.0, offsetZ));
            e.field_70177_z += this.skyAngularVelocity;
            while (e.field_70177_z > 360.0f) {
                e.field_70177_z -= 360.0f;
            }
            double velocity = Math.sqrt(e.field_70159_w * e.field_70159_w + e.field_70179_y * e.field_70179_y);
            angle = e.field_70159_w == 0.0 ? (e.field_70179_y > 0.0 ? 1.5707964f : -1.5707964f) : (float)Math.atan(e.field_70179_y / e.field_70159_w);
            if (e.field_70159_w < 0.0) {
                angle += (float)Math.PI;
            }
            e.field_70159_w = velocity * (double)MathHelper.func_76134_b((float)(angle += deltaTheta));
            e.field_70179_y = velocity * (double)MathHelper.func_76126_a((float)angle);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean updatePlayerForSpin(EntityPlayerSP p, float partial) {
        float angleDelta = partial * this.angularVelocityRadians;
        if (this.doSpinning && angleDelta != 0.0f) {
            boolean doCentrifugal = false;
            double xx = p.field_70165_t - this.spinCentreX;
            double zz = p.field_70161_v - this.spinCentreZ;
            double arc = Math.sqrt(xx * xx + zz * zz);
            float angle = xx == 0.0 ? (zz > 0.0 ? 1.5707964f : -1.5707964f) : (float)Math.atan(zz / xx);
            if (xx < 0.0) {
                angle += (float)Math.PI;
            }
            double offsetX = -(arc *= (double)angleDelta) * Math.sin(angle += angleDelta / 3.0f);
            double offsetZ = arc * Math.cos(angle);
            if (p.field_70170_p.func_184144_a((Entity)p, p.func_174813_aQ()).size() == 0) {
                int collisions = 0;
                do {
                    List list;
                    if ((collisions = (list = p.field_70170_p.func_184144_a((Entity)p, p.func_174813_aQ().func_72321_a(offsetX, 0.0, offsetZ))).size()) <= 0) continue;
                    if (!doCentrifugal) {
                        p.field_70159_w += -offsetX;
                        p.field_70179_y += -offsetZ;
                    }
                    offsetX /= 2.0;
                    offsetZ /= 2.0;
                    if (offsetX < 0.01 && offsetX > -0.01) {
                        offsetX = 0.0;
                    }
                    if (offsetZ < 0.01 && offsetZ > -0.01) {
                        offsetZ = 0.0;
                    }
                    doCentrifugal = true;
                } while (collisions > 0);
                p.field_70165_t += offsetX;
                p.field_70161_v += offsetZ;
                p.func_174826_a(p.func_174813_aQ().func_72317_d(offsetX, 0.0, offsetZ));
            }
            p.field_70177_z += this.skyAngularVelocity * partial;
            p.field_70761_aq += this.skyAngularVelocity * partial;
            while (p.field_70177_z > 360.0f) {
                p.field_70177_z -= 360.0f;
            }
            while (p.field_70177_z < 0.0f) {
                p.field_70177_z += 360.0f;
            }
            return doCentrifugal;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void applyCentrifugalForce(EntityPlayerSP p) {
        int quadrant = 0;
        double xd = p.field_70165_t - this.spinCentreX;
        double zd = p.field_70161_v - this.spinCentreZ;
        double accel = Math.sqrt(xd * xd + zd * zd) * (double)this.angularVelocityRadians * (double)this.angularVelocityRadians * 4.0;
        quadrant = xd < 0.0 ? (xd < -Math.abs(zd) ? 2 : (zd < 0.0 ? 3 : 1)) : (xd > Math.abs(zd) ? 0 : (zd < 0.0 ? 3 : 1));
        switch (quadrant) {
            case 0: {
                p.field_70159_w += accel;
                break;
            }
            case 1: {
                p.field_70179_y += accel;
                break;
            }
            case 2: {
                p.field_70159_w -= accel;
                break;
            }
            default: {
                p.field_70179_y -= accel;
            }
        }
    }

    public void sendPackets(EntityPlayerMP player) {
        ArrayList<Object> objList = new ArrayList<Object>();
        objList.add(Float.valueOf(this.angularVelocityRadians));
        objList.add(this.thrustersFiring);
        if (player == null) {
            GalacticraftCore.packetPipeline.sendToDimension(new PacketSimple(PacketSimple.EnumSimplePacket.C_UPDATE_STATION_SPIN, GCCoreUtil.getDimensionID(this.worldProvider), objList), GCCoreUtil.getDimensionID(this.worldProvider));
        } else {
            GalacticraftCore.packetPipeline.sendTo(new PacketSimple(PacketSimple.EnumSimplePacket.C_UPDATE_STATION_SPIN, GCCoreUtil.getDimensionID(player.field_70170_p), objList), player);
        }
        objList = new ArrayList();
        objList.add(this.spinCentreX);
        objList.add(this.spinCentreZ);
        if (player == null) {
            GalacticraftCore.packetPipeline.sendToDimension(new PacketSimple(PacketSimple.EnumSimplePacket.C_UPDATE_STATION_DATA, GCCoreUtil.getDimensionID(this.worldProvider), objList), GCCoreUtil.getDimensionID(this.worldProvider));
        } else {
            GalacticraftCore.packetPipeline.sendTo(new PacketSimple(PacketSimple.EnumSimplePacket.C_UPDATE_STATION_DATA, GCCoreUtil.getDimensionID(player.field_70170_p), objList), player);
        }
        objList = new ArrayList();
        objList.add(this.ssBoundsMinX);
        objList.add(this.ssBoundsMaxX);
        objList.add(this.ssBoundsMinY);
        objList.add(this.ssBoundsMaxY);
        objList.add(this.ssBoundsMinZ);
        objList.add(this.ssBoundsMaxZ);
        if (player == null) {
            GalacticraftCore.packetPipeline.sendToDimension(new PacketSimple(PacketSimple.EnumSimplePacket.C_UPDATE_STATION_BOX, GCCoreUtil.getDimensionID(this.worldProvider), objList), GCCoreUtil.getDimensionID(this.worldProvider));
        } else {
            GalacticraftCore.packetPipeline.sendTo(new PacketSimple(PacketSimple.EnumSimplePacket.C_UPDATE_STATION_BOX, GCCoreUtil.getDimensionID(player.field_70170_p), objList), player);
        }
    }

    private void save() {
        if (this.savefile == null) {
            this.savefile = OrbitSpinSaveData.initWorldData(this.worldProvider.field_76579_a);
            this.dataNotLoaded = false;
        } else {
            this.writeToNBT(this.savefile.datacompound);
            this.savefile.func_76185_a();
        }
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.doSpinning = true;
        this.angularVelocityRadians = nbt.func_74760_g("omegaRad");
        this.skyAngularVelocity = nbt.func_74760_g("omegaSky");
        this.angularVelocityTarget = nbt.func_74760_g("omegaTarget");
        this.angularVelocityAccel = nbt.func_74760_g("omegaAcc");
        NBTTagCompound oneBlock = (NBTTagCompound)nbt.func_74781_a("oneBlock");
        this.oneSSBlock = oneBlock != null ? new BlockPos(oneBlock.func_74762_e("x"), oneBlock.func_74762_e("y"), oneBlock.func_74762_e("z")) : null;
        this.refresh(this.oneSSBlock, false);
        this.sendPackets(null);
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt.func_74757_a("doSpinning", this.doSpinning);
        nbt.func_74776_a("omegaRad", this.angularVelocityRadians);
        nbt.func_74776_a("omegaSky", this.skyAngularVelocity);
        nbt.func_74776_a("omegaTarget", this.angularVelocityTarget);
        nbt.func_74776_a("omegaAcc", this.angularVelocityAccel);
        if (this.oneSSBlock != null) {
            NBTTagCompound oneBlock = new NBTTagCompound();
            oneBlock.func_74768_a("x", this.oneSSBlock.func_177958_n());
            oneBlock.func_74768_a("y", this.oneSSBlock.func_177956_o());
            oneBlock.func_74768_a("z", this.oneSSBlock.func_177952_p());
            nbt.func_74782_a("oneBlock", (NBTBase)oneBlock);
        }
        return nbt;
    }
}

