/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.client.jei;

import javax.annotation.Nonnull;
import mezz.jei.api.BlankModPlugin;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.api.recipe.IRecipeWrapperFactory;
import mezz.jei.api.recipe.IStackHelper;
import micdoodle8.mods.galacticraft.api.GalacticraftRegistry;
import micdoodle8.mods.galacticraft.api.recipe.CompressorRecipes;
import micdoodle8.mods.galacticraft.api.recipe.INasaWorkbenchRecipe;
import micdoodle8.mods.galacticraft.api.recipe.ShapedRecipesGC;
import micdoodle8.mods.galacticraft.api.recipe.ShapelessOreRecipeGC;
import micdoodle8.mods.galacticraft.core.GCBlocks;
import micdoodle8.mods.galacticraft.core.GCItems;
import micdoodle8.mods.galacticraft.core.client.jei.buggy.BuggyRecipeCategory;
import micdoodle8.mods.galacticraft.core.client.jei.buggy.BuggyRecipeWrapper;
import micdoodle8.mods.galacticraft.core.client.jei.circuitfabricator.CircuitFabricatorRecipeCategory;
import micdoodle8.mods.galacticraft.core.client.jei.circuitfabricator.CircuitFabricatorRecipeMaker;
import micdoodle8.mods.galacticraft.core.client.jei.circuitfabricator.CircuitFabricatorRecipeWrapper;
import micdoodle8.mods.galacticraft.core.client.jei.ingotcompressor.IngotCompressorRecipeCategory;
import micdoodle8.mods.galacticraft.core.client.jei.ingotcompressor.IngotCompressorShapedRecipeWrapper;
import micdoodle8.mods.galacticraft.core.client.jei.ingotcompressor.IngotCompressorShapelessRecipeWrapper;
import micdoodle8.mods.galacticraft.core.client.jei.refinery.RefineryRecipeCategory;
import micdoodle8.mods.galacticraft.core.client.jei.refinery.RefineryRecipeMaker;
import micdoodle8.mods.galacticraft.core.client.jei.refinery.RefineryRecipeWrapper;
import micdoodle8.mods.galacticraft.core.client.jei.tier1rocket.Tier1RocketRecipeCategory;
import micdoodle8.mods.galacticraft.core.client.jei.tier1rocket.Tier1RocketRecipeWrapper;
import net.minecraft.item.ItemStack;

@JEIPlugin
public class GalacticraftJEI
extends BlankModPlugin {
    public void register(@Nonnull IModRegistry registry) {
        IGuiHelper guiHelper = registry.getJeiHelpers().getGuiHelper();
        final IStackHelper stackHelper = registry.getJeiHelpers().getStackHelper();
        registry.addRecipeCategories(new IRecipeCategory[]{new Tier1RocketRecipeCategory(guiHelper), new BuggyRecipeCategory(guiHelper), new CircuitFabricatorRecipeCategory(guiHelper), new IngotCompressorRecipeCategory(guiHelper), new RefineryRecipeCategory(guiHelper)});
        registry.handleRecipes(INasaWorkbenchRecipe.class, Tier1RocketRecipeWrapper::new, "galacticraft.rocketT1");
        registry.handleRecipes(INasaWorkbenchRecipe.class, BuggyRecipeWrapper::new, "galacticraft.buggy");
        registry.handleRecipes(CircuitFabricatorRecipeWrapper.class, recipe -> recipe, "galacticraft.circuits");
        registry.handleRecipes(ShapedRecipesGC.class, IngotCompressorShapedRecipeWrapper::new, "galacticraft.ingotcompressor");
        registry.handleRecipes(ShapelessOreRecipeGC.class, (IRecipeWrapperFactory)new IRecipeWrapperFactory<ShapelessOreRecipeGC>(){

            public IRecipeWrapper getRecipeWrapper(ShapelessOreRecipeGC recipe) {
                return new IngotCompressorShapelessRecipeWrapper(stackHelper, recipe);
            }
        }, "galacticraft.ingotcompressor");
        registry.handleRecipes(RefineryRecipeWrapper.class, recipe -> recipe, "galacticraft.refinery");
        registry.addRecipes(GalacticraftRegistry.getRocketT1Recipes(), "galacticraft.rocketT1");
        registry.addRecipes(GalacticraftRegistry.getBuggyBenchRecipes(), "galacticraft.buggy");
        registry.addRecipes(CircuitFabricatorRecipeMaker.getRecipesList(), "galacticraft.circuits");
        registry.addRecipes(CompressorRecipes.getRecipeList(), "galacticraft.ingotcompressor");
        registry.addRecipes(RefineryRecipeMaker.getRecipesList(), "galacticraft.refinery");
        ItemStack nasaWorkbench = new ItemStack(GCBlocks.nasaWorkbench);
        registry.addRecipeCategoryCraftingItem(nasaWorkbench, new String[]{"galacticraft.rocketT1"});
        registry.addRecipeCategoryCraftingItem(nasaWorkbench, new String[]{"galacticraft.buggy"});
        registry.addRecipeCategoryCraftingItem(new ItemStack(GCBlocks.machineBase2, 1, 4), new String[]{"galacticraft.circuits"});
        registry.addRecipeCategoryCraftingItem(new ItemStack(GCBlocks.machineBase, 1, 12), new String[]{"galacticraft.ingotcompressor"});
        registry.addRecipeCategoryCraftingItem(new ItemStack(GCBlocks.refinery), new String[]{"galacticraft.refinery"});
        GCItems.hideItemsJEI(registry.getJeiHelpers().getItemBlacklist());
    }
}

