/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.client.gui.screen;

import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.imageio.ImageIO;
import micdoodle8.mods.galacticraft.api.vector.Vector2;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.core.Constants;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.client.gui.element.GuiElementCheckbox;
import micdoodle8.mods.galacticraft.core.client.gui.element.GuiElementGradientButton;
import micdoodle8.mods.galacticraft.core.client.gui.element.GuiElementGradientList;
import micdoodle8.mods.galacticraft.core.client.gui.element.GuiElementSlider;
import micdoodle8.mods.galacticraft.core.client.gui.element.GuiElementTextBox;
import micdoodle8.mods.galacticraft.core.client.model.ModelFlag;
import micdoodle8.mods.galacticraft.core.dimension.SpaceRace;
import micdoodle8.mods.galacticraft.core.dimension.SpaceRaceManager;
import micdoodle8.mods.galacticraft.core.entities.EntityFlag;
import micdoodle8.mods.galacticraft.core.network.PacketSimple;
import micdoodle8.mods.galacticraft.core.util.ColorUtil;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.core.wrappers.FlagData;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.FMLClientHandler;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiNewSpaceRace
extends GuiScreen
implements GuiElementCheckbox.ICheckBoxCallback,
GuiElementTextBox.ITextBoxCallback {
    protected static final ResourceLocation texture = new ResourceLocation(Constants.ASSET_PREFIX, "textures/gui/gui.png");
    private int ticksPassed;
    private EntityPlayer thePlayer;
    private GuiElementCheckbox checkboxPaintbrush;
    private GuiElementCheckbox checkboxShowGrid;
    private GuiElementCheckbox checkboxEraser;
    private GuiElementCheckbox checkboxSelector;
    private GuiElementCheckbox checkboxColorSelector;
    private GuiElementTextBox textBoxRename;
    private boolean initialized;
    private GuiElementSlider sliderColorR;
    private GuiElementSlider sliderColorG;
    private GuiElementSlider sliderColorB;
    private GuiElementSlider sliderBrushSize;
    private GuiElementSlider sliderEraserSize;
    private GuiElementGradientList gradientListAddPlayers;
    private GuiElementGradientList gradientListRemovePlayers;
    private EnumSpaceRaceGui currentState = EnumSpaceRaceGui.MAIN;
    private int buttonFlag_width;
    private int buttonFlag_height;
    private int buttonFlag_xPosition;
    private int buttonFlag_yPosition;
    private boolean buttonFlag_hover;
    private int buttonTeamColor_width;
    private int buttonTeamColor_height;
    private int buttonTeamColor_xPosition;
    private int buttonTeamColor_yPosition;
    private boolean buttonTeamColor_hover;
    private Vector2 flagDesignerScale = new Vector2();
    private float flagDesignerMinX;
    private float flagDesignerMinY;
    private float flagDesignerWidth;
    private float flagDesignerHeight;
    private int selectionMinX;
    private int selectionMaxX;
    private int selectionMinY;
    private int selectionMaxY;
    private EntityFlag dummyFlag;
    private ModelFlag dummyModel;
    private SpaceRace spaceRaceData;
    public Map<String, Integer> recentlyInvited;
    private boolean lastMousePressed;
    private boolean isDirty;
    private boolean canEdit;

    public GuiNewSpaceRace(EntityPlayer player) {
        this.dummyFlag = new EntityFlag((World)FMLClientHandler.instance().getClient().field_71441_e);
        this.dummyModel = new ModelFlag();
        this.recentlyInvited = new HashMap<String, Integer>();
        this.lastMousePressed = false;
        this.isDirty = true;
        this.thePlayer = player;
        SpaceRace race = SpaceRaceManager.getSpaceRaceFromPlayer(player.func_146103_bH().getName());
        if (race != null) {
            this.spaceRaceData = race;
        } else {
            ArrayList<String> playerList = new ArrayList<String>();
            playerList.add(player.func_146103_bH().getName());
            this.spaceRaceData = new SpaceRace(playerList, "gui.space_race.unnamed", new FlagData(48, 32), new Vector3(1.0, 1.0, 1.0));
        }
        this.field_146297_k = FMLClientHandler.instance().getClient();
        this.canEdit = this.canPlayerEdit();
    }

    private boolean canPlayerEdit() {
        return this.field_146297_k.field_71439_g.func_146103_bH().getName().equals(this.spaceRaceData.getPlayerNames().get(0));
    }

    public void func_73866_w_() {
        float sliderR = 0.0f;
        float sliderG = 0.0f;
        float sliderB = 0.0f;
        if (this.sliderColorR != null && this.sliderColorG != null && this.sliderColorB != null) {
            sliderR = (float)this.sliderColorR.getSliderPos() / (float)this.sliderColorR.getButtonHeight();
            sliderG = (float)this.sliderColorG.getSliderPos() / (float)this.sliderColorG.getButtonHeight();
            sliderB = (float)this.sliderColorB.getSliderPos() / (float)this.sliderColorB.getButtonHeight();
        }
        super.func_73866_w_();
        this.field_146292_n.clear();
        if (this.initialized) {
            this.buttonFlag_width = 81;
            this.buttonFlag_height = 58;
            this.buttonFlag_xPosition = this.field_146294_l / 2 - this.buttonFlag_width / 2;
            this.buttonFlag_yPosition = this.field_146295_m / 2 - this.field_146295_m / 3 + 10;
            this.buttonTeamColor_width = 45;
            this.buttonTeamColor_height = 45;
            this.buttonTeamColor_xPosition = this.buttonFlag_xPosition + this.buttonFlag_width + 10;
            this.buttonTeamColor_yPosition = this.buttonFlag_yPosition + this.buttonFlag_height / 2 - this.buttonTeamColor_height / 2;
            this.field_146292_n.add(new GuiElementGradientButton(0, this.field_146294_l / 2 - this.field_146294_l / 3 + 15, this.field_146295_m / 2 - this.field_146295_m / 4 - 15, 50, 15, this.currentState == EnumSpaceRaceGui.MAIN ? GCCoreUtil.translate("gui.space_race.create.close.name") : GCCoreUtil.translate("gui.space_race.create.back.name")));
            switch (this.currentState) {
                case MAIN: {
                    this.textBoxRename = new GuiElementTextBox(1, this, this.field_146294_l / 2 - 75, this.buttonFlag_yPosition + this.buttonFlag_height + 10, 150, 16, GCCoreUtil.translate("gui.space_race.create.rename.name"), false, 25, true);
                    this.field_146292_n.add(this.textBoxRename);
                    if (this.canEdit) {
                        this.field_146292_n.add(new GuiElementGradientButton(2, this.field_146294_l / 2 - 120, this.textBoxRename.field_146129_i + this.field_146295_m / 10, 100, this.field_146295_m / 10, GCCoreUtil.translate("gui.space_race.create.add_players.name")));
                        this.field_146292_n.add(new GuiElementGradientButton(3, this.field_146294_l / 2 - 120, this.textBoxRename.field_146129_i + this.field_146295_m / 10 + this.field_146295_m / 10 + this.field_146295_m / 50, 100, this.field_146295_m / 10, GCCoreUtil.translate("gui.space_race.create.rem_players.name")));
                    }
                    GuiElementGradientButton localStats = new GuiElementGradientButton(4, this.field_146294_l / 2 + (this.canEdit ? 20 : -50), this.textBoxRename.field_146129_i + this.field_146295_m / 10, 100, this.field_146295_m / 10, GCCoreUtil.translate("gui.space_race.create.server_stats.name"));
                    GuiElementGradientButton serverStats = new GuiElementGradientButton(5, this.field_146294_l / 2 + (this.canEdit ? 20 : -50), this.textBoxRename.field_146129_i + this.field_146295_m / 10 + this.field_146295_m / 10 + this.field_146295_m / 50, 100, this.field_146295_m / 10, GCCoreUtil.translate("gui.space_race.create.global_stats.name"));
                    localStats.field_146124_l = false;
                    serverStats.field_146124_l = false;
                    this.field_146292_n.add(localStats);
                    this.field_146292_n.add(serverStats);
                    break;
                }
                case ADD_PLAYER: {
                    this.field_146292_n.add(new GuiElementGradientButton(2, this.field_146294_l / 2 - this.field_146294_l / 3 + 7, this.field_146295_m / 2 + this.field_146295_m / 4 - 15, 64, 15, GCCoreUtil.translate("gui.space_race.create.send_invite.name")));
                    int xPos0 = ((GuiElementGradientButton)((Object)this.field_146292_n.get((int)0))).field_146128_h + ((GuiElementGradientButton)((Object)this.field_146292_n.get(0))).func_146117_b() + 10;
                    int xPos1 = this.field_146294_l / 2 + this.field_146294_l / 3 - 10;
                    int yPos0 = this.field_146295_m / 2 - this.field_146295_m / 3 + 10;
                    int yPos1 = this.field_146295_m / 2 + this.field_146295_m / 3 - 10;
                    this.gradientListAddPlayers = new GuiElementGradientList(xPos0, yPos0, xPos1 - xPos0, yPos1 - yPos0);
                    break;
                }
                case REMOVE_PLAYER: {
                    this.field_146292_n.add(new GuiElementGradientButton(2, this.field_146294_l / 2 - this.field_146294_l / 3 + 7, this.field_146295_m / 2 + this.field_146295_m / 4 - 15, 64, 15, GCCoreUtil.translate("gui.space_race.create.remove.name")));
                    int xPos0b = ((GuiElementGradientButton)((Object)this.field_146292_n.get((int)0))).field_146128_h + ((GuiElementGradientButton)((Object)this.field_146292_n.get(0))).func_146117_b() + 10;
                    int xPos1b = this.field_146294_l / 2 + this.field_146294_l / 3 - 10;
                    int yPos0b = this.field_146295_m / 2 - this.field_146295_m / 3 + 10;
                    int yPos1b = this.field_146295_m / 2 + this.field_146295_m / 3 - 10;
                    this.gradientListRemovePlayers = new GuiElementGradientList(xPos0b, yPos0b, xPos1b - xPos0b, yPos1b - yPos0b);
                    break;
                }
                case DESIGN_FLAG: {
                    int guiBottom = this.field_146295_m / 2 + this.field_146295_m / 4;
                    int guiTop = this.field_146295_m / 2 - this.field_146295_m / 4;
                    int guiRight = this.field_146294_l / 2 + this.field_146294_l / 3;
                    this.flagDesignerScale = new Vector2((float)this.field_146294_l / 130.0f, (float)this.field_146295_m / 70.0f);
                    this.flagDesignerMinX = (float)(this.field_146294_l / 2) - (float)this.spaceRaceData.getFlagData().getWidth() * (float)this.flagDesignerScale.x / 2.0f;
                    this.flagDesignerMinY = (float)(this.field_146295_m / 2) - (float)this.spaceRaceData.getFlagData().getHeight() * (float)this.flagDesignerScale.y / 2.0f;
                    this.flagDesignerWidth = (float)this.spaceRaceData.getFlagData().getWidth() * (float)this.flagDesignerScale.x;
                    this.flagDesignerHeight = (float)this.spaceRaceData.getFlagData().getHeight() * (float)this.flagDesignerScale.y;
                    int flagDesignerRight = (int)(this.flagDesignerMinX + this.flagDesignerWidth);
                    int availWidth = (int)(((float)(guiRight - 10) - (this.flagDesignerMinX + this.flagDesignerWidth + 10.0f)) / 3.0f);
                    float x1 = flagDesignerRight + 10;
                    float x2 = guiRight - 10;
                    float y1 = (float)(guiBottom - 10) - (x2 - x1);
                    int height = (int)(y1 - 10.0f - (float)(guiTop + 10));
                    this.sliderColorR = new GuiElementSlider(1, flagDesignerRight + 10, guiTop + 10, availWidth, height, true, new Vector3(0.0, 0.0, 0.0), new Vector3(1.0, 0.0, 0.0));
                    this.sliderColorG = new GuiElementSlider(2, flagDesignerRight + 11 + availWidth, guiTop + 10, availWidth, height, true, new Vector3(0.0, 0.0, 0.0), new Vector3(0.0, 1.0, 0.0));
                    this.sliderColorB = new GuiElementSlider(3, flagDesignerRight + 12 + availWidth * 2, guiTop + 10, availWidth, height, true, new Vector3(0.0, 0.0, 0.0), new Vector3(0.0, 0.0, 1.0));
                    this.sliderColorR.setSliderPos(sliderR);
                    this.sliderColorG.setSliderPos(sliderG);
                    this.sliderColorB.setSliderPos(sliderB);
                    this.field_146292_n.add(this.sliderColorR);
                    this.field_146292_n.add(this.sliderColorG);
                    this.field_146292_n.add(this.sliderColorB);
                    this.checkboxPaintbrush = new GuiElementCheckbox(5, this, (int)(this.flagDesignerMinX - 15.0f), this.field_146295_m / 2 - this.field_146295_m / 4 + 10, 13, 13, 26, 26, 133, 0, "", 0x404040, false);
                    this.checkboxEraser = new GuiElementCheckbox(6, this, (int)(this.flagDesignerMinX - 15.0f), this.field_146295_m / 2 - this.field_146295_m / 4 + 25, 13, 13, 26, 26, 133, 52, "", 0x404040, false);
                    this.checkboxSelector = new GuiElementCheckbox(7, this, (int)(this.flagDesignerMinX - 15.0f), this.field_146295_m / 2 - this.field_146295_m / 4 + 40, 13, 13, 26, 26, 133, 78, "", 0x404040, false);
                    this.checkboxColorSelector = new GuiElementCheckbox(8, this, (int)(this.flagDesignerMinX - 15.0f), this.field_146295_m / 2 - this.field_146295_m / 4 + 55, 13, 13, 26, 26, 133, 104, "", 0x404040, false);
                    this.checkboxShowGrid = new GuiElementCheckbox(9, this, (int)(this.flagDesignerMinX - 15.0f), this.field_146295_m / 2 - this.field_146295_m / 4 + 90, 13, 13, 26, 26, 133, 26, "", 0x404040, false);
                    this.sliderBrushSize = new GuiElementSlider(10, this.checkboxPaintbrush.field_146128_h - 40, this.checkboxPaintbrush.field_146129_i, 35, 13, false, new Vector3(0.34, 0.34, 0.34), new Vector3(0.34, 0.34, 0.34), GCCoreUtil.translate("gui.space_race.create.brush_size.name"));
                    this.sliderEraserSize = new GuiElementSlider(11, this.checkboxEraser.field_146128_h - 40, this.checkboxEraser.field_146129_i, 35, 13, false, new Vector3(0.34, 0.34, 0.34), new Vector3(0.34, 0.34, 0.34), GCCoreUtil.translate("gui.space_race.create.eraser_size.name"));
                    this.sliderEraserSize.field_146125_m = false;
                    this.field_146292_n.add(this.checkboxPaintbrush);
                    this.field_146292_n.add(this.checkboxShowGrid);
                    this.field_146292_n.add(this.checkboxEraser);
                    this.field_146292_n.add(this.checkboxSelector);
                    this.field_146292_n.add(this.checkboxColorSelector);
                    this.field_146292_n.add(this.sliderBrushSize);
                    this.field_146292_n.add(this.sliderEraserSize);
                    break;
                }
                case CHANGE_TEAM_COLOR: {
                    int guiBottom = this.field_146295_m / 2 + this.field_146295_m / 4;
                    int guiTop = this.field_146295_m / 2 - this.field_146295_m / 4;
                    int guiLeft = this.field_146294_l / 6;
                    int guiRight = this.field_146294_l / 2 + this.field_146294_l / 3;
                    int flagDesignerRight = guiLeft;
                    int availWidth = (guiRight - guiLeft - 100) / 3;
                    float x1 = flagDesignerRight + 10;
                    float x2 = guiLeft - 10;
                    float y1 = (float)(guiBottom - 10) - (x2 - x1);
                    int height = (int)(y1 - 10.0f - (float)(guiTop + 30));
                    this.sliderColorR = new GuiElementSlider(1, flagDesignerRight + 25, guiTop + 30, availWidth, height, true, new Vector3(0.0, 0.0, 0.0), new Vector3(1.0, 0.0, 0.0));
                    this.sliderColorG = new GuiElementSlider(2, flagDesignerRight + availWidth + 50, guiTop + 30, availWidth, height, true, new Vector3(0.0, 0.0, 0.0), new Vector3(0.0, 1.0, 0.0));
                    this.sliderColorB = new GuiElementSlider(3, flagDesignerRight + availWidth * 2 + 75, guiTop + 30, availWidth, height, true, new Vector3(0.0, 0.0, 0.0), new Vector3(0.0, 0.0, 1.0));
                    this.sliderColorR.setSliderPos(this.spaceRaceData.getTeamColor().floatX());
                    this.sliderColorG.setSliderPos(this.spaceRaceData.getTeamColor().floatY());
                    this.sliderColorB.setSliderPos(this.spaceRaceData.getTeamColor().floatZ());
                    this.field_146292_n.add(this.sliderColorR);
                    this.field_146292_n.add(this.sliderColorG);
                    this.field_146292_n.add(this.sliderColorB);
                    break;
                }
            }
        }
    }

    public void func_146281_b() {
        this.exitCurrentScreen(false);
    }

    protected void func_73869_a(char keyChar, int keyID) throws IOException {
        if (this.textBoxRename != null && this.textBoxRename.keyTyped(keyChar, keyID)) {
            return;
        }
        super.func_73869_a(keyChar, keyID);
    }

    private void exitCurrentScreen(boolean close) {
        if (this.currentState == EnumSpaceRaceGui.MAIN) {
            if (this.isDirty) {
                this.sendSpaceRaceData();
            }
            if (close) {
                if (this.canEdit) {
                    this.writeFlagToFile();
                }
                this.thePlayer.func_71053_j();
            }
        } else {
            this.currentState = EnumSpaceRaceGui.MAIN;
            this.func_73866_w_();
        }
    }

    protected void func_146284_a(GuiButton buttonClicked) {
        switch (buttonClicked.field_146127_k) {
            case 0: {
                if (this.currentState == EnumSpaceRaceGui.CHANGE_TEAM_COLOR) {
                    this.markDirty();
                }
                this.exitCurrentScreen(true);
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                SpaceRace race;
                GuiElementGradientList.ListElement playerToRemove;
                if (this.currentState == EnumSpaceRaceGui.MAIN && this.canEdit) {
                    this.currentState = EnumSpaceRaceGui.ADD_PLAYER;
                    this.func_73866_w_();
                    break;
                }
                if (this.currentState == EnumSpaceRaceGui.ADD_PLAYER) {
                    SpaceRace race2;
                    GuiElementGradientList.ListElement playerToInvite = this.gradientListAddPlayers.getSelectedElement();
                    if (playerToInvite == null || this.recentlyInvited.containsKey(playerToInvite.value) || (race2 = SpaceRaceManager.getSpaceRaceFromPlayer(this.thePlayer.func_146103_bH().getName())) == null) break;
                    GalacticraftCore.packetPipeline.sendToServer(new PacketSimple(PacketSimple.EnumSimplePacket.S_INVITE_RACE_PLAYER, GCCoreUtil.getDimensionID((World)this.field_146297_k.field_71441_e), new Object[]{playerToInvite.value, race2.getSpaceRaceID()}));
                    this.recentlyInvited.put(playerToInvite.value, 1200);
                    break;
                }
                if (this.currentState != EnumSpaceRaceGui.REMOVE_PLAYER || (playerToRemove = this.gradientListRemovePlayers.getSelectedElement()) == null || (race = SpaceRaceManager.getSpaceRaceFromPlayer(this.thePlayer.func_146103_bH().getName())) == null) break;
                GalacticraftCore.packetPipeline.sendToServer(new PacketSimple(PacketSimple.EnumSimplePacket.S_REMOVE_RACE_PLAYER, GCCoreUtil.getDimensionID((World)this.field_146297_k.field_71441_e), new Object[]{playerToRemove.value, race.getSpaceRaceID()}));
                break;
            }
            case 3: {
                if (this.currentState != EnumSpaceRaceGui.MAIN || !this.canEdit) break;
                this.currentState = EnumSpaceRaceGui.REMOVE_PLAYER;
                this.func_73866_w_();
                break;
            }
        }
    }

    protected void func_73864_a(int x, int y, int clickIndex) throws IOException {
        super.func_73864_a(x, y, clickIndex);
    }

    public void func_73876_c() {
        ArrayList<GuiElementGradientList.ListElement> playerNames;
        super.func_73876_c();
        if (this.ticksPassed % 100 == 0) {
            if (this.isDirty || this.ticksPassed == 0) {
                this.sendSpaceRaceData();
                this.isDirty = false;
            } else {
                this.updateSpaceRaceData();
            }
        }
        ++this.ticksPassed;
        for (Map.Entry<String, Integer> e : new HashSet<Map.Entry<String, Integer>>(this.recentlyInvited.entrySet())) {
            int timeLeft = e.getValue();
            if (--timeLeft < 0) {
                this.recentlyInvited.remove(e.getKey());
                continue;
            }
            this.recentlyInvited.put(e.getKey(), timeLeft);
        }
        if (this.currentState == EnumSpaceRaceGui.ADD_PLAYER && this.gradientListAddPlayers != null && this.ticksPassed % 20 == 0) {
            playerNames = new ArrayList<GuiElementGradientList.ListElement>();
            for (int i = 0; i < this.thePlayer.field_70170_p.field_73010_i.size(); ++i) {
                EntityPlayer player = (EntityPlayer)this.thePlayer.field_70170_p.field_73010_i.get(i);
                if (!(player.func_70068_e((Entity)this.thePlayer) <= 625.0)) continue;
                String username = player.func_146103_bH().getName();
                if (this.spaceRaceData.getPlayerNames().contains(username)) continue;
                playerNames.add(new GuiElementGradientList.ListElement(username, this.recentlyInvited.containsKey(username) ? ColorUtil.to32BitColor(255, 250, 120, 0) : ColorUtil.to32BitColor(255, 190, 190, 190)));
            }
            this.gradientListAddPlayers.updateListContents(playerNames);
            if (this.field_146292_n.size() >= 2) {
                boolean bl = ((GuiElementGradientButton)((Object)this.field_146292_n.get((int)1))).field_146124_l = this.gradientListAddPlayers.getSelectedElement() != null;
            }
        }
        if (this.currentState == EnumSpaceRaceGui.REMOVE_PLAYER && this.gradientListRemovePlayers != null && this.ticksPassed % 20 == 0) {
            playerNames = new ArrayList();
            for (int i = 1; i < this.spaceRaceData.getPlayerNames().size(); ++i) {
                String playerName = this.spaceRaceData.getPlayerNames().get(i);
                playerNames.add(new GuiElementGradientList.ListElement(playerName, ColorUtil.to32BitColor(255, 190, 190, 190)));
            }
            this.gradientListRemovePlayers.updateListContents(playerNames);
            if (this.field_146292_n.size() >= 2) {
                boolean bl = ((GuiElementGradientButton)((Object)this.field_146292_n.get((int)1))).field_146124_l = this.gradientListRemovePlayers.getSelectedElement() != null;
            }
        }
        if (this.currentState == EnumSpaceRaceGui.ADD_PLAYER && this.gradientListAddPlayers != null) {
            this.gradientListAddPlayers.update();
        }
        if (this.currentState == EnumSpaceRaceGui.REMOVE_PLAYER && this.gradientListRemovePlayers != null) {
            this.gradientListRemovePlayers.update();
        }
        if (!this.initialized) {
            return;
        }
        if (this.currentState == EnumSpaceRaceGui.DESIGN_FLAG) {
            int unScaledX;
            int x = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
            int y = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
            if (this.canEdit && (float)x >= this.flagDesignerMinX && (float)y >= this.flagDesignerMinY && (float)x <= this.flagDesignerMinX + this.flagDesignerWidth && (float)y <= this.flagDesignerMinY + this.flagDesignerHeight) {
                unScaledX = (int)Math.floor((double)((float)x - this.flagDesignerMinX) / this.flagDesignerScale.x);
                int unScaledY = (int)Math.floor((double)((float)y - this.flagDesignerMinY) / this.flagDesignerScale.y);
                if (Mouse.isButtonDown((int)0)) {
                    if (this.checkboxEraser.isSelected != null && this.checkboxEraser.isSelected.booleanValue()) {
                        this.setColorWithBrushSize(unScaledX, unScaledY, new Vector3(255.0, 255.0, 255.0), (int)Math.floor(this.sliderEraserSize.getNormalizedValue() * 10.0f) + 1);
                    } else if (this.checkboxColorSelector.isSelected != null && this.checkboxColorSelector.isSelected.booleanValue()) {
                        Vector3 colorAt = this.spaceRaceData.getFlagData().getColorAt(unScaledX, unScaledY);
                        this.sliderColorR.setSliderPos(colorAt.floatX());
                        this.sliderColorG.setSliderPos(colorAt.floatY());
                        this.sliderColorB.setSliderPos(colorAt.floatZ());
                    } else if (this.checkboxPaintbrush.isSelected != null && this.checkboxPaintbrush.isSelected.booleanValue()) {
                        this.setColorWithBrushSize(unScaledX, unScaledY, new Vector3(this.sliderColorR.getColorValueD(), this.sliderColorG.getColorValueD(), this.sliderColorB.getColorValueD()), (int)Math.floor(this.sliderBrushSize.getNormalizedValue() * 10.0f) + 1);
                    }
                }
            }
            if (this.checkboxSelector != null) {
                if (!this.lastMousePressed && Mouse.isButtonDown((int)0) && this.checkboxSelector.isSelected != null && this.checkboxSelector.isSelected.booleanValue()) {
                    if ((float)x >= this.flagDesignerMinX && (float)y >= this.flagDesignerMinY && (float)x <= this.flagDesignerMinX + this.flagDesignerWidth && (float)y <= this.flagDesignerMinY + this.flagDesignerHeight) {
                        unScaledX = (int)Math.floor((double)((float)x - this.flagDesignerMinX) / this.flagDesignerScale.x);
                        int unScaledY = (int)Math.floor((double)((float)y - this.flagDesignerMinY) / this.flagDesignerScale.y);
                        this.selectionMinX = unScaledX;
                        this.selectionMinY = unScaledY;
                    } else {
                        this.selectionMinY = -1;
                        this.selectionMinX = -1;
                    }
                } else if (this.lastMousePressed && !Mouse.isButtonDown((int)0) && this.checkboxSelector.isSelected != null && this.checkboxSelector.isSelected.booleanValue()) {
                    if (this.selectionMinX != -1 && this.selectionMinY != -1 && (float)x >= this.flagDesignerMinX && (float)y >= this.flagDesignerMinY && (float)x <= this.flagDesignerMinX + this.flagDesignerWidth && (float)y <= this.flagDesignerMinY + this.flagDesignerHeight) {
                        unScaledX = (int)Math.floor((double)((float)x - this.flagDesignerMinX) / this.flagDesignerScale.x);
                        int unScaledY = (int)Math.floor((double)((float)y - this.flagDesignerMinY) / this.flagDesignerScale.y);
                        this.selectionMaxX = Math.min(unScaledX + 1, this.spaceRaceData.getFlagData().getWidth());
                        this.selectionMaxY = Math.min(unScaledY + 1, this.spaceRaceData.getFlagData().getHeight());
                        if (this.selectionMinX > this.selectionMaxX) {
                            int temp = this.selectionMaxX - 1;
                            this.selectionMaxX = this.selectionMinX + 1;
                            this.selectionMinX = temp;
                        }
                        if (this.selectionMinY > this.selectionMaxY) {
                            int temp = this.selectionMaxY - 1;
                            this.selectionMaxY = this.selectionMinY + 1;
                            this.selectionMinY = temp;
                        }
                    } else {
                        this.selectionMaxY = -1;
                        this.selectionMaxX = -1;
                    }
                }
            }
            if (this.sliderBrushSize != null && this.sliderBrushSize.field_146125_m) {
                this.sliderBrushSize.field_146126_j = GCCoreUtil.translate("gui.space_race.create.brush_radius.name") + ": " + ((int)Math.floor(this.sliderBrushSize.getNormalizedValue() * 10.0f) + 1);
            }
            if (this.sliderEraserSize != null && this.sliderEraserSize.field_146125_m) {
                this.sliderEraserSize.field_146126_j = GCCoreUtil.translate("gui.space_race.create.eraser_radius.name") + ": " + ((int)Math.floor(this.sliderEraserSize.getNormalizedValue() * 10.0f) + 1);
            }
            if (this.sliderColorR != null && this.sliderColorR.field_146125_m) {
                this.sliderColorR.field_146126_j = String.valueOf((int)Math.floor(this.sliderColorR.getColorValueD()));
            }
            if (this.sliderColorG != null && this.sliderColorG.field_146125_m) {
                this.sliderColorG.field_146126_j = String.valueOf((int)Math.floor(this.sliderColorG.getColorValueD()));
            }
            if (this.sliderColorB != null && this.sliderColorB.field_146125_m) {
                this.sliderColorB.field_146126_j = String.valueOf((int)Math.floor(this.sliderColorB.getColorValueD()));
            }
        } else if (this.currentState == EnumSpaceRaceGui.MAIN && this.lastMousePressed && !Mouse.isButtonDown((int)0)) {
            if (this.buttonFlag_hover) {
                this.currentState = EnumSpaceRaceGui.DESIGN_FLAG;
                this.func_73866_w_();
            }
            if (this.buttonTeamColor_hover) {
                this.currentState = EnumSpaceRaceGui.CHANGE_TEAM_COLOR;
                this.func_73866_w_();
            }
        }
        this.lastMousePressed = Mouse.isButtonDown((int)0);
    }

    private void setColor(int unScaledX, int unScaledY, Vector3 color) {
        if (this.selectionMaxX - this.selectionMinX > 0 && this.selectionMaxY - this.selectionMinY > 0) {
            if (unScaledX >= this.selectionMinX && unScaledX <= this.selectionMaxX - 1 && unScaledY >= this.selectionMinY && unScaledY <= this.selectionMaxY - 1) {
                this.markDirty();
                this.spaceRaceData.getFlagData().setColorAt(unScaledX, unScaledY, color);
            }
        } else {
            this.markDirty();
            this.spaceRaceData.getFlagData().setColorAt(unScaledX, unScaledY, color);
        }
    }

    private void setColorWithBrushSize(int unScaledX, int unScaledY, Vector3 color, int brushSize) {
        for (int x = unScaledX - brushSize + 1; x < unScaledX + brushSize; ++x) {
            for (int y = unScaledY - brushSize + 1; y < unScaledY + brushSize; ++y) {
                float relativeY;
                float relativeX;
                if (x < 0 || x >= this.spaceRaceData.getFlagData().getWidth() || y < 0 || y >= this.spaceRaceData.getFlagData().getHeight() || !(Math.sqrt((relativeX = (float)x + 0.5f - ((float)unScaledX + 0.5f)) * relativeX + (relativeY = (float)y + 0.5f - ((float)unScaledY + 0.5f)) * relativeY) <= (double)brushSize)) continue;
                this.setColor(x, y, color);
            }
        }
    }

    public void updateSpaceRaceData() {
        String playerName = FMLClientHandler.instance().getClient().field_71439_g.func_146103_bH().getName();
        SpaceRace race = SpaceRaceManager.getSpaceRaceFromPlayer(playerName);
        if (race != null && !this.isDirty) {
            this.spaceRaceData = race;
            this.canEdit = this.canPlayerEdit();
            if (!this.textBoxRename.text.equals(race.getTeamName())) {
                this.textBoxRename.text = race.getTeamName();
            }
        }
    }

    public void sendSpaceRaceData() {
        if (this.canEdit) {
            ArrayList<Object> objList = new ArrayList<Object>();
            objList.add(this.spaceRaceData.getSpaceRaceID());
            objList.add(this.spaceRaceData.getTeamName());
            objList.add(this.spaceRaceData.getFlagData());
            objList.add(this.spaceRaceData.getTeamColor());
            objList.add(this.spaceRaceData.getPlayerNames().toArray(new String[this.spaceRaceData.getPlayerNames().size()]));
            GalacticraftCore.packetPipeline.sendToServer(new PacketSimple(PacketSimple.EnumSimplePacket.S_START_NEW_SPACE_RACE, GCCoreUtil.getDimensionID((World)this.field_146297_k.field_71441_e), objList));
        }
    }

    public void func_73863_a(int par1, int par2, float par3) {
        this.func_146276_q_();
        if (this.initialized) {
            this.buttonFlag_hover = this.canEdit && this.currentState == EnumSpaceRaceGui.MAIN && par1 >= this.buttonFlag_xPosition && par2 >= this.buttonFlag_yPosition && par1 < this.buttonFlag_xPosition + this.buttonFlag_width && par2 < this.buttonFlag_yPosition + this.buttonFlag_height;
            this.buttonTeamColor_hover = this.canEdit && this.currentState == EnumSpaceRaceGui.MAIN && par1 >= this.buttonTeamColor_xPosition && par2 >= this.buttonTeamColor_yPosition && par1 < this.buttonTeamColor_xPosition + this.buttonTeamColor_width && par2 < this.buttonTeamColor_yPosition + this.buttonTeamColor_height;
            switch (this.currentState) {
                case MAIN: {
                    this.func_73732_a(this.field_146289_q, GCCoreUtil.translate("gui.space_race.create.title.name"), this.field_146294_l / 2, this.field_146295_m / 2 - this.field_146295_m / 3 - 15, 0xFFFFFF);
                    this.drawFlagButton();
                    this.drawColorButton();
                    GuiElementGradientButton serverStats = (GuiElementGradientButton)((Object)this.field_146292_n.get(this.canEdit ? 4 : 2));
                    GuiElementGradientButton localStats = (GuiElementGradientButton)((Object)this.field_146292_n.get(this.canEdit ? 5 : 3));
                    serverStats.field_146126_j = par1 > serverStats.field_146128_h && par1 < serverStats.field_146128_h + serverStats.field_146120_f && par2 > serverStats.field_146129_i && par2 < serverStats.field_146129_i + serverStats.field_146121_g ? GCCoreUtil.translate("gui.space_race.coming_soon") : GCCoreUtil.translate("gui.space_race.create.server_stats.name");
                    if (par1 > localStats.field_146128_h && par1 < localStats.field_146128_h + localStats.field_146120_f && par2 > localStats.field_146129_i && par2 < localStats.field_146129_i + localStats.field_146121_g) {
                        localStats.field_146126_j = GCCoreUtil.translate("gui.space_race.coming_soon");
                        break;
                    }
                    localStats.field_146126_j = GCCoreUtil.translate("gui.space_race.create.global_stats.name");
                    break;
                }
                case ADD_PLAYER: {
                    this.func_73732_a(this.field_146289_q, GCCoreUtil.translate("gui.space_race.create.invite_player.name"), this.field_146294_l / 2, this.field_146295_m / 2 - this.field_146295_m / 3 - 15, 0xFFFFFF);
                    this.func_73732_a(this.field_146289_q, GCCoreUtil.translate("gui.space_race.create.player_radius.name"), this.field_146294_l / 2, this.field_146295_m / 2 + this.field_146295_m / 3 + 3, ColorUtil.to32BitColor(255, 180, 40, 40));
                    break;
                }
                case REMOVE_PLAYER: {
                    this.func_73732_a(this.field_146289_q, GCCoreUtil.translate("gui.space_race.create.remove_player.name"), this.field_146294_l / 2, this.field_146295_m / 2 - this.field_146295_m / 3 - 15, 0xFFFFFF);
                    break;
                }
                case DESIGN_FLAG: {
                    int x;
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    GL11.glDisable((int)3553);
                    GL11.glEnable((int)3042);
                    GL11.glDisable((int)3008);
                    OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
                    GL11.glShadeModel((int)7425);
                    Tessellator tessellator = Tessellator.func_178181_a();
                    VertexBuffer worldRenderer = tessellator.func_178180_c();
                    for (x = 0; x < this.spaceRaceData.getFlagData().getWidth(); ++x) {
                        for (int y = 0; y < this.spaceRaceData.getFlagData().getHeight(); ++y) {
                            Vector3 color = this.spaceRaceData.getFlagData().getColorAt(x, y);
                            GL11.glColor4f((float)color.floatX(), (float)color.floatY(), (float)color.floatZ(), (float)1.0f);
                            worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
                            worldRenderer.func_181662_b((double)this.flagDesignerMinX + (double)x * this.flagDesignerScale.x, (double)this.flagDesignerMinY + (double)y * this.flagDesignerScale.y + 1.0 * this.flagDesignerScale.y, 0.0).func_181675_d();
                            worldRenderer.func_181662_b((double)this.flagDesignerMinX + (double)x * this.flagDesignerScale.x + 1.0 * this.flagDesignerScale.x, (double)this.flagDesignerMinY + (double)y * this.flagDesignerScale.y + 1.0 * this.flagDesignerScale.y, 0.0).func_181675_d();
                            worldRenderer.func_181662_b((double)this.flagDesignerMinX + (double)x * this.flagDesignerScale.x + 1.0 * this.flagDesignerScale.x, (double)this.flagDesignerMinY + (double)y * this.flagDesignerScale.y, 0.0).func_181675_d();
                            worldRenderer.func_181662_b((double)this.flagDesignerMinX + (double)x * this.flagDesignerScale.x, (double)this.flagDesignerMinY + (double)y * this.flagDesignerScale.y, 0.0).func_181675_d();
                            tessellator.func_78381_a();
                        }
                    }
                    if (this.checkboxShowGrid != null && this.checkboxShowGrid.isSelected != null && this.checkboxShowGrid.isSelected.booleanValue()) {
                        for (x = 0; x <= this.spaceRaceData.getFlagData().getWidth(); ++x) {
                            worldRenderer.func_181668_a(1, DefaultVertexFormats.field_181706_f);
                            worldRenderer.func_181662_b((double)this.flagDesignerMinX + (double)x * this.flagDesignerScale.x, (double)this.flagDesignerMinY, (double)this.field_73735_i).func_181666_a(0.0f, 0.0f, 0.0f, 1.0f).func_181675_d();
                            worldRenderer.func_181662_b((double)this.flagDesignerMinX + (double)x * this.flagDesignerScale.x, (double)(this.flagDesignerMinY + this.flagDesignerHeight), (double)this.field_73735_i).func_181666_a(0.0f, 0.0f, 0.0f, 1.0f).func_181675_d();
                            tessellator.func_78381_a();
                        }
                        for (int y = 0; y <= this.spaceRaceData.getFlagData().getHeight(); ++y) {
                            worldRenderer.func_181668_a(1, DefaultVertexFormats.field_181706_f);
                            worldRenderer.func_181662_b((double)this.flagDesignerMinX, (double)this.flagDesignerMinY + (double)y * this.flagDesignerScale.y, (double)this.field_73735_i).func_181666_a(0.0f, 0.0f, 0.0f, 1.0f).func_181675_d();
                            worldRenderer.func_181662_b((double)(this.flagDesignerMinX + this.flagDesignerWidth), (double)this.flagDesignerMinY + (double)y * this.flagDesignerScale.y, (double)this.field_73735_i).func_181666_a(0.0f, 0.0f, 0.0f, 1.0f).func_181675_d();
                            tessellator.func_78381_a();
                        }
                    }
                    if (!(this.lastMousePressed && this.checkboxSelector.isSelected != null && this.checkboxSelector.isSelected.booleanValue() || this.selectionMaxX - this.selectionMinX <= 0 || this.selectionMaxY - this.selectionMinY <= 0)) {
                        worldRenderer.func_181668_a(3, DefaultVertexFormats.field_181706_f);
                        float col = (float)(Math.sin((double)this.ticksPassed * 0.3) * 0.4 + 0.1);
                        worldRenderer.func_181662_b((double)this.flagDesignerMinX + (double)this.selectionMinX * this.flagDesignerScale.x, (double)this.flagDesignerMinY + (double)this.selectionMinY * this.flagDesignerScale.y, (double)this.field_73735_i).func_181666_a(col, col, col, 1.0f).func_181675_d();
                        worldRenderer.func_181662_b((double)this.flagDesignerMinX + (double)this.selectionMaxX * this.flagDesignerScale.x, (double)this.flagDesignerMinY + (double)this.selectionMinY * this.flagDesignerScale.y, (double)this.field_73735_i).func_181666_a(col, col, col, 1.0f).func_181675_d();
                        worldRenderer.func_181662_b((double)this.flagDesignerMinX + (double)this.selectionMaxX * this.flagDesignerScale.x, (double)this.flagDesignerMinY + (double)this.selectionMaxY * this.flagDesignerScale.y, (double)this.field_73735_i).func_181666_a(col, col, col, 1.0f).func_181675_d();
                        worldRenderer.func_181662_b((double)this.flagDesignerMinX + (double)this.selectionMinX * this.flagDesignerScale.x, (double)this.flagDesignerMinY + (double)this.selectionMaxY * this.flagDesignerScale.y, (double)this.field_73735_i).func_181666_a(col, col, col, 1.0f).func_181675_d();
                        worldRenderer.func_181662_b((double)this.flagDesignerMinX + (double)this.selectionMinX * this.flagDesignerScale.x, (double)this.flagDesignerMinY + (double)this.selectionMinY * this.flagDesignerScale.y, (double)this.field_73735_i).func_181666_a(col, col, col, 1.0f).func_181675_d();
                        tessellator.func_78381_a();
                    }
                    int guiRight = this.field_146294_l / 2 + this.field_146294_l / 3;
                    int guiBottom = this.field_146295_m / 2 + this.field_146295_m / 4;
                    float x1 = this.sliderColorR.field_146128_h;
                    float x2 = guiRight - 10;
                    float y1 = (float)(guiBottom - 10) - (x2 - x1);
                    float y2 = guiBottom - 10;
                    worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
                    worldRenderer.func_181662_b((double)x2, (double)y1, (double)this.field_73735_i).func_181666_a(0.0f, 0.0f, 0.0f, 1.0f).func_181675_d();
                    worldRenderer.func_181662_b((double)x1, (double)y1, (double)this.field_73735_i).func_181666_a(0.0f, 0.0f, 0.0f, 1.0f).func_181675_d();
                    worldRenderer.func_181662_b((double)x1, (double)y2, (double)this.field_73735_i).func_181666_a(0.0f, 0.0f, 0.0f, 1.0f).func_181675_d();
                    worldRenderer.func_181662_b((double)x2, (double)y2, (double)this.field_73735_i).func_181666_a(0.0f, 0.0f, 0.0f, 1.0f).func_181675_d();
                    tessellator.func_78381_a();
                    worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
                    worldRenderer.func_181662_b((double)x2 - 1.0, (double)y1 + 1.0, (double)this.field_73735_i).func_181666_a(this.sliderColorR.getNormalizedValue(), this.sliderColorG.getNormalizedValue(), this.sliderColorB.getNormalizedValue(), 1.0f).func_181675_d();
                    worldRenderer.func_181662_b((double)x1 + 1.0, (double)y1 + 1.0, (double)this.field_73735_i).func_181666_a(this.sliderColorR.getNormalizedValue(), this.sliderColorG.getNormalizedValue(), this.sliderColorB.getNormalizedValue(), 1.0f).func_181675_d();
                    worldRenderer.func_181662_b((double)x1 + 1.0, (double)y2 - 1.0, (double)this.field_73735_i).func_181666_a(this.sliderColorR.getNormalizedValue(), this.sliderColorG.getNormalizedValue(), this.sliderColorB.getNormalizedValue(), 1.0f).func_181675_d();
                    worldRenderer.func_181662_b((double)x2 - 1.0, (double)y2 - 1.0, (double)this.field_73735_i).func_181666_a(this.sliderColorR.getNormalizedValue(), this.sliderColorG.getNormalizedValue(), this.sliderColorB.getNormalizedValue(), 1.0f).func_181675_d();
                    tessellator.func_78381_a();
                    GL11.glShadeModel((int)7424);
                    GL11.glDisable((int)3042);
                    GL11.glEnable((int)3008);
                    GL11.glEnable((int)3553);
                    break;
                }
                case CHANGE_TEAM_COLOR: {
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    GL11.glDisable((int)3553);
                    GL11.glEnable((int)3042);
                    GL11.glDisable((int)3008);
                    OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
                    GL11.glShadeModel((int)7425);
                    float x1 = this.sliderColorG.field_146128_h;
                    float x2 = this.sliderColorG.field_146128_h + this.sliderColorG.func_146117_b();
                    float y1 = this.field_146295_m / 2 - this.field_146295_m / 3 + 5;
                    float y2 = this.sliderColorG.field_146129_i - 5;
                    float xDiff = x2 - x1;
                    float yDiff = y2 - y1;
                    if (xDiff > yDiff) {
                        x1 = (float)(this.sliderColorG.field_146128_h + this.sliderColorG.func_146117_b() / 2) - yDiff / 2.0f;
                        x2 = (float)(this.sliderColorG.field_146128_h + this.sliderColorG.func_146117_b() / 2) + yDiff / 2.0f;
                    } else {
                        y2 = y1 + xDiff;
                    }
                    Tessellator tessellator = Tessellator.func_178181_a();
                    VertexBuffer worldRenderer = tessellator.func_178180_c();
                    worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
                    worldRenderer.func_181662_b((double)x2 - 1.0, (double)y1 + 1.0, (double)this.field_73735_i).func_181666_a(this.sliderColorR.getNormalizedValue(), this.sliderColorG.getNormalizedValue(), this.sliderColorB.getNormalizedValue(), 1.0f).func_181675_d();
                    worldRenderer.func_181662_b((double)x1 + 1.0, (double)y1 + 1.0, (double)this.field_73735_i).func_181666_a(this.sliderColorR.getNormalizedValue(), this.sliderColorG.getNormalizedValue(), this.sliderColorB.getNormalizedValue(), 1.0f).func_181675_d();
                    worldRenderer.func_181662_b((double)x1 + 1.0, (double)y2 - 1.0, (double)this.field_73735_i).func_181666_a(this.sliderColorR.getNormalizedValue(), this.sliderColorG.getNormalizedValue(), this.sliderColorB.getNormalizedValue(), 1.0f).func_181675_d();
                    worldRenderer.func_181662_b((double)x2 - 1.0, (double)y2 - 1.0, (double)this.field_73735_i).func_181666_a(this.sliderColorR.getNormalizedValue(), this.sliderColorG.getNormalizedValue(), this.sliderColorB.getNormalizedValue(), 1.0f).func_181675_d();
                    tessellator.func_78381_a();
                    this.spaceRaceData.setTeamColor(new Vector3(this.sliderColorR.getNormalizedValue(), this.sliderColorG.getNormalizedValue(), this.sliderColorB.getNormalizedValue()));
                    GL11.glShadeModel((int)7424);
                    GL11.glDisable((int)3042);
                    GL11.glEnable((int)3008);
                    GL11.glEnable((int)3553);
                }
            }
        }
        super.func_73863_a(par1, par2, par3);
        if (this.currentState == EnumSpaceRaceGui.ADD_PLAYER && this.gradientListAddPlayers != null) {
            this.gradientListAddPlayers.draw(par1, par2);
        }
        if (this.currentState == EnumSpaceRaceGui.REMOVE_PLAYER && this.gradientListRemovePlayers != null) {
            this.gradientListRemovePlayers.draw(par1, par2);
        }
        for (GuiButton button : this.field_146292_n) {
            if (!(button instanceof GuiElementSlider)) continue;
            ((GuiElementSlider)button).drawHoveringText();
        }
    }

    private void markDirty() {
        this.isDirty = true;
    }

    private void drawFlagButton() {
        int color;
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)this.buttonFlag_xPosition + 2.9f), (float)(this.buttonFlag_yPosition + this.buttonFlag_height + 1 - 4), (float)0.0f);
        GL11.glScalef((float)74.0f, (float)74.0f, (float)1.0f);
        GL11.glTranslatef((float)0.0f, (float)0.36f, (float)1.0f);
        GL11.glScalef((float)1.0f, (float)1.0f, (float)-1.0f);
        this.dummyFlag.flagData = this.spaceRaceData.getFlagData();
        this.dummyModel.renderFlag(this.dummyFlag, this.ticksPassed);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)500.0f);
        int n = color = this.buttonFlag_hover ? 170 : 100;
        if (this.canEdit) {
            String message = GCCoreUtil.translate("gui.space_race.create.customize.name");
            this.field_146289_q.func_175065_a(message, (float)(this.buttonFlag_xPosition + this.buttonFlag_width / 2 - this.field_146289_q.func_78256_a(message) / 2), (float)(this.buttonFlag_yPosition + this.buttonFlag_height / 2 - 5), ColorUtil.to32BitColor(255, color, color, color), this.buttonFlag_hover);
        }
        GL11.glPopMatrix();
        if (this.buttonFlag_hover) {
            Gui.func_73734_a((int)this.buttonFlag_xPosition, (int)this.buttonFlag_yPosition, (int)(this.buttonFlag_xPosition + this.buttonFlag_width), (int)(this.buttonFlag_yPosition + this.buttonFlag_height), (int)ColorUtil.to32BitColor(255, 50, 50, 50));
        }
        Gui.func_73734_a((int)(this.buttonFlag_xPosition + this.buttonFlag_width - 1), (int)this.buttonFlag_yPosition, (int)(this.buttonFlag_xPosition + this.buttonFlag_width), (int)(this.buttonFlag_yPosition + this.buttonFlag_height), (int)ColorUtil.to32BitColor(255, 0, 0, 0));
        Gui.func_73734_a((int)this.buttonFlag_xPosition, (int)this.buttonFlag_yPosition, (int)(this.buttonFlag_xPosition + 1), (int)(this.buttonFlag_yPosition + this.buttonFlag_height), (int)ColorUtil.to32BitColor(255, 0, 0, 0));
        Gui.func_73734_a((int)this.buttonFlag_xPosition, (int)this.buttonFlag_yPosition, (int)(this.buttonFlag_xPosition + this.buttonFlag_width), (int)(this.buttonFlag_yPosition + 1), (int)ColorUtil.to32BitColor(255, 0, 0, 0));
        Gui.func_73734_a((int)this.buttonFlag_xPosition, (int)(this.buttonFlag_yPosition + this.buttonFlag_height - 1), (int)(this.buttonFlag_xPosition + this.buttonFlag_width), (int)(this.buttonFlag_yPosition + this.buttonFlag_height), (int)ColorUtil.to32BitColor(255, 0, 0, 0));
    }

    private void drawColorButton() {
        int color;
        Gui.func_73734_a((int)(this.buttonTeamColor_xPosition + 2), (int)(this.buttonTeamColor_yPosition + 2), (int)(this.buttonTeamColor_xPosition + this.buttonTeamColor_width - 2), (int)(this.buttonTeamColor_yPosition + this.buttonTeamColor_height - 2), (int)ColorUtil.to32BitColor(255, (int)(this.spaceRaceData.getTeamColor().x * 255.0), (int)(this.spaceRaceData.getTeamColor().y * 255.0), (int)(this.spaceRaceData.getTeamColor().z * 255.0)));
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)500.0f);
        int n = color = this.buttonTeamColor_hover ? 170 : 100;
        if (this.canEdit) {
            this.field_146289_q.func_175065_a(GCCoreUtil.translate("gui.space_race.create.change_color.name.0"), (float)(this.buttonTeamColor_xPosition + this.buttonTeamColor_width / 2 - this.field_146289_q.func_78256_a(GCCoreUtil.translate("gui.space_race.create.change_color.name.0")) / 2), (float)(this.buttonTeamColor_yPosition + this.buttonTeamColor_height / 2 - 13), ColorUtil.to32BitColor(255, color, color, color), this.buttonTeamColor_hover);
        }
        this.field_146289_q.func_175065_a(GCCoreUtil.translate("gui.space_race.create.change_color.name.1"), (float)(this.buttonTeamColor_xPosition + this.buttonTeamColor_width / 2 - this.field_146289_q.func_78256_a(GCCoreUtil.translate("gui.space_race.create.change_color.name.1")) / 2), (float)(this.buttonTeamColor_yPosition + this.buttonTeamColor_height / 2 - (this.canEdit ? 3 : 9)), ColorUtil.to32BitColor(255, color, color, color), this.buttonTeamColor_hover);
        this.field_146289_q.func_175065_a(GCCoreUtil.translate("gui.space_race.create.change_color.name.2"), (float)(this.buttonTeamColor_xPosition + this.buttonTeamColor_width / 2 - this.field_146289_q.func_78256_a(GCCoreUtil.translate("gui.space_race.create.change_color.name.2")) / 2), (float)(this.buttonTeamColor_yPosition + this.buttonTeamColor_height / 2 + (this.canEdit ? 7 : 1)), ColorUtil.to32BitColor(255, color, color, color), this.buttonTeamColor_hover);
        GL11.glPopMatrix();
        if (this.buttonTeamColor_hover) {
            Gui.func_73734_a((int)this.buttonTeamColor_xPosition, (int)this.buttonTeamColor_yPosition, (int)(this.buttonTeamColor_xPosition + this.buttonTeamColor_width), (int)(this.buttonTeamColor_yPosition + this.buttonTeamColor_height), (int)ColorUtil.to32BitColor(55, 50, 50, 50));
        }
        Gui.func_73734_a((int)(this.buttonTeamColor_xPosition + this.buttonTeamColor_width - 1), (int)this.buttonTeamColor_yPosition, (int)(this.buttonTeamColor_xPosition + this.buttonTeamColor_width), (int)(this.buttonTeamColor_yPosition + this.buttonTeamColor_height), (int)ColorUtil.to32BitColor(255, 0, 0, 0));
        Gui.func_73734_a((int)this.buttonTeamColor_xPosition, (int)this.buttonTeamColor_yPosition, (int)(this.buttonTeamColor_xPosition + 1), (int)(this.buttonTeamColor_yPosition + this.buttonTeamColor_height), (int)ColorUtil.to32BitColor(255, 0, 0, 0));
        Gui.func_73734_a((int)this.buttonTeamColor_xPosition, (int)this.buttonTeamColor_yPosition, (int)(this.buttonTeamColor_xPosition + this.buttonTeamColor_width), (int)(this.buttonTeamColor_yPosition + 1), (int)ColorUtil.to32BitColor(255, 0, 0, 0));
        Gui.func_73734_a((int)this.buttonTeamColor_xPosition, (int)(this.buttonTeamColor_yPosition + this.buttonTeamColor_height - 1), (int)(this.buttonTeamColor_xPosition + this.buttonTeamColor_width), (int)(this.buttonTeamColor_yPosition + this.buttonTeamColor_height), (int)ColorUtil.to32BitColor(255, 0, 0, 0));
    }

    public void func_146270_b(int i) {
        if (this.field_146297_k.field_71441_e != null) {
            int scaleX = Math.min(this.ticksPassed * 14, this.field_146294_l / 3);
            int scaleY = Math.min(this.ticksPassed * 14, this.field_146295_m / 3);
            if (scaleX == this.field_146294_l / 3 && scaleY == this.field_146295_m / 3 && !this.initialized) {
                this.initialized = true;
                this.func_73866_w_();
            }
            this.func_73733_a(this.field_146294_l / 2 - scaleX, this.field_146295_m / 2 - scaleY, this.field_146294_l / 2 + scaleX, this.field_146295_m / 2 + scaleY, -1072689136, -804253680);
        } else {
            this.func_146278_c(i);
        }
    }

    @Override
    public void onSelectionChanged(GuiElementCheckbox checkbox, boolean newSelected) {
        if (((Object)((Object)checkbox)).equals((Object)this.checkboxEraser)) {
            if (newSelected) {
                this.sliderEraserSize.field_146125_m = true;
                if (this.checkboxPaintbrush.isSelected.booleanValue()) {
                    this.sliderBrushSize.field_146125_m = false;
                    this.checkboxPaintbrush.isSelected = false;
                } else if (this.checkboxSelector.isSelected.booleanValue()) {
                    this.checkboxSelector.isSelected = false;
                } else if (this.checkboxColorSelector.isSelected.booleanValue()) {
                    this.checkboxColorSelector.isSelected = false;
                }
            } else {
                this.sliderEraserSize.field_146125_m = false;
            }
        } else if (((Object)((Object)checkbox)).equals((Object)this.checkboxPaintbrush)) {
            if (newSelected) {
                this.sliderBrushSize.field_146125_m = true;
                if (this.checkboxEraser.isSelected.booleanValue()) {
                    this.sliderEraserSize.field_146125_m = false;
                    this.checkboxEraser.isSelected = false;
                } else if (this.checkboxSelector.isSelected.booleanValue()) {
                    this.checkboxSelector.isSelected = false;
                } else if (this.checkboxColorSelector.isSelected.booleanValue()) {
                    this.checkboxColorSelector.isSelected = false;
                }
            } else {
                this.sliderBrushSize.field_146125_m = false;
            }
        } else if (((Object)((Object)checkbox)).equals((Object)this.checkboxSelector)) {
            if (newSelected) {
                if (this.checkboxEraser.isSelected.booleanValue()) {
                    this.sliderEraserSize.field_146125_m = false;
                    this.checkboxEraser.isSelected = false;
                } else if (this.checkboxPaintbrush.isSelected.booleanValue()) {
                    this.sliderBrushSize.field_146125_m = false;
                    this.checkboxPaintbrush.isSelected = false;
                } else if (this.checkboxColorSelector.isSelected.booleanValue()) {
                    this.checkboxColorSelector.isSelected = false;
                }
            }
        } else if (((Object)((Object)checkbox)).equals((Object)this.checkboxColorSelector) && newSelected) {
            if (this.checkboxEraser.isSelected.booleanValue()) {
                this.sliderEraserSize.field_146125_m = false;
                this.checkboxEraser.isSelected = false;
            } else if (this.checkboxPaintbrush.isSelected.booleanValue()) {
                this.sliderBrushSize.field_146125_m = false;
                this.checkboxPaintbrush.isSelected = false;
            } else if (this.checkboxSelector.isSelected.booleanValue()) {
                this.checkboxSelector.isSelected = false;
            }
        }
    }

    @Override
    public boolean canPlayerEdit(GuiElementCheckbox checkbox, EntityPlayer player) {
        return true;
    }

    @Override
    public boolean getInitiallySelected(GuiElementCheckbox checkbox) {
        return ((Object)((Object)checkbox)).equals((Object)this.checkboxPaintbrush);
    }

    @Override
    public void onIntruderInteraction() {
    }

    @Override
    public void onIntruderInteraction(GuiElementTextBox textBox) {
    }

    @Override
    public boolean canPlayerEdit(GuiElementTextBox textBox, EntityPlayer player) {
        return this.canEdit;
    }

    @Override
    public void onTextChanged(GuiElementTextBox textBox, String newText) {
        if (textBox == this.textBoxRename && !newText.equals(this.spaceRaceData.getTeamName())) {
            this.spaceRaceData.setTeamName(newText);
            this.markDirty();
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    @Override
    public String getInitialText(GuiElementTextBox textBox) {
        if (textBox == this.textBoxRename) {
            return this.spaceRaceData.getTeamName();
        }
        return "";
    }

    @Override
    public int getTextColor(GuiElementTextBox textBox) {
        return ColorUtil.to32BitColor(255, 255, 255, 255);
    }

    private File writeFlagToFile() {
        try {
            String dirName = Minecraft.func_71410_x().field_71412_D.getAbsolutePath();
            File directory = new File(dirName, "assets");
            boolean success = true;
            if (!directory.exists()) {
                success = directory.mkdir();
            }
            if (success) {
                if (!(directory = new File(directory, "flagCache")).exists()) {
                    success = directory.mkdir();
                }
                if (success) {
                    File file = new File(directory, this.spaceRaceData.getSpaceRaceID() + ".png");
                    ImageIO.write((RenderedImage)this.spaceRaceData.getFlagData().toBufferedImage(), "png", file);
                    return file;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static enum EnumSpaceRaceGui {
        MAIN,
        ADD_PLAYER,
        REMOVE_PLAYER,
        DESIGN_FLAG,
        CHANGE_TEAM_COLOR;

    }
}

