/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.blocks;

import java.util.Random;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.core.GCFluids;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.proxy.ClientProxyCore;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.IFluidBlock;

public class BlockFluidGC
extends BlockFluidClassic {
    private final String fluidName;
    private final Fluid fluid;

    public BlockFluidGC(Fluid fluid, String assetName) {
        super(fluid, assetName.startsWith("oil") || assetName.startsWith("fuel") ? GCFluids.materialOil : Material.field_151586_h);
        this.fluidName = assetName;
        this.fluid = fluid;
        if (assetName.startsWith("oil")) {
            this.field_149789_z = true;
        }
        this.func_149663_c(assetName);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (worldIn.field_72995_K && this.fluidName.startsWith("oil") && playerIn instanceof EntityPlayerSP) {
            ClientProxyCore.playerClientHandler.onBuild(7, (EntityPlayerSP)playerIn);
        }
        return super.func_180639_a(worldIn, pos, state, playerIn, hand, side, hitX, hitY, hitZ);
    }

    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        BlockPos below;
        IBlockState state;
        super.func_180655_c(stateIn, worldIn, pos, rand);
        if (this.fluidName.startsWith("oil") && rand.nextInt(1200) == 0) {
            worldIn.func_184148_a(null, (double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), SoundEvents.field_187656_cX, SoundCategory.BLOCKS, rand.nextFloat() * 0.25f + 0.75f, 1.0E-5f + rand.nextFloat() * 0.5f);
        }
        if (this.fluidName.equals("oil") && rand.nextInt(10) == 0 && (state = worldIn.func_180495_p(below = pos.func_177977_b())).func_177230_c().isSideSolid(state, (IBlockAccess)worldIn, below, EnumFacing.UP) && !worldIn.func_180495_p(pos.func_177979_c(2)).func_177230_c().func_149688_o(worldIn.func_180495_p(pos)).func_76230_c()) {
            GalacticraftCore.proxy.spawnParticle("oilDrip", new Vector3((float)pos.func_177958_n() + rand.nextFloat(), (double)pos.func_177956_o() - 1.05, (float)pos.func_177952_p() + rand.nextFloat()), new Vector3(0.0, 0.0, 0.0), new Object[0]);
        }
    }

    public boolean canDisplace(IBlockAccess world, BlockPos pos) {
        if (world.func_180495_p(pos).func_177230_c().func_149688_o(world.func_180495_p(pos)).func_76224_d()) {
            return false;
        }
        return super.canDisplace(world, pos);
    }

    public boolean displaceIfPossible(World world, BlockPos pos) {
        if (world.func_180495_p(pos).func_177230_c().func_149688_o(world.func_180495_p(pos)).func_76224_d()) {
            return false;
        }
        return super.displaceIfPossible(world, pos);
    }

    public boolean isFlammable(IBlockAccess world, BlockPos pos, EnumFacing face) {
        if (this.fluidName.startsWith("fuel")) {
            ((World)world).func_72876_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 6.0f, true);
            return true;
        }
        return this.fluidName.startsWith("oil");
    }

    public IBlockState getExtendedState(IBlockState oldState, IBlockAccess world, BlockPos pos) {
        IExtendedBlockState state = (IExtendedBlockState)oldState;
        state = state.withProperty((IUnlistedProperty)FLOW_DIRECTION, (Object)Float.valueOf((float)BlockFluidGC.getFlowDirection((IBlockAccess)world, (BlockPos)pos)));
        IBlockState[][] upBlockState = new IBlockState[3][3];
        float[][] height = new float[3][3];
        float[][] corner = new float[2][2];
        upBlockState[1][1] = world.func_180495_p(pos.func_177979_c(this.densityDir));
        height[1][1] = this.getFluidHeightForRender(world, pos, upBlockState[1][1]);
        if (height[1][1] == 1.0f) {
            for (int i = 0; i < 2; ++i) {
                for (int j = 0; j < 2; ++j) {
                    corner[i][j] = 1.0f;
                }
            }
        } else {
            int j;
            int i;
            for (i = 0; i < 3; ++i) {
                for (j = 0; j < 3; ++j) {
                    if (i == 1 && j == 1) continue;
                    upBlockState[i][j] = world.func_180495_p(pos.func_177982_a(i - 1, 0, j - 1).func_177979_c(this.densityDir));
                    height[i][j] = this.getFluidHeightForRender(world, pos.func_177982_a(i - 1, 0, j - 1), upBlockState[i][j]);
                }
            }
            for (i = 0; i < 2; ++i) {
                for (j = 0; j < 2; ++j) {
                    corner[i][j] = this.getFluidHeightAverage(new float[]{height[i][j], height[i][j + 1], height[i + 1][j], height[i + 1][j + 1]});
                }
            }
            boolean n = this.isFluid(upBlockState[0][1]);
            boolean s = this.isFluid(upBlockState[2][1]);
            boolean w = this.isFluid(upBlockState[1][0]);
            boolean e = this.isFluid(upBlockState[1][2]);
            boolean nw = this.isFluid(upBlockState[0][0]);
            boolean ne = this.isFluid(upBlockState[0][2]);
            boolean sw = this.isFluid(upBlockState[2][0]);
            boolean se = this.isFluid(upBlockState[2][2]);
            if (nw || n || w) {
                corner[0][0] = 1.0f;
            }
            if (ne || n || e) {
                corner[0][1] = 1.0f;
            }
            if (sw || s || w) {
                corner[1][0] = 1.0f;
            }
            if (se || s || e) {
                corner[1][1] = 1.0f;
            }
        }
        state = state.withProperty((IUnlistedProperty)LEVEL_CORNERS[0], (Object)Float.valueOf(corner[0][0]));
        state = state.withProperty((IUnlistedProperty)LEVEL_CORNERS[1], (Object)Float.valueOf(corner[0][1]));
        state = state.withProperty((IUnlistedProperty)LEVEL_CORNERS[2], (Object)Float.valueOf(corner[1][1]));
        state = state.withProperty((IUnlistedProperty)LEVEL_CORNERS[3], (Object)Float.valueOf(corner[1][0]));
        return state;
    }

    private boolean isFluid(IBlockState state) {
        return state.func_177230_c().func_149688_o(state).func_76224_d() || state.func_177230_c() instanceof IFluidBlock;
    }

    public float getFluidHeightForRender(IBlockAccess world, BlockPos pos, IBlockState up) {
        IBlockState here = world.func_180495_p(pos);
        if (here.func_177230_c() == this) {
            if (up.func_177230_c().func_149688_o(here).func_76224_d() || up.func_177230_c() instanceof IFluidBlock) {
                return 1.0f;
            }
            if (this.func_176201_c(here) == this.getMaxRenderHeightMeta()) {
                return 0.875f;
            }
        }
        if (here.func_177230_c() instanceof BlockLiquid) {
            return Math.min(1.0f - BlockLiquid.func_149801_b((int)((Integer)here.func_177229_b((IProperty)BlockLiquid.field_176367_b))), 0.875f);
        }
        return !here.func_177230_c().func_149688_o(here).func_76220_a() && up.func_177230_c() == this ? 1.0f : this.getQuantaPercentage(world, pos) * 0.875f;
    }
}

